/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.net.URL;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.history.HistoryAddin;

public class HistoryContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu popup) {
        JMenuItem item = popup.createMenuItem((ToggleAction)IdeAction.find((int)HistoryAddin.HISTORY_CMD_ID), MenuConstants.WEIGHT_FILE_OPEN);
        Element[] selection = popup.getContext().getSelection();
        if (selection != null && selection.length == 1 && selection[0] != null && selection[0].mayHaveChildren()) {
            URL url = null;
            if (selection[0] instanceof RelativeDirectoryContextFolder) {
                URLPath path = ((RelativeDirectoryContextFolder)selection[0]).getRootDirectories();
                url = path != null ? path.getFirstEntry() : null;
            } else if (selection[0] instanceof Project) {
                URLPath path = PathsConfiguration.getInstance((Project)((Project)selection[0])).getProjectSourcePath();
                url = path != null ? path.getFirstEntry() : null;
            } else if (selection[0] instanceof Locatable) {
                url = ((Locatable)selection[0]).getURL();
            }
            if (url != null && URLFileSystem.isDirectoryPath((URL)url) && url.getProtocol().equals("file")) {
                popup.add((Component)item, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU + 1.0f);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

