/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.history.HistoryConstants;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.IdeCompareView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdevimpl.compare.BaseCompareAddin;
import oracle.jdevimpl.history.HistoryController;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.history.HistoryPropertiesCommand;
import oracle.jdevimpl.history.HistoryViewer;

public final class HistoryAddin
implements Addin {
    public static final String EXTENSION_ID = "oracle.jdeveloper.history";
    public static final int HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"HISTORY_CMD_ID");
    public static final int PURGE_HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"PURGE_HISTORY_CMD_ID");
    public static final int CUSTOMIZE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"CUSTOMIZE_FILTERS_CMD_ID");
    public static final int OPEN_HISTORY_VIEWER_CMD_ID = Ide.findOrCreateCmdID((String)"OPEN_HISTORY_VIEWER_CMD_ID");
    public static final String RESTORE_HISTORY_CMD = "oracle.ide.cmd.RestoreHistoryCommand";
    public static final int RESTORE_HISTORY_CMD_ID = HistoryConstants.RESTORE_HISTORY_CMD_ID;
    public static final String RESTORE_HISTORY_RENAME_CMD = "oracle.ide.cmd.RestoreHistoryRenameCommand";
    public static final int RESTORE_HISTORY_RENAME_CMD_ID = HistoryConstants.RESTORE_HISTORY_RENAME_CMD_ID;

    public void initialize() {
        new HistoryManagerImpl();
        IdeAction.find((int)51).addController((Controller)HistoryController.getInstance());
        Ide.getMainWindow().addDynamicMenuListener(new DynamicMenuListener(){

            public JComponent[] gatherDynamicActions(Context context) {
                if (!(context.getView() instanceof HistoryViewer)) {
                    return new JComponent[0];
                }
                HistoryViewer historyViewer = (HistoryViewer)context.getView();
                ArrayList<JComponent> components = new ArrayList<JComponent>();
                BaseCompareAddin.gatherCompareDynamicActions(context, components);
                if (historyViewer.isLocalHistoryView() || historyViewer.isEditableRHS()) {
                    components.add(new JPopupMenu.Separator());
                }
                if (historyViewer.isLocalHistoryView()) {
                    components.add(Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)PURGE_HISTORY_CMD_ID), 0.0f));
                }
                if (historyViewer.isEditableRHS()) {
                    components.add(Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)RESTORE_HISTORY_CMD_ID), 0.0f));
                }
                components.add(new JPopupMenu.Separator());
                components.add(Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)CUSTOMIZE_FILTERS_CMD_ID), 0.0f));
                if (historyViewer.getSelection().length > 0 && !historyViewer.isCompareViewComponentFocused()) {
                    components.add(new JPopupMenu.Separator());
                    components.add(Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)HistoryPropertiesCommand.PROPERTIES_CMD_ID), 0.0f));
                }
                return components.toArray(new JComponent[0]);
            }
        });
        HistoryManager.getHistoryManager().getContextMenu().addContextMenuListener(new ContextMenuListener(){

            public boolean handleDefaultAction(Context context) {
                if (!(context.getView() instanceof HistoryViewer)) {
                    return false;
                }
                try {
                    IdeAction.find((int)OPEN_HISTORY_VIEWER_CMD_ID).performAction(context);
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)e);
                }
                return true;
            }

            public void menuWillHide(ContextMenu popup) {
            }

            public void menuWillShow(ContextMenu popup) {
                if (!(popup.getContext().getView() instanceof HistoryViewer)) {
                    return;
                }
                HistoryViewer historyViewer = (HistoryViewer)popup.getContext().getView();
                float section = 1.0f;
                section = this.menuWillShowCompareEditActions(popup, historyViewer, section);
                IdeAction openHistoryViewerAction0 = IdeAction.find((int)OPEN_HISTORY_VIEWER_CMD_ID);
                openHistoryViewerAction0.updateAction(popup.getContext());
                if (openHistoryViewerAction0.isEnabled()) {
                    popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)openHistoryViewerAction0), section, false);
                    section += 0.01f;
                }
                if (historyViewer.isLocalHistoryView()) {
                    popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)historyViewer.resolveGlobalAction(IdeAction.find((int)PURGE_HISTORY_CMD_ID))), section, false);
                }
                if (historyViewer.isEditableRHS()) {
                    popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)historyViewer.resolveGlobalAction(IdeAction.find((int)RESTORE_HISTORY_CMD_ID))), section, false);
                }
                if (historyViewer.isLocalHistoryView() || historyViewer.isEditableRHS()) {
                    section += 0.01f;
                }
                section = BaseCompareAddin.addCompareToolbarActionsToPopup(popup, section);
                popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)historyViewer.resolveGlobalAction(IdeAction.find((int)CUSTOMIZE_FILTERS_CMD_ID))), section, false);
                popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)historyViewer.resolveGlobalAction(IdeAction.find((int)51))), section, false);
                section += 0.01f;
                if (historyViewer.getSelection().length > 0 && !historyViewer.isCompareViewComponentFocused()) {
                    popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)HistoryPropertiesCommand.PROPERTIES_CMD_ID)), section, false);
                }
            }

            private float menuWillShowCompareEditActions(ContextMenu popup, HistoryViewer historyViewer, float section) {
                Action[] editActions;
                Component c;
                CompareView compareView = historyViewer.getCompareView();
                if (compareView == null) {
                    return section;
                }
                if (compareView instanceof ListCompareView && ((ListCompareView)compareView).getCompareMode() == CompareMode.TWO_WAY_COMPARE && ((ListCompareView)compareView).isSelectionComparable()) {
                    Object[] selection = ((ListCompareView)compareView).getSelectionForCompare();
                    try {
                        ((DirectoryFile)selection[0]).getCompareContributor();
                        ((DirectoryFile)selection[1]).getCompareContributor();
                        popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.compareDirectoryFile"))), section);
                        section += 0.01f;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
                    return section;
                }
                Component gui1 = compareView.getGUI();
                Component gui2 = null;
                try {
                    gui2 = compareView instanceof IdeCompareView ? ((IdeCompareView)compareView).getSecondaryDrawer().getGUI() : null;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (!(SwingUtilities.isDescendingFrom(c, gui1) || gui2 != null && SwingUtilities.isDescendingFrom(c, gui2))) {
                    return section;
                }
                Action[] actionArray = editActions = compareView instanceof BaseCompareView ? ((BaseCompareView)compareView).getEditActions() : null;
                if (editActions == null) {
                    return section;
                }
                for (int i = 0; i < editActions.length; ++i) {
                    if (editActions[i] == null) {
                        section += 0.01f;
                        continue;
                    }
                    popup.add((Component)(editActions[i] instanceof ToggleAction ? popup.createMenuItem((ToggleAction)editActions[i]) : new JMenuItem(editActions[i])), section, false);
                }
                return section += 0.01f;
            }
        });
    }
}

