/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.resource.CompareArb;

public class CompareController
implements Controller {
    private static CompareController _singleton;

    public static final CompareController getDefaultController() {
        if (_singleton == null) {
            _singleton = new CompareController();
        }
        return _singleton;
    }

    protected CompareView getCompareView(Context context) {
        if (context.getView() instanceof CompareViewOwner) {
            return ((CompareViewOwner)context.getView()).getCompareView();
        }
        return null;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof CompareEditor && cmdId == 51) {
            action.setEnabled(false);
            return true;
        }
        CompareView compareView = this.getCompareView(context);
        if (compareView == null) {
            return false;
        }
        if (context.getView() instanceof CompareViewOwner) {
            if (cmdId == CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID) {
                action.setEnabled(compareView instanceof ListCompareView && ((ListCompareView)compareView).isSelectionComparable());
                return true;
            }
            if (cmdId == CompareAddin.GO_FIRST_CMD_ID || cmdId == CompareAddin.GO_LAST_CMD_ID) {
                if (compareView == null || compareView.getModel() == null) {
                    return false;
                }
                action.setEnabled(compareView instanceof BaseCompareView && compareView.getModel().getDifferenceCount() > 0);
                return true;
            }
            if (cmdId == CompareAddin.GO_NEXT_CMD_ID) {
                try {
                    action.setEnabled(compareView instanceof BaseCompareView && ((BaseCompareView)compareView).hasNextDifference());
                    return true;
                }
                catch (ExpiredTextBufferException etbe) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == CompareAddin.GO_PREVIOUS_CMD_ID) {
                try {
                    action.setEnabled(compareView instanceof BaseCompareView && ((BaseCompareView)compareView).hasPreviousDifference());
                    return true;
                }
                catch (ExpiredTextBufferException etbe) {
                    action.setEnabled(false);
                    return true;
                }
            }
        }
        if (cmdId == CompareConstants.ACCEPT_LEFT_THEN_RIGHT_CMD_ID || cmdId == CompareConstants.ACCEPT_RIGHT_THEN_LEFT_CMD_ID) {
            if (compareView instanceof BaseCompareView) {
                BaseCompareView baseCompareView = (BaseCompareView)compareView;
                action.setEnabled(baseCompareView.getCompareMode() == CompareMode.THREE_WAY_MERGE && baseCompareView.hasCurrentDifference());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane editorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (editorPane == null) {
                return false;
            }
            if (cmdId == 22) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == 18) {
                action.setEnabled(editorPane.canCopy());
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        CompareView compareView = this.getCompareView(context);
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof ListCompareView && cmdId == CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID) {
            final Object[] selection = ((ListCompareView)compareView).getSelectionForCompare();
            if (selection != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CompareIdeViewer.get().show(((DirectoryFile)selection[0]).getCompareContributor(), ((DirectoryFile)selection[1]).getCompareContributor());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane editorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (editorPane == null) {
                return false;
            }
            if (cmdId == 22) {
                editorPane.selectAll();
                return true;
            }
            if (cmdId == 18) {
                editorPane.copy();
                return true;
            }
        }
        if (compareView instanceof BaseCompareView) {
            BaseCompareView navigableView = (BaseCompareView)compareView;
            if (cmdId == CompareAddin.GO_FIRST_CMD_ID) {
                navigableView.goToFirstDifference();
                this.requestFocusInCompareView(compareView);
                return true;
            }
            if (cmdId == CompareAddin.GO_NEXT_CMD_ID) {
                if (!navigableView.hasNextDifference()) {
                    return true;
                }
                boolean gotNext = navigableView.goToNextDifference();
                if (!gotNext) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.get("COMPARE_NEXT_NO_MORE"), (String)CompareArb.get("COMPARE_NEXT_NO_MORE_TITLE"), null)) {
                        navigableView.goToFirstDifference();
                        this.requestFocusInCompareView(compareView);
                    }
                } else {
                    this.requestFocusInCompareView(compareView);
                }
                return true;
            }
            if (cmdId == CompareAddin.GO_PREVIOUS_CMD_ID) {
                if (!navigableView.hasPreviousDifference()) {
                    return true;
                }
                boolean gotPrev = navigableView.goToPreviousDifference();
                if (!gotPrev) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.get("COMPARE_PREV_NO_MORE"), (String)CompareArb.get("COMPARE_PREV_NO_MORE_TITLE"), null)) {
                        navigableView.goToLastDifference();
                        this.requestFocusInCompareView(compareView);
                    } else {
                        this.requestFocusInCompareView(compareView);
                    }
                }
                return true;
            }
            if (cmdId == CompareAddin.GO_LAST_CMD_ID) {
                navigableView.goToLastDifference();
                this.requestFocusInCompareView(compareView);
                return true;
            }
        }
        if (cmdId == CompareConstants.ACCEPT_LEFT_THEN_RIGHT_CMD_ID || cmdId == CompareConstants.ACCEPT_RIGHT_THEN_LEFT_CMD_ID) {
            BaseCompareView baseCompareView;
            if (compareView instanceof BaseCompareView && ((BaseCompareView)compareView).getCompareMode() == CompareMode.THREE_WAY_MERGE && (baseCompareView = (BaseCompareView)compareView).hasCurrentDifference()) {
                if (cmdId == CompareConstants.ACCEPT_LEFT_THEN_RIGHT_CMD_ID) {
                    baseCompareView.acceptLeftThenRightSide();
                }
                if (cmdId == CompareConstants.ACCEPT_RIGHT_THEN_LEFT_CMD_ID) {
                    baseCompareView.acceptRightThenLeftSide();
                }
            }
            return true;
        }
        return false;
    }

    private final boolean requestFocusInCompareView(CompareView compareView) {
        if (!(compareView instanceof BaseCompareView)) {
            return false;
        }
        Component focusable = ((BaseCompareView)compareView).getFocusComponent();
        return focusable != null && focusable.requestFocusInWindow();
    }
}

