/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.time;

import ilog.views.util.time.IlvCalendarUtil;
import java.util.Calendar;

public interface IlvTimeIncrementPolicy {
    public void floorTime(Calendar var1);

    public void incrementTime(Calendar var1);

    public void decrementTime(Calendar var1);

    public static class Year
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getYearStep() {
            return this.a;
        }

        public void setYearStep(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(1) / this.a);
            IlvCalendarUtil.yearFloor(calendar);
            calendar.set(1, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(1, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(1, -this.a);
        }
    }

    public static class Month
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getMonthStep() {
            return this.a;
        }

        public void setMonthStep(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(2) / this.a);
            IlvCalendarUtil.monthFloor(calendar);
            calendar.set(2, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(2, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(2, -this.a);
        }
    }

    public static class Week
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getWeekStep() {
            return this.a;
        }

        public void setWeekStep(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(3) / this.a);
            IlvCalendarUtil.weekFloor(calendar);
            calendar.set(3, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(3, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(3, -this.a);
        }
    }

    public static class Day
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getDayStep() {
            return this.a;
        }

        public void setDayStep(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Step must be > 0");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(6) / this.a);
            IlvCalendarUtil.dayFloor(calendar);
            calendar.set(6, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(6, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(6, -this.a);
        }
    }

    public static class HalfDay
    implements IlvTimeIncrementPolicy {
        @Override
        public void floorTime(Calendar calendar) {
            IlvCalendarUtil.halfDayFloor(calendar);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(9, 1);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(9, -1);
        }
    }

    public static class Hour
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getHourStep() {
            return this.a;
        }

        public void setHourStep(int n) {
            if (n <= 0 || n > 24 || 24 % n != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 24");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(11) / this.a);
            IlvCalendarUtil.hourFloor(calendar);
            calendar.set(11, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            int n = (calendar.get(11) / this.a + 1) * this.a;
            calendar.set(11, n);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            if (this.a == 1 && calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
                calendar.add(11, -this.a);
            } else {
                int n = (calendar.get(11) / this.a - 1) * this.a;
                calendar.set(11, n);
            }
        }
    }

    public static class Minute
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getMinuteStep() {
            return this.a;
        }

        public void setMinuteStep(int n) {
            if (n <= 0 || n > 60 || 60 % n != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 60");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(12) / this.a);
            IlvCalendarUtil.minuteFloor(calendar);
            calendar.set(12, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(12, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(12, -this.a);
        }
    }

    public static class Second
    implements IlvTimeIncrementPolicy {
        private int a = 1;

        public int getSecondStep() {
            return this.a;
        }

        public void setSecondStep(int n) {
            if (n <= 0 || n > 60 || 60 % n != 0) {
                throw new IllegalArgumentException("Step must be a positive divisor of 60");
            }
            this.a = n;
        }

        @Override
        public void floorTime(Calendar calendar) {
            int n = this.a * (calendar.get(13) / this.a);
            IlvCalendarUtil.secondFloor(calendar);
            calendar.set(13, n);
        }

        @Override
        public void incrementTime(Calendar calendar) {
            calendar.add(13, this.a);
        }

        @Override
        public void decrementTime(Calendar calendar) {
            calendar.add(13, -this.a);
        }
    }
}

