/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.annotation.NoWarning;
import ilog.views.util.print.IlvJNLPPrintUtil;
import ilog.views.util.print.IlvMessagesSupport;
import ilog.views.util.print.IlvPrintableDocument;
import ilog.views.util.print.IlvPrintingController;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.ServiceManager;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.Sides;
import javax.swing.JOptionPane;

public class IlvPrintUtil {
    public static final RenderingHints.Key KEY_PRINTING = PrintingKey.c;
    public static final Object VALUE_PRINT_ON = PrintingKey.a;
    public static final Object VALUE_PRINT_OFF = PrintingKey.b;
    public static final RenderingHints.Key KEY_PRINTING_TRANSFORM = PrintingTransformKey.a;
    private static boolean a = true;
    private static boolean b = false;
    private static DocFlavor c = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    private static IlvPrintUtil d;

    @NoWarning(value={"javax.print.attribute.standard.JobName.<init>(java.lang.String, java.util.Locale)"})
    private PrintRequestAttributeSet i(IlvPrintingController ilvPrintingController) {
        PrintRequestAttributeSet printRequestAttributeSet;
        IlvPrintableDocument ilvPrintableDocument;
        block11: {
            DocAttribute docAttribute;
            Media media;
            Paper paper;
            block13: {
                PrintService printService;
                block12: {
                    int n;
                    ilvPrintableDocument = ilvPrintingController.getDocument();
                    PrinterJob printerJob = ilvPrintingController.getPrinterJob();
                    printService = printerJob.getPrintService();
                    printRequestAttributeSet = ilvPrintingController.a();
                    if (printService == null) {
                        return printRequestAttributeSet;
                    }
                    Sides sides = ilvPrintableDocument.getSides();
                    if (sides != null) {
                        printRequestAttributeSet.add(sides);
                    }
                    if ((n = ilvPrintableDocument.getOrientation()) == 0) {
                        printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
                    } else if (n == 1) {
                        printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
                    } else {
                        printRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
                    }
                    paper = ilvPrintableDocument.getPaperFormat();
                    if (paper == null) break block11;
                    float f = (float)Math.rint(paper.getWidth() * 25400.0 / 72.0) / 25400.0f;
                    float f2 = (float)Math.rint(paper.getHeight() * 25400.0 / 72.0) / 25400.0f;
                    media = MediaSize.findMedia(f, f2, 25400);
                    if (media == null) break block12;
                    if (printService.isAttributeValueSupported(media, null, null)) break block13;
                }
                if ((docAttribute = (Media)printService.getDefaultAttributeValue(Media.class)) != null) {
                    media = docAttribute;
                }
            }
            printRequestAttributeSet.add(media);
            docAttribute = new MediaPrintableArea((float)Math.rint(paper.getImageableX() * 25400.0 / 72.0) / 25400.0f, (float)Math.rint(paper.getImageableY() * 25400.0 / 72.0) / 25400.0f, (float)Math.rint(paper.getImageableWidth() * 25400.0 / 72.0) / 25400.0f, (float)Math.rint(paper.getImageableHeight() * 25400.0 / 72.0) / 25400.0f, 25400);
            printRequestAttributeSet.add(docAttribute);
        }
        if (ilvPrintableDocument.getName() != null) {
            printRequestAttributeSet.add(new JobName(ilvPrintableDocument.getName(), IlvLocaleUtil.getCurrentLocale()));
        }
        return printRequestAttributeSet;
    }

    private void a(PrintRequestAttributeSet printRequestAttributeSet, IlvPrintingController ilvPrintingController) {
        double d;
        double d2;
        double d3;
        double d4;
        MediaSize mediaSize;
        PrinterJob printerJob = ilvPrintingController.getPrinterJob();
        PrintService printService = printerJob.getPrintService();
        Object object = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (object != null) {
            if (printService.getSupportedAttributeValues(OrientationRequested.class, c, null) != null && printService.isAttributeValueSupported(OrientationRequested.PORTRAIT, c, null)) {
                int n = 1;
                n = object == OrientationRequested.PORTRAIT ? 1 : (object == OrientationRequested.LANDSCAPE ? 0 : 2);
                ilvPrintingController.getDocument().setOrientation(n);
            }
        }
        object = printRequestAttributeSet.get(Media.class);
        if (object == null) {
            object = printService.getDefaultAttributeValue(Media.class);
        }
        if (!(object instanceof MediaSizeName)) {
            object = MediaSizeName.NA_LETTER;
        }
        if ((mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)object)) == null) {
            mediaSize = MediaSize.NA.LETTER;
        }
        Paper paper = new Paper();
        double d5 = (double)mediaSize.getX(25400) * 72.0;
        double d6 = (double)mediaSize.getY(25400) * 72.0;
        paper.setSize(d5, d6);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            d4 = (double)mediaPrintableArea.getX(25400) * 72.0;
            d3 = (double)mediaPrintableArea.getY(25400) * 72.0;
            d2 = (double)mediaPrintableArea.getWidth(25400) * 72.0;
            d = (double)mediaPrintableArea.getHeight(25400) * 72.0;
        } else {
            if (d5 >= 432.0) {
                d4 = 72.0;
                d2 = d5 - 144.0;
            } else {
                d4 = d5 / 6.0;
                d2 = d5 * 0.75;
            }
            if (d6 >= 432.0) {
                d3 = 72.0;
                d = d6 - 144.0;
            } else {
                d3 = d6 / 6.0;
                d = d6 * 0.75;
            }
        }
        paper.setImageableArea(d4, d3, d2, d);
        ilvPrintingController.getDocument().setPaperFormat(paper);
    }

    private static IlvPrintUtil a() {
        if (d == null) {
            if (IlvPrintUtil.isEnabledJNLPPrintingSupport()) {
                try {
                    if (Class.forName("javax.jnlp.ServiceManager") != null) {
                        if (ServiceManager.lookup((String)"javax.jnlp.PrintService") != null) {
                            d = new IlvJNLPPrintUtil();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (d == null) {
                d = new IlvPrintUtil();
            }
        }
        return d;
    }

    static boolean a(IlvPrintingController ilvPrintingController) {
        return IlvPrintUtil.a().b(ilvPrintingController);
    }

    boolean b(IlvPrintingController ilvPrintingController) {
        boolean bl;
        boolean bl2 = bl = ilvPrintingController.getPrinterJob().getPrintService() != null;
        if (!bl) {
            JOptionPane.showMessageDialog(new Frame(), new IlvMessagesSupport().getMessage("NoPrintService"));
        }
        return bl;
    }

    static boolean c(IlvPrintingController ilvPrintingController) {
        return IlvPrintUtil.a().d(ilvPrintingController);
    }

    boolean d(IlvPrintingController ilvPrintingController) {
        if (b) {
            return ilvPrintingController.getPreparedPrinterJob().printDialog();
        }
        PrintRequestAttributeSet printRequestAttributeSet = this.i(ilvPrintingController);
        printRequestAttributeSet.add(new PageRanges(1, ilvPrintingController.getDocument().getNumberOfPages() > 0 ? ilvPrintingController.getDocument().getNumberOfPages() : 1));
        boolean bl = ilvPrintingController.getPreparedPrinterJob().printDialog(printRequestAttributeSet);
        if (bl) {
            this.a(printRequestAttributeSet, ilvPrintingController);
        }
        return bl;
    }

    static PageFormat e(IlvPrintingController ilvPrintingController) {
        return IlvPrintUtil.a().f(ilvPrintingController);
    }

    PageFormat f(IlvPrintingController ilvPrintingController) {
        PrinterJob printerJob = ilvPrintingController.getPreparedPrinterJob();
        PrintRequestAttributeSet printRequestAttributeSet = this.i(ilvPrintingController);
        PageFormat pageFormat = printerJob.pageDialog(printRequestAttributeSet);
        return pageFormat;
    }

    static void g(IlvPrintingController ilvPrintingController) throws PrinterException {
        IlvPrintUtil.a().h(ilvPrintingController);
    }

    void h(IlvPrintingController ilvPrintingController) throws PrinterException {
        PrinterJob printerJob = ilvPrintingController.getPreparedPrinterJob();
        if (ilvPrintingController.getDocument().getName() != null) {
            printerJob.setJobName(ilvPrintingController.getDocument().getName());
        }
        printerJob.print(this.i(ilvPrintingController));
    }

    static boolean a(Media media) {
        return media.toString().indexOf("envelope") != -1;
    }

    static double b(Media media) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
        if (mediaSize != null) {
            return mediaSize.getX(25400) * 72.0f;
        }
        return 0.0;
    }

    static double c(Media media) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
        if (mediaSize != null) {
            return mediaSize.getY(25400) * 72.0f;
        }
        return 0.0;
    }

    static Media a(PageFormat pageFormat) {
        int n = pageFormat.getOrientation();
        float f = (float)Math.rint(pageFormat.getWidth() * 25400.0 / 72.0) / 25400.0f;
        float f2 = (float)Math.rint(pageFormat.getHeight() * 25400.0 / 72.0) / 25400.0f;
        boolean bl = n == 1;
        return MediaSize.findMedia(bl ? f : f2, bl ? f2 : f, 25400);
    }

    static Media[] a(PrinterJob printerJob) {
        return IlvPrintUtil.a().b(printerJob);
    }

    Media[] b(PrinterJob printerJob) {
        PrintService printService = printerJob.getPrintService();
        if (printService == null) {
            return null;
        }
        Object object = printService.getSupportedAttributeValues(Media.class, c, null);
        if (object == null) {
            Media media = IlvPrintUtil.a(printerJob.defaultPage());
            return new Media[]{media};
        }
        if (object.getClass().isArray()) {
            Media[] mediaArray = (Media[])object;
            int n = 0;
            for (int i = 0; i < mediaArray.length; ++i) {
                if (!(mediaArray[i] instanceof MediaSizeName)) continue;
                ++n;
            }
            Media[] mediaArray2 = new Media[n];
            int n2 = 0;
            for (int i = 0; i < mediaArray.length; ++i) {
                if (!(mediaArray[i] instanceof MediaSizeName)) continue;
                mediaArray2[n2++] = mediaArray[i];
            }
            return mediaArray2;
        }
        return new Media[]{(Media)object};
    }

    static Window a(Component component) {
        if (component instanceof Window || component == null) {
            return (Window)component;
        }
        return IlvPrintUtil.a(component.getParent());
    }

    static Image a(Class clazz, String string) throws IOException {
        int n;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(clazz + ".getResourceAsStream(" + string + ") returns null");
        }
        byte[][] byArrayArray = new byte[1][];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byArrayArray[0] = new byte[1024];
        while ((n = bufferedInputStream.read(byArrayArray[0])) > 0) {
            byteArrayOutputStream.write(byArrayArray[0], 0, n);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.flush();
        byArrayArray[0] = byteArrayOutputStream.toByteArray();
        if (byArrayArray[0] == null) {
            throw new IOException(clazz.getName() + "/" + string + " not found.");
        }
        if (byArrayArray[0].length == 0) {
            throw new IOException("warning: " + string + " is zero-length");
        }
        return Toolkit.getDefaultToolkit().createImage(byArrayArray[0]);
    }

    public static void setEnabledJNLPPrintingSupport(boolean bl) {
        a = bl;
    }

    public static boolean isEnabledJNLPPrintingSupport() {
        return a;
    }

    public static void setNativePrintDialog(boolean bl) {
        b = bl;
    }

    public static boolean isNativePrintDialog() {
        return b;
    }

    IlvPrintUtil() {
        if (File.separatorChar == '\\') {
            try {
                if (System.getProperty("sun.java2d.print.enableGDITextLayout") == null) {
                    System.setProperty("sun.java2d.print.enableGDITextLayout", "false");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private static final class PrintingTransformKey
    extends RenderingHints.Key {
        static PrintingTransformKey a = new PrintingTransformKey(20081205);

        private PrintingTransformKey(int n) {
            super(n);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object == null || object instanceof AffineTransform;
        }
    }

    private static final class PrintingKey
    extends RenderingHints.Key {
        static final Object a = Boolean.TRUE;
        static final Object b = Boolean.FALSE;
        static PrintingKey c = new PrintingKey(20081205);

        private PrintingKey(int n) {
            super(n);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object == null || object == a || object == b;
        }
    }
}

