/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.svg.svggen.SVGGraphics2D;
import ilog.views.util.print.IlvPrintUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IlvFOUtil {
    public static String FONamespaceUri = "http://www.w3.org/1999/XSL/Format";
    public static String SVGNamespaceUri = "http://www.w3.org/2000/svg";

    public static Element paintToFO(Document document, Paintable paintable, int n, int n2) {
        Element element = document.createElementNS(FONamespaceUri, "fo:instream-foreign-object");
        element.setAttribute("xmlns", SVGNamespaceUri);
        Element element2 = document.createElementNS(SVGNamespaceUri, "svg");
        element2.setAttribute("width", Integer.toString(n));
        element2.setAttribute("height", Integer.toString(n2));
        element2.appendChild(document.createElementNS(SVGNamespaceUri, "defs"));
        Element element3 = document.createElementNS(SVGNamespaceUri, "g");
        element2.appendChild(element3);
        try {
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
            sVGGraphics2D.setTopLevelGroup(element3);
            sVGGraphics2D.setSVGCanvasSize(new Dimension(n, n2));
            paintable.paint((Graphics2D)sVGGraphics2D);
            Iterator iterator = sVGGraphics2D.getDefinitionSet().iterator();
            while (iterator.hasNext()) {
                element3.appendChild((Element)iterator.next());
            }
            sVGGraphics2D.getDOMTreeManager().applyDefaultRenderingStyle(element3);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        element.appendChild(element2);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element paintToFO(Document document, Component component) {
        ComponentPaintable componentPaintable = new ComponentPaintable(component);
        try {
            Element element = IlvFOUtil.paintToFOUnscaled(document, componentPaintable);
            return element;
        }
        finally {
            componentPaintable.dispose();
        }
    }

    public static Element paintToFOUnscaled(Document document, ComponentPaintable componentPaintable) {
        Component component = componentPaintable.getComponent();
        int n = component.getWidth();
        int n2 = component.getHeight();
        return IlvFOUtil.paintToFO(document, componentPaintable, n, n2);
    }

    public static Element paintToFOScaled(Document document, ComponentPaintable componentPaintable, double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException();
        }
        Component component = componentPaintable.getComponent();
        int n = component.getWidth();
        int n2 = component.getHeight();
        AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d, 0.0, 0.0);
        return IlvFOUtil.paintToFO(document, new TransformedPaintable(componentPaintable, affineTransform), (int)Math.ceil(d * (double)n), (int)Math.ceil(d * (double)n2));
    }

    public static Element paintToFOFitted(Document document, ComponentPaintable componentPaintable, int n, int n2, int n3, int n4) {
        Component component = componentPaintable.getComponent();
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n3) {
            case 2: 
            case 4: {
                break;
            }
            case 10: {
                n3 = component.getComponentOrientation().isLeftToRight() ? 2 : 4;
                break;
            }
            case 11: {
                n3 = component.getComponentOrientation().isLeftToRight() ? 4 : 2;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (n4) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n5 = component.getWidth();
        int n6 = component.getHeight();
        double d = (double)n / (double)n5;
        double d2 = (double)n2 / (double)n6;
        double d3 = Math.min(d, d2);
        AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d3, n3 == 2 ? 0.0 : (n3 == 4 ? 1.0 : 0.5) * ((double)n - d3 * (double)n5), n4 == 1 ? 0.0 : (n4 == 3 ? 1.0 : 0.5) * ((double)n2 - d3 * (double)n6));
        return IlvFOUtil.paintToFO(document, new TransformedPaintable(componentPaintable, affineTransform), n, n2);
    }

    private IlvFOUtil() {
    }

    static class TransformedPaintable
    implements Paintable {
        private final Paintable a;
        private final AffineTransform b;

        TransformedPaintable(Paintable paintable, AffineTransform affineTransform) {
            this.a = paintable;
            this.b = affineTransform;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            AffineTransform affineTransform = graphics2D.getTransform();
            try {
                graphics2D.transform(this.b);
                this.a.paint(graphics2D);
            }
            finally {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public static class ComponentPaintable
    implements Paintable {
        private Component a;

        public ComponentPaintable(Component component) {
            this.a = component;
        }

        public Component getComponent() {
            return this.a;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(IlvPrintUtil.KEY_PRINTING, IlvPrintUtil.VALUE_PRINT_ON);
            try {
                this.a.print(graphics2D);
            }
            finally {
                graphics2D.setRenderingHint(IlvPrintUtil.KEY_PRINTING, IlvPrintUtil.VALUE_PRINT_OFF);
            }
        }

        public void dispose() {
            this.a = null;
        }
    }

    public static interface Paintable {
        public void paint(Graphics2D var1);
    }
}

