/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import ilog.views.util.internal.IlvInternalError;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class IlvPolygon2D
implements Shape,
Cloneable {
    private transient GeneralPath a;

    protected IlvPolygon2D() {
    }

    public abstract int getNumberOfPoints();

    public abstract Point2D getPoint(int var1);

    public abstract Point2D[] getPoints();

    private GeneralPath a() {
        if (this.a == null) {
            int n = this.getNumberOfPoints();
            GeneralPath generalPath = new GeneralPath(0, n);
            Point2D point2D = this.getPoint(0);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            for (int i = 1; i < n; ++i) {
                point2D = this.getPoint(i);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            generalPath.closePath();
            this.a = generalPath;
        }
        return this.a;
    }

    @Override
    public Rectangle getBounds() {
        int n = this.getNumberOfPoints();
        assert (n > 0);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Point2D point2D = this.getPoint(i);
            double d = point2D.getX();
            double d2 = point2D.getY();
            if ((double)n2 > d) {
                n2 = (int)Math.floor(d);
            }
            if ((double)n3 < d) {
                n3 = (int)Math.ceil(d);
            }
            if ((double)n4 > d2) {
                n4 = (int)Math.floor(d2);
            }
            if (!((double)n5 < d2)) continue;
            n5 = (int)Math.ceil(d2);
        }
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    @Override
    public abstract Rectangle2D getBounds2D();

    private int a(double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds2D();
        if (d < rectangle2D.getMinX() || d > rectangle2D.getMaxX() || d2 < rectangle2D.getMinY() || d2 > rectangle2D.getMaxY()) {
            return 0;
        }
        int n = this.getNumberOfPoints();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d3;
            int n3 = i == 0 ? n - 1 : i - 1;
            Point2D point2D = this.getPoint(n3);
            double d4 = point2D.getX();
            double d5 = point2D.getY();
            point2D = this.getPoint(i);
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            if (d5 > d2) {
                if (d7 > d2) continue;
                if (d7 == d2) {
                    if (d6 == d) {
                        return 1;
                    }
                    n2 += d6 < d ? 1 : -1;
                    continue;
                }
            } else if (d5 < d2) {
                if (d7 < d2) continue;
                if (d7 == d2) {
                    if (d6 == d) {
                        return 1;
                    }
                    n2 += d6 < d ? -1 : 1;
                    continue;
                }
            } else {
                if (d4 == d) {
                    return 1;
                }
                if (d7 < d2) {
                    n2 += d4 < d ? 1 : -1;
                    continue;
                }
                if (d7 > d2) {
                    n2 += d4 < d ? -1 : 1;
                    continue;
                }
                if (d4 < d && d6 < d || d4 > d && d6 > d) continue;
                return 1;
            }
            if ((d3 = (d4 - d) * (d7 - d2) - (d6 - d) * (d5 - d2)) == 0.0) {
                return 1;
            }
            n2 += d3 > 0.0 ? 2 : -2;
        }
        if (n2 & true) {
            throw new IlvInternalError("error in IlvPolygon2D.windingNumber");
        }
        return n2 >> 1;
    }

    public boolean containsInInterior(double d, double d2) {
        int n = this.a(d, d2);
        if ((n & 1) != 0) {
            return false;
        }
        return ((n >>= 1) & 1) != 0;
    }

    public boolean containsInClosure(double d, double d2) {
        int n = this.a(d, d2);
        if ((n & 1) != 0) {
            return true;
        }
        return ((n >>= 1) & 1) != 0;
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.containsInInterior(d, d2);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.a().intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.a().contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int a = 0;

            @Override
            public int currentSegment(double[] dArray) {
                if (this.a < IlvPolygon2D.this.getNumberOfPoints()) {
                    Point2D point2D = IlvPolygon2D.this.getPoint(this.a);
                    dArray[0] = point2D.getX();
                    dArray[1] = point2D.getY();
                    if (affineTransform != null) {
                        affineTransform.transform(dArray, 0, dArray, 0, 1);
                    }
                    return this.a == 0 ? 0 : 1;
                }
                return 4;
            }

            @Override
            public int currentSegment(float[] fArray) {
                if (this.a < IlvPolygon2D.this.getNumberOfPoints()) {
                    Point2D point2D = IlvPolygon2D.this.getPoint(this.a);
                    fArray[0] = (float)point2D.getX();
                    fArray[1] = (float)point2D.getY();
                    if (affineTransform != null) {
                        affineTransform.transform(fArray, 0, fArray, 0, 1);
                    }
                    return this.a == 0 ? 0 : 1;
                }
                return 4;
            }

            @Override
            public int getWindingRule() {
                return 0;
            }

            @Override
            public boolean isDone() {
                return this.a > IlvPolygon2D.this.getNumberOfPoints();
            }

            @Override
            public void next() {
                ++this.a;
            }
        };
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    private static double b(double d, double d2) {
        if (d > 0.0 && d2 >= 0.0) {
            return d2 / (d + d2);
        }
        if (d2 > 0.0 && d <= 0.0) {
            return 1.0 + d / (d - d2);
        }
        if (d < 0.0 && d2 <= 0.0) {
            return 2.0 + d2 / (d + d2);
        }
        if (d2 < 0.0 && d >= 0.0) {
            return 3.0 + d / (d - d2);
        }
        throw new IlvInternalError("ilog.views.util.java2d.IlvPolygon2D.Angle");
    }

    private static double a(double d) {
        if (d >= 2.0) {
            return d - 2.0;
        }
        return d + 2.0;
    }

    public boolean containsInConvexHull(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        CircularInterval circularInterval = new CircularInterval();
        int n = this.getNumberOfPoints();
        for (int i = 0; i < n; ++i) {
            Point2D point2D2 = this.getPoint(i);
            double d3 = point2D2.getX() - d;
            double d4 = point2D2.getY() - d2;
            if (d3 == 0.0 && d4 == 0.0) {
                return true;
            }
            double d5 = IlvPolygon2D.b(d3, d4);
            if (!circularInterval.add(d5, IlvPolygon2D.a(d5))) continue;
            return true;
        }
        return false;
    }

    public double getArea() {
        int n = this.getNumberOfPoints();
        if (n <= 2) {
            return 0.0;
        }
        Point2D point2D = this.getPoint(0);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = 0.0;
        for (int i = 2; i < n; ++i) {
            point2D = this.getPoint(i - 1);
            double d4 = point2D.getX();
            double d5 = point2D.getY();
            point2D = this.getPoint(i);
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            d3 += (d4 -= d) * (d7 -= d2) - (d6 -= d) * (d5 -= d2);
        }
        return 0.5 * d3;
    }

    public Point2D getGravity0() {
        int n = this.getNumberOfPoints();
        assert (n > 0);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Point2D point2D = this.getPoint(i);
            d += point2D.getX();
            d2 += point2D.getY();
        }
        return new Point2D.Double(d / (double)n, d2 / (double)n);
    }

    public Point2D getGravity1() {
        int n = this.getNumberOfPoints();
        assert (n > 0);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            Point2D point2D = this.getPoint(i);
            Point2D point2D2 = this.getPoint(i == n - 1 ? 0 : i + 1);
            double d4 = point2D.getX();
            double d5 = point2D.getY();
            double d6 = point2D2.getX();
            double d7 = point2D2.getY();
            double d8 = d6 - d4;
            double d9 = d7 - d5;
            double d10 = d8 == 0.0 ? Math.abs(d9) : (d9 == 0.0 ? Math.abs(d8) : Math.sqrt(d8 * d8 + d9 * d9));
            d += (d4 + d6) * d10;
            d2 += d5 + d7 + d10;
            d3 += d10;
        }
        if (d3 >= 1.0E-10) {
            d3 = 2.0 * d3;
            return new Point2D.Double(d / d3, d2 / d3);
        }
        return this.getGravity0();
    }

    public Point2D getGravity2() {
        int n = this.getNumberOfPoints();
        Point2D point2D = this.getPoint(0);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 2; i < n; ++i) {
            point2D = this.getPoint(i - 1);
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            point2D = this.getPoint(i);
            double d8 = point2D.getX();
            double d9 = point2D.getY();
            double d10 = (d6 -= d) * (d9 -= d2) - (d8 -= d) * (d7 -= d2);
            d3 += (d6 + d8) * d10;
            d4 += (d7 + d9) * d10;
            d5 += d10;
        }
        if (Math.abs(d5) >= 1.0E-10) {
            d5 = 3.0 * d5;
            return new Point2D.Double(d + d3 / d5, d2 + d4 / d5);
        }
        return this.getGravity1();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            IlvPolygon2D ilvPolygon2D = (IlvPolygon2D)object;
            int n = this.getNumberOfPoints();
            if (n == ilvPolygon2D.getNumberOfPoints()) {
                Point2D[] point2DArray = this.getPoints();
                Point2D[] point2DArray2 = ilvPolygon2D.getPoints();
                for (int i = 0; i < n; ++i) {
                    if (point2DArray[i].equals(point2DArray2[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        int n = this.getNumberOfPoints();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append("(");
            stringBuffer.append(this.getPoint(i).getX());
            stringBuffer.append(",");
            stringBuffer.append(this.getPoint(i).getY());
            stringBuffer.append(")");
        }
        stringBuffer.append("-]");
        return stringBuffer.toString();
    }

    private static class CircularInterval {
        private boolean a = false;
        private double b;
        private double c;

        public boolean contains(double d) {
            if (this.a) {
                if (this.b <= this.c) {
                    return this.b <= d && d <= this.c;
                }
                return this.b <= d || d <= this.c;
            }
            return false;
        }

        public boolean containsInterval(double d, double d2) {
            if (this.a) {
                if (this.b <= this.c) {
                    return this.b <= d && d <= d2 && d2 <= this.c;
                }
                if (d <= d2) {
                    return this.b <= d || d2 <= this.c;
                }
                return this.b <= d && d2 <= this.c;
            }
            return false;
        }

        public boolean add(double d, double d2) {
            if (this.a) {
                boolean bl = this.contains(d);
                boolean bl2 = this.contains(d2);
                if (!bl && !bl2) {
                    throw new IlvInternalError("ilog.views.util.java2d.IlvPolygon2D.containsInConvexHull");
                }
                if (bl && bl2 && !this.containsInterval(d, d2)) {
                    return true;
                }
                if (!bl) {
                    this.b = d;
                }
                if (!bl2) {
                    this.c = d2;
                }
                return false;
            }
            this.a = true;
            this.b = d;
            this.c = d2;
            return false;
        }
    }

    public static class Double
    extends IlvPolygon2D {
        private int a;
        private Point2D.Double[] b;

        public Double(Point2D[] point2DArray) {
            int n = point2DArray.length;
            if (n == 0) {
                throw new IllegalArgumentException("points should not be empty");
            }
            this.a = n;
            this.b = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                Point2D point2D = point2DArray[i];
                this.b[i] = new Point2D.Double(point2D.getX(), point2D.getY());
            }
        }

        public Double(double[] dArray, double[] dArray2, int n) {
            if (n == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n;
            this.b = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = new Point2D.Double(dArray[i], dArray2[i]);
            }
        }

        public Double(float[] fArray, float[] fArray2, int n) {
            if (n == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n;
            this.b = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = new Point2D.Double(fArray[i], fArray2[i]);
            }
        }

        public Double(int[] nArray, int[] nArray2, int n) {
            if (n == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n;
            this.b = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = new Point2D.Double(nArray[i], nArray2[i]);
            }
        }

        @Override
        public int getNumberOfPoints() {
            return this.a;
        }

        @Override
        public Point2D getPoint(int n) {
            return this.b[n];
        }

        @Override
        public Point2D[] getPoints() {
            return this.b;
        }

        @Override
        public Rectangle2D getBounds2D() {
            int n = this.a;
            assert (n > 0);
            double d = java.lang.Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            double d3 = java.lang.Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (int i = 0; i < n; ++i) {
                Point2D.Double double_ = this.b[i];
                if (d > double_.x) {
                    d = double_.x;
                }
                if (d2 < double_.x) {
                    d2 = double_.x;
                }
                if (d3 > double_.y) {
                    d3 = double_.y;
                }
                if (!(d4 < double_.y)) continue;
                d4 = double_.y;
            }
            return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        }

        public Object clone() {
            try {
                Double double_ = (Double)super.clone();
                int n = this.a;
                double_.b = new Point2D.Double[n];
                for (int i = 0; i < n; ++i) {
                    double_.b[i] = (Point2D.Double)this.b[i].clone();
                }
                return double_;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            int n = this.a;
            long l = -n << 3;
            long l2 = this.getClass().hashCode();
            for (int i = 0; i < n; ++i) {
                l += java.lang.Double.doubleToLongBits(this.b[i].x);
                l2 += java.lang.Double.doubleToLongBits(this.b[i].y);
            }
            return (int)l + (int)(l >>> 32) + (int)(l2 << 1) + (int)(l2 >>> 31);
        }
    }

    public static class Float
    extends IlvPolygon2D {
        private int a;
        private Point2D.Float[] b;

        public Float(Point2D[] point2DArray) {
            int n = point2DArray.length;
            if (n == 0) {
                throw new IllegalArgumentException("points should not be empty");
            }
            this.a = n;
            this.b = new Point2D.Float[n];
            for (int i = 0; i < n; ++i) {
                Point2D point2D = point2DArray[i];
                this.b[i] = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
            }
        }

        public Float(float[] fArray, float[] fArray2, int n) {
            if (n == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n;
            this.b = new Point2D.Float[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = new Point2D.Float(fArray[i], fArray2[i]);
            }
        }

        @Override
        public int getNumberOfPoints() {
            return this.a;
        }

        @Override
        public Point2D getPoint(int n) {
            return this.b[n];
        }

        @Override
        public Point2D[] getPoints() {
            return this.b;
        }

        @Override
        public Rectangle2D getBounds2D() {
            int n = this.a;
            assert (n > 0);
            float f = java.lang.Float.MAX_VALUE;
            float f2 = -3.4028235E38f;
            float f3 = java.lang.Float.MAX_VALUE;
            float f4 = -3.4028235E38f;
            for (int i = 0; i < n; ++i) {
                Point2D.Float float_ = this.b[i];
                if (f > float_.x) {
                    f = float_.x;
                }
                if (f2 < float_.x) {
                    f2 = float_.x;
                }
                if (f3 > float_.y) {
                    f3 = float_.y;
                }
                if (!(f4 < float_.y)) continue;
                f4 = float_.y;
            }
            return new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        }

        public Object clone() {
            try {
                Float float_ = (Float)super.clone();
                int n = this.a;
                float_.b = new Point2D.Float[n];
                for (int i = 0; i < n; ++i) {
                    float_.b[i] = (Point2D.Float)this.b[i].clone();
                }
                return float_;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            int n = this.a;
            int n2 = -n << 3;
            int n3 = this.getClass().hashCode();
            for (int i = 0; i < n; ++i) {
                n2 += java.lang.Float.floatToIntBits(this.b[i].x);
                n3 += java.lang.Float.floatToIntBits(this.b[i].y);
            }
            return n2 + (n3 << 1);
        }
    }
}

