/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.image;

import ilog.views.util.image.ChunkStream;
import ilog.views.util.image.IDATOutputStream;
import ilog.views.util.image.ImageEncoderImpl;
import ilog.views.util.image.PNGEncodeParam;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGImageEncoder
extends ImageEncoderImpl {
    private static final int a = 0;
    private static final int b = 2;
    private static final int c = 3;
    private static final int d = 4;
    private static final int e = 6;
    private static final byte[] f = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private PNGEncodeParam g;
    private RenderedImage h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private int n;
    private int o;
    private boolean p = false;
    private boolean q = false;
    private boolean r;
    private byte[] s = null;
    private byte[] t = null;
    private byte[] u = null;
    private byte[] v = null;
    private DataOutputStream w;
    private byte[] x = null;
    private byte[] y = null;
    private byte[][] z = null;
    private static final float[] aa;

    public PNGImageEncoder(OutputStream outputStream, PNGEncodeParam pNGEncodeParam) {
        super(outputStream, pNGEncodeParam);
        if (pNGEncodeParam != null) {
            this.g = pNGEncodeParam;
        }
        this.w = new DataOutputStream(outputStream);
    }

    private void a() throws IOException {
        this.w.write(f);
    }

    private void b() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IHDR");
        chunkStream.writeInt(this.i);
        chunkStream.writeInt(this.j);
        chunkStream.writeByte((byte)this.k);
        chunkStream.writeByte((byte)this.n);
        chunkStream.writeByte(0);
        chunkStream.writeByte(0);
        chunkStream.writeByte(this.r ? 1 : 0);
        chunkStream.writeToStream(this.w);
    }

    private static int a(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    private void a(OutputStream outputStream, Raster raster, int n, int n2, int n3, int n4) throws IOException {
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        int n9 = 8 / this.k;
        int n10 = n7 * this.m;
        int[] nArray = new int[n10];
        int n11 = (n10 - (n *= this.m) + (n3 *= this.m) - 1) / n3;
        int n12 = n11 * this.m;
        if (this.k < 8) {
            n12 = (n12 + n9 - 1) / n9;
        } else if (this.k == 16) {
            n12 *= 2;
        }
        if (n12 == 0) {
            return;
        }
        this.y = new byte[n12 + this.o];
        this.x = new byte[n12 + this.o];
        this.z = new byte[5][n12 + this.o];
        int n13 = (1 << this.k) - 1;
        for (int i = n6 + n2; i < n6 + n8; i += n4) {
            int n14;
            int n15;
            int n16;
            raster.getPixels(n5, i, n7, 1, nArray);
            if (this.q) {
                n16 = 8 - this.k;
                n15 = 0;
                while (n15 < n7) {
                    int n17 = n15++;
                    nArray[n17] = nArray[n17] >> n16;
                }
            }
            n16 = this.o;
            n15 = 0;
            int n18 = 0;
            switch (this.k) {
                case 1: 
                case 2: 
                case 4: {
                    int n19;
                    n14 = n9 - 1;
                    for (int j = n; j < n10; j += n3) {
                        n19 = PNGImageEncoder.a(nArray[j] >> this.l, n13);
                        n18 = n18 << this.k | n19;
                        if (n15++ != n14) continue;
                        this.y[n16++] = (byte)n18;
                        n18 = 0;
                        n15 = 0;
                    }
                    if (n15 == 0) break;
                    this.y[n16++] = (byte)(n18 <<= (n9 - n15) * this.k);
                    break;
                }
                case 8: {
                    int n19;
                    for (int j = n; j < n10; j += n3) {
                        for (n19 = 0; n19 < this.m; ++n19) {
                            this.y[n16++] = (byte)PNGImageEncoder.a(nArray[j + n19] >> this.l, n13);
                        }
                    }
                    break;
                }
                case 16: {
                    int n19;
                    for (int j = n; j < n10; j += n3) {
                        for (n19 = 0; n19 < this.m; ++n19) {
                            int n20 = PNGImageEncoder.a(nArray[j + n19] >> this.l, n13);
                            this.y[n16++] = (byte)(n20 >> 8);
                            this.y[n16++] = (byte)(n20 & 0xFF);
                        }
                    }
                    break;
                }
            }
            n14 = this.g.filterRow(this.y, this.x, this.z, n12, this.o);
            outputStream.write(n14);
            outputStream.write(this.z[n14], this.o, n12);
            byte[] byArray = this.y;
            this.y = this.x;
            this.x = byArray;
        }
    }

    private void c() throws IOException {
        IDATOutputStream iDATOutputStream = new IDATOutputStream(this.w, 8192);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)iDATOutputStream, new Deflater(9));
        Raster raster = this.h.getData(new Rectangle(this.h.getMinX(), this.h.getMinY(), this.h.getWidth(), this.h.getHeight()));
        if (this.p) {
            int n = raster.getNumBands() - 1;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            raster = raster.createChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, nArray);
        }
        if (this.r) {
            this.a(deflaterOutputStream, raster, 0, 0, 8, 8);
            this.a(deflaterOutputStream, raster, 4, 0, 8, 8);
            this.a(deflaterOutputStream, raster, 0, 4, 4, 8);
            this.a(deflaterOutputStream, raster, 2, 0, 4, 4);
            this.a(deflaterOutputStream, raster, 0, 2, 2, 4);
            this.a(deflaterOutputStream, raster, 1, 0, 2, 2);
            this.a(deflaterOutputStream, raster, 0, 1, 1, 2);
        } else {
            this.a(deflaterOutputStream, raster, 0, 0, 1, 1);
        }
        deflaterOutputStream.finish();
        iDATOutputStream.flush();
    }

    private void d() throws IOException {
        ChunkStream chunkStream = new ChunkStream("IEND");
        chunkStream.writeToStream(this.w);
    }

    private void e() throws IOException {
        if (this.g.isChromaticitySet() || this.g.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("cHRM");
            float[] fArray = !this.g.isSRGBIntentSet() ? this.g.getChromaticity() : aa;
            for (int i = 0; i < 8; ++i) {
                chunkStream.writeInt((int)(fArray[i] * 100000.0f));
            }
            chunkStream.writeToStream(this.w);
        }
    }

    private void f() throws IOException {
        if (this.g.isGammaSet() || this.g.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("gAMA");
            float f = !this.g.isSRGBIntentSet() ? this.g.getGamma() : 0.45454544f;
            chunkStream.writeInt((int)(f * 100000.0f));
            chunkStream.writeToStream(this.w);
        }
    }

    private void g() throws IOException {
        if (this.g.isICCProfileDataSet()) {
            ChunkStream chunkStream = new ChunkStream("iCCP");
            byte[] byArray = this.g.getICCProfileData();
            chunkStream.write(byArray);
            chunkStream.writeToStream(this.w);
        }
    }

    private void h() throws IOException {
        if (this.g.isSignificantBitsSet()) {
            ChunkStream chunkStream = new ChunkStream("sBIT");
            int[] nArray = this.g.getSignificantBits();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                chunkStream.writeByte(nArray[i]);
            }
            chunkStream.writeToStream(this.w);
        }
    }

    private void i() throws IOException {
        if (this.g.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("sRGB");
            int n = this.g.getSRGBIntent();
            chunkStream.write(n);
            chunkStream.writeToStream(this.w);
        }
    }

    private void j() throws IOException {
        if (this.s == null) {
            return;
        }
        ChunkStream chunkStream = new ChunkStream("PLTE");
        for (int i = 0; i < this.s.length; ++i) {
            chunkStream.writeByte(this.s[i]);
            chunkStream.writeByte(this.t[i]);
            chunkStream.writeByte(this.u[i]);
        }
        chunkStream.writeToStream(this.w);
    }

    private void k() throws IOException {
        if (this.g.isBackgroundSet()) {
            ChunkStream chunkStream = new ChunkStream("bKGD");
            switch (this.n) {
                case 0: 
                case 4: {
                    int n = ((PNGEncodeParam.Gray)this.g).getBackgroundGray();
                    chunkStream.writeShort(n);
                    break;
                }
                case 3: {
                    int n = ((PNGEncodeParam.Palette)this.g).getBackgroundPaletteIndex();
                    chunkStream.writeByte(n);
                    break;
                }
                case 2: 
                case 6: {
                    int[] nArray = ((PNGEncodeParam.RGB)this.g).getBackgroundRGB();
                    chunkStream.writeShort(nArray[0]);
                    chunkStream.writeShort(nArray[1]);
                    chunkStream.writeShort(nArray[2]);
                }
            }
            chunkStream.writeToStream(this.w);
        }
    }

    private void l() throws IOException {
        if (this.g.isPaletteHistogramSet()) {
            ChunkStream chunkStream = new ChunkStream("hIST");
            int[] nArray = this.g.getPaletteHistogram();
            for (int i = 0; i < nArray.length; ++i) {
                chunkStream.writeShort(nArray[i]);
            }
            chunkStream.writeToStream(this.w);
        }
    }

    private void m() throws IOException {
        if (this.g.isTransparencySet() && this.n != 4 && this.n != 6) {
            ChunkStream chunkStream = new ChunkStream("tRNS");
            if (this.g instanceof PNGEncodeParam.Palette) {
                byte[] byArray = ((PNGEncodeParam.Palette)this.g).getPaletteTransparency();
                for (int i = 0; i < byArray.length; ++i) {
                    chunkStream.writeByte(byArray[i]);
                }
            } else if (this.g instanceof PNGEncodeParam.Gray) {
                int n = ((PNGEncodeParam.Gray)this.g).getTransparentGray();
                chunkStream.writeShort(n);
            } else if (this.g instanceof PNGEncodeParam.RGB) {
                int[] nArray = ((PNGEncodeParam.RGB)this.g).getTransparentRGB();
                chunkStream.writeShort(nArray[0]);
                chunkStream.writeShort(nArray[1]);
                chunkStream.writeShort(nArray[2]);
            }
            chunkStream.writeToStream(this.w);
        } else if (this.n == 3) {
            int n;
            int n2;
            for (n2 = n = Math.min(255, this.v.length - 1); n2 >= 0 && this.v[n2] == -1; --n2) {
            }
            if (n2 >= 0) {
                ChunkStream chunkStream = new ChunkStream("tRNS");
                for (int i = 0; i <= n2; ++i) {
                    chunkStream.writeByte(this.v[i]);
                }
                chunkStream.writeToStream(this.w);
            }
        }
    }

    private void n() throws IOException {
        if (this.g.isPhysicalDimensionSet()) {
            ChunkStream chunkStream = new ChunkStream("pHYs");
            int[] nArray = this.g.getPhysicalDimension();
            chunkStream.writeInt(nArray[0]);
            chunkStream.writeInt(nArray[1]);
            chunkStream.writeByte((byte)nArray[2]);
            chunkStream.writeToStream(this.w);
        }
    }

    private void o() throws IOException {
        if (this.g.isSuggestedPaletteSet()) {
            ChunkStream chunkStream = new ChunkStream("sPLT");
            System.out.println("sPLT not supported yet.");
            chunkStream.writeToStream(this.w);
        }
    }

    private void p() throws IOException {
        if (this.g.isModificationTimeSet()) {
            ChunkStream chunkStream = new ChunkStream("tIME");
            Date date = this.g.getModificationTime();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
            gregorianCalendar.setTime(date);
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2);
            int n3 = gregorianCalendar.get(5);
            int n4 = gregorianCalendar.get(11);
            int n5 = gregorianCalendar.get(12);
            int n6 = gregorianCalendar.get(13);
            chunkStream.writeShort(n);
            chunkStream.writeByte(n2 + 1);
            chunkStream.writeByte(n3);
            chunkStream.writeByte(n4);
            chunkStream.writeByte(n5);
            chunkStream.writeByte(n6);
            chunkStream.writeToStream(this.w);
        }
    }

    private void q() throws IOException {
        if (this.g.isTextSet()) {
            String[] stringArray = this.g.getText();
            for (int i = 0; i < stringArray.length / 2; ++i) {
                byte[] byArray = stringArray[2 * i].getBytes();
                byte[] byArray2 = stringArray[2 * i + 1].getBytes();
                ChunkStream chunkStream = new ChunkStream("tEXt");
                chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                chunkStream.write(0);
                chunkStream.write(byArray2);
                chunkStream.writeToStream(this.w);
            }
        }
    }

    private void r() throws IOException {
        if (this.g.isCompressedTextSet()) {
            String[] stringArray = this.g.getCompressedText();
            for (int i = 0; i < stringArray.length / 2; ++i) {
                byte[] byArray = stringArray[2 * i].getBytes();
                byte[] byArray2 = stringArray[2 * i + 1].getBytes();
                ChunkStream chunkStream = new ChunkStream("zTXt");
                chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                chunkStream.write(0);
                chunkStream.write(0);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(chunkStream);
                deflaterOutputStream.write(byArray2);
                deflaterOutputStream.finish();
                chunkStream.writeToStream(this.w);
            }
        }
    }

    private void s() throws IOException {
        int n = this.g.getNumPrivateChunks();
        for (int i = 0; i < n; ++i) {
            String string = this.g.getPrivateChunkType(i);
            byte[] byArray = this.g.getPrivateChunkData(i);
            ChunkStream chunkStream = new ChunkStream(string);
            chunkStream.write(byArray);
            chunkStream.writeToStream(this.w);
        }
    }

    private PNGEncodeParam.Gray a(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        PNGEncodeParam.Gray gray = new PNGEncodeParam.Gray();
        int n = 0;
        int n2 = 255 / ((1 << this.k) - 1);
        int n3 = 1 << this.k;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            if (by != i * n2 || by != byArray2[i] || by != byArray3[i]) {
                return null;
            }
            byte by2 = byArray4[i];
            if (by2 == 0) {
                gray.setTransparentGray(i);
                if (++n <= 1) continue;
                return null;
            }
            if (by2 == -1) continue;
            return null;
        }
        return gray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(RenderedImage renderedImage) throws IOException {
        Object object;
        this.h = renderedImage;
        this.i = this.h.getWidth();
        this.j = this.h.getHeight();
        SampleModel sampleModel = this.h.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        this.k = -1;
        this.l = 0;
        if (this.g instanceof PNGEncodeParam.Gray) {
            object = (PNGEncodeParam.Gray)this.g;
            if (((PNGEncodeParam.Gray)object).isBitDepthSet()) {
                this.k = ((PNGEncodeParam)object).getBitDepth();
            }
            if (((PNGEncodeParam.Gray)object).isBitShiftSet()) {
                this.l = ((PNGEncodeParam.Gray)object).getBitShift();
            }
        }
        if (this.k == -1) {
            this.k = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == this.k) continue;
                throw new RuntimeException();
            }
            if (this.k > 2 && this.k < 4) {
                this.k = 4;
            } else if (this.k > 4 && this.k < 8) {
                this.k = 8;
            } else if (this.k > 8 && this.k < 16) {
                this.k = 16;
            } else if (this.k > 16) {
                throw new RuntimeException();
            }
        }
        this.m = sampleModel.getNumBands();
        this.o = this.m * (this.k == 16 ? 2 : 1);
        object = this.h.getColorModel();
        if (object instanceof IndexColorModel) {
            if (this.k < 1 || this.k > 8) {
                throw new RuntimeException();
            }
            if (sampleModel.getNumBands() != 1) {
                throw new RuntimeException();
            }
            IndexColorModel indexColorModel = (IndexColorModel)object;
            int n = indexColorModel.getMapSize();
            this.s = new byte[n];
            this.t = new byte[n];
            this.u = new byte[n];
            this.v = new byte[n];
            indexColorModel.getReds(this.s);
            indexColorModel.getGreens(this.t);
            indexColorModel.getBlues(this.u);
            indexColorModel.getAlphas(this.v);
            this.o = 1;
            if (this.g == null) {
                this.g = this.a(this.s, this.t, this.u, this.v);
            }
            if (this.g == null) {
                this.g = new PNGEncodeParam.Palette();
            }
            if (this.g instanceof PNGEncodeParam.Palette) {
                PNGEncodeParam.Palette palette = (PNGEncodeParam.Palette)this.g;
                if (palette.isPaletteSet()) {
                    int[] nArray2 = palette.getPalette();
                    n = nArray2.length / 3;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        this.s[i] = (byte)nArray2[n2++];
                        this.t[i] = (byte)nArray2[n2++];
                        this.u[i] = (byte)nArray2[n2++];
                        this.v[i] = -1;
                    }
                }
                this.n = 3;
            } else {
                if (!(this.g instanceof PNGEncodeParam.Gray)) throw new RuntimeException();
                this.v = null;
                this.u = null;
                this.t = null;
                this.s = null;
                this.n = 0;
            }
        } else if (this.m == 1) {
            if (this.g == null) {
                this.g = new PNGEncodeParam.Gray();
            }
            this.n = 0;
        } else if (this.m == 2) {
            if (this.g == null) {
                this.g = new PNGEncodeParam.Gray();
            }
            if (this.g.isTransparencySet()) {
                this.p = true;
                this.m = 1;
                if (nArray[0] == 8 && this.k < 8) {
                    this.q = true;
                }
                this.o = this.k == 16 ? 2 : 1;
                this.n = 0;
            } else {
                if (this.k < 8) {
                    this.k = 8;
                }
                this.n = 4;
            }
        } else if (this.m == 3) {
            if (this.g == null) {
                this.g = new PNGEncodeParam.RGB();
            }
            this.n = 2;
        } else if (this.m == 4) {
            if (this.g == null) {
                this.g = new PNGEncodeParam.RGB();
            }
            if (this.g.isTransparencySet()) {
                this.p = true;
                this.m = 3;
                this.o = this.k == 16 ? 6 : 3;
                this.n = 2;
            } else {
                this.n = 6;
            }
        }
        this.r = this.g.getInterlacing();
        this.a();
        this.b();
        this.e();
        this.f();
        this.g();
        this.h();
        this.i();
        this.j();
        this.l();
        this.m();
        this.k();
        this.n();
        this.o();
        this.p();
        this.q();
        this.r();
        this.s();
        this.c();
        this.d();
        this.w.flush();
    }

    static {
        float[] fArray = new float[8];
        fArray[0] = 0.3127f;
        fArray[1] = 0.329f;
        fArray[2] = 0.64f;
        fArray[3] = 0.33f;
        fArray[4] = 0.3f;
        fArray[5] = 0.6f;
        fArray[6] = 0.15f;
        fArray[7] = 0.06f;
        aa = fArray;
    }
}

