/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.css.parser;

import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.parser.DeclarationValue;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.styling.IlvCSSDeclaration;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class Declaration
implements Serializable,
IlvCSSDeclaration {
    private final IlvCSSDOMImplementation a;
    private final String b;
    public String _loadedTarget;
    private DeclarationValue c;
    private IlvCSSDocument d;
    public int _documentLine;

    protected Declaration(IlvCSSDOMImplementation ilvCSSDOMImplementation, String string) {
        this.a = ilvCSSDOMImplementation;
        this._documentLine = -1;
        this.b = string != null ? string.intern() : null;
        this.c = ilvCSSDOMImplementation.getEmptyDeclarationValue();
    }

    public static Declaration copy(Declaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException("null declaration to copy");
        }
        Declaration declaration2 = declaration.a.createDeclaration(declaration.b);
        declaration2.c = declaration.c;
        declaration2.d = declaration.d;
        declaration2._loadedTarget = declaration._loadedTarget;
        declaration2._documentLine = declaration._documentLine;
        return declaration2;
    }

    public static Declaration copy(Declaration declaration, String string) {
        if (declaration == null) {
            throw new IllegalArgumentException("null declaration to copy");
        }
        Declaration declaration2 = declaration.a.createDeclaration(string);
        declaration2.c = declaration.c;
        declaration2.d = declaration.d;
        declaration2._loadedTarget = declaration._loadedTarget;
        declaration2._documentLine = declaration._documentLine;
        return declaration2;
    }

    public final IlvCSSDOMImplementation getDOMImplementation() {
        return this.a;
    }

    public IlvCSSDocument getDocument() {
        if (this.d == null) {
            throw new RuntimeException("null document for declaration " + this);
        }
        return this.d;
    }

    @Override
    public String getProperty() {
        return this.b;
    }

    public String getSource() {
        return this.b;
    }

    public DeclarationValue getDeclarationValue() {
        return this.c;
    }

    public void setDeclarationValue(DeclarationValue declarationValue) {
        if (declarationValue == null) {
            throw new IllegalArgumentException("null DeclarationValue - use getEmptyDeclarationValue() instead");
        }
        this.c = declarationValue;
    }

    @Override
    public String getValue() {
        return this.c.getValueAsString();
    }

    public void setValue(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if (!(string2 = this.c.getValueAsString()).equals(string)) {
            this.c = this.a.createDeclarationValue(string);
        }
    }

    @Override
    public int getLineNumber() {
        return this._documentLine;
    }

    public void setDocument(IlvCSSDocument ilvCSSDocument) {
        this.d = ilvCSSDocument;
    }

    @Override
    public URL getDocumentPath() {
        return this.d == null ? null : this.d.getURL();
    }

    public void setDocumentPath(URL uRL) {
        if (this.getDocument() == null) {
            this.d = new IlvCSSDocument();
        }
        this.d.setURL(uRL);
    }

    public void print(PrintStream printStream, int n) {
        Rule.a(printStream, n);
        printStream.print("{" + this.b + " -> " + this.getValue() + "} ");
    }

    @Override
    public void printCSS(PrintWriter printWriter, int n) {
        this.printCSS(printWriter, n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void printCSS(PrintWriter printWriter, int n, IlvCSSDocument ilvCSSDocument) {
        Rule.a(printWriter, n);
        String string = this.getValue();
        if (this._loadedTarget != null) {
            if (this._loadedTarget.startsWith("url(")) {
                if (!string.startsWith("url(")) {
                    if (ilvCSSDocument != null && ilvCSSDocument.getURL() != null) {
                        string = Declaration.a(string, ilvCSSDocument.getURL());
                    }
                    printWriter.println(this.b + " : \"url(" + Rule.escape(string) + ")\" ;");
                    return;
                }
            }
        }
        printWriter.println(this.b + " : \"" + Rule.escape(string) + "\" ;");
    }

    public boolean equals(Object object) {
        throw new RuntimeException("Want to know where Declaration:equal is used. This is problematic and should be removed. Use isIdentical if possible.");
    }

    @Override
    public boolean isIdentical(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Declaration)) {
            return false;
        }
        Declaration declaration = (Declaration)object;
        if (!Rule.a(this.b, declaration.b)) {
            return false;
        }
        return Rule.a(this.getValue(), declaration.getValue());
    }

    public int hashCode() {
        int n = 0;
        if (this.b != null) {
            n += this.b.hashCode();
        }
        return n ^= this.getValue().hashCode() * 31;
    }

    private static String a(String string, URL uRL) {
        URL uRL2;
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("URL badly formatted: " + string);
        }
        String string2 = IlvURLUtil.getRelativePath(uRL2, uRL);
        if (string2 != null) {
            return string2;
        }
        return string;
    }
}

