/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import ilog.views.util.collections.internal.IlvArrayIterator;
import ilog.views.util.collections.internal.IlvBalancedBinaryTree;
import ilog.views.util.internal.IlvInternalError;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.TreeSet;

public class IlvHashTreeList<E>
extends AbstractList<E>
implements Cloneable,
RandomAccess {
    private transient IlvBalancedBinaryTree a = new IlvBalancedBinaryTree();
    private transient HashMap<E, Object> b = new HashMap();
    private Comparator<Entry> c = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n;
            int n2 = IlvHashTreeList.this.a.getIndexOfEntry(entry);
            return n2 > (n = IlvHashTreeList.this.a.getIndexOfEntry(entry2)) ? 1 : (n2 < n ? -1 : 0);
        }
    };

    public IlvHashTreeList() {
    }

    public IlvHashTreeList(Collection<? extends E> collection) {
        this.a(collection.size(), collection.iterator());
    }

    public IlvHashTreeList(E[] EArray) {
        this.a(EArray.length, new IlvArrayIterator(EArray));
    }

    private void a(E e, Entry<E> entry) {
        Object object = this.b.get(entry.a);
        if (object == null) {
            this.b.put(e, entry);
        } else if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.add(entry);
        } else if (object instanceof Entry) {
            TreeSet<Entry> treeSet = new TreeSet<Entry>(this.c);
            treeSet.add((Entry)object);
            treeSet.add(entry);
            this.b.put(e, treeSet);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency");
        }
    }

    private void b(E e, Entry<E> entry) {
        Object object = this.b.get(entry.a);
        if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.remove(entry);
            if (treeSet.size() == 1) {
                this.b.put(entry.a, treeSet.first());
            }
        } else if (object == entry) {
            this.b.remove(entry.a);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency - did the hash code of an element change?");
        }
    }

    private Entry<E> a(Object object) {
        Object object2 = this.b.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).first();
        }
        return (Entry)object2;
    }

    private Entry<E> b(Object object) {
        Object object2 = this.b.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).last();
        }
        return (Entry)object2;
    }

    private Entry<E> a(int n) {
        return (Entry)this.a.getEntryAt(n);
    }

    private Entry<E> a() {
        int n = this.a.getSize();
        if (n > 0) {
            return (Entry)this.a.getEntryAt(0);
        }
        return null;
    }

    private Entry<E> b() {
        int n = this.a.getSize();
        if (n > 0) {
            return (Entry)this.a.getEntryAt(n - 1);
        }
        return null;
    }

    public E getFirstElement() {
        Entry<E> entry = this.a();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (E)entry.a;
    }

    public E getLastElement() {
        Entry<E> entry = this.b();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (E)entry.a;
    }

    private Entry<E> a(Entry<E> entry) {
        int n;
        IlvBalancedBinaryTree.Node node = entry.getHoldingNode();
        int n2 = node.getEntriesCount();
        for (n = n2 - 1; n >= 0 && node.getEntry(n) != entry; --n) {
        }
        if (n < 0) {
            throw new IllegalStateException();
        }
        if (n + 1 < n2) {
            return (Entry)node.getEntry(n + 1);
        }
        if ((node = this.a.getSuccessor(node)) != null) {
            return (Entry)node.getEntry(0);
        }
        return null;
    }

    private Entry<E> b(Entry<E> entry) {
        int n;
        IlvBalancedBinaryTree.Node node = entry.getHoldingNode();
        int n2 = node.getEntriesCount();
        for (n = n2 - 1; n >= 0 && node.getEntry(n) != entry; --n) {
        }
        if (n < 0) {
            throw new IllegalStateException();
        }
        if (n > 0) {
            return (Entry)node.getEntry(n - 1);
        }
        if ((node = this.a.getPredecessor(node)) != null) {
            return (Entry)node.getEntry(node.getEntriesCount() - 1);
        }
        return null;
    }

    private void c(Entry<E> entry) {
        this.a.deleteEntry(entry);
        ++this.modCount;
        this.b(entry.a, entry);
    }

    @Override
    public int size() {
        return this.a.getSize();
    }

    @Override
    public boolean contains(Object object) {
        return this.b.get(object) != null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int a;
            private Entry<E> b;
            private Entry<E> c;
            {
                this.a = IlvHashTreeList.this.modCount;
                this.b = null;
                this.c = IlvHashTreeList.this.a();
            }

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public E next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                if (IlvHashTreeList.this.modCount != this.a) {
                    throw new ConcurrentModificationException();
                }
                this.b = this.c;
                this.c = IlvHashTreeList.this.a(this.c);
                return this.b.a;
            }

            @Override
            public void remove() {
                if (this.b == null) {
                    throw new IllegalStateException();
                }
                if (IlvHashTreeList.this.modCount != this.a) {
                    throw new ConcurrentModificationException();
                }
                IlvHashTreeList.this.c(this.b);
                ++this.a;
                this.b = null;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        Entry<E> entry = this.a(object);
        if (entry != null) {
            this.c(entry);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.a.deleteAll();
        this.b.clear();
    }

    @Override
    public E get(int n) {
        Entry<E> entry = this.a(n);
        return (E)entry.a;
    }

    private E a(Entry<E> entry, E e) {
        Object t = entry.a;
        if (e != t) {
            this.b(t, entry);
            entry.a = e;
            this.a(e, entry);
        }
        return (E)t;
    }

    @Override
    public E set(int n, E e) {
        Entry<E> entry = this.a(n);
        return this.a(entry, e);
    }

    @Override
    public void add(int n, E e) {
        Entry<E> entry;
        block7: {
            if (n < 0 || n > this.a.getSize()) {
                throw new IndexOutOfBoundsException();
            }
            entry = new Entry<E>(e);
            IlvBalancedBinaryTree.Node node = this.a.getRoot();
            if (node == null) {
                this.a.insertEntryAtRoot(entry);
            } else {
                while (true) {
                    int n2;
                    int n3 = n2 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
                    if (n <= n2) {
                        if (node.getLeftBranch() == null) {
                            this.a.insertEntryBefore(node, entry);
                            break block7;
                        }
                        node = node.getLeftBranch();
                        continue;
                    }
                    int n4 = node.getEntriesCount();
                    if ((n -= n2) < n4) break;
                    if (node.getRightBranch() == null) {
                        this.a.insertEntryAfter(node, entry);
                        break block7;
                    }
                    n -= n4;
                    node = node.getRightBranch();
                }
                this.a.insertEntryInto(node, n, entry);
            }
        }
        ++this.modCount;
        this.a(e, entry);
    }

    @Override
    public E remove(int n) {
        Entry<E> entry = this.a(n);
        Object t = entry.a;
        this.c(entry);
        return (E)t;
    }

    @Override
    public int indexOf(Object object) {
        Entry<E> entry = this.a(object);
        if (entry != null) {
            return this.a.getIndexOfEntry(entry);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Entry<E> entry = this.b(object);
        if (entry != null) {
            return this.a.getIndexOfEntry(entry);
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MyListIterator(0, this.a(), null);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        Entry<E> entry;
        Entry<E> entry2;
        if (n == 0) {
            entry2 = this.a();
            entry = null;
        } else if (n == this.a.getSize()) {
            entry2 = null;
            entry = this.b();
        } else {
            entry2 = this.a(n);
            entry = this.b(entry2);
        }
        return new MyListIterator(n, entry2, entry);
    }

    private void a(int n, Iterator<? extends E> iterator) {
        IlvBalancedBinaryTree.Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[i] = new Entry<E>(iterator.next());
        }
        this.a.init(entryArray);
        Entry<E> entry = this.a();
        while (entry != null) {
            this.a(entry.a, entry);
            entry = this.a(entry);
        }
    }

    public int binarySearch(E e) {
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n = 0;
        while (node != null) {
            int n2 = ((Comparable)((Entry)node.getEntry((int)0)).a).compareTo(e);
            if (n2 > 0) {
                node = node.getLeftBranch();
                continue;
            }
            if (node.getLeftBranch() != null) {
                n += node.getLeftBranch().getBranchSize();
            }
            if (n2 == 0) {
                return n;
            }
            n2 = node.getEntriesCount();
            if (n2 > 1) {
                int n3 = ((Comparable)((Entry)node.getEntry((int)(n2 - 1))).a).compareTo(e);
                if (n3 < 0) {
                    n += n2;
                    node = node.getRightBranch();
                    continue;
                }
                if (n3 == 0) {
                    return n + n2 - 1;
                }
                n3 = 0;
                int n4 = n2 - 1;
                while (n4 - n3 > 1) {
                    int n5 = n3 + n4 >> 1;
                    int n6 = ((Comparable)((Entry)node.getEntry((int)n5)).a).compareTo(e);
                    if (n6 < 0) {
                        n3 = n5;
                        continue;
                    }
                    if (n6 > 0) {
                        n4 = n5;
                        continue;
                    }
                    return n + n5;
                }
                return -(n + n4) - 1;
            }
            n += n2;
            node = node.getRightBranch();
        }
        return -n - 1;
    }

    public int binarySearch(E e, Comparator<? super E> comparator) {
        if (comparator == null) {
            return this.binarySearch(e);
        }
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n = 0;
        while (node != null) {
            int n2 = comparator.compare(((Entry)node.getEntry((int)0)).a, e);
            if (n2 > 0) {
                node = node.getLeftBranch();
                continue;
            }
            if (node.getLeftBranch() != null) {
                n += node.getLeftBranch().getBranchSize();
            }
            if (n2 == 0) {
                return n;
            }
            n2 = node.getEntriesCount();
            if (n2 > 1) {
                int n3 = comparator.compare(((Entry)node.getEntry((int)(n2 - 1))).a, e);
                if (n3 < 0) {
                    n += n2;
                    node = node.getRightBranch();
                    continue;
                }
                if (n3 == 0) {
                    return n + n2 - 1;
                }
                n3 = 0;
                int n4 = n2 - 1;
                while (n4 - n3 > 1) {
                    int n5 = n3 + n4 >> 1;
                    int n6 = comparator.compare(((Entry)node.getEntry((int)n5)).a, e);
                    if (n6 < 0) {
                        n3 = n5;
                        continue;
                    }
                    if (n6 > 0) {
                        n4 = n5;
                        continue;
                    }
                    return n + n5;
                }
                return -(n + n4) - 1;
            }
            n += n2;
            node = node.getRightBranch();
        }
        return -n - 1;
    }

    public int limitedBinarySearch(E e, int n, int n2) {
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n3 = 0;
        while (node != null) {
            int n4;
            int n5;
            int n6 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
            if (n >= n6 + (n5 = node.getEntriesCount())) {
                n -= n6 + n5;
                n2 -= n6 + n5;
                n3 += n6 + n5;
                node = node.getRightBranch();
                continue;
            }
            if (n2 < n6) {
                node = node.getLeftBranch();
                continue;
            }
            if (n <= n6) {
                n4 = ((Comparable)((Entry)node.getEntry((int)0)).a).compareTo(e);
                if (n4 > 0) {
                    node = node.getLeftBranch();
                    continue;
                }
                if (n4 == 0) {
                    return n3;
                }
                n = n6 + 1;
            }
            if (n5 > 1) {
                if (n2 >= n6 + n5 - 1) {
                    n4 = ((Comparable)((Entry)node.getEntry((int)(n5 - 1))).a).compareTo(e);
                    if (n4 < 0) {
                        n -= n6 + n5;
                        n2 -= n6 + n5;
                        n3 += n6 + n5;
                        node = node.getRightBranch();
                        continue;
                    }
                    if (n4 == 0) {
                        return n3 + n5 - 1;
                    }
                    n2 = n6 + n5 - 2;
                }
                n -= n6;
                n2 -= n6;
                n3 += n6;
                while (n <= n2) {
                    n4 = n + n2 >> 1;
                    int n7 = ((Comparable)((Entry)node.getEntry((int)n4)).a).compareTo(e);
                    if (n7 < 0) {
                        n = n4 + 1;
                        continue;
                    }
                    if (n7 > 0) {
                        n2 = n4 - 1;
                        continue;
                    }
                    return n3 + n4;
                }
                return -(n3 + n) - 1;
            }
            n -= n6 + n5;
            n2 -= n6 + n5;
            n3 += n6 + n5;
            node = node.getRightBranch();
        }
        return -n3 - 1;
    }

    public int limitedBinarySearch(E e, Comparator<? super E> comparator, int n, int n2) {
        if (comparator == null) {
            return this.limitedBinarySearch(e, n, n2);
        }
        IlvBalancedBinaryTree.Node node = this.a.getRoot();
        int n3 = 0;
        while (node != null) {
            int n4;
            int n5;
            int n6 = node.getLeftBranch() != null ? node.getLeftBranch().getBranchSize() : 0;
            if (n >= n6 + (n5 = node.getEntriesCount())) {
                n -= n6 + n5;
                n2 -= n6 + n5;
                n3 += n6 + n5;
                node = node.getRightBranch();
                continue;
            }
            if (n2 < n6) {
                node = node.getLeftBranch();
                continue;
            }
            if (n <= n6) {
                n4 = comparator.compare(((Entry)node.getEntry((int)0)).a, e);
                if (n4 > 0) {
                    node = node.getLeftBranch();
                    continue;
                }
                if (n4 == 0) {
                    return n3;
                }
                n = n6 + 1;
            }
            if (n5 > 1) {
                if (n2 >= n6 + n5 - 1) {
                    n4 = comparator.compare(((Entry)node.getEntry((int)(n5 - 1))).a, e);
                    if (n4 < 0) {
                        n -= n6 + n5;
                        n2 -= n6 + n5;
                        n3 += n6 + n5;
                        node = node.getRightBranch();
                        continue;
                    }
                    if (n4 == 0) {
                        return n3 + n5 - 1;
                    }
                    n2 = n6 + n5 - 2;
                }
                n -= n6;
                n2 -= n6;
                n3 += n6;
                while (n <= n2) {
                    n4 = n + n2 >> 1;
                    int n7 = comparator.compare(((Entry)node.getEntry((int)n4)).a, e);
                    if (n7 < 0) {
                        n = n4 + 1;
                        continue;
                    }
                    if (n7 > 0) {
                        n2 = n4 - 1;
                        continue;
                    }
                    return n3 + n4;
                }
                return -(n3 + n) - 1;
            }
            n -= n6 + n5;
            n2 -= n6 + n5;
            n3 += n6 + n5;
            node = node.getRightBranch();
        }
        return -n3 - 1;
    }

    public Object clone() {
        try {
            IlvHashTreeList ilvHashTreeList = (IlvHashTreeList)super.clone();
            ilvHashTreeList.a = new IlvBalancedBinaryTree();
            ilvHashTreeList.b = new HashMap();
            ilvHashTreeList.modCount = 0;
            ilvHashTreeList.a(this.size(), this.iterator());
            return ilvHashTreeList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private class MyListIterator
    implements ListIterator<E> {
        private int a;
        private Entry<E> b;
        private Entry<E> c;
        private Entry<E> d;
        private int e;

        MyListIterator(int n, Entry<E> entry, Entry<E> entry2) {
            this.a = IlvHashTreeList.this.modCount;
            this.b = null;
            this.c = IlvHashTreeList.this.a();
            this.d = null;
            this.e = 0;
            this.e = n;
            this.c = entry;
            this.d = entry2;
        }

        @Override
        public boolean hasNext() {
            return this.c != null;
        }

        @Override
        public E next() {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.c;
            this.d = this.c;
            this.c = IlvHashTreeList.this.a(this.c);
            ++this.e;
            return this.b.a;
        }

        @Override
        public boolean hasPrevious() {
            return this.d != null;
        }

        @Override
        public E previous() {
            if (this.d == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.d;
            this.c = this.d;
            this.d = IlvHashTreeList.this.b(this.d);
            --this.e;
            return this.b.a;
        }

        @Override
        public int nextIndex() {
            return this.e;
        }

        @Override
        public int previousIndex() {
            return this.e - 1;
        }

        @Override
        public void remove() {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            if (this.b == this.d) {
                this.d = IlvHashTreeList.this.b(this.b);
                --this.e;
            } else {
                this.c = IlvHashTreeList.this.a(this.b);
            }
            IlvHashTreeList.this.c(this.b);
            ++this.a;
            this.b = null;
        }

        @Override
        public void set(E e) {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.a(this.b, e);
        }

        @Override
        public void add(E e) {
            if (IlvHashTreeList.this.modCount != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.add(this.e, e);
            ++this.e;
            ++this.a;
            this.b = null;
        }
    }

    static class Entry<T>
    extends IlvBalancedBinaryTree.Entry {
        T a;

        Entry(T t) {
            this.a = t;
        }

        public String toString() {
            return "+" + this.a;
        }
    }
}

