/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.builder.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.event.IlvMessageMapper;
import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.event.MessageListener;
import ilog.views.appframe.swing.IlvPanelView;
import ilog.views.appframe.swing.IlvPopupMenu;
import ilog.views.builder.IlvBuilder;
import ilog.views.symbology.builder.IlvSymbolDesignerUtilities;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerDocument;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerView;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteListener;
import ilog.views.symbology.palettes.event.PaletteViewerEvent;
import ilog.views.symbology.palettes.event.PaletteViewerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteDocumentationDialog;
import ilog.views.symbology.palettes.swing.IlvPaletteManagerCollapsibleTreeViewer;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeViewer;
import ilog.views.symbology.palettes.swing.event.PaletteDropEvent;
import ilog.views.symbology.palettes.swing.event.PaletteDropListener;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JTree;

public class IlvSymbolPaletteView
extends IlvPanelView {
    private IlvPaletteManager a;
    private IlvPopupMenu b;
    private IlvPopupMenu c;
    private PaletteDropListener d;
    private IlvPaletteDocumentationDialog e = null;
    private IlvPaletteManagerCollapsibleTreeViewer f = null;

    public IlvSymbolPaletteView() {
        this.setLayout(new BorderLayout());
        this.d = new DragDropPaletteListener();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    IlvSymbolPaletteView.this.editSymbol();
                }
            }
        };
        final class MyPMCTV
        extends IlvPaletteManagerCollapsibleTreeViewer {
            public MyPMCTV(PaletteListener paletteListener, MouseListener mouseListener, PaletteDropListener paletteDropListener) {
                super(paletteListener, mouseListener, paletteDropListener);
            }

            @Override
            public void select(IlvPalette ilvPalette) {
                super.select(ilvPalette);
                IlvSymbolPaletteView.this.updateActionState();
            }
        }
        this.f = new MyPMCTV(null, mouseAdapter, this.d);
        this.f.setEditable(true);
        this.f.setMultiSelectionEnabled(true);
        this.add(this.f);
        this.f.addPaletteViewerListener(new PaletteViewerListener(){

            @Override
            public void categorySelected(PaletteViewerEvent paletteViewerEvent) {
                IlvSymbolPaletteView.this.updateActionState();
            }

            @Override
            public void symbolSelected(PaletteViewerEvent paletteViewerEvent) {
                IlvSymbolPaletteView.this.updateActionState();
            }

            @Override
            public void categoryDeselected(PaletteViewerEvent paletteViewerEvent) {
                IlvSymbolPaletteView.this.updateActionState();
            }

            @Override
            public void symbolDeselected(PaletteViewerEvent paletteViewerEvent) {
                IlvSymbolPaletteView.this.updateActionState();
            }
        });
        this.b = new IlvPopupMenu();
        this.b.setSettingsName("symbolPaletteViewPopupMenu");
        this.c = new IlvPopupMenu();
        this.c.setSettingsName("symbolPaletteTabPopupMenu");
        this.f.setTreePopupMenu(this.b);
        this.f.setHeaderPopupMenu(this.c);
    }

    public void updateActionState() {
        String[] stringArray = new String[8];
        stringArray[0] = "NewCategory";
        stringArray[1] = "NewSymbol";
        stringArray[2] = "EditSymbol";
        stringArray[3] = "CategoryProperties";
        stringArray[4] = "PaletteProperties";
        stringArray[5] = "DeletePaletteObject";
        stringArray[6] = "SavePaletteAs";
        stringArray[7] = "ClosePalette";
        String[] stringArray2 = stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            Action action = this.getApplication().getAction(stringArray2[i]);
            if (action == null) continue;
            this.updateAction(action);
        }
    }

    @Override
    public void setApplication(IlvApplication ilvApplication) {
        super.setApplication(ilvApplication);
        this.b.setApplication(ilvApplication);
        this.c.setApplication(ilvApplication);
        this.a = this.a();
        this.f.setPaletteManager(this.a);
        int n = this.a.getPaletteCount();
        if (n > 0) {
            this.f.select(this.a.getPalette(0), true);
        }
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                this.f.select(this.a.getPalette(i), true);
            }
        }
        this.getApplication().addMessageListener(new MessageListener(){

            @Override
            public void receiveMessage(MessageEvent messageEvent) {
                if ("SymbolOpened".equals(messageEvent.getMessageName())) {
                    IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)messageEvent.getMessageParameters()[1];
                    IlvSymbolPaletteView.this.f.select(ilvPaletteSymbol);
                } else if ("SymbolPaletteRenamed".equals(messageEvent.getMessageName())) {
                    IlvPalette ilvPalette = (IlvPalette)messageEvent.getMessageParameters()[0];
                    IlvSymbolPaletteView.this.f.refreshCollapsiblePanelHeader(ilvPalette);
                }
            }
        }, "");
    }

    @Override
    protected void registerMappings(IlvMessageMapper ilvMessageMapper) {
        super.registerMappings(ilvMessageMapper);
        ilvMessageMapper.registerActionMethod("NewPalette", "newPalette");
        ilvMessageMapper.registerActionMethod("NewCategory", "newCategory");
        ilvMessageMapper.registerActionStateMethod("NewCategory", "newCategoryState");
        ilvMessageMapper.registerActionMethod("NewSymbol", "newSymbol");
        ilvMessageMapper.registerActionStateMethod("NewSymbol", "newSymbolState");
        ilvMessageMapper.registerActionMethod("EditSymbol", "editSymbol");
        ilvMessageMapper.registerActionStateMethod("EditSymbol", "editSymbolState");
        ilvMessageMapper.registerActionMethod("CategoryProperties", "categoryProperties");
        ilvMessageMapper.registerActionStateMethod("CategoryProperties", "categoryPropertiesState");
        ilvMessageMapper.registerActionMethod("PaletteProperties", "paletteProperties");
        ilvMessageMapper.registerActionStateMethod("PaletteProperties", "palettePropertiesState");
        ilvMessageMapper.registerActionMethod("DeletePaletteObject", "deletePaletteObject");
        ilvMessageMapper.registerActionStateMethod("DeletePaletteObject", "deletePaletteObjectState");
        ilvMessageMapper.registerActionMethod("ClosePalette", "closePalette");
        ilvMessageMapper.registerActionStateMethod("ClosePalette", "closePaletteState");
        ilvMessageMapper.registerActionMethod("OpenPalette", "openPalette");
        ilvMessageMapper.registerActionMethod("SavePaletteAs", "savePaletteAs");
        ilvMessageMapper.registerActionStateMethod("SavePaletteAs", "savePaletteAsState");
        ilvMessageMapper.registerActionMethod("Reporting", "reporting");
        ilvMessageMapper.registerActionStateMethod("Reporting", "reportingState");
    }

    public void newPalette() {
        IlvPalette ilvPalette = IlvSymbolDesignerUtilities.newPalette(this.getApplication(), this.a());
    }

    public void newCategory() {
        if (this.f()) {
            String string = this.getApplication().getString("SymbolDesigner.DefaultCategoryName");
            IlvPaletteCategory ilvPaletteCategory = new IlvPaletteCategory(string);
            ilvPaletteCategory.setName(string);
            if (this.a(ilvPaletteCategory)) {
                if (this.e() != null) {
                    this.e().add(ilvPaletteCategory);
                } else {
                    this.b().getRoot().add(ilvPaletteCategory);
                }
                this.f();
                this.b(ilvPaletteCategory);
            }
        }
    }

    public void newCategoryState(Action action) {
        boolean bl = this.a != null && this.b() != null && !this.a.isPaletteReadOnly(this.b());
        action.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSymbol() {
        IlvSymbolDesignerDocument ilvSymbolDesignerDocument = (IlvSymbolDesignerDocument)this.getApplication().newDocument(this.getApplication().getDocumentTemplate("Symbol"), true, null);
        if (ilvSymbolDesignerDocument != null) {
            IlvPaletteSymbol ilvPaletteSymbol = ilvSymbolDesignerDocument.getEditorDocument().getSymbol();
            if (this.e() != null) {
                this.e().add(ilvPaletteSymbol);
            } else {
                this.b().getRoot().add(ilvPaletteSymbol);
            }
            File file = null;
            try {
                try {
                    file = ilvSymbolDesignerDocument.getEditorDocument().setAutomaticIcon(ilvPaletteSymbol);
                }
                catch (MalformedURLException malformedURLException) {
                    file = null;
                }
                this.f();
                try {
                    ilvSymbolDesignerDocument.setPathName(new URL(IlvSymbolDesignerUtilities.getPaletteObjectURL(this.b().getJarURL(), SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbol))));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
                this.b(ilvPaletteSymbol);
            }
            finally {
                file.delete();
            }
        }
    }

    public void newSymbolState(Action action) {
        boolean bl = this.a != null && this.b() != null && !this.a.isPaletteReadOnly(this.b());
        action.setEnabled(bl);
    }

    public void editSymbol() {
        IlvPaletteSymbol[] ilvPaletteSymbolArray = this.d();
        IlvPalette ilvPalette = this.b();
        if (ilvPaletteSymbolArray != null && ilvPalette != null) {
            for (int i = 0; i < ilvPaletteSymbolArray.length; ++i) {
                String string = SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbolArray[i]);
                IlvSymbolDesignerUtilities.openSymbol(this.getApplication(), ilvPalette.getJarURL(), string);
            }
        }
    }

    public void editSymbolState(Action action) {
        if (this.a().isPaletteReadOnly(this.b())) {
            action.putValue("Name", this.getApplication().getString("SymbolDesigner.Action.EditSymbol.AlternateName"));
        } else {
            action.putValue("Name", this.getApplication().getString("SymbolDesigner.Action.EditSymbol.Name"));
        }
        action.setEnabled(this.d().length > 0);
    }

    public void categoryProperties() {
        if (this.a().isPaletteReadOnly(this.b())) {
            this.a(this.e());
        } else if (this.f() && this.a(this.e())) {
            this.f();
        }
    }

    public void categoryPropertiesState(Action action) {
        action.setEnabled(this.e() != null);
    }

    public void paletteProperties() {
        if (this.a().isPaletteReadOnly(this.b())) {
            this.a(this.b());
        } else if (this.f() && this.a(this.b())) {
            this.f();
        }
    }

    public void palettePropertiesState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void deletePaletteObject() {
        IlvPaletteObject[] ilvPaletteObjectArray = this.f.getSelectedPaletteObjects();
        for (int i = 0; i < ilvPaletteObjectArray.length; ++i) {
            IlvPaletteObject ilvPaletteObject = ilvPaletteObjectArray[i];
            if (ilvPaletteObject == null) continue;
            String string = ilvPaletteObject instanceof IlvPaletteSymbol ? "Symbol" : "Category";
            if (JOptionPane.showOptionDialog(IlvBuilder.getBuilder(this.getApplication()).getFrame(), this.getApplication().getString("SymbolDesigner.ConfirmDelete" + string + ".Message"), this.getApplication().getString("SymbolDesigner.ConfirmDelete" + string + ".Title"), 0, 3, null, null, null) != 0 || !this.f()) continue;
            ilvPaletteObject.getParent().remove(ilvPaletteObject);
            this.f();
        }
    }

    public void deletePaletteObjectState(Action action) {
        if (this.a().isPaletteReadOnly(this.b())) {
            action.setEnabled(false);
            return;
        }
        IlvPaletteObject[] ilvPaletteObjectArray = this.f.getSelectedPaletteObjects();
        boolean bl = ilvPaletteObjectArray.length > 0;
        for (int i = 0; i < ilvPaletteObjectArray.length; ++i) {
            if (ilvPaletteObjectArray[i].getParent() != null) continue;
            bl = false;
        }
        action.setEnabled(bl);
    }

    public void openPalette(ActionEvent actionEvent) {
        IlvPalette ilvPalette = IlvSymbolDesignerUtilities.openPalette(this.getApplication(), this.a());
        if (ilvPalette != null) {
            this.f.select(ilvPalette, true);
        }
    }

    public void savePaletteAs() {
        File file;
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null && (file = IlvSymbolDesignerUtilities.choosePaletteFile(this.getApplication(), false, IlvURLUtil.convertFileURLToFile(ilvPalette.getJarURL()))) != null) {
            this.a(ilvPalette, file);
        }
    }

    public void savePaletteAsState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void closePalette() {
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null) {
            IlvSymbolDesignerView ilvSymbolDesignerView;
            this.a.remove(ilvPalette);
            ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(this);
            if (componentContext != null && (ilvSymbolDesignerView = (IlvSymbolDesignerView)this.getApplication().getActiveView(true)) != null) {
                componentContext.setTarget(ilvSymbolDesignerView.getEditorView());
            }
            this.updateActionState();
        }
    }

    public void closePaletteState(Action action) {
        action.setEnabled(this.b() != null);
    }

    public void reporting() {
        if (this.e == null) {
            this.e = new IlvPaletteDocumentationDialog(this.a());
        }
        IlvPaletteTreeViewer ilvPaletteTreeViewer = (IlvPaletteTreeViewer)this.f.getSelectedPaletteViewer();
        this.e.run(this.getApplication().getMainComponent(), ilvPaletteTreeViewer.getPalette(), ilvPaletteTreeViewer.getSelectedPaletteObjects());
    }

    public void reportingState(Action action) {
        action.setEnabled(this.d().length > 0 || this.b() != null);
    }

    private IlvPaletteManager a() {
        return IlvSymbolDesignerUtilities.getPaletteManager(this.getApplication());
    }

    private IlvPalette b() {
        return this.f.getSelectedPalette();
    }

    private IlvPaletteSymbol c() {
        return this.f.getSelectedSymbol();
    }

    private IlvPaletteSymbol[] d() {
        return this.f.getSelectedSymbols();
    }

    private IlvPaletteCategory e() {
        return this.f.getSelectedCategory();
    }

    private boolean f() {
        IlvPalette ilvPalette = this.b();
        if (ilvPalette != null) {
            if (!this.a().isPaletteReadOnly(ilvPalette)) {
                return this.a(this.b(), IlvURLUtil.convertFileURLToFile(ilvPalette.getJarURL()));
            }
            IlvBuilder.showErrorBox(this.getApplication(), "SymbolDesigner.CannotSaveReadOnlyPalette", null);
            return false;
        }
        return false;
    }

    private boolean a(IlvPalette ilvPalette, File file) {
        return IlvSymbolDesignerUtilities.savePalette(this.getApplication(), this.a(), ilvPalette, file);
    }

    private boolean a(Object object) {
        return IlvSymbolDesignerUtilities.showPalettePropertiesForm(this, this.getApplication(), object, false);
    }

    private void b(Object object) {
        JTree jTree = (JTree)((IlvPaletteTreeViewer)this.f.getSelectedPaletteViewer()).getComponent();
        IlvSymbolDesignerUtilities.expandAll(jTree);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            if (jTree.getPathForRow(i).getLastPathComponent() != object) continue;
            jTree.setSelectionRow(i);
            break;
        }
    }

    private class DragDropPaletteListener
    implements PaletteDropListener {
        private DragDropPaletteListener() {
        }

        @Override
        public void objectsCopied(PaletteDropEvent paletteDropEvent) {
            IlvPalette ilvPalette = paletteDropEvent.getTargetPalette();
            IlvSymbolDesignerUtilities.savePalette(IlvSymbolPaletteView.this.getApplication(), IlvSymbolPaletteView.this.a(), ilvPalette, IlvURLUtil.convertFileURLToFile(ilvPalette.getJarURL()));
        }

        @Override
        public void objectsMoved(PaletteDropEvent paletteDropEvent) {
            IlvPalette ilvPalette = paletteDropEvent.getTargetPalette();
            IlvPalette ilvPalette2 = paletteDropEvent.getSourcePalette();
            IlvDocument[] ilvDocumentArray = IlvSymbolPaletteView.this.getApplication().getOpenDocuments();
            for (int i = 0; i < ilvDocumentArray.length; ++i) {
                IlvDocument ilvDocument = ilvDocumentArray[i];
                if (!(ilvDocument instanceof IlvSymbolDesignerDocument)) continue;
                IlvSymbolDesignerDocument ilvSymbolDesignerDocument = (IlvSymbolDesignerDocument)ilvDocument;
                IlvSymbolEditorDocument ilvSymbolEditorDocument = ilvSymbolDesignerDocument.getEditorDocument();
                Collection collection = paletteDropEvent.getChildren();
                for (Object e : collection) {
                    if (!(e instanceof IlvPaletteSymbol)) continue;
                    IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)e;
                    if (ilvSymbolEditorDocument.getOriginalSymbol() != ilvPaletteSymbol) continue;
                    try {
                        URL uRL = new URL(IlvSymbolDesignerUtilities.getPaletteObjectURL(ilvPalette.getJarURL(), SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbol)));
                        ilvSymbolDesignerDocument.setPathName(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new RuntimeException(malformedURLException);
                    }
                }
            }
            if (IlvSymbolDesignerUtilities.savePalette(IlvSymbolPaletteView.this.getApplication(), IlvSymbolPaletteView.this.a(), ilvPalette, IlvURLUtil.convertFileURLToFile(ilvPalette.getJarURL())) && ilvPalette != ilvPalette2) {
                IlvSymbolDesignerUtilities.savePalette(IlvSymbolPaletteView.this.getApplication(), IlvSymbolPaletteView.this.a(), ilvPalette2, IlvURLUtil.convertFileURLToFile(ilvPalette2.getJarURL()));
            }
        }
    }
}

