/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.swing;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentAboutToChangeEvent;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentMonitor;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerLayerVisibilityEvent;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.internal.IlvUtility;
import ilog.views.swing.IlvToolTipManager;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.beans.Beans;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class IlvJScrollManagerView
extends JComponent {
    private static UI a;
    private IlvManagerView b;
    private JScrollBar c;
    private JScrollBar d;
    private int e;
    private int f;
    private boolean g = true;
    private boolean h = true;
    private int i;
    private int j;
    private boolean k;
    private scrollListener l = new scrollListener();
    private Object m;
    private int n = 0;
    private int o = 0;
    private transient MouseEvent p = null;
    private transient Timer q = new Timer(this.o + 50, new showPendingToolTipAction());
    private transient long r = 0L;
    private transient Object s = null;
    private transient String t = null;
    private transient IlvPoint u = new IlvPoint();
    private transient int v = 0;
    private transient boolean w = false;
    private boolean x = false;
    private IlvBoundingBoxCache y = new IlvBoundingBoxCache(1);
    public static final int VERTICAL_SCROLLBAR_AS_NEEDED = 20;
    public static final int VERTICAL_SCROLLBAR_NEVER = 21;
    public static final int VERTICAL_SCROLLBAR_ALWAYS = 22;
    public static final int HORIZONTAL_SCROLLBAR_AS_NEEDED = 30;
    public static final int HORIZONTAL_SCROLLBAR_NEVER = 31;
    public static final int HORIZONTAL_SCROLLBAR_ALWAYS = 32;

    private boolean a(IlvGraphic ilvGraphic) {
        IlvTransformer ilvTransformer = this.b.getTransformer();
        IlvRect ilvRect = this.y.get(ilvTransformer);
        if (ilvRect == null) {
            return false;
        }
        IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
        return ilvRect2.x > ilvRect.x && ilvRect2.x + ilvRect2.width < ilvRect.x + ilvRect.width && ilvRect2.y > ilvRect.y && ilvRect2.y + ilvRect2.height < ilvRect.y + ilvRect.height;
    }

    public IlvJScrollManagerView() {
        this(new IlvManager(), new IlvTransformer());
    }

    public IlvJScrollManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        this.b = this.createManagerView(ilvManager, ilvTransformer);
        this.a();
    }

    public IlvJScrollManagerView(IlvManagerView ilvManagerView) {
        this.b = ilvManagerView;
        this.a();
    }

    @Override
    public void updateUI() {
        if (a == null) {
            a = new UI();
        }
        this.setUI(a);
    }

    public void setAdjusting(boolean bl) {
        if (bl) {
            ++this.v;
            if (this.v == 1) {
                this.w = false;
            }
        } else if (this.v > 0) {
            --this.v;
            if (this.v == 0 && this.w) {
                this.w = false;
                this.x = false;
                this.adjustScrollBars();
            }
        }
    }

    public final boolean isAdjusting() {
        return this.v > 0;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public final JScrollBar getVerticalScrollBar() {
        return this.c;
    }

    public final JScrollBar getHorizontalScrollBar() {
        return this.d;
    }

    protected IlvManagerView createManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        return new IlvManagerView(ilvManager, ilvTransformer);
    }

    private final void a() {
        this.setBorder(new BevelBorder(1));
        this.setLayout(null);
        this.add(this.b);
        this.c = new JScrollBar(1);
        this.c.setUnitIncrement(10);
        this.add(this.c);
        this.d = new JScrollBar(0);
        this.d.setUnitIncrement(10);
        this.add(this.d);
        this.setOpaque(true);
        this.updateUI();
        this.i = 22;
        this.j = 32;
        this.v = 0;
        this.q.setRepeats(false);
    }

    @Override
    public void removeNotify() {
        this.k = false;
        this.d.removeAdjustmentListener(this.l);
        this.c.removeAdjustmentListener(this.l);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.d.addAdjustmentListener(this.l);
        this.c.addAdjustmentListener(this.l);
        this.k = true;
        this.adjustScrollBars();
    }

    @Override
    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getBorder().getBorderInsets(this);
        int n3 = this.g ? this.c.getPreferredSize().width : 0;
        int n4 = this.h ? this.d.getPreferredSize().height : 0;
        this.b.setBounds(insets.left, insets.top, Math.max(0, n - n3 - (insets.left + insets.right)), Math.max(0, n2 - n4 - (insets.top + insets.bottom)));
        if (this.g) {
            this.c.setBounds(n - n3 - insets.right, insets.top, n3, n2 - n4 - (insets.top + insets.bottom));
        }
        if (this.h) {
            this.d.setBounds(insets.left, n2 - n4 - insets.bottom, n - n3 - (insets.left + insets.right), n4);
        }
    }

    public final IlvManagerView getView() {
        return this.b;
    }

    public final void setView(IlvManagerView ilvManagerView) {
        if (ilvManagerView == null) {
            if (Beans.isDesignTime()) {
                return;
            }
            throw new IllegalArgumentException("view cannot be null");
        }
        this.addImpl(ilvManagerView, null, 0);
    }

    public void adjustScrollBars() {
        if (IlvSwingUtil.isDispatchThread()) {
            this.c();
        } else {
            this.b();
        }
    }

    private void b() {
        if (this.x) {
            return;
        }
        this.x = true;
        SwingUtilities.invokeLater(this.l);
    }

    private void c() {
        if (!this.k) {
            return;
        }
        if (this.isAdjusting()) {
            this.w = true;
            return;
        }
        this.x = false;
        IlvRect ilvRect = this.b.computeBBox();
        this.y.put(this.b.getTransformer(), new IlvRect(ilvRect));
        int n = this.b.getHeight();
        int n2 = this.b.getWidth();
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, n2, n);
        ilvRect.width = (float)Math.floor((double)ilvRect.width + 1.0);
        ilvRect.height = (float)Math.floor((double)ilvRect.height + 1.0);
        ilvRect.x = (float)Math.floor(ilvRect.x);
        ilvRect.y = (float)Math.floor(ilvRect.y);
        ilvRect.add(ilvRect2);
        this.e = -((int)ilvRect.x);
        this.f = -((int)ilvRect.y);
        if (this.getHorizontalScrollBarPolicy() == 30) {
            if (ilvRect2.x <= ilvRect.x && ilvRect.x + ilvRect.width <= ilvRect2.x + ilvRect2.width) {
                this.setHorizontalScrollBarVisible(false);
            } else {
                this.setHorizontalScrollBarVisible(true);
            }
        }
        if (this.getVerticalScrollBarPolicy() == 20) {
            if (ilvRect2.y <= ilvRect.y && ilvRect.y + ilvRect.height <= ilvRect2.y + ilvRect2.height) {
                this.setVerticalScrollBarVisible(false);
            } else {
                this.setVerticalScrollBarVisible(true);
            }
        }
        if (this.c != null && this.g && (this.c.getValue() != this.f || this.c.getVisibleAmount() != n || (float)this.c.getMaximum() != ilvRect.height)) {
            this.c.removeAdjustmentListener(this.l);
            this.c.setValues(this.f, n > 0 ? n : 1, 0, (int)ilvRect.height);
            this.c.setBlockIncrement(Math.max(this.c.getVisibleAmount(), 1));
            this.c.addAdjustmentListener(this.l);
        }
        if (this.d != null && this.h && (this.d.getValue() != this.e || this.d.getVisibleAmount() != n2 || (float)this.d.getMaximum() != ilvRect.width)) {
            this.d.removeAdjustmentListener(this.l);
            this.d.setValues(this.e, n2 > 0 ? n2 : 1, 0, (int)ilvRect.width);
            this.d.setBlockIncrement(Math.max(this.d.getVisibleAmount(), 1));
            this.d.addAdjustmentListener(this.l);
        }
        if (this.d != null) {
            this.e = this.d.getValue();
        }
        if (this.c != null) {
            this.f = this.c.getValue();
        }
    }

    public void adjustView() {
        if (this.d.getValue() != this.e || this.c.getValue() != this.f) {
            this.b.removeTransformerListener(this.l);
            this.b.removeComponentListener(this.l);
            this.b.translate(this.d != null && this.h ? (float)(-(this.d.getValue() - this.e)) : 0.0f, this.c != null && this.g ? (float)(-(this.c.getValue() - this.f)) : 0.0f, true);
            this.b.addTransformerListener(this.l);
            this.b.addComponentListener(this.l);
            if (this.getHorizontalScrollBarPolicy() == 30 || this.getVerticalScrollBarPolicy() == 20) {
                this.adjustScrollBars();
            }
            float f = ((Component)this.c).getHeight();
            float f2 = ((Component)this.c).getWidth();
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, f2, f);
            IlvRect ilvRect2 = this.b.computeBBox();
            ilvRect2.add(ilvRect);
            ilvRect2.width = (float)Math.floor((double)ilvRect2.width + 1.0);
            ilvRect2.height = (float)Math.floor((double)ilvRect2.height + 1.0);
            ilvRect2.x = (float)Math.floor(ilvRect2.x);
            ilvRect2.y = (float)Math.floor(ilvRect2.y);
            this.e = this.d.getValue();
            this.f = this.c.getValue();
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.i;
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (n == this.i) {
            return;
        }
        switch (n) {
            case 20: {
                this.i = n;
                this.adjustScrollBars();
                break;
            }
            case 21: {
                this.i = n;
                this.setVerticalScrollBarVisible(false);
                break;
            }
            case 22: {
                this.i = n;
                this.setVerticalScrollBarVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
            }
        }
    }

    public int getHorizontalScrollBarPolicy() {
        return this.j;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        if (n == this.j) {
            return;
        }
        switch (n) {
            case 30: {
                this.j = n;
                this.adjustScrollBars();
                break;
            }
            case 31: {
                this.j = n;
                this.setHorizontalScrollBarVisible(false);
                break;
            }
            case 32: {
                this.j = n;
                this.setHorizontalScrollBarVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
            }
        }
    }

    public boolean isVerticalScrollBarVisible() {
        return this.g;
    }

    public void setVerticalScrollBarVisible(boolean bl) {
        if (bl == this.g) {
            return;
        }
        this.g = bl;
        if (bl) {
            this.adjustScrollBars();
            this.invalidate();
            this.add(this.c);
            this.validate();
        } else {
            this.remove(this.c);
            this.invalidate();
            this.validate();
        }
    }

    public boolean isHorizontalScrollBarVisible() {
        return this.h;
    }

    public void setHorizontalScrollBarVisible(boolean bl) {
        if (bl == this.h) {
            return;
        }
        this.h = bl;
        if (bl) {
            this.adjustScrollBars();
            this.invalidate();
            this.add(this.d);
            this.validate();
        } else {
            this.remove(this.d);
            this.invalidate();
            this.validate();
        }
    }

    public boolean isWheelScrollingEnabled() {
        return this.m != null;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl) {
            if (this.m == null) {
                this.m = new IlvUtility.MouseWheelAdapter(this);
                this.addMouseWheelListener((MouseWheelListener)this.m);
            }
        } else if (this.m != null) {
            this.removeMouseWheelListener((MouseWheelListener)this.m);
            this.m = null;
        }
    }

    public void processManagerViewKeyEvent(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.b) {
            keyEvent.setSource(this);
        }
        try {
            this.processKeyEvent(keyEvent);
        }
        finally {
            if (keyEvent.getSource() != object) {
                keyEvent.setSource(object);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.h && this.g) {
            graphics.setColor(this.getBackground());
            Border border = this.getBorder();
            int n = 0;
            int n2 = 0;
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n = insets.right;
                n2 = insets.bottom;
            }
            int n3 = this.c.getPreferredSize().width;
            int n4 = this.d.getPreferredSize().height;
            graphics.fillRect(this.getWidth() - n3 - n, this.getHeight() - n4 - n2, n3, n4);
            try {
                if (UIManager.getLookAndFeel().getName().contains("GTK")) {
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.paintComponent(graphics);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof IlvManagerView) {
            if (this.b != null && this.b.getParent() == this) {
                this.b.removeTransformerListener(this.l);
                this.b.removeComponentListener(this.l);
                this.b.removeManagerChangedListener(this.l);
                this.b.getManager().removeManagerContentChangedListener(this.l);
                this.b.getManager().removeManagerLayerListener(this.l);
                this.remove(this.b);
            }
            this.b = (IlvManagerView)component;
            this.b.addTransformerListener(this.l);
            this.b.addComponentListener(this.l);
            this.b.addManagerChangedListener(this.l);
            this.b.getManager().addManagerContentChangedListener(this.l);
            this.b.getManager().addManagerLayerListener(this.l);
            this.setToolTipDelay(0);
        }
        super.addImpl(component, object, n);
    }

    public void setToolTipDelay(int n) {
        if (n != this.n) {
            boolean bl = this.n > 0;
            boolean bl2 = n > 0;
            this.o = this.n = n;
            this.p = null;
            this.q.setInitialDelay(this.o + 50);
            if (bl != bl2) {
                if (bl2) {
                    ToolTipManager.sharedInstance().registerComponent(this);
                } else {
                    ToolTipManager.sharedInstance().unregisterComponent(this);
                    this.s = null;
                    this.t = null;
                }
            }
        }
    }

    public final int getToolTipDelay() {
        return this.n;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.n <= 0) {
            return super.getToolTipText(mouseEvent);
        }
        long l = System.currentTimeMillis();
        if (l - this.r < (long)this.n) {
            this.p = mouseEvent;
            this.q.start();
            return this.t;
        }
        this.r = l;
        this.a(mouseEvent);
        this.p = null;
        return this.t;
    }

    private boolean a(MouseEvent mouseEvent) {
        Serializable serializable;
        String string;
        IlvTransformer ilvTransformer;
        IlvManagerView ilvManagerView = this.getView();
        this.u.move(mouseEvent.getX(), mouseEvent.getY());
        long l = System.currentTimeMillis();
        IlvGraphic ilvGraphic = ilvManagerView.getManager().getObject(this.u, ilvManagerView, true);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        this.o = this.n + (int)l3 / 4;
        this.q.setInitialDelay(this.o + 50);
        if (ilvGraphic != null) {
            ilvTransformer = ilvManagerView.getTransformer();
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag instanceof IlvManager) {
                ilvTransformer = ((IlvManager)ilvGraphicBag).getDrawingTransformer(ilvManagerView);
            }
            serializable = (string = ilvGraphic.getToolTipText(this.u, ilvTransformer)) != null ? ilvGraphic : null;
        } else {
            ilvTransformer = ilvManagerView.getTransformer();
            ilvGraphic = ilvManagerView.getManager();
            string = ilvGraphic.getToolTipText(this.u, ilvTransformer);
            serializable = string != null ? ilvManagerView : null;
        }
        string = IlvToolTipManager.a(string, ilvGraphic);
        boolean bl = serializable != this.s || !(string == null ? this.t == null : string.equals(this.t));
        this.s = serializable;
        this.t = string;
        return bl;
    }

    private class showPendingToolTipAction
    implements ActionListener {
        private showPendingToolTipAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IlvJScrollManagerView.this.p != null && IlvJScrollManagerView.this.n >= 0) {
                MouseEvent mouseEvent = IlvJScrollManagerView.this.p;
                IlvJScrollManagerView.this.r = System.currentTimeMillis();
                boolean bl = IlvJScrollManagerView.this.a(mouseEvent);
                IlvJScrollManagerView.this.p = null;
                if (bl) {
                    MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    ToolTipManager.sharedInstance().mouseExited(mouseEvent2);
                    MouseEvent mouseEvent3 = new MouseEvent((Component)mouseEvent.getSource(), 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    ToolTipManager.sharedInstance().mouseEntered(mouseEvent3);
                    MouseEvent mouseEvent4 = new MouseEvent((Component)mouseEvent.getSource(), 503, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    ToolTipManager.sharedInstance().mouseMoved(mouseEvent4);
                }
            }
        }
    }

    private static class UI
    extends ComponentUI {
        private UI() {
        }

        @Override
        public void update(Graphics graphics, JComponent jComponent) {
            IlvJScrollManagerView ilvJScrollManagerView = (IlvJScrollManagerView)jComponent;
            IlvManagerView ilvManagerView = ilvJScrollManagerView.getView();
            if (jComponent.isOpaque() && (ilvManagerView == null || ilvManagerView.isTransparent())) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
            this.paint(graphics, jComponent);
        }
    }

    private class scrollListener
    extends ComponentAdapter
    implements TransformerListener,
    ManagerContentMonitor,
    ManagerLayerListener,
    AdjustmentListener,
    Serializable,
    Runnable,
    ManagerChangedListener {
        private scrollListener() {
        }

        @Override
        public void managerChanged(ManagerChangedEvent managerChangedEvent) {
            if (managerChangedEvent.getOldValue() != null) {
                managerChangedEvent.getOldValue().removeManagerContentChangedListener(this);
                managerChangedEvent.getOldValue().removeManagerLayerListener(this);
            }
            if (managerChangedEvent.getNewValue() != null) {
                managerChangedEvent.getNewValue().addManagerContentChangedListener(this);
                managerChangedEvent.getNewValue().addManagerLayerListener(this);
            }
            IlvJScrollManagerView.this.adjustScrollBars();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            IlvJScrollManagerView.this.c();
        }

        @Override
        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            IlvJScrollManagerView.this.adjustScrollBars();
        }

        @Override
        public void contentAboutToChange(ManagerContentAboutToChangeEvent managerContentAboutToChangeEvent) {
            IlvGraphic ilvGraphic = managerContentAboutToChangeEvent.getGraphicObject();
            if (IlvJScrollManagerView.this.a(ilvGraphic)) {
                return;
            }
            if (!managerContentAboutToChangeEvent.isAdjusting()) {
                IlvJScrollManagerView.this.b();
            }
        }

        @Override
        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            if (!managerContentChangedEvent.isAdjusting()) {
                IlvGraphic ilvGraphic;
                IlvGraphic ilvGraphic2;
                IlvGraphic ilvGraphic3;
                if (managerContentChangedEvent instanceof ObjectInsertedEvent ? IlvJScrollManagerView.this.a(ilvGraphic3 = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject()) : (managerContentChangedEvent instanceof ObjectVisibilityChangedEvent ? IlvJScrollManagerView.this.a(ilvGraphic2 = ((ObjectVisibilityChangedEvent)managerContentChangedEvent).getGraphicObject()) : (managerContentChangedEvent instanceof ObjectBBoxChangedEvent ? IlvJScrollManagerView.this.a(ilvGraphic = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getGraphicObject()) : managerContentChangedEvent instanceof ObjectRemovedEvent))) {
                    return;
                }
                IlvJScrollManagerView.this.b();
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            IlvJScrollManagerView.this.adjustView();
        }

        @Override
        public void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
        }

        @Override
        public void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
        }

        @Override
        public void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
        }

        @Override
        public void layerChanged(ManagerLayerEvent managerLayerEvent) {
            IlvManagerView ilvManagerView;
            if (managerLayerEvent instanceof ManagerLayerVisibilityEvent && ((ilvManagerView = ((ManagerLayerVisibilityEvent)managerLayerEvent).getManagerView()) == null || ilvManagerView == IlvJScrollManagerView.this.b)) {
                IlvJScrollManagerView.this.adjustScrollBars();
            }
        }

        @Override
        public void run() {
            IlvJScrollManagerView.this.c();
        }
    }
}

