/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.IlvUtility;
import ilog.views.linkconnector.IlvShapePath;
import ilog.views.util.java2d.internal.IlvMath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Vector;

public class IlvClippingUtil {
    private IlvClippingUtil() {
    }

    public static void ConnectLinksToPoint(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, IlvPoint ilvPoint, final IlvTransformer ilvTransformer, boolean bl) {
        final IlvGraphic ilvGraphic2 = ilvGraphic;
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            @Override
            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvPoint ilvPoint = (IlvPoint)object;
                IlvTransformer ilvTransformer2 = ilvTransformer;
                if (ilvGraphic.getGraphicBag() != ilvGraphic2.getGraphicBag() && ilvTransformer != (ilvTransformer2 = IlvUtility.getTransformerFromTo(ilvGraphic2, ilvTransformer, ilvGraphic))) {
                    ilvPoint = new IlvPoint(ilvPoint);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPoint);
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse(ilvPoint);
                    }
                }
                ((IlvLinkImage)ilvGraphic).movePoint(0, ilvPoint.x, ilvPoint.y, ilvTransformer2);
            }
        };
        ilvGrapher.applyToObjects(ilvGrapher.getLinksFrom(ilvGraphic), ilvApplyObject, (Object)ilvPoint, bl);
        IlvApplyObject ilvApplyObject2 = new IlvApplyObject(){

            @Override
            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvPoint ilvPoint = (IlvPoint)object;
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
                IlvTransformer ilvTransformer2 = ilvTransformer;
                if (ilvGraphic.getGraphicBag() != ilvGraphic2.getGraphicBag() && ilvTransformer != (ilvTransformer2 = IlvUtility.getTransformerFromTo(ilvGraphic2, ilvTransformer, ilvGraphic))) {
                    ilvPoint = new IlvPoint(ilvPoint);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPoint);
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse(ilvPoint);
                    }
                }
                ilvLinkImage.movePoint(ilvLinkImage.getPointsCardinal() - 1, ilvPoint.x, ilvPoint.y, ilvTransformer2);
            }
        };
        ilvGrapher.applyToObjects(ilvGrapher.getLinksTo(ilvGraphic), ilvApplyObject2, (Object)ilvPoint, bl);
    }

    public static void ConnectToPoint(IlvLinkImage ilvLinkImage, final IlvPoint ilvPoint, final IlvPoint ilvPoint2, final IlvTransformer ilvTransformer, boolean bl) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            @Override
            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
                if (ilvPoint != null) {
                    ilvLinkImage.movePoint(0, ilvPoint.x, ilvPoint.y, ilvTransformer);
                }
                if (ilvPoint2 != null) {
                    ilvLinkImage.movePoint(ilvLinkImage.getPointsCardinal() - 1, ilvPoint2.x, ilvPoint2.y, ilvTransformer);
                }
            }
        };
        if (ilvLinkImage.getGraphicBag() == null) {
            ilvApplyObject.apply(ilvLinkImage, null);
        } else {
            ilvLinkImage.getGraphicBag().applyToObject(ilvLinkImage, ilvApplyObject, null, bl);
        }
    }

    public static void ConnectToViewPoint(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, boolean bl) {
        if (ilvPoint != null && ilvTransformer != null) {
            ilvPoint = new IlvPoint(ilvPoint);
            ilvTransformer.inverse(ilvPoint);
        }
        if (ilvPoint2 != null && ilvTransformer != null) {
            ilvPoint2 = new IlvPoint(ilvPoint2);
            ilvTransformer.inverse(ilvPoint2);
        }
        IlvClippingUtil.ConnectToPoint(ilvLinkImage, ilvPoint, ilvPoint2, ilvTransformer, bl);
    }

    public static void ConnectToNodeCenters(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2, IlvTransformer ilvTransformer, boolean bl3) {
        IlvRect ilvRect;
        IlvTransformer ilvTransformer2;
        IlvPoint ilvPoint = null;
        if (bl) {
            ilvTransformer2 = IlvUtility.getTransformerFromTo(ilvLinkImage, ilvTransformer, ilvLinkImage.getFrom());
            ilvRect = ilvLinkImage.getFrom().boundingBox(ilvTransformer2);
            ilvPoint = new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
        }
        IlvPoint ilvPoint2 = null;
        if (bl2) {
            ilvTransformer2 = IlvUtility.getTransformerFromTo(ilvLinkImage, ilvTransformer, ilvLinkImage.getTo());
            ilvRect = ilvLinkImage.getTo().boundingBox(ilvTransformer2);
            ilvPoint2 = new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
        }
        IlvClippingUtil.ConnectToViewPoint(ilvLinkImage, ilvPoint, ilvPoint2, ilvTransformer, bl3);
    }

    public static IlvPoint BestClipPointOnRay(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n) {
        if (n == 0) {
            return new IlvPoint(ilvPoint);
        }
        boolean bl = false;
        IlvPoint ilvPoint3 = null;
        IlvPoint ilvPoint4 = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.0;
        double d3 = ilvPoint2.x - ilvPoint.x;
        double d4 = ilvPoint2.y - ilvPoint.y;
        double d5 = d3 * d3 + d4 * d4;
        for (int i = 0; i < n; ++i) {
            if (ilvPointArray[i] == null) continue;
            d3 = ilvPointArray[i].x - ilvPoint.x;
            d4 = ilvPointArray[i].y - ilvPoint.y;
            double d6 = d3 * d3 + d4 * d4;
            if (IlvClippingUtil.a(ilvPoint, ilvPoint2, ilvPointArray[i])) {
                if (!(d5 >= d6)) continue;
                bl = true;
                if (!(d6 > d2)) continue;
                d2 = d6;
                ilvPoint4 = ilvPointArray[i];
                continue;
            }
            if (bl || !(d6 <= d)) continue;
            d = d6;
            ilvPoint3 = ilvPointArray[i];
        }
        return bl ? ilvPoint4 : (ilvPoint3 != null ? ilvPoint3 : new IlvPoint(ilvPoint));
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        float f;
        float f2 = ilvPoint2.x > ilvPoint.x ? ilvPoint2.x - ilvPoint.x : ilvPoint.x - ilvPoint2.x;
        float f3 = f = ilvPoint2.y > ilvPoint.y ? ilvPoint2.y - ilvPoint.y : ilvPoint.y - ilvPoint2.y;
        if (f2 > f) {
            if (ilvPoint.x < ilvPoint2.x && ilvPoint.x <= ilvPoint3.x) {
                return true;
            }
            if (ilvPoint.x > ilvPoint2.x && ilvPoint.x >= ilvPoint3.x) {
                return true;
            }
        } else {
            if (ilvPoint.y < ilvPoint2.y && ilvPoint.y <= ilvPoint3.y) {
                return true;
            }
            if (ilvPoint.y > ilvPoint2.y && ilvPoint.y >= ilvPoint3.y) {
                return true;
            }
        }
        return false;
    }

    public static boolean LineIntersectsSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5) {
        if (ilvPoint3.equals(ilvPoint4)) {
            if ((ilvPoint3.x - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) == (ilvPoint2.x - ilvPoint.x) * (ilvPoint3.y - ilvPoint.y)) {
                ilvPoint5.x = ilvPoint3.x;
                ilvPoint5.y = ilvPoint3.y;
                return true;
            }
        } else if (IlvUtil.GetLineIntersection(ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5) != null) {
            float f;
            float f2 = ilvPoint4.x > ilvPoint3.x ? ilvPoint4.x - ilvPoint3.x : ilvPoint3.x - ilvPoint4.x;
            float f3 = f = ilvPoint4.y > ilvPoint3.y ? ilvPoint4.y - ilvPoint3.y : ilvPoint3.y - ilvPoint4.y;
            if (f2 > f ? ilvPoint3.x <= ilvPoint5.x && ilvPoint5.x <= ilvPoint4.x || ilvPoint4.x <= ilvPoint5.x && ilvPoint5.x <= ilvPoint3.x : ilvPoint3.y <= ilvPoint5.y && ilvPoint5.y <= ilvPoint4.y || ilvPoint4.y <= ilvPoint5.y && ilvPoint5.y <= ilvPoint3.y) {
                return true;
            }
        }
        return false;
    }

    public static int LineIntersectsPolyPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, boolean bl, IlvPoint[] ilvPointArray2) {
        IlvPoint ilvPoint3;
        int n = 0;
        IlvPoint ilvPoint4 = null;
        IlvPoint ilvPoint5 = null;
        IlvPoint ilvPoint6 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Point2D point2D = null;
        IlvPoint ilvPoint7 = new IlvPoint();
        IlvPoint ilvPoint8 = new IlvPoint();
        IlvPoint ilvPoint9 = new IlvPoint();
        for (int i = 0; i < ilvPointArray.length; ++i) {
            ilvPoint6 = ilvPointArray[i];
            if (ilvPoint5 != null && IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint6, ilvPoint7) && (point2D == null || !point2D.equals(ilvPoint7))) {
                int n2 = n++;
                point2D = ilvPoint7;
                ilvPointArray2[n2] = point2D;
                ilvPoint7 = new IlvPoint();
                bl4 = true;
                if (i == 1) {
                    bl2 = true;
                }
            }
            if (ilvPoint4 != null && !bl3 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint5.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint5.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) && (point2D == null || !point2D.equals(ilvPoint5))) {
                    int n3 = n++;
                    point2D = ilvPoint5;
                    ilvPointArray2[n3] = point2D;
                }
            }
            ilvPoint4 = ilvPoint5;
            ilvPoint5 = ilvPoint6;
            bl3 = bl4;
        }
        IlvPoint ilvPoint10 = ilvPoint3 = n > 0 ? ilvPointArray2[0] : null;
        if (ilvPointArray.length > 2 && bl) {
            ilvPoint6 = ilvPointArray[0];
            if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint6, ilvPoint7) || point2D != null && point2D.equals(ilvPoint7) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint7))) {
                ilvPointArray2[n++] = ilvPoint7;
                ilvPoint7 = new IlvPoint();
                bl4 = true;
            }
            if (!bl3 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint5.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint5.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) || point2D != null && point2D.equals(ilvPoint5) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint5))) {
                    int n4 = n++;
                    point2D = ilvPoint5;
                    ilvPointArray2[n4] = point2D;
                }
            }
            ilvPoint4 = ilvPointArray[0];
            if (!bl2 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint6.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint6.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) || point2D != null && point2D.equals(ilvPoint6) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint6))) {
                    ilvPointArray2[n++] = ilvPoint6;
                }
            }
        }
        return n;
    }

    public static int LineIntersectsEllipse(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, IlvPoint[] ilvPointArray) {
        double d = ilvPoint2.x - ilvPoint.x;
        double d2 = ilvPoint2.y - ilvPoint.y;
        double d3 = 0.5 * (double)ilvRect.width;
        double d4 = 0.5 * (double)ilvRect.height;
        double d5 = (double)ilvRect.x + d3;
        double d6 = (double)ilvRect.y + d4;
        if (d == 0.0 && d2 == 0.0) {
            return 0;
        }
        double d7 = d > 0.0 ? d : -d;
        double d8 = d2 > 0.0 ? d2 : -d2;
        if (d7 > d8) {
            double d9 = d2 / d;
            double d10 = (double)ilvPoint.y - d6 - d9 * ((double)ilvPoint.x - d5);
            double d11 = d4 * d4 + d3 * d3 * d9 * d9 - d10 * d10;
            if (d11 < 0.0) {
                return 0;
            }
            if (d11 == 0.0) {
                double d12 = -d9 * d10 * d3 * d3 / (d4 * d4 + d3 * d3 * d9 * d9);
                double d13 = d9 * d12 + d10;
                ilvPointArray[0] = new IlvPoint((float)(d12 + d5), (float)(d13 + d6));
                return 1;
            }
            double d14 = Math.sqrt(d11);
            double d15 = (d3 * d4 * d14 - d9 * d10 * d3 * d3) / (d4 * d4 + d3 * d3 * d9 * d9);
            double d16 = d9 * d15 + d10;
            ilvPointArray[0] = new IlvPoint((float)(d15 + d5), (float)(d16 + d6));
            d15 = (-d3 * d4 * d14 - d9 * d10 * d3 * d3) / (d4 * d4 + d3 * d3 * d9 * d9);
            d16 = d9 * d15 + d10;
            ilvPointArray[1] = new IlvPoint((float)(d15 + d5), (float)(d16 + d6));
            return 2;
        }
        double d17 = d / d2;
        double d18 = (double)ilvPoint.x - d5 - d17 * ((double)ilvPoint.y - d6);
        double d19 = d3 * d3 + d4 * d4 * d17 * d17 - d18 * d18;
        if (d19 < 0.0) {
            return 0;
        }
        if (d19 == 0.0) {
            double d20 = -d17 * d18 * d4 * d4 / (d3 * d3 + d4 * d4 * d17 * d17);
            double d21 = d17 * d20 + d18;
            ilvPointArray[0] = new IlvPoint((float)(d21 + d5), (float)(d20 + d6));
            return 1;
        }
        double d22 = Math.sqrt(d19);
        double d23 = (d3 * d4 * d22 - d17 * d18 * d4 * d4) / (d3 * d3 + d4 * d4 * d17 * d17);
        double d24 = d17 * d23 + d18;
        ilvPointArray[0] = new IlvPoint((float)(d24 + d5), (float)(d23 + d6));
        d23 = (-d3 * d4 * d22 - d17 * d18 * d4 * d4) / (d3 * d3 + d4 * d4 * d17 * d17);
        d24 = d17 * d23 + d18;
        ilvPointArray[1] = new IlvPoint((float)(d24 + d5), (float)(d23 + d6));
        return 2;
    }

    public static int LineIntersectsArc(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, double d, double d2, IlvPoint[] ilvPointArray) {
        int n;
        int n2 = IlvClippingUtil.LineIntersectsEllipse(ilvPoint, ilvPoint2, ilvRect, ilvPointArray);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!(IlvClippingUtil.a(ilvRect, ilvPointArray[n], d) <= d2)) continue;
            ilvPointArray[n3++] = ilvPointArray[n];
        }
        for (n = n3; n < n2; ++n) {
            ilvPointArray[n] = null;
        }
        return n3;
    }

    public static int LineIntersectsQuadSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n, IlvPoint[] ilvPointArray2) {
        int n2;
        double d;
        double d2;
        double d3 = ilvPointArray[n].x;
        double d4 = 2.0 * ((double)ilvPointArray[n + 1].x - d3);
        double d5 = (double)ilvPointArray[n + 2].x - d4 - d3;
        double d6 = ilvPointArray[n].y;
        double d7 = 2.0 * ((double)ilvPointArray[n + 1].y - d6);
        double d8 = (double)ilvPointArray[n + 2].y - d7 - d6;
        double d9 = ilvPoint2.x - ilvPoint.x;
        double d10 = ilvPoint2.y - ilvPoint.y;
        if (d9 == 0.0 && d10 == 0.0) {
            return 0;
        }
        double[] dArray = new double[2];
        double d11 = d9 > 0.0 ? d9 : -d9;
        double d12 = d10 > 0.0 ? d10 : -d10;
        if (d11 > d12) {
            d2 = d10 / d9;
            d = (double)ilvPoint.y - d2 * (double)ilvPoint.x;
            n2 = IlvMath.calcQuadSolution(d2 * d5 - d8, d2 * d4 - d7, d2 * d3 - d6 + d, dArray);
        } else {
            d2 = d9 / d10;
            d = (double)ilvPoint.x - d2 * (double)ilvPoint.y;
            n2 = IlvMath.calcQuadSolution(d2 * d8 - d5, d2 * d7 - d4, d2 * d6 - d3 + d, dArray);
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(0.0 <= dArray[i]) || !(dArray[i] <= 1.0)) continue;
            ilvPointArray2[n3++] = new IlvPoint((float)(d5 * dArray[i] * dArray[i] + d4 * dArray[i] + d3), (float)(d8 * dArray[i] * dArray[i] + d7 * dArray[i] + d6));
        }
        return n3;
    }

    public static int LineIntersectsCubicSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n, IlvPoint[] ilvPointArray2) {
        int n2;
        double d;
        double d2;
        double d3 = ilvPointArray[n].x;
        double d4 = 3.0 * ((double)ilvPointArray[n + 1].x - d3);
        double d5 = (double)(3.0f * (ilvPointArray[n + 2].x - ilvPointArray[n + 1].x)) - d4;
        double d6 = (double)ilvPointArray[n + 3].x - d5 - d4 - d3;
        double d7 = ilvPointArray[n].y;
        double d8 = 3.0 * ((double)ilvPointArray[n + 1].y - d7);
        double d9 = (double)(3.0f * (ilvPointArray[n + 2].y - ilvPointArray[n + 1].y)) - d8;
        double d10 = (double)ilvPointArray[n + 3].y - d9 - d8 - d7;
        double d11 = ilvPoint2.x - ilvPoint.x;
        double d12 = ilvPoint2.y - ilvPoint.y;
        if (d11 == 0.0 && d12 == 0.0) {
            return 0;
        }
        double[] dArray = new double[3];
        double d13 = d11 > 0.0 ? d11 : -d11;
        double d14 = d12 > 0.0 ? d12 : -d12;
        if (d13 > d14) {
            d2 = d12 / d11;
            d = (double)ilvPoint.y - d2 * (double)ilvPoint.x;
            n2 = IlvMath.calcCubicSolution(d2 * d6 - d10, d2 * d5 - d9, d2 * d4 - d8, d2 * d3 - d7 + d, dArray);
        } else {
            d2 = d11 / d12;
            d = (double)ilvPoint.x - d2 * (double)ilvPoint.y;
            n2 = IlvMath.calcCubicSolution(d2 * d10 - d6, d2 * d9 - d5, d2 * d8 - d4, d2 * d7 - d3 + d, dArray);
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(0.0 <= dArray[i]) || !(dArray[i] <= 1.0)) continue;
            ilvPointArray2[n3++] = new IlvPoint((float)(d6 * dArray[i] * dArray[i] * dArray[i] + d5 * dArray[i] * dArray[i] + d4 * dArray[i] + d3), (float)(d10 * dArray[i] * dArray[i] * dArray[i] + d9 * dArray[i] * dArray[i] + d8 * dArray[i] + d7));
        }
        return n3;
    }

    private static double a(IlvRect ilvRect, IlvPoint ilvPoint, double d) {
        float f = ilvPoint.x - ilvRect.x - ilvRect.width / 2.0f;
        float f2 = ilvRect.y + ilvRect.height / 2.0f - ilvPoint.y;
        double d2 = (double)f / (double)ilvRect.width;
        double d3 = (double)f2 / (double)ilvRect.height;
        double d4 = 57.29577951308232 * Math.atan2(d3, d2);
        d4 -= d;
        while (d4 < 0.0) {
            d4 += 360.0;
        }
        while (d4 > 360.0) {
            d4 -= 360.0;
        }
        return d4;
    }

    private static void a(IlvRect ilvRect, double d, IlvPoint ilvPoint) {
        d = d * Math.PI / 180.0;
        ilvPoint.x = ilvRect.x + 0.5f * ilvRect.width * (1.0f + (float)Math.cos(d));
        ilvPoint.y = ilvRect.y + 0.5f * ilvRect.height * (1.0f - (float)Math.sin(d));
    }

    public static IlvPoint ArcStartPoint(IlvRect ilvRect, double d) {
        double d2 = d;
        IlvPoint ilvPoint = new IlvPoint();
        IlvClippingUtil.a(ilvRect, d2, ilvPoint);
        double d3 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
        if (d3 > 180.0) {
            double d4 = 0.0;
            while (d3 > 180.0) {
                d2 = d + (d4 += 0.004);
                IlvClippingUtil.a(ilvRect, d2, ilvPoint);
                d3 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
            }
            double d5 = d4;
            while (d3 < 180.0) {
                d5 = d4;
                d2 = d + (d4 /= 8.0);
                IlvClippingUtil.a(ilvRect, d2, ilvPoint);
                d3 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
            }
            d2 = d + d5;
            IlvClippingUtil.a(ilvRect, d2, ilvPoint);
        }
        return ilvPoint;
    }

    public static IlvPoint ArcEndPoint(IlvRect ilvRect, double d, double d2) {
        if (d2 == 0.0) {
            return IlvClippingUtil.ArcStartPoint(ilvRect, d);
        }
        double d3 = d + d2;
        IlvPoint ilvPoint = new IlvPoint();
        IlvClippingUtil.a(ilvRect, d3, ilvPoint);
        double d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
        if (d4 > d2) {
            double d5 = 0.0;
            while (d4 > d2) {
                d3 = d + d2 - (d5 += 0.004);
                IlvClippingUtil.a(ilvRect, d3, ilvPoint);
                d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
            }
            double d6 = d5;
            while (d4 < d2) {
                d6 = d5;
                d3 = d + d2 - (d5 /= 8.0);
                IlvClippingUtil.a(ilvRect, d3, ilvPoint);
                d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d);
            }
            d3 = d + d2 - d6;
            IlvClippingUtil.a(ilvRect, d3, ilvPoint);
        }
        return ilvPoint;
    }

    public static IlvPoint getClippedPoint(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        if (ilvGraphic instanceof IlvShapePath) {
            if (ilvPoint == null || ilvPoint2 == null) {
                return null;
            }
            if (ilvPoint.equals(ilvPoint2)) {
                return new IlvPoint(ilvPoint);
            }
            return IlvClippingUtil.getClippedPoint(((IlvShapePath)((Object)ilvGraphic)).getShapePath(ilvTransformer), null, 0.0f, ilvPoint, ilvPoint2);
        }
        return ilvGraphic.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public static IlvPoint getClippedPoint(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        IlvPoint[] ilvPointArray;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        ilvPointArray = new IlvPoint[]{new IlvPoint(ilvRect.x, ilvRect.y), new IlvPoint(ilvRect.x + ilvRect.width, ilvPointArray[0].y), new IlvPoint(ilvPointArray[1].x, ilvRect.y + ilvRect.height), new IlvPoint(ilvRect.x, ilvPointArray[2].y)};
        IlvPoint[] ilvPointArray2 = new IlvPoint[4];
        int n = IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray, true, ilvPointArray2);
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray2, n);
    }

    public static IlvPoint getClippedPoint(PathIterator pathIterator, IlvTransformer ilvTransformer, float f, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        double d;
        double d2;
        double d3;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        Vector<IlvPoint> vector = new Vector<IlvPoint>(2, 2);
        IlvPoint[] ilvPointArray = new IlvPoint[3];
        float[] fArray = new float[6];
        IlvPoint[] ilvPointArray2 = new IlvPoint[4];
        for (int i = 0; i < 4; ++i) {
            ilvPointArray2[i] = new IlvPoint();
        }
        IlvPoint ilvPoint3 = new IlvPoint();
        IlvPoint ilvPoint4 = new IlvPoint();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    ilvPointArray2[0].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[0]);
                    }
                    ilvPoint3.move(ilvPointArray2[0].x, ilvPointArray2[0].y);
                    break;
                }
                case 1: {
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[1], ilvPointArray2[0]);
                    IlvPoint ilvPoint5 = new IlvPoint();
                    if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[0], ilvPointArray2[1], ilvPoint5)) {
                        vector.addElement(ilvPoint5);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 2: {
                    int n;
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPointArray2[2].move(fArray[2], fArray[3]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[2]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[2]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[2], ilvPointArray2[1]);
                    int n2 = IlvClippingUtil.LineIntersectsQuadSpline(ilvPoint, ilvPoint2, ilvPointArray2, 0, ilvPointArray);
                    for (n = 0; n < n2; ++n) {
                        vector.addElement(ilvPointArray[n]);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 3: {
                    int n;
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPointArray2[2].move(fArray[2], fArray[3]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[2]);
                    }
                    ilvPointArray2[3].move(fArray[4], fArray[5]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[3]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[3]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[3], ilvPointArray2[2]);
                    int n2 = IlvClippingUtil.LineIntersectsCubicSpline(ilvPoint, ilvPoint2, ilvPointArray2, 0, ilvPointArray);
                    for (n = 0; n < n2; ++n) {
                        vector.addElement(ilvPointArray[n]);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 4: {
                    ilvPointArray2[1].setLocation(ilvPoint3);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[1], ilvPointArray2[0]);
                    IlvPoint ilvPoint5 = new IlvPoint();
                    if (!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[0], ilvPointArray2[1], ilvPoint5)) break;
                    vector.addElement(ilvPoint5);
                }
            }
            pathIterator.next();
        }
        if (vector.size() == 0) {
            return new IlvPoint(ilvPoint);
        }
        Object[] objectArray = new IlvPoint[vector.size()];
        vector.copyInto(objectArray);
        IlvPoint ilvPoint6 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, (IlvPoint[])objectArray, objectArray.length);
        if (f > 0.0f && objectArray.length > 0 && (d3 = Math.sqrt((d2 = (double)(ilvPoint2.x - ilvPoint.x)) * d2 + (d = (double)(ilvPoint2.y - ilvPoint.y)) * d)) != 0.0) {
            ilvPoint6.x += (float)(0.5 * (double)f * d2 / d3);
            ilvPoint6.y += (float)(0.5 * (double)f * d / d3);
        }
        return ilvPoint6;
    }

    private static void a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        float f = ilvPoint.x;
        double d = ilvPoint2.x - f;
        float f2 = ilvPoint.y;
        double d2 = ilvPoint2.y - f2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 > (double)1.0E-11f) {
            float f3 = 1.0E-5f;
            for (int i = 0; i < 6; ++i) {
                ilvPoint.x -= (float)(d / d3 * (double)f3);
                ilvPoint.y -= (float)(d2 / d3 * (double)f3);
                if (ilvPoint.x != f || ilvPoint.y != f2) {
                    return;
                }
                f3 *= 10.0f;
            }
        }
    }
}

