/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkpolicy;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvTunnelCrossings
extends IlvAbstractCrossingGraphic {
    public IlvTunnelCrossings(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage) {
        super(ilvCrossingAwareLinkImage);
    }

    public IlvTunnelCrossings(IlvTunnelCrossings ilvTunnelCrossings) {
        super(ilvTunnelCrossings);
    }

    public IlvTunnelCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvTunnelCrossings(this);
    }

    @Override
    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        graphics.setColor(ilvLinkImage.getForeground());
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, true, false);
        if (!drawingParameters.g) {
            return;
        }
        IlvGraphicUtil.DrawBezier(graphics, drawingParameters.a, 4, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
        IlvGraphicUtil.DrawBezier(graphics, drawingParameters.b, 4, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.c, 2, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
    }

    @Override
    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint3, ilvPoint4, ilvPoint5, ilvPoint6, f3, false, false);
        if (!drawingParameters.g) {
            return false;
        }
        if (IlvGraphicUtil.PointInBezier(ilvPoint2, drawingParameters.a, 4, drawingParameters.d, 0, 1, null)) {
            return true;
        }
        if (IlvGraphicUtil.PointInBezier(ilvPoint2, drawingParameters.b, 4, drawingParameters.d, 0, 1, null)) {
            return true;
        }
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, drawingParameters.c, 2, drawingParameters.d, 0, 1, null);
    }

    @Override
    public IlvRect expandLinkBoundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        float f;
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = this.getRelatedLinkImage();
        float f2 = ilvCrossingAwareLinkImage.getGap();
        if (ilvCrossingAwareLinkImage.isGapZoomable()) {
            f2 = (float)((double)f2 * d);
        }
        if ((f = ilvCrossingAwareLinkImage.getLineWidth()) != 0.0f) {
            float f3 = ilvCrossingAwareLinkImage.getMaximumLineWidth();
            f = IlvStrokeInfo.zoomedLineWidth(f, f3, ilvTransformer, true);
        }
        f = (float)((double)f * d);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f2 + f, f2);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f2 + f, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f2, 2.0f * f2 + f);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f2 + f);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect4 = new IlvRect(ilvRect);
        ilvRect4.x -= 1.5f * ilvRect3.width;
        ilvRect4.y -= 1.5f * ilvRect2.height;
        ilvRect4.width += 3.0f * ilvRect3.width;
        ilvRect4.height += 3.0f * ilvRect2.height;
        return ilvRect4;
    }

    @Override
    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, false, true);
        if (!drawingParameters.g) {
            return;
        }
        IlvRect ilvRect2 = new IlvRect();
        IlvGraphicUtil.BezierBoundingBox(ilvRect2, drawingParameters.a, 4, drawingParameters.d, 0, 1, null);
        ilvRect.add(ilvRect2);
        IlvGraphicUtil.BezierBoundingBox(ilvRect2, drawingParameters.b, 4, drawingParameters.d, 0, 1, null);
        ilvRect.add(ilvRect2);
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.c, 2, drawingParameters.d, 0, 1, null));
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        IlvPoint[] c;
        float d;
        float e;
        float[] f;
        boolean g = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, boolean bl, boolean bl2) {
            float f2;
            float f3;
            float f4;
            double d;
            this.e = ilvLinkImage.getLineWidth();
            int n = ilvLinkImage.getEndCap();
            double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (bl) {
                this.f = ilvLinkImage.getLineStyle();
            }
            if (this.e != 0.0f) {
                f4 = ilvLinkImage.getMaximumLineWidth();
                if (bl) {
                    this.f = IlvStrokeInfo.zoomedLineStyle(this.f, this.e, f4, ilvTransformer);
                }
                this.e = IlvStrokeInfo.zoomedLineWidth(this.e, f4, ilvTransformer, bl2);
            }
            this.d = (float)((double)this.e * d);
            f4 = ilvPoint3.x - ilvPoint2.x;
            float f5 = ilvPoint3.y - ilvPoint2.y;
            double d3 = Math.sqrt(f4 * f4 + f5 * f5);
            if (d3 == 0.0) {
                this.g = false;
                return;
            }
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (n == 0) {
                double d4;
                if (ilvPoint != null) {
                    f3 = ilvPoint2.x - ilvPoint.x;
                    f2 = ilvPoint2.y - ilvPoint.y;
                    if (Math.abs(f3 * f5 - f2 * f4) < 0.01f) {
                        d4 = Math.sqrt(f3 * f3 + f2 * f2);
                        if (d4 > (double)(0.5f * this.d)) {
                            f6 = (float)((double)(0.5f * this.d * f4) / d3);
                            f7 = (float)((double)(0.5f * this.d * f5) / d3);
                        }
                    }
                }
                if (ilvPoint4 != null) {
                    f3 = ilvPoint4.x - ilvPoint3.x;
                    f2 = ilvPoint4.y - ilvPoint3.y;
                    if (Math.abs(f3 * f5 - f2 * f4) < 0.01f) {
                        d4 = Math.sqrt(f3 * f3 + f2 * f2);
                        if (d4 > (double)(0.5f * this.d)) {
                            f8 = (float)((double)(0.5f * this.d * f4) / d3);
                            f9 = (float)((double)(0.5f * this.d * f5) / d3);
                        }
                    }
                }
                if ((d3 = Math.sqrt((f4 += f6 + f8) * f4 + (f5 += f7 + f9) * f5)) == 0.0) {
                    this.g = false;
                    return;
                }
            }
            f3 = 0.5f * this.d + f;
            f2 = 0.5f * this.d + f;
            if (f2 == 0.0f) {
                this.g = false;
                return;
            }
            if ((double)(2.0f * f3) > d3) {
                f3 = (float)(d3 / 2.0);
            }
            int n2 = -1;
            if (f4 < 0.0f || f4 == 0.0f && f5 < 0.0f) {
                n2 = 1;
            }
            this.a = new IlvPoint[4];
            this.b = new IlvPoint[4];
            this.c = new IlvPoint[2];
            float f10 = ilvPoint2.x - f6;
            float f11 = ilvPoint2.y - f7;
            float f12 = ilvPoint3.x + f8;
            float f13 = ilvPoint3.y + f9;
            float f14 = -((float)((double)((float)n2 * f2 * f5) / d3));
            float f15 = (float)((double)((float)n2 * f2 * f4) / d3);
            float f16 = (float)((double)(f3 * f4) / d3);
            float f17 = (float)((double)(f3 * f5) / d3);
            this.a[0] = new IlvPoint(f10, f11);
            this.a[1] = new IlvPoint(f10 + 0.42f * f14, f11 + 0.42f * f15);
            this.a[2] = new IlvPoint(f10 + 0.58f * f16 + f14, f11 + 0.58f * f17 + f15);
            this.a[3] = new IlvPoint(f10 + f16 + f14, f11 + f17 + f15);
            this.b[0] = new IlvPoint(f12, f13);
            this.b[1] = new IlvPoint(f12 + 0.42f * f14, f13 + 0.42f * f15);
            this.b[2] = new IlvPoint(f12 - 0.58f * f16 + f14, f13 - 0.58f * f17 + f15);
            this.b[3] = new IlvPoint(f12 - f16 + f14, f13 - f17 + f15);
            this.c[0] = this.a[3];
            this.c[1] = this.b[3];
        }
    }
}

