/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.internal.IlvLineSegment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class IlvPolyPoints
implements Serializable {
    protected int _numsegments = 0;
    protected IlvLineSegment[] _segments = null;
    protected IlvPoint[] _points = null;
    static final long serialVersionUID = -3050828890023879427L;

    protected IlvPolyPoints() {
    }

    public int getNumberOfSegments() {
        return this._numsegments;
    }

    public IlvLineSegment getSegment(int n) {
        return this._segments[n];
    }

    public IlvLineSegment[] getSegments() {
        return this._segments;
    }

    public abstract int getNumberOfPoints();

    public IlvPoint getPoint(int n) {
        return this._points[n];
    }

    public IlvPoint[] getPoints() {
        return this._points;
    }

    public IlvPoint[] getPointsCloned() {
        int n = this._points.length;
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            ilvPointArray[i] = (IlvPoint)this._points[i].clone();
        }
        return ilvPointArray;
    }

    public int getClosestSegment(IlvPoint ilvPoint) {
        if (this._numsegments <= 0) {
            throw new Error("cannot call getClosestSegment() on empty IlvPolyPoints");
        }
        float f = 1.0E35f;
        int n = 0;
        for (int i = 0; i < this._numsegments; ++i) {
            float f2 = this._segments[i].sqdist(ilvPoint);
            if (!(f2 < f)) continue;
            f = f2;
            n = i;
        }
        return n;
    }

    public Rectangle getBounds() {
        int n = this.getNumberOfPoints();
        if (n == 0) {
            return null;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = this._points[i];
            if ((float)n2 > ilvPoint.x) {
                n2 = (int)Math.floor(ilvPoint.x);
            }
            if ((float)n3 < ilvPoint.x) {
                n3 = (int)Math.ceil(ilvPoint.x);
            }
            if ((float)n4 > ilvPoint.y) {
                n4 = (int)Math.floor(ilvPoint.y);
            }
            if (!((float)n5 < ilvPoint.y)) continue;
            n5 = (int)Math.ceil(ilvPoint.y);
        }
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public Rectangle2D getBounds2D() {
        int n = this.getNumberOfPoints();
        if (n == 0) {
            return null;
        }
        float f = 1.0E35f;
        float f2 = -1.0E35f;
        float f3 = 1.0E35f;
        float f4 = -1.0E35f;
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = this._points[i];
            if (f > ilvPoint.x) {
                f = ilvPoint.x;
            }
            if (f2 < ilvPoint.x) {
                f2 = ilvPoint.x;
            }
            if (f3 > ilvPoint.y) {
                f3 = ilvPoint.y;
            }
            if (!(f4 < ilvPoint.y)) continue;
            f4 = ilvPoint.y;
        }
        return new IlvRect(f, f3, f2 - f, f4 - f3);
    }

    public IlvPoint getGravity0() {
        int n = this.getNumberOfPoints();
        if (n <= 0) {
            throw new Error("cannot call getGravity0() on empty IlvPolyPoints");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = this._points[i];
            f += ilvPoint.x;
            f2 += ilvPoint.y;
        }
        return new IlvPoint(f / (float)n, f2 / (float)n);
    }

    public IlvPoint getGravity1() {
        int n = this.getNumberOfSegments();
        if (n <= 0) {
            throw new Error("cannot call getGravity1() on empty IlvPolyPoints");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < n; ++i) {
            IlvLineSegment ilvLineSegment = this._segments[i];
            float f4 = ilvLineSegment.length();
            f += (ilvLineSegment.getFrom().x + ilvLineSegment.getTo().x) * f4;
            f2 += (ilvLineSegment.getFrom().y + ilvLineSegment.getTo().y) * f4;
            f3 += f4;
        }
        if ((double)f3 >= 1.0E-10) {
            f3 = 2.0f * f3;
            return new IlvPoint(f / f3, f2 / f3);
        }
        return this.getGravity0();
    }

    public abstract PointAndDirection getMedian();

    public abstract TwoPolylines computeThickLinkShape(float var1);

    public abstract void setNumberOfSegments(int var1);

    public abstract void setSegment(int var1, IlvPoint var2, IlvPoint var3);

    public abstract void applyTransform(IlvTransformer var1);

    public abstract void reverse();

    public abstract void insertPoint(int var1, IlvPoint var2);

    public abstract void insertPoint(IlvPoint var1);

    public abstract void movePoint(int var1, IlvPoint var2);

    public abstract void removePoint(int var1);

    public abstract void removeRedundantPoints();

    static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        if (ilvPoint.x == ilvPoint3.x) {
            return ilvPoint.x == ilvPoint2.x && (ilvPoint.y <= ilvPoint2.y && ilvPoint2.y <= ilvPoint3.y || ilvPoint.y >= ilvPoint2.y && ilvPoint2.y >= ilvPoint3.y);
        }
        if (ilvPoint.y == ilvPoint3.y) {
            return ilvPoint.y == ilvPoint2.y && (ilvPoint.x <= ilvPoint2.x && ilvPoint2.x <= ilvPoint3.x || ilvPoint.x >= ilvPoint2.x && ilvPoint2.x >= ilvPoint3.x);
        }
        return (ilvPoint.x - ilvPoint2.x) * (ilvPoint3.y - ilvPoint2.y) == (ilvPoint.y - ilvPoint2.y) * (ilvPoint3.x - ilvPoint2.x) && (ilvPoint.x <= ilvPoint2.x && ilvPoint2.x <= ilvPoint3.x || ilvPoint.x >= ilvPoint2.x && ilvPoint2.x >= ilvPoint3.x) && (ilvPoint.y <= ilvPoint2.y && ilvPoint2.y <= ilvPoint3.y || ilvPoint.y >= ilvPoint2.y && ilvPoint2.y >= ilvPoint3.y);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            IlvPolyPoints ilvPolyPoints = (IlvPolyPoints)object;
            if (this.getNumberOfSegments() == ilvPolyPoints.getNumberOfSegments()) {
                IlvPoint[] ilvPointArray = ilvPolyPoints.getPoints();
                int n = this._points.length;
                for (int i = 0; i < n; ++i) {
                    if (this._points[i].equals(ilvPointArray[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this._points.length;
        int n2 = -n << 3;
        int n3 = this.getClass().hashCode();
        for (int i = 0; i < n; ++i) {
            n2 += Float.floatToIntBits(this._points[i].x);
            n3 += Float.floatToIntBits(this._points[i].y);
        }
        return n2 + (n3 << 1);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(2);
        if (this._points == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this._points.length);
            for (int i = 0; i < this._points.length; ++i) {
                objectOutputStream.writeObject(this._points[i]);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        if (by == 1) {
            this._points = (IlvPoint[])objectInputStream.readObject();
        } else if (by == 2) {
            this._points = new IlvPoint[objectInputStream.readInt()];
            for (int i = 0; i < this._points.length; ++i) {
                this._points[i] = (IlvPoint)objectInputStream.readObject();
            }
        } else {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        int n = this._points.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append("(");
            stringBuffer.append(this._points[i].x);
            stringBuffer.append(",");
            stringBuffer.append(this._points[i].y);
            stringBuffer.append(")");
        }
        if (this.getNumberOfSegments() == n) {
            stringBuffer.append("-");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class TwoPolylines {
        public IlvPolyPoints leftparallel;
        public IlvPolyPoints rightparallel;

        TwoPolylines(IlvPolyPoints ilvPolyPoints, IlvPolyPoints ilvPolyPoints2) {
            this.leftparallel = ilvPolyPoints;
            this.rightparallel = ilvPolyPoints2;
        }

        public String toString() {
            return this.getClass().getName() + "[leftparallel=" + this.leftparallel + ", rightparallel=" + this.rightparallel + "]";
        }
    }

    public static class PointAndDirection {
        public IlvPoint point;
        public int direction;
        public float slope;

        PointAndDirection(IlvPoint ilvPoint, int n, float f) {
            this.point = ilvPoint;
            this.direction = n;
            this.slope = f;
        }

        public String toString() {
            return this.getClass().getName() + "[point=(" + this.point.x + "," + this.point.y + "), direction=" + this.direction + ", slope=" + this.slope + "]";
        }
    }
}

