/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.decoration;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.decoration.IlvBalloon;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;

public class IlvRoundRectBalloon
extends IlvBalloon {
    private int a;
    private int b;
    private BalloonPointer c;

    public IlvRoundRectBalloon() {
    }

    public IlvRoundRectBalloon(IlvRoundRectBalloon ilvRoundRectBalloon) {
        super(ilvRoundRectBalloon);
        this.a = ilvRoundRectBalloon.a;
        this.b = ilvRoundRectBalloon.b;
    }

    public IlvRoundRectBalloon(int n, int n2, int n3, Color color, Color color2, Color color3, int n4, int n5) {
        super(n, n2, n3, color, color2, color3);
        this.setRadius(n4);
        this.setPointerDistance(n5);
    }

    public IlvRoundRectBalloon(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setRadius(ilvInputStream.readInt("radius"));
        this.setPointerDistance(ilvInputStream.readInt("pointerDistance"));
    }

    @Override
    public IlvGraphic copy() {
        return new IlvRoundRectBalloon(this);
    }

    @Override
    void a() {
        super.a();
        this.c = this.a(this.getOrientation());
    }

    @Override
    public IlvPoint getHotSpot() {
        if (!this.b()) {
            this.a();
        }
        IlvRect ilvRect = this.boundingBox(null);
        ilvRect.width -= (float)this.getShadowThickness();
        ilvRect.height -= (float)this.getShadowThickness();
        switch (this.getOrientation()) {
            case 3: 
            case 7: {
                ilvRect.width -= (float)this.getPointerDepth();
                break;
            }
            default: {
                ilvRect.height -= (float)this.getPointerDepth();
            }
        }
        return this.a(ilvRect);
    }

    private IlvPoint a(IlvRect ilvRect) {
        if (!this.b()) {
            this.a();
        }
        return this.c.getHotSpot(ilvRect);
    }

    public void setPointerDistance(int n) {
        this.b = n;
        this.d();
    }

    public int getPointerDistance() {
        return this.b;
    }

    public void setRadius(int n) {
        this.a = n;
        this.d();
    }

    public int getRadius() {
        return this.a;
    }

    private BalloonPointer a(int n) {
        if (!this.b()) {
            this.a();
        }
        BalloonPointer balloonPointer = null;
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                balloonPointer = new SouthPointer();
                break;
            }
            case 3: {
                balloonPointer = new EastPointer();
                break;
            }
            case 7: {
                balloonPointer = new WestPointer();
                break;
            }
            default: {
                balloonPointer = new NorthPointer();
            }
        }
        return balloonPointer;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (!this.b()) {
            this.a();
        }
        this.c.draw(graphics, ilvTransformer);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.c.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("radius", this.getRadius());
        ilvOutputStream.write("pointerDistance", this.getPointerDistance());
    }

    private class WestPointer
    extends BalloonPointer {
        private WestPointer() {
        }

        @Override
        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f;
            float f2 = ilvRect.y;
            float f3 = ilvRect.x + ilvRect.width;
            float f4 = ilvRect.y + ilvRect.height;
            float f5 = IlvRoundRectBalloon.this.getPointerDepth();
            float f6 = f = (f2 + f4 - f5) / 2.0f;
            float f7 = f + f5;
            float f8 = f3;
            float f9 = f8 + f5;
            float f10 = f3;
            ilvPoint.x = f8;
            ilvPoint.y = f;
            ilvPoint2.x = f9;
            ilvPoint2.y = f6;
            ilvPoint3.x = f10;
            ilvPoint3.y = f7;
        }

        @Override
        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n = IlvRoundRectBalloon.this.getPointerDepth();
            f2 = (ilvRect.height - (float)n) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            f = ilvRect.width + (float)n;
            IlvPoint ilvPoint = new IlvPoint(f, f2);
            return ilvPoint;
        }
    }

    private class EastPointer
    extends BalloonPointer {
        private EastPointer() {
        }

        @Override
        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f;
            float f2 = ilvRect.x;
            float f3 = ilvRect.y;
            float f4 = ilvRect.y + ilvRect.height;
            float f5 = IlvRoundRectBalloon.this.getPointerDepth();
            float f6 = f = (f3 + f4 - f5) / 2.0f;
            float f7 = f + f5;
            float f8 = f2;
            float f9 = f8 - f5;
            float f10 = f2;
            ilvPoint.x = f8;
            ilvPoint.y = f;
            ilvPoint2.x = f9;
            ilvPoint2.y = f6;
            ilvPoint3.x = f10;
            ilvPoint3.y = f7;
        }

        @Override
        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n = IlvRoundRectBalloon.this.getPointerDepth();
            f2 = (ilvRect.height - (float)n) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            f = 1.0f;
            IlvPoint ilvPoint = new IlvPoint(f, f2);
            return ilvPoint;
        }
    }

    private class NorthPointer
    extends BalloonPointer {
        private NorthPointer() {
        }

        @Override
        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f;
            float f2;
            float f3 = ilvRect.x;
            float f4 = ilvRect.x + ilvRect.width;
            float f5 = ilvRect.y + ilvRect.height;
            float f6 = IlvRoundRectBalloon.this.getPointerDistance();
            float f7 = IlvRoundRectBalloon.this.getPointerDepth();
            float f8 = (f3 + f4 - f7) / 2.0f;
            f8 += (float)IlvRoundRectBalloon.this.getShadowThickness();
            if (f6 > 0.0f && f6 < f8 - f3) {
                f8 = f3 + f6;
            }
            if (IlvRoundRectBalloon.this.getOrientation() == 2) {
                f2 = f8;
                f = f8 + f7;
            } else {
                f2 = f = f8 + f7;
            }
            float f9 = f5;
            float f10 = f5 + f7;
            float f11 = f5;
            ilvPoint.x = f8;
            ilvPoint.y = f9;
            ilvPoint2.x = f2;
            ilvPoint2.y = f10;
            ilvPoint3.x = f;
            ilvPoint3.y = f11;
        }

        @Override
        public IlvPoint getHotSpot(IlvRect ilvRect) {
            int n = IlvRoundRectBalloon.this.getPointerDepth();
            float f = ilvRect.height + (float)n;
            float f2 = IlvRoundRectBalloon.this.getOrientation() == 2 ? (ilvRect.width - (float)n) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f : (ilvRect.width + (float)n) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            return new IlvPoint(f2, f);
        }
    }

    private class SouthPointer
    extends BalloonPointer {
        private SouthPointer() {
        }

        @Override
        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f;
            float f2;
            float f3 = ilvRect.x;
            float f4 = ilvRect.y;
            float f5 = ilvRect.x + ilvRect.width;
            int n = IlvRoundRectBalloon.this.getPointerDepth();
            float f6 = (f3 + f5 - (float)n) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness();
            int n2 = IlvRoundRectBalloon.this.getPointerDistance();
            if (n2 > 0 && (float)n2 < f6 - f3) {
                f6 = f3 + (float)n2;
            }
            if (IlvRoundRectBalloon.this.getOrientation() == 4) {
                f2 = f6;
                f = f6 + (float)n;
            } else {
                f2 = f = f6 + (float)n;
            }
            float f7 = f4;
            float f8 = f7 - (float)n;
            float f9 = f7;
            ilvPoint.x = f6;
            ilvPoint.y = f7;
            ilvPoint2.x = f2;
            ilvPoint2.y = f8;
            ilvPoint3.x = f;
            ilvPoint3.y = f9;
        }

        @Override
        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f = 1.0f;
            float f2 = 0.0f;
            f2 = IlvRoundRectBalloon.this.getOrientation() == 4 ? (ilvRect.width - (float)IlvRoundRectBalloon.this.getPointerDepth()) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f : (ilvRect.width + (float)IlvRoundRectBalloon.this.getPointerDepth()) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            return new IlvPoint(f2, f);
        }
    }

    private abstract class BalloonPointer {
        private Area a;
        private Area b;
        private IlvRect c;

        private BalloonPointer() {
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer, IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape = this.a(ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
            graphics.setColor(IlvRoundRectBalloon.this.getShadowColor());
            graphics2D.fill(this.b);
            graphics2D.draw(this.b);
            graphics.setColor(IlvRoundRectBalloon.this.getBalloonColor());
            graphics2D.fill(shape);
            graphics.setColor(IlvRoundRectBalloon.this.getBorderColor());
            graphics2D.draw(shape);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        private Shape a(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            if (this.c != null && this.c.height == ilvRect.height && this.c.width == ilvRect.width) {
                if (this.c.x == ilvRect.x && this.c.y == ilvRect.y) {
                    return this.a;
                }
                this.a.transform(AffineTransform.getTranslateInstance(ilvRect.x - this.c.x, ilvRect.y - this.c.y));
                this.b.transform(AffineTransform.getTranslateInstance(ilvRect.x - this.c.x, ilvRect.y - this.c.y));
                this.c = ilvRect;
                return this.a;
            }
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, IlvRoundRectBalloon.this.getRadius(), IlvRoundRectBalloon.this.getRadius());
            GeneralPath generalPath = new GeneralPath(float_);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            generalPath.lineTo(ilvPoint2.x, ilvPoint2.y);
            generalPath.lineTo(ilvPoint3.x, ilvPoint3.y);
            this.a = new Area(generalPath);
            this.b = new Area(generalPath);
            this.b.transform(AffineTransform.getTranslateInstance(IlvRoundRectBalloon.this.getShadowThickness(), IlvRoundRectBalloon.this.getShadowThickness()));
            this.c = ilvRect;
            return this.a;
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
            IlvRect ilvRect = IlvRoundRectBalloon.this.e();
            IlvPoint ilvPoint = new IlvPoint();
            IlvPoint ilvPoint2 = new IlvPoint();
            IlvPoint ilvPoint3 = new IlvPoint();
            this.getPointer(ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
                ilvTransformer.apply(ilvPoint3);
            }
            this.draw(graphics, ilvTransformer, ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
        }

        public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
            Shape shape;
            IlvRect ilvRect = IlvRoundRectBalloon.this.e();
            IlvPoint ilvPoint3 = new IlvPoint();
            IlvPoint ilvPoint4 = new IlvPoint();
            IlvPoint ilvPoint5 = new IlvPoint();
            this.getPointer(ilvRect, ilvPoint3, ilvPoint4, ilvPoint5);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
                ilvTransformer.apply(ilvPoint3);
                ilvTransformer.apply(ilvPoint4);
                ilvTransformer.apply(ilvPoint5);
            }
            if ((shape = this.a(ilvRect, ilvPoint3, ilvPoint4, ilvPoint5)).contains(ilvPoint2)) {
                return true;
            }
            return this.b.contains(ilvPoint2);
        }

        public abstract IlvPoint getHotSpot(IlvRect var1);

        protected abstract void getPointer(IlvRect var1, IlvPoint var2, IlvPoint var3, IlvPoint var4);
    }
}

