/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTextInterface;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.objectinteractor.IlvTextEditor;
import ilog.views.util.java2d.IlvPattern;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;

public class IlvTextSelection
extends IlvDrawSelection {
    private boolean a = true;
    private Range b = new Range(-1, -1);

    public IlvTextSelection(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
        this.setHandlesShape(3);
    }

    public IlvTextSelection(IlvGraphic ilvGraphic, boolean bl) {
        super(ilvGraphic);
        this.setResizable(bl);
    }

    public IlvTextSelection(IlvGraphic ilvGraphic, boolean bl, boolean bl2) {
        super(ilvGraphic);
        this.setResizable(bl);
        this.setEditable(bl2);
    }

    public void setResizable(boolean bl) {
        this.a = bl;
    }

    @Override
    public boolean supportsResize() {
        return this.a;
    }

    public Range getRange() {
        return this.b;
    }

    public void setRange(Range range) {
        if (range != null) {
            this.b.setRange(range);
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        return super.boundingBox(ilvTransformer);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        if (this.isOnBorder(ilvPoint2, ilvTransformer)) {
            return true;
        }
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        return ilvRect.contains(ilvPoint2.x, ilvPoint2.y);
    }

    public boolean isOnBorder(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        ilvRect.expand(IlvUtil.GetDeltaLine());
        if (ilvRect.contains(ilvPoint.x, ilvPoint.y)) {
            double d = Math.floor(2.0f * this.getHandlesSize() + 1.0f + IlvUtil.GetDeltaLine());
            double d2 = (double)ilvPoint.x - ilvRect.getMinX();
            if (0.0 <= d2 && d2 <= d) {
                return true;
            }
            d2 = ilvRect.getMaxX() - (double)ilvPoint.x;
            if (0.0 <= d2 && d2 <= d) {
                return true;
            }
            double d3 = (double)ilvPoint.y - ilvRect.getMinY();
            if (0.0 <= d3 && d3 <= d) {
                return true;
            }
            d3 = ilvRect.getMaxY() - (double)ilvPoint.y;
            if (0.0 <= d3 && d3 <= d) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.a(graphics, ilvTransformer, true);
    }

    @Override
    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
        this.a(graphics, ilvTransformer, false);
    }

    private void a(Graphics graphics, IlvTransformer ilvTransformer, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        Color color = this.getHandlesColor();
        if (!this.b.isEmpty() && !this.isActive()) {
            color = this.getActiveHandlesColor().brighter();
        }
        IlvPattern ilvPattern = new IlvPattern(14, color, null);
        graphics2D.setPaint(ilvPattern);
        int n = (int)(2.0f * this.getHandlesSize());
        int n2 = (int)ilvRect.getMinX();
        int n3 = (int)ilvRect.getMaxX();
        int n4 = (int)ilvRect.getMinY();
        int n5 = (int)ilvRect.getMaxY();
        int n6 = (int)ilvRect.getWidth();
        int n7 = (int)ilvRect.getHeight();
        graphics2D.fillRect(n2, n4, n6 - n, n);
        graphics2D.fillRect(n2, n4 + n, n, n7 - n);
        graphics2D.fillRect(n2 + n, n5 - n, n6 - n, n);
        graphics2D.fillRect(n3 - n, n4, n, n7 - n);
        if (this.supportsResize() && bl) {
            super.draw(graphics, ilvTransformer);
        }
        if (this.b.isEmpty()) {
            return;
        }
        if (!(this.getObject() instanceof IlvTextInterface)) {
            return;
        }
        IlvTextInterface ilvTextInterface = (IlvTextInterface)((Object)this.getObject());
        graphics2D.setXORMode(Color.MAGENTA);
        graphics2D.setPaint(Color.GREEN);
        Shape shape = ilvTextInterface.getCaretShape(this.b, ilvTransformer);
        if (shape != null) {
            if (this.b.isCollapsed()) {
                graphics2D.draw(shape);
            } else {
                graphics2D.fill(shape);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    @Override
    public String getDefaultInteractor() {
        return IlvTextEditor.class.getName();
    }

    public static class Range {
        public int from = -1;
        public int to = -1;

        public Range() {
        }

        public Range(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        public Range(int n) {
            this(n, n);
        }

        public void setRange(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        public void setRange(Range range) {
            this.from = range.from;
            this.to = range.to;
        }

        public boolean isEmpty() {
            if (this.from > this.to) {
                return true;
            }
            return this.from < 0 || this.to < 0;
        }

        public boolean isCollapsed() {
            return !this.isEmpty() && this.from == this.to;
        }

        public String toString() {
            return "[" + this.from + ":" + this.to + "]";
        }
    }
}

