/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvSpline;
import java.awt.Graphics;

public class IlvSplineSelection
extends IlvPolyPointsSelection {
    private static boolean a = true;
    private static boolean b = false;
    private static String c;
    private IlvPoint[] d;

    public IlvSplineSelection(IlvSpline ilvSpline) {
        super(ilvSpline);
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        if (!b) {
            return ilvRect;
        }
        if (!a) {
            return ilvRect;
        }
        int n = this.getHandleCardinal();
        if (n == 0) {
            return ilvRect;
        }
        IlvSpline ilvSpline = this.getSpline();
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f, 2.0f);
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = ilvSpline.getPointAt(i, ilvTransformer);
            ilvRect2.x = ilvPoint.x - 1.0f;
            ilvRect2.y = ilvPoint.y - 1.0f;
            ilvRect.add(ilvRect2);
        }
        return ilvRect;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        super.draw(graphics, ilvTransformer);
        this.drawWithoutHandles(graphics, ilvTransformer);
    }

    @Override
    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getSpline().getSmoothness();
        if (!b) {
            return;
        }
        IlvSpline ilvSpline = this.getSpline();
        graphics.setColor(this.getHandlesColor());
        int n = this.getHandleCardinal();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            IlvPoint ilvPoint = ilvSpline.getPointAt(i, ilvTransformer);
            int n4 = (int)Math.floor(ilvPoint.x);
            int n5 = (int)Math.floor(ilvPoint.y);
            if ((i == 0 || n2 != n4 || n3 != n5) && i != 0) {
                graphics.drawLine(n4, n5, n2, n3);
            }
            n2 = n4;
            n3 = n5;
        }
    }

    @Override
    public IlvPoint getHandle(int n, IlvTransformer ilvTransformer) {
        float f;
        block5: {
            IlvSpline ilvSpline;
            block4: {
                ilvSpline = this.getSpline();
                if (!a) {
                    return ilvSpline.getPointAt(n, ilvTransformer);
                }
                f = ilvSpline.getSmoothness();
                if (f == -1.0f) break block4;
                if (f != -2.0f) break block5;
            }
            return ilvSpline.getPointAt(n, ilvTransformer);
        }
        IlvPoint[] ilvPointArray = this.d != null ? this.d : IlvGraphicUtil.GetPolyPoints(this.getSpline(), ilvTransformer);
        IlvPoint ilvPoint = this.getPolyPoints().getPointAt(n, ilvTransformer);
        return IlvGraphicUtil.GetSmoothSplineHandleFromBend(n, ilvPointArray, ilvPointArray.length, f, false);
    }

    @Override
    protected void beforeLoopAllHandles(IlvTransformer ilvTransformer) {
        if (!a) {
            return;
        }
        this.d = IlvGraphicUtil.GetPolyPoints(this.getSpline(), ilvTransformer);
    }

    @Override
    protected void afterLoopAllHandles() {
        this.d = null;
    }

    public IlvSpline getSpline() {
        return (IlvSpline)this.getObject();
    }

    @Override
    public String getDefaultInteractor() {
        return c == null ? "ilog.views.graphic.IlvSplineEdition" : c;
    }

    public static void SetDefaultInteractor(String string) {
        c = string;
    }

    public static boolean IsHandlesOnSplineMode() {
        return a;
    }

    public static void SetHandlesOnSplineMode(boolean bl) {
        a = bl;
    }

    public static boolean IsShowTangentsMode() {
        return b;
    }

    public static void SetShowTangentsMode(boolean bl) {
        b = bl;
    }
}

