/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvSplineLinkSelection;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvSplineLinkImage
extends IlvLinkImage {
    private IlvPoint[] a = null;
    private float b = -1.0f;

    public IlvSplineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.a(ilvPointArray, true);
    }

    public IlvSplineLinkImage(IlvSplineLinkImage ilvSplineLinkImage) {
        super(ilvSplineLinkImage);
        this.a(ilvSplineLinkImage.a, true);
        this.b = ilvSplineLinkImage.b;
    }

    public IlvSplineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvPoint[] ilvPointArray = ilvInputStream.readPointArray("points");
        this.a(ilvPointArray, false);
        try {
            this.setSmoothness(ilvInputStream.readFloat("smoothness"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.setSmoothness(-1.0f);
        }
    }

    private void a(IlvPoint[] ilvPointArray, boolean bl) {
        if (ilvPointArray == null) {
            return;
        }
        if (bl) {
            this.a = new IlvPoint[ilvPointArray.length];
            for (int i = 0; i < ilvPointArray.length; ++i) {
                this.a[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        } else {
            this.a = ilvPointArray;
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvSplineLinkImage(this);
    }

    @Override
    public int getPointsCardinal() {
        if (this.a == null) {
            return 2;
        }
        return this.a.length + 2;
    }

    @Override
    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        int n = this.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        if (n > 2) {
            for (int i = 1; i < n - 1; ++i) {
                ilvPointArray[i] = new IlvPoint(this.a[i - 1]);
                if (ilvTransformer == null) continue;
                ilvTransformer.apply(ilvPointArray[i]);
            }
        }
        ilvPointArray[0] = new IlvPoint();
        ilvPointArray[n - 1] = new IlvPoint();
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[n - 1], ilvTransformer);
        return ilvPointArray;
    }

    @Override
    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n, int n2) {
        if (ilvPointArray != null && n + n2 > ilvPointArray.length || n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid Argument");
        }
        if (n2 == 0 || ilvPointArray == null) {
            this.a = null;
        } else {
            int n3 = this.getPointsCardinal() - 2;
            int n4 = Math.min(n2, n3);
            if (n3 != n2) {
                IlvPoint[] ilvPointArray2 = this.a;
                this.a = new IlvPoint[n2];
                if (ilvPointArray2 != null) {
                    System.arraycopy(ilvPointArray2, 0, this.a, 0, n4);
                }
            }
            int n5 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                this.a[n5].move(ilvPointArray[n + n5].x, ilvPointArray[n + n5].y);
            }
            while (n5 < n2) {
                this.a[n5] = new IlvPoint(ilvPointArray[n + n5]);
                ++n5;
            }
        }
    }

    @Override
    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        if (n == 0 || n == this.getPointsCardinal() - 1) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
            this.getConnectionPoints(ilvPointArray[0], ilvPointArray[1], ilvTransformer);
            if (n == 0) {
                return ilvPointArray[0];
            }
            return ilvPointArray[1];
        }
        IlvPoint ilvPoint = new IlvPoint(this.a[n - 1]);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        return ilvPoint;
    }

    @Override
    public boolean allowsPointInsertion() {
        return true;
    }

    @Override
    public boolean allowsPointRemoval() {
        return this.a != null && this.a.length >= 1;
    }

    @Override
    public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n < 0) {
            throw new IllegalArgumentException("negative index: " + n);
        }
        if (n > this.getPointsCardinal()) {
            throw new IllegalArgumentException("bad index:" + n + " (> number of points = " + this.getPointsCardinal() + ")");
        }
        IlvPoint[] ilvPointArray = this.a;
        int n2 = this.a == null ? 0 : ilvPointArray.length;
        int n3 = this.getPointsCardinal();
        if (n == 0) {
            IlvPoint ilvPoint = this.getPointAt(0, null);
            this.a = new IlvPoint[n2 + 1];
            this.a[0] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 1, n2);
            }
            this.movePoint(0, f, f2, ilvTransformer);
        } else if (n == n3) {
            IlvPoint ilvPoint = this.getPointAt(n3 - 1, null);
            this.a = new IlvPoint[n2 + 1];
            this.a[n2] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n2);
            }
            this.movePoint(n3, f, f2, ilvTransformer);
        } else {
            this.a = new IlvPoint[n2 + 1];
            --n;
            if (ilvPointArray != null) {
                if (n > 0) {
                    System.arraycopy(ilvPointArray, 0, this.a, 0, n);
                }
                System.arraycopy(ilvPointArray, n, this.a, n + 1, n2 - n);
            }
            this.a[n] = new IlvPoint(f, f2);
        }
    }

    @Override
    public void removePoint(int n, IlvTransformer ilvTransformer) {
        if (n == 0) {
            return;
        }
        if (n == this.getPointsCardinal() - 1) {
            return;
        }
        if (this.a != null && --n >= 0 && n < this.a.length) {
            int n2;
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[ilvPointArray.length - 1];
            if (n > 0) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n);
            }
            if ((n2 = ilvPointArray.length - n - 1) > 0) {
                System.arraycopy(ilvPointArray, n + 1, this.a, n, n2);
            }
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
    }

    @Override
    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n == 0 || n == this.getPointsCardinal() - 1) {
            super.movePoint(n, f, f2, ilvTransformer);
        } else {
            try {
                this.a[n - 1].move(f, f2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("bad index: " + n);
            }
        }
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.getPointsCardinal() > 2 && this.a != null) {
            for (int i = 0; i < this.a.length; ++i) {
                if (ilvTransformer == null) continue;
                ilvTransformer.apply(this.a[i]);
            }
        }
    }

    @Override
    public boolean pointsInBBox() {
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        float f = this.getLineWidth();
        IlvRect ilvRect = new IlvRect();
        int n = ilvPointArray.length;
        if (n > 1) {
            if (f == 0.0f) {
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray, n, false, this.getSmoothness(), 0.0f, 0, 0, null);
            } else {
                f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, true);
                double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
                float f2 = ilvPointArray[n - 1].x;
                float f3 = ilvPointArray[n - 1].y;
                IlvUtility.retractPointsForArrowHead(this, ilvPointArray, -1.0f, ilvTransformer);
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray, n, false, this.getSmoothness(), (float)((double)f * d), 0, this.getEndCap(), null);
                ilvPointArray[n - 1].x = f2;
                ilvPointArray[n - 1].y = f3;
            }
            if (this.isOriented()) {
                ilvRect.add(this.arrowBBox(ilvPointArray[n - 2], ilvPointArray[n - 1], ilvTransformer));
            }
            if (ilvRect.width < 1.0E-20f) {
                ilvRect.width = 1.0E-20f;
            }
            if (ilvRect.height < 1.0E-20f) {
                ilvRect.height = 1.0E-20f;
            }
        } else if (ilvPointArray.length == 1) {
            ilvRect.reshape(ilvPointArray[0].x, ilvPointArray[0].y, 1.0E-20f, 1.0E-20f);
        } else {
            ilvRect.reshape(0.0f, 0.0f, 1.0E-20f, 1.0E-20f);
        }
        return ilvRect;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, ilvPointArray.length, false, this.getSmoothness(), 0.0f, 0, 0, null);
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        int n = ilvPointArray.length;
        if (this.isOriented() && this.arrowContains(ilvPoint, ilvPoint2, ilvPointArray[n - 2], ilvPointArray[n - 1], ilvTransformer)) {
            return true;
        }
        IlvUtility.retractPointsForArrowHead(this, ilvPointArray, f, ilvTransformer);
        return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, n, false, this.getSmoothness(), (float)((double)f * d), 0, this.getEndCap(), null);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        int n = ilvPointArray.length;
        float f = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        graphics.setColor(this.getForeground());
        if (f == 0.0f && fArray == null) {
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, false, this.getSmoothness(), 0.0f, 0, 0, null, null, true);
        } else {
            float f2 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
            float f3 = ilvPointArray[n - 1].x;
            float f4 = ilvPointArray[n - 1].y;
            IlvUtility.retractPointsForArrowHead(this, ilvPointArray, f, ilvTransformer);
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, false, this.getSmoothness(), f, 0, this.getEndCap(), fArray, ilvTransformer, true);
            ilvPointArray[n - 1].x = f3;
            ilvPointArray[n - 1].y = f4;
        }
        this.drawArrow(graphics, ilvPointArray[n - 2], ilvPointArray[n - 1], ilvTransformer);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("points", this.a);
        float f = this.getSmoothness();
        if (f != -1.0f) {
            ilvOutputStream.write("smoothness", f);
        }
    }

    public void setSmoothness(float f) {
        block3: {
            block2: {
                if (f == -1.0f) break block2;
                if (f != -2.0f && (!(f >= 0.0f) || !(f <= 1.0f))) break block3;
            }
            this.b = f;
        }
    }

    public float getSmoothness() {
        return this.b;
    }

    @Override
    public boolean isSpline() {
        return true;
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvSplineLinkSelection(this);
    }
}

