/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.IlvBidiGraphic;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.text.IlvBidiUtil;
import ilog.views.util.text.internal.IlvICUNumberFormatFactory;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.io.IOException;

public abstract class IlvScale
extends IlvBidiGraphic
implements IlvFontInterface {
    final IlvRect a = new IlvRect();
    private Color b = null;
    private float c;
    private float d;
    private Font e = IlvToolkit.defaultFont;
    private int f;
    private int g;
    private String[] h;
    private int[] i;
    private int j;
    private int k;
    private String l;
    private float m;
    private float n;
    private boolean o;
    private boolean p;

    public IlvScale(IlvRect ilvRect, int n, int n2, float f, float f2, float f3, float f4, String string) {
        this.a.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        this.setStepSize(f);
        this.setSubStepSize(f2);
        this.f = n;
        this.g = n2;
        this.m = f3;
        this.n = f4;
        this.l = string;
        this.b();
    }

    public IlvScale(IlvRect ilvRect, String[] stringArray, int n, float f, float f2) {
        this.a.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        this.setStepSize(f);
        this.setSubStepSize(f2);
        this.g = n;
        this.m = 0.0f;
        this.n = 0.0f;
        this.setFormat("0.#");
        this.setLabels(stringArray);
    }

    public IlvScale(IlvScale ilvScale) {
        super(ilvScale);
        int n;
        this.a.reshape(ilvScale.a.x, ilvScale.a.y, ilvScale.a.width, ilvScale.a.height);
        this.c = ilvScale.c;
        this.d = ilvScale.d;
        this.f = ilvScale.f;
        this.g = ilvScale.g;
        this.m = ilvScale.m;
        this.n = ilvScale.n;
        this.l = ilvScale.l;
        this.o = ilvScale.o;
        this.p = ilvScale.p;
        this.e = ilvScale.e;
        this.setForeground(ilvScale.b);
        this.j = ilvScale.j;
        this.k = ilvScale.k;
        if (ilvScale.i != null) {
            this.i = new int[ilvScale.i.length];
            for (n = 0; n < this.i.length; ++n) {
                this.i[n] = ilvScale.i[n];
            }
        }
        if (ilvScale.h != null) {
            this.h = new String[ilvScale.h.length];
            for (n = 0; n < this.h.length; ++n) {
                this.h[n] = ilvScale.h[n];
            }
        }
        this.setAntialiasing(ilvScale.isAntialiasing());
    }

    public IlvScale(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        IlvRect ilvRect = ilvInputStream.readRect("rectangle");
        this.a.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        this.setFont(ilvInputStream.readFont("font"));
        this.setStepSize(ilvInputStream.readFloat("stepSize"));
        this.setSubStepSize(ilvInputStream.readFloat("subStepSize"));
        this.setNumberOfSubSteps(ilvInputStream.readInt("numberOfSubSteps"));
        try {
            this.m = ilvInputStream.readFloat("min");
            this.n = ilvInputStream.readFloat("max");
            this.l = ilvInputStream.readString("format");
            this.f = ilvInputStream.readInt("numberOfSteps");
            this.b();
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            String[] stringArray = ilvInputStream.readStringArray("labels");
            this.setLabels(stringArray);
        }
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public final int getNumberOfSteps() {
        return this.f;
    }

    public final void setNumberOfSteps(int n) {
        if (n != this.f) {
            this.f = n;
            this.b();
        }
    }

    public final int getNumberOfSubSteps() {
        return this.g;
    }

    public final void setNumberOfSubSteps(int n) {
        this.g = n;
    }

    public final float getStepSize() {
        return this.c;
    }

    public final void setStepSize(float f) {
        this.c = f;
    }

    public final float getSubStepSize() {
        return this.d;
    }

    public final void setSubStepSize(float f) {
        this.d = f;
    }

    public final float getMin() {
        return this.m;
    }

    public final void setMin(float f) {
        if (f != this.m) {
            this.m = f;
            if (this.n < this.m) {
                this.n = f;
            }
            this.b();
        }
    }

    public final float getMax() {
        return this.n;
    }

    public final void setMax(float f) {
        if (f != this.n) {
            this.n = f;
            if (this.n < this.m) {
                this.m = f;
            }
            this.b();
        }
    }

    public final String getFormat() {
        return this.l;
    }

    public final void setFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("format is null");
        }
        this.o = !string.equals("");
        this.l = string;
        this.p = false;
        if (this.o) {
            this.b();
        }
    }

    @Override
    public void setFont(Font font) {
        this.e = font;
        this.a();
    }

    @Override
    public Font getFont() {
        return this.e;
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public final void setAntialiasing(boolean bl) {
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.a();
    }

    public final String[] getLabels() {
        return this.h;
    }

    final int a(int n) {
        return this.i[n];
    }

    final int b(int n) {
        return this.j;
    }

    final int c(int n) {
        return this.k;
    }

    private void a() {
        if (this.h != null) {
            Font font = this.getFont();
            boolean bl = this.isAntialiasing();
            this.i = new int[this.h.length];
            IlvRect ilvRect = IlvGraphicUtil.GetStringBounds(this, " ", font, bl);
            this.j = (int)ilvRect.height;
            this.k = (int)IlvGraphicUtil.GetFontDescent(" ", font, bl);
            for (int i = 0; i < this.h.length; ++i) {
                if (this.h[i] != null) {
                    ilvRect = IlvGraphicUtil.GetStringBounds(this, this.h[i], font, bl);
                    this.i[i] = (int)ilvRect.width;
                    continue;
                }
                this.i[i] = 0;
            }
        } else {
            this.i = null;
            this.j = 0;
            this.k = 0;
        }
    }

    private void b() {
        float f = this.m;
        float f2 = this.n;
        int n = this.getNumberOfSteps();
        this.p = false;
        this.o = true;
        this.h = null;
        if (n > 1) {
            this.h = new String[n];
            float f3 = (f2 - f) / (float)(n - 1);
            DecimalFormat decimalFormat = IlvICUNumberFormatFactory.getInstance(this.l, this.getULocale());
            float f4 = f;
            this.p = true;
            for (int i = 0; i < n; ++i) {
                this.h[i] = decimalFormat.format((double)f4);
                f4 += f3;
            }
        }
        this.a();
    }

    public void setLabels(String[] stringArray) {
        this.f = stringArray != null ? stringArray.length : 0;
        this.p = false;
        this.o = false;
        this.l = "";
        if (this.f >= 1 && stringArray != null) {
            this.h = new String[this.f];
            for (int i = 0; i < this.f; ++i) {
                this.h[i] = stringArray[i];
            }
        } else {
            this.h = null;
        }
        this.a();
    }

    public void setLabel(int n, String string) {
        if (this.h != null && n < this.f) {
            this.p = false;
            this.o = false;
            this.l = "";
            if (string != null) {
                this.h[n] = string;
                this.i[n] = (int)IlvGraphicUtil.GetStringBounds((IlvGraphic)this, (String)string, (Font)this.e, (boolean)this.isAntialiasing()).width;
            } else {
                this.h[n] = null;
                this.i[n] = 0;
            }
        }
    }

    @Override
    public boolean isLocaleSensitive() {
        return this.p;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        ilvTransformer.apply(this.a);
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.b;
        this.b = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        return IlvBidiUtil.isAdvancedBidiOn();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.a();
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.a();
        }
    }

    @Override
    public void localeChanged(ULocale uLocale, ULocale uLocale2) {
        super.localeChanged(uLocale, uLocale2);
        if (this.o) {
            this.b();
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("rectangle", this.a);
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("stepSize", this.getStepSize());
        ilvOutputStream.write("subStepSize", this.getSubStepSize());
        ilvOutputStream.write("numberOfSubSteps", this.getNumberOfSubSteps());
        if (this.o) {
            ilvOutputStream.write("min", this.getMin());
            ilvOutputStream.write("max", this.getMax());
            ilvOutputStream.write("format", this.getFormat());
            ilvOutputStream.write("numberOfSteps", this.getNumberOfSteps());
        } else {
            ilvOutputStream.write("labels", this.getLabels());
        }
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }
}

