/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvReliefRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvReliefLabel
extends IlvReliefRectangle
implements IlvFontInterface,
IlvLabelInterface {
    private String a = null;
    private Font b = IlvToolkit.defaultFont;
    private int c;
    private ComponentOrientation d;
    private int e;
    private IlvRect f;

    public IlvReliefLabel() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "");
    }

    public IlvReliefLabel(IlvRect ilvRect, String string) {
        super(ilvRect);
        this.c = 513;
        this.setLabel(string);
        this.invalidateBidiCache();
    }

    public IlvReliefLabel(IlvRect ilvRect, String string, int n) {
        super(ilvRect, n);
        this.c = 513;
        this.setLabel(string);
        this.invalidateBidiCache();
    }

    public IlvReliefLabel(IlvPoint ilvPoint, String string, int n) {
        this(new IlvRect(ilvPoint.x, ilvPoint.y, 10.0f, 10.0f), string, n);
        this.fitToLabel();
    }

    public IlvReliefLabel(IlvReliefLabel ilvReliefLabel) {
        super(ilvReliefLabel);
        this.c = ilvReliefLabel.c;
        this.setLabel(ilvReliefLabel.getLabel());
        this.setFont(ilvReliefLabel.getFont());
        this.setAntialiasing(ilvReliefLabel.isAntialiasing());
        this.invalidateBidiCache();
    }

    public IlvReliefLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readFont("font");
        this.setLabel(ilvInputStream.readString("label"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.invalidateBidiCache();
    }

    @Override
    public final void setLabel(String string) {
        if (this.a == string && this.f != null) {
            return;
        }
        if (this.a == null || string == null || !string.equals(this.a)) {
            this.a = string;
            this.d();
        }
    }

    public void fitToLabel() {
        float f = this.getThickness();
        this.drawrect.resize(this.f.width + 4.0f * f, this.f.height + 4.0f * f);
    }

    @Override
    public final String getLabel() {
        return this.a;
    }

    @Override
    public boolean supportMultiline() {
        return false;
    }

    private void d() {
        if (this.b != null) {
            this.f = IlvGraphicUtil.GetStringBounds(this, this.getLabel(), this.getFont(), this.isAntialiasing());
        }
    }

    @Override
    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        int n = this.getThickness();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        if (ilvRect.width > (float)(2 * n) && ilvRect.height > (float)(2 * n)) {
            ilvRect.x += (float)n;
            ilvRect.y += (float)n;
            ilvRect.height -= (float)(2 * n);
            ilvRect.width -= (float)(2 * n);
            IlvRect ilvRect2 = this.f;
            ilvRect.x += ilvRect.width / 2.0f - ilvRect2.width / 2.0f;
            ilvRect.y += (ilvRect.height - ilvRect2.height) / 2.0f;
            ilvRect.height = ilvRect2.height;
            ilvRect.width = ilvRect2.width;
        }
        return ilvRect;
    }

    @Override
    public final void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (font == this.b) {
            return;
        }
        this.b = font;
        this.d();
    }

    @Override
    public final Font getFont() {
        return this.b;
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        if (this.d == null) {
            this.d = super.getComponentOrientation();
        }
        return this.d;
    }

    @Override
    public void setBaseTextDirection(int n) {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return;
        }
        if (n == this.c) {
            return;
        }
        IlvBidiUtil.checkBaseTextDirectionChoice(n, false, false);
        int n2 = this.getResolvedBaseTextDirection();
        this.c = n;
        this.e = 0;
        int n3 = this.getResolvedBaseTextDirection();
        if (n2 != n3) {
            this.baseTextDirectionChanged(n2, n3);
        }
    }

    @Override
    public int getBaseTextDirection() {
        return this.c;
    }

    @Override
    public int getResolvedBaseTextDirection() {
        if (this.e == 0) {
            this.e = super.getResolvedBaseTextDirection();
        }
        return this.e;
    }

    @Override
    protected void invalidateBidiCache() {
        this.d = null;
        this.e = 0;
    }

    @Override
    public boolean usesBidiMarkers() {
        return IlvBidiUtil.isStringRTL(this, this.a, this.getComponentOrientation());
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        return IlvBidiUtil.isAdvancedBidiOn();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.d();
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.d();
        }
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl == this.isAntialiasing()) {
            return;
        }
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.d();
    }

    @Override
    public IlvGraphic copy() {
        return new IlvReliefLabel(this);
    }

    @Override
    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.drawLabel(graphics, ilvRect, ilvTransformer);
    }

    public void drawLabel(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        String string = this.getLabel();
        if (string == null) {
            return;
        }
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height)) : new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        if (rectangle.width != 0 && rectangle.height != 0) {
            boolean bl = this.isAntialiasing();
            Font font = this.getFont();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            IlvRect ilvRect2 = this.f;
            int n = (int)Math.floor(ilvRect.x) + ((int)Math.floor(ilvRect.width) - (int)Math.floor(ilvRect2.width)) / 2;
            int n2 = (int)Math.floor(ilvRect.y) + ((int)Math.floor(ilvRect.height) + (int)Math.floor(ilvRect2.height)) / 2;
            graphics.setFont(font);
            graphics.setColor(this.getForeground());
            IlvGraphicUtil.DrawString(this, graphics, string, n, n2, bl);
            graphics.setClip(shape);
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("label", this.getLabel());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    @Override
    public String toString() {
        String string = this.getLabel();
        return super.toString() + (string != null ? " Label: " + string : " (no label)");
    }
}

