/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvFixedSizeGraphic;
import ilog.views.graphic.IlvGraphicHandleInteractor;
import ilog.views.graphic.IlvGraphicHandleSelection;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPopupMenu;

public class IlvHalfZoomingGraphic
extends IlvFixedSizeGraphic {
    private double a;
    private double b;
    private double c;
    private Color d;
    private Color e;
    private boolean f = true;
    private float g = 1.0f;
    private boolean h = true;
    private boolean i = true;
    public static final IlvObjectInteractor DELEGATE_INTERACTOR = new DelegateObjectInteractor();
    private IlvTransformer[] j = new IlvTransformer[3];
    private IlvTransformer[] k = new IlvTransformer[3];

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, int n, IlvPoint ilvPoint, double d, double d2, double d3) {
        super(ilvGraphic, n, ilvPoint);
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = Color.black;
        this.e = Color.gray;
        this.setObjectInteractor(DELEGATE_INTERACTOR);
    }

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, IlvPoint ilvPoint, double d, double d2, double d3) {
        this(ilvGraphic, 0, ilvPoint, d, d2, d3);
    }

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, int n, double d, double d2, double d3) {
        this(ilvGraphic, n, null, d, d2, d3);
    }

    public IlvHalfZoomingGraphic(IlvHalfZoomingGraphic ilvHalfZoomingGraphic) {
        super(ilvHalfZoomingGraphic);
        this.a = ilvHalfZoomingGraphic.a;
        this.b = ilvHalfZoomingGraphic.b;
        this.c = ilvHalfZoomingGraphic.c;
        this.setUnzoomedForeground(ilvHalfZoomingGraphic.d);
        this.setUnzoomedBackground(ilvHalfZoomingGraphic.e);
        this.f = ilvHalfZoomingGraphic.f;
        this.g = ilvHalfZoomingGraphic.g;
        this.h = ilvHalfZoomingGraphic.h;
        this.i = ilvHalfZoomingGraphic.i;
        this.setObjectInteractor(DELEGATE_INTERACTOR);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvHalfZoomingGraphic(this);
    }

    public IlvHalfZoomingGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readDouble("minZoom");
        this.b = ilvInputStream.readDouble("maxZoom");
        this.c = ilvInputStream.readDouble("initialZoom");
        this.setUnzoomedForeground(ilvInputStream.readColor("foreground"));
        this.setUnzoomedBackground(ilvInputStream.readColor("background"));
        try {
            this.f = ilvInputStream.readBoolean("grayedWhenUnzoomed");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readFloat("alpha");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.h = ilvInputStream.readBoolean("useAlphaBuffer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.i = ilvInputStream.readBoolean("rotatable");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("minZoom", this.a);
        ilvOutputStream.write("maxZoom", this.b);
        ilvOutputStream.write("initialZoom", this.c);
        ilvOutputStream.write("foreground", this.d);
        ilvOutputStream.write("background", this.e);
        ilvOutputStream.write("grayedWhenUnzoomed", this.f);
        ilvOutputStream.write("alpha", this.g);
        ilvOutputStream.write("useAlphaBuffer", this.h);
        ilvOutputStream.write("rotatable", this.i);
    }

    @Override
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        super.setGraphicBag(ilvGraphicBag);
        ((DelegateObjectInteractor)DELEGATE_INTERACTOR).b();
    }

    @Override
    public final void setPosition(int n) {
        super.setPosition(n);
        this.b();
    }

    @Override
    public final void setPoint(IlvPoint ilvPoint) {
        super.setPoint(ilvPoint);
        this.b();
    }

    public double getMinZoom() {
        return this.a;
    }

    public void setMinZoom(double d) {
        this.a = d;
    }

    public double getMaxZoom() {
        return this.b;
    }

    public void setMaxZoom(double d) {
        this.b = d;
    }

    public double getInitialZoom() {
        return this.c;
    }

    public void setInitialZoom(double d) {
        if (d == 0.0) {
            d = 1.0;
        }
        this.c = d;
    }

    public void setUnzoomedForeground(Color color) {
        Color color2 = this.d;
        this.d = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getUnzoomedForeground() {
        return this.d;
    }

    public void setUnzoomedBackground(Color color) {
        Color color2 = this.e;
        this.e = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getUnzoomedBackground() {
        return this.e;
    }

    public void setGrayedWhenUnzoomed(boolean bl) {
        this.f = bl;
    }

    public boolean isGrayedWhenUnzoomed() {
        return this.f;
    }

    public void setRotatable(boolean bl) {
        if (bl != this.i) {
            this.i = bl;
            this.b();
        }
    }

    public boolean isRotatable() {
        return this.i;
    }

    public void setAlpha(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.g = f;
    }

    public float getAlpha() {
        return this.g;
    }

    public void setAlphaBufferEnabled(boolean bl) {
        this.h = bl;
        if (!bl) {
            IlvDrawWithBufferedImage.clearCache();
        }
    }

    public boolean isAlphaBufferEnabled() {
        return this.h;
    }

    @Override
    public boolean isDelegateObjectInteractor(IlvObjectInteractor ilvObjectInteractor) {
        return ilvObjectInteractor == DELEGATE_INTERACTOR;
    }

    @Override
    protected void notifyObjectInteractorToManager(IlvObjectInteractor ilvObjectInteractor) {
        ((DelegateObjectInteractor)DELEGATE_INTERACTOR).b();
        super.notifyObjectInteractorToManager(ilvObjectInteractor);
    }

    public IlvTransformer computeTransformer(IlvTransformer ilvTransformer) {
        int n;
        for (n = 0; n < this.j.length; ++n) {
            IlvTransformer ilvTransformer2;
            IlvTransformer ilvTransformer3 = this.k[n];
            if (ilvTransformer3 == null || (ilvTransformer2 = this.j[n]) == null || (ilvTransformer != null || !ilvTransformer2.isIdentity()) && !ilvTransformer2.equals(ilvTransformer)) continue;
            return this.k[n];
        }
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvPoint ilvPoint = this.getPoint();
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        double d2 = 0.0;
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
            if (this.i && ilvTransformer.getx21() != 0.0) {
                d2 = Math.atan2(ilvTransformer.getx21(), ilvTransformer.getx11());
            }
        }
        IlvTransformer ilvTransformer4 = new IlvTransformer();
        ilvTransformer4.setValues(1.0, 0.0, 0.0, 1.0, (double)ilvPoint2.x - (double)ilvPoint.x, (double)ilvPoint2.y - (double)ilvPoint.y);
        if (this.i && d2 != 0.0) {
            ilvTransformer4.rotate(ilvPoint2.x, ilvPoint2.y, Math.toDegrees(d2));
        }
        if (d < this.a * this.c()) {
            if (!this.f) {
                d = this.a;
            }
        } else {
            d = d > this.b * this.c() ? this.b : (d /= this.c());
        }
        ilvTransformer4.scale(ilvPoint.x, ilvPoint.y, d, d);
        int n2 = 0;
        for (n = 0; n < this.j.length; ++n) {
            if (this.j[n] != null) continue;
            n2 = n;
            break;
        }
        this.k[n2] = ilvTransformer4;
        this.j[n2] = new IlvTransformer(ilvTransformer);
        return ilvTransformer4;
    }

    private void b() {
        this.j = new IlvTransformer[3];
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f);
            }
        }
        if (bl && this.isAlphaBufferEnabled()) {
            this.g = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.g = f;
        } else {
            this.a(graphics2D, ilvTransformer);
        }
        if (bl && f != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                IlvRect ilvRect = this.boundingBox(ilvTransformer);
                graphics2D.setColor(this.e);
                graphics2D.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                graphics2D.setColor(this.d);
                graphics2D.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                return;
            }
        }
        this.getObject().callDraw(graphics2D, this.computeTransformer(ilvTransformer));
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                IlvRect ilvRect = this.unzoomedBBox();
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvRect);
                }
                return ilvRect;
            }
        }
        return this.getObject().boundingBox(this.computeTransformer(ilvTransformer));
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        for (int i = 0; i < this.j.length; ++i) {
            this.k[i] = null;
        }
    }

    protected IlvRect unzoomedBBox() {
        return this.boundingBox(null);
    }

    protected double getReferenceZoom() {
        return 1.0;
    }

    private double c() {
        if (this.c == 0.0) {
            return 1.0;
        }
        return this.getReferenceZoom() / this.c;
    }

    @Override
    public boolean zoomable() {
        IlvPoint ilvPoint = this.getPoint();
        IlvRect ilvRect = this.getObject().boundingBox(null);
        if (ilvPoint.x < ilvRect.x || ilvPoint.y < ilvRect.y || ilvPoint.x > ilvRect.x + ilvRect.width || ilvPoint.y > ilvRect.y + ilvRect.height) {
            return false;
        }
        return (this.f || this.a == 0.0) && this.b >= this.c && this.getObject().zoomable();
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return this.boundingBox(ilvTransformer).inside(ilvPoint2.x, ilvPoint2.y);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvPoint3);
        }
        if (!ilvTransformer2.isIdentity()) {
            ilvTransformer2.inverse(ilvPoint3);
        }
        return this.getObject().contains(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    @Override
    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return this.boundingBox(ilvTransformer).intersects(ilvRect2);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().intersects(ilvRect3, ilvRect2, ilvTransformer2);
    }

    @Override
    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return ilvRect2.contains(this.boundingBox(ilvTransformer));
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().inside(ilvRect3, ilvRect2, ilvTransformer2);
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return IlvClippingUtil.getClippedPoint(this.boundingBox(ilvTransformer), ilvPoint, ilvPoint2);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        return this.getObject().getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer2);
    }

    @Override
    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return this.getToolTipText();
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        String string = this.getObject().getToolTipText(ilvPoint, ilvTransformer2);
        if (string != null) {
            return string;
        }
        return this.getToolTipText();
    }

    @Override
    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        if (this.f) {
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d < this.a * this.c()) {
                return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        JPopupMenu jPopupMenu = this.getObject().getPopupMenu(ilvPoint, ilvTransformer2, ilvManagerView, ilvPopupMenuManager);
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    @Override
    public IlvSelection makeSelection() {
        IlvSelection ilvSelection = this.getObject().makeSelection();
        return new IlvGraphicHandleSelection(this, ilvSelection){

            @Override
            protected IlvTransformer getVirtualViewTransformer(IlvTransformer ilvTransformer) {
                return IlvHalfZoomingGraphic.this.computeTransformer(ilvTransformer);
            }
        };
    }

    static class DelegateObjectInteractor
    extends IlvGraphicHandleInteractor {
        public DelegateObjectInteractor() {
            IlvObjectInteractor.Put(this.getClass().getName(), this);
        }

        @Override
        protected boolean acceptObject(IlvGraphic ilvGraphic) {
            return ilvGraphic instanceof IlvHalfZoomingGraphic;
        }

        @Override
        protected IlvTransformer getVirtualViewTransformer(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
            return ((IlvHalfZoomingGraphic)ilvGraphic).computeTransformer(ilvTransformer);
        }

        @Override
        protected IlvTransformer getVirtualToRealViewTransformer(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
            return null;
        }
    }
}

