/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.util;

import com.ibm.icu.util.ULocale;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.parser.AttributeSelector;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.css.parser.SimpleSelector;
import ilog.views.util.cssbeans.IlvCSSBeans;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JOptionPane;

public class IlvRuleUtils {
    public static void removeMetaDeclarationUNUSED(Rule rule, String string) {
        Declaration[] declarationArray = rule.getMetadata();
        int n = -1;
        for (int i = 0; i < declarationArray.length; ++i) {
            Declaration declaration = declarationArray[i];
            if (!declaration.getSource().equals(string)) continue;
            n = i;
            break;
        }
        if (n > -1) {
            Declaration[] declarationArray2 = new Declaration[declarationArray.length - 1];
            if (n > 0) {
                System.arraycopy(declarationArray, 0, declarationArray2, 0, n);
            }
            if (n < declarationArray.length - 1) {
                System.arraycopy(declarationArray, n + 1, declarationArray2, n, declarationArray.length - n - 1);
            }
            rule.setMetadata(declarationArray2);
        }
    }

    public static boolean isSetUNUSED(Rule rule, String string) {
        return IlvRuleUtils.getDeclarationUNUSED(rule, string) != null;
    }

    public static String[] getPropertyNamesUNUSED(Rule rule) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Declaration[] declarationArray = rule.getDeclarations();
        if (declarationArray != null) {
            for (int i = 0; i < declarationArray.length; ++i) {
                Declaration declaration = declarationArray[i];
                String string = declaration.getSource();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getDeclarationValueUNUSED(Rule rule, String string) {
        return IlvRuleUtils.a(rule, string, false);
    }

    public static String getMetaDeclarationValueUNUSED(Rule rule, String string) {
        return IlvRuleUtils.a(rule, string, true);
    }

    public static String setDeclarationValueUNUSED(Rule rule, String string, String string2) {
        Declaration declaration = IlvRuleUtils.getDeclarationUNUSED(rule, string);
        String string3 = null;
        if (declaration != null) {
            string3 = declaration.getValue();
            declaration.setValue(string2);
        }
        return string3;
    }

    public static Declaration getDeclarationUNUSED(Rule rule, String string) {
        Declaration[] declarationArray = rule.getDeclarations();
        if (declarationArray != null) {
            for (int i = 0; i < declarationArray.length; ++i) {
                Declaration declaration = declarationArray[i];
                if (!declaration.getSource().equals(string)) continue;
                return declaration;
            }
        }
        return null;
    }

    private static String a(Rule rule, String string, boolean bl) {
        Declaration declaration = IlvRuleUtils.b(rule, string, bl);
        if (declaration != null) {
            return declaration.getValue();
        }
        return null;
    }

    private static Declaration b(Rule rule, String string, boolean bl) {
        Declaration[] declarationArray;
        Declaration[] declarationArray2 = declarationArray = bl ? rule.getMetadata() : rule.getDeclarations();
        if (declarationArray != null) {
            for (int i = 0; i < declarationArray.length; ++i) {
                Declaration declaration = declarationArray[i];
                if (!declaration.getSource().equals(string)) continue;
                return declaration;
            }
        }
        return null;
    }

    public static String getTypeUNUSED(Rule rule) {
        if (rule == null) {
            return null;
        }
        SimpleSelector[] simpleSelectorArray = rule.getSelector();
        if (simpleSelectorArray != null && simpleSelectorArray.length > 0) {
            return IlvRuleUtils.getLastSelectorElement(rule).getType();
        }
        return null;
    }

    public static boolean hasPseudoClassesUNUSED(Rule rule) {
        return rule.getPseudos() != null && rule.getPseudos().length > 0;
    }

    public static URL getSourceURLUNUSED(Rule rule) {
        Declaration[] declarationArray = rule.getDeclarations();
        if (declarationArray != null && declarationArray.length > 0 && declarationArray[0].getDocument() != null) {
            return declarationArray[0].getDocument().getBaseURL();
        }
        return null;
    }

    public static Object[] getMatchingObjectsUNUSED(Rule rule, IlvCSSBeans ilvCSSBeans, IlvCSSModel ilvCSSModel, Object object) {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        IlvRuleUtils.a(rule, ilvCSSBeans, ilvCSSModel, object, object, arrayList, arrayList2);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = arrayList.indexOf(object);
                int n2 = arrayList.indexOf(object2);
                int n3 = (Integer)arrayList2.get(n);
                int n4 = (Integer)arrayList2.get(n2);
                return n3 - n4;
            }
        });
        return arrayList.toArray();
    }

    private static void a(Rule rule, IlvCSSBeans ilvCSSBeans, IlvCSSModel ilvCSSModel, Object object, Object object2, ArrayList arrayList, ArrayList arrayList2) {
        Object[] objectArray;
        Collection<Rule> collection = ilvCSSBeans.getDebugRules(ilvCSSModel, object, object2, null, null);
        if (collection.contains(rule) && !arrayList.contains(object2)) {
            arrayList.add(object2);
            arrayList2.add(new Integer(collection.size()));
        }
        if ((objectArray = ilvCSSModel.getChildrenAsArray(object2)) != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                IlvRuleUtils.a(rule, ilvCSSBeans, ilvCSSModel, object, object3, arrayList, arrayList2);
            }
        }
    }

    public static Rule[] getMatchedRulesUNUSED(Object object, IlvCSSBeans ilvCSSBeans, IlvCSSModel ilvCSSModel, Object object2) {
        if (object != null) {
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            ilvCSSBeans.getDebugRules(ilvCSSModel, object2, object, null, arrayList);
            return arrayList.toArray(new Rule[arrayList.size()]);
        }
        return new Rule[0];
    }

    public static synchronized Rule[] getParentRulesUNUSED(Rule rule, Rule[] ruleArray) {
        return IlvRuleUtils.getParentRulesUNUSED(rule, ruleArray, false);
    }

    public static synchronized Rule[] getParentRulesUNUSED(Rule rule, Rule[] ruleArray, boolean bl) {
        if (rule == null) {
            return new Rule[0];
        }
        ArrayList arrayList = IlvRuleUtils.a(rule, ruleArray);
        int n = arrayList.indexOf(rule);
        if (n != -1) {
            int n2;
            int n3 = n2 = bl ? n + 1 : n;
            while (n2 < arrayList.size()) {
                arrayList.remove(n2);
            }
        } else if (bl) {
            arrayList.add(rule);
        }
        return arrayList.toArray(new Rule[arrayList.size()]);
    }

    private static synchronized ArrayList a(Rule rule, Rule[] ruleArray) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        if (rule == null) {
            return arrayList;
        }
        if (ruleArray == null) {
            arrayList.add(rule);
            return arrayList;
        }
        boolean bl = true;
        SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(rule);
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule2 = ruleArray[i];
            if (rule == rule2) {
                bl = false;
                arrayList.add(rule);
                continue;
            }
            SimpleSelector simpleSelector2 = IlvRuleUtils.getLastSelectorElement(rule2);
            if ((!bl || !IlvRuleUtils.a(simpleSelector2, simpleSelector)) && (bl || !IlvRuleUtils.a(simpleSelector, simpleSelector2))) continue;
            arrayList.add(rule2);
        }
        return arrayList;
    }

    private static boolean a(SimpleSelector simpleSelector, SimpleSelector simpleSelector2) {
        if (simpleSelector.getID() != null && !simpleSelector.getID().equals(simpleSelector2.getID())) {
            return false;
        }
        if (simpleSelector.getType() != null && !simpleSelector.getType().equals(simpleSelector2.getType())) {
            return false;
        }
        if (!IlvRuleUtils.b(simpleSelector.getCSSclasses(), simpleSelector2.getCSSclasses())) {
            return false;
        }
        if (!IlvRuleUtils.b(simpleSelector.getPseudoClasses(), simpleSelector2.getPseudoClasses())) {
            return false;
        }
        return IlvRuleUtils.a(simpleSelector.getAttributes(), simpleSelector2.getAttributes());
    }

    private static boolean a(AttributeSelector attributeSelector, AttributeSelector attributeSelector2) {
        int n = attributeSelector.getComparator();
        if (n >= 3 && n <= 8 && attributeSelector2.getValue() != null) {
            try {
                double d = Double.parseDouble(attributeSelector.getValue());
                double d2 = Double.parseDouble(attributeSelector2.getValue());
                int n2 = Double.compare(d, d2);
                return n2 == 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attributeSelector.getValue().equals(attributeSelector2.getValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean a(AttributeSelector[] attributeSelectorArray, AttributeSelector[] attributeSelectorArray2) {
        if (attributeSelectorArray == null) {
            return true;
        }
        if (attributeSelectorArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < attributeSelectorArray.length) {
            AttributeSelector attributeSelector = attributeSelectorArray[n];
            String string = attributeSelector.getAttributeName();
            int n2 = attributeSelector.getComparator();
            String string2 = attributeSelector.getValue();
            boolean bl = false;
            block16: for (int i = 0; i < attributeSelectorArray2.length; ++i) {
                AttributeSelector attributeSelector2 = attributeSelectorArray2[i];
                if (!string.equals(attributeSelector2.getAttributeName())) continue;
                bl = true;
                if (string2 == null || n2 == 0) continue;
                if (IlvRuleUtils.a(attributeSelector, attributeSelector2)) {
                    if (IlvRuleUtils.a(n2, attributeSelector2.getComparator())) continue;
                    return false;
                }
                int n3 = attributeSelector2.getComparator();
                switch (n2) {
                    case 1: {
                        if (n3 == 9 || n3 == 2 && attributeSelector2.getValue() != null && attributeSelector2.getValue().indexOf(string2) != -1) continue block16;
                        return false;
                    }
                    case 9: {
                        if (n3 == 1 || n3 == 2) continue block16;
                        return false;
                    }
                    case 2: {
                        if (attributeSelector2.getValue() != null && attributeSelector2.getValue().indexOf(string2) != -1) continue block16;
                        return false;
                    }
                    case 7: {
                        return false;
                    }
                    case 8: {
                        continue block16;
                    }
                    case 3: 
                    case 4: {
                        switch (n3) {
                            case 5: 
                            case 6: 
                            case 7: {
                                if (!IlvRuleUtils.a(string2, attributeSelector2.getValue(), true)) continue block16;
                                return false;
                            }
                        }
                        continue block16;
                    }
                    case 5: 
                    case 6: {
                        switch (n3) {
                            case 3: 
                            case 4: 
                            case 7: {
                                if (!IlvRuleUtils.a(attributeSelector2.getValue(), string2, true)) break;
                                return false;
                            }
                        }
                        continue block16;
                    }
                }
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean a(String string, String string2, boolean bl) {
        double d = Double.parseDouble(string);
        double d2 = Double.parseDouble(string2);
        int n = Double.compare(d, d2);
        return bl ? n >= 0 : n > 0;
    }

    private static boolean a(int n, int n2) {
        if (n == n2) {
            return true;
        }
        switch (n) {
            case 3: {
                return n2 == 4 || n2 == 8;
            }
            case 4: {
                return n2 != 5;
            }
            case 5: {
                return n2 == 6 || n2 == 8;
            }
            case 6: {
                return n2 != 3;
            }
            case 7: {
                return n2 != 8;
            }
            case 8: {
                return n2 != 7;
            }
            case 2: {
                return n2 == 1;
            }
        }
        return false;
    }

    public static Declaration[] getDeclarationsUNUSED(Rule[] ruleArray) {
        Map map = IlvRuleUtils.getDeclarationsAsMapUNUSED(ruleArray, true);
        return map.values().toArray(new Declaration[map.size()]);
    }

    public static Map getDeclarationsAsMapUNUSED(Rule[] ruleArray, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (ruleArray != null) {
            for (int i = 0; i < ruleArray.length; ++i) {
                Declaration[] declarationArray = ruleArray[i].getDeclarations();
                for (int j = 0; j < declarationArray.length; ++j) {
                    Declaration declaration = declarationArray[j];
                    if (bl) {
                        hashMap.put(declaration.getSource(), declaration);
                        continue;
                    }
                    hashMap.put(declaration.getSource(), declaration.getValue());
                }
            }
        }
        return hashMap;
    }

    public static Map getDeclarationsUNUSED(Rule rule, Rule[] ruleArray) {
        Rule[] ruleArray2 = IlvRuleUtils.getParentRulesUNUSED(rule, ruleArray, true);
        return IlvRuleUtils.getDeclarationsAsMapUNUSED(ruleArray2, false);
    }

    public static SimpleSelector getLastSelectorElement(Rule rule) {
        SimpleSelector[] simpleSelectorArray = rule.getSelector();
        if (simpleSelectorArray == null || simpleSelectorArray.length == 0) {
            return null;
        }
        SimpleSelector simpleSelector = simpleSelectorArray[simpleSelectorArray.length - 1];
        return simpleSelector;
    }

    public static Rule[] getRulesFromClassUNUSED(Rule[] ruleArray, Class clazz) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule = ruleArray[i];
            Declaration declaration = IlvRuleUtils.getDeclarationUNUSED(rule, "class");
            if (declaration == null) continue;
            try {
                Class<?> clazz2 = Class.forName(declaration.getValue());
                if (!clazz.isAssignableFrom(clazz2)) continue;
                arrayList.add(rule);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new Rule[arrayList.size()]);
    }

    public static Rule[] getRulesFromIdUNUSED(Rule[] ruleArray, String string) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (int i = 0; i < ruleArray.length; ++i) {
            SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(ruleArray[i]);
            if (!(simpleSelector.getID() != null & string.equals(simpleSelector.getID()))) continue;
            arrayList.add(ruleArray[i]);
        }
        return arrayList.toArray(new Rule[arrayList.size()]);
    }

    public static Rule[] getRulesFromCSSclassUNUSED(Rule[] ruleArray, String string) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        block0: for (int i = 0; i < ruleArray.length; ++i) {
            SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(ruleArray[i]);
            String[] stringArray = simpleSelector.getCSSclasses();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                arrayList.add(ruleArray[i]);
                continue block0;
            }
        }
        return arrayList.toArray(new Rule[arrayList.size()]);
    }

    public static Rule[] getRootRulesUNUSED(Rule[] ruleArray) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (int i = 0; i < ruleArray.length; ++i) {
            Declaration[] declarationArray = ruleArray[i].getDeclarations();
            for (int j = 0; j < declarationArray.length; ++j) {
                Rule[] ruleArray2;
                String string = IlvRuleUtils.getAtRuleId(declarationArray[j]);
                if (string == null || (ruleArray2 = IlvRuleUtils.getRulesFromIdUNUSED(ruleArray, string)) == null) continue;
                arrayList.addAll(Arrays.asList(ruleArray2));
            }
        }
        ArrayList<Rule> arrayList2 = new ArrayList<Rule>(Arrays.asList(ruleArray));
        arrayList2.removeAll(arrayList);
        return arrayList2.toArray(new Rule[arrayList2.size()]);
    }

    public static String getAtRuleId(Declaration declaration) {
        block3: {
            String string;
            block2: {
                string = declaration.getValue();
                if (string.startsWith("@+")) break block2;
                if (string.startsWith("@#")) break block2;
                if (!string.startsWith("@=")) break block3;
            }
            String string2 = string.substring(2);
            return string2;
        }
        return null;
    }

    public static Rule getParentRuleUNUSED(Rule rule, Rule[] ruleArray) {
        Rule[] ruleArray2 = IlvRuleUtils.getParentRulesUNUSED(rule, ruleArray);
        if (ruleArray2.length > 0) {
            return ruleArray2[ruleArray2.length - 1];
        }
        return null;
    }

    public static String getDeclarationValueUNUSED(Rule rule, Rule[] ruleArray, String string) {
        if (rule.getDeclarations() == null) {
            return null;
        }
        Declaration declaration = IlvRuleUtils.getDeclarationUNUSED(rule, string);
        if (declaration != null) {
            return declaration.getValue();
        }
        Rule[] ruleArray2 = IlvRuleUtils.getParentRulesUNUSED(rule, ruleArray);
        for (int i = ruleArray2.length; i > 0; --i) {
            String string2 = IlvRuleUtils.getDeclarationValueUNUSED(ruleArray2[i - 1], string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public static String getDeclarationValue(Rule[] ruleArray, String string) {
        return IlvRuleUtils.getDeclarationValue(ruleArray, string, false);
    }

    public static String getDeclarationValue(Rule[] ruleArray, String string, boolean bl) {
        for (int i = ruleArray.length; i > 0; --i) {
            String string2 = IlvRuleUtils.a(ruleArray[i - 1], string, bl);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public static Rule getRuleWithDeclarationUNUSED(Rule rule, Rule[] ruleArray, String string) {
        if (rule.getDeclarations() == null) {
            return null;
        }
        Declaration declaration = IlvRuleUtils.getDeclarationUNUSED(rule, string);
        if (declaration != null) {
            return rule;
        }
        Rule[] ruleArray2 = IlvRuleUtils.getParentRulesUNUSED(rule, ruleArray);
        for (int i = ruleArray2.length; i > 0; --i) {
            String string2 = IlvRuleUtils.getDeclarationValueUNUSED(ruleArray2[i - 1], string);
            if (string2 == null) continue;
            return ruleArray2[i - 1];
        }
        return null;
    }

    public static String getCopyIdUNUSED(String string, Rule[] ruleArray) {
        String string2 = string;
        int n = 0;
        Rule[] ruleArray2 = IlvRuleUtils.getRulesFromIdUNUSED(ruleArray, string2);
        while (ruleArray2.length > 0) {
            string2 = string + "_copy_" + ++n;
            ruleArray2 = IlvRuleUtils.getRulesFromIdUNUSED(ruleArray, string2);
        }
        return string2;
    }

    public static Rule[] getAdditionalRulesUNUSED(Rule[] ruleArray, Rule[] ruleArray2) {
        HashSet hashSet = IlvRuleUtils.getAdditionalRulesUNUSED(ruleArray[ruleArray.length - 1], ruleArray, ruleArray2, null, true);
        return hashSet.toArray(new Rule[hashSet.size()]);
    }

    public static HashSet getAdditionalRulesUNUSED(Rule rule, Rule[] ruleArray, Rule[] ruleArray2, HashSet hashSet, boolean bl) {
        SubRuleMethodsUNUSED subRuleMethodsUNUSED = new SubRuleMethodsUNUSED(ruleArray2);
        Rule[] ruleArray3 = subRuleMethodsUNUSED.getLocalRules(rule, ruleArray, bl);
        if (hashSet == null) {
            hashSet = new HashSet<Rule>(Arrays.asList(ruleArray3));
        } else {
            hashSet.addAll(Arrays.asList(ruleArray3));
        }
        return hashSet;
    }

    private static HashSet a(SimpleSelector simpleSelector, Rule rule, Rule[] ruleArray, boolean bl, HashSet hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<Rule>();
        }
        if (rule != null) {
            Declaration[] declarationArray = rule.getDeclarations();
            for (int i = 0; i < declarationArray.length; ++i) {
                Declaration declaration = declarationArray[i];
                if (!declaration.getValue().startsWith("@+")) {
                    if (!declaration.getValue().startsWith("@#")) {
                        if (!declaration.getValue().startsWith("@=")) continue;
                    }
                }
                String string = declaration.getValue().substring(2);
                Rule[] ruleArray2 = IlvRuleUtils.getRulesFromIdUNUSED(ruleArray, string);
                for (int j = 0; j < ruleArray2.length; ++j) {
                    Rule rule2 = ruleArray2[j];
                    if (hashSet.contains(rule2)) continue;
                    if (bl) {
                        hashSet.add(rule2);
                        IlvRuleUtils.a(simpleSelector, rule2, ruleArray, true, hashSet);
                        continue;
                    }
                    if (IlvRuleUtils.b(simpleSelector, rule2, false)) {
                        hashSet.add(rule2);
                        IlvRuleUtils.a(simpleSelector, rule2, ruleArray, true, hashSet);
                        continue;
                    }
                    IlvRuleUtils.a(simpleSelector, rule2, ruleArray, false, hashSet);
                }
            }
        }
        return hashSet;
    }

    private static boolean b(SimpleSelector simpleSelector, Rule rule, boolean bl) {
        SimpleSelector simpleSelector2 = IlvRuleUtils.getLastSelectorElement(rule);
        if (bl && simpleSelector.getID() != null && !simpleSelector.getID().equals(simpleSelector2.getID())) {
            return false;
        }
        if (bl && simpleSelector.getType() != null && !simpleSelector.getType().equals(simpleSelector2.getType())) {
            return false;
        }
        if (!IlvRuleUtils.b(simpleSelector.getCSSclasses(), simpleSelector2.getCSSclasses())) {
            return false;
        }
        if (!IlvRuleUtils.c(simpleSelector.getAttributes(), simpleSelector2.getAttributes())) {
            return false;
        }
        return IlvRuleUtils.b(simpleSelector.getPseudoClasses(), simpleSelector2.getPseudoClasses());
    }

    public static String[] copyUNUSED(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private static AttributeSelector[] a(AttributeSelector[] attributeSelectorArray) {
        if (attributeSelectorArray == null) {
            return null;
        }
        AttributeSelector[] attributeSelectorArray2 = new AttributeSelector[attributeSelectorArray.length];
        System.arraycopy(attributeSelectorArray, 0, attributeSelectorArray2, 0, attributeSelectorArray.length);
        return attributeSelectorArray2;
    }

    public static boolean manageRedundantRuleUNUSED(IlvRule ilvRule, IlvBuilderDocument ilvBuilderDocument, Component component) {
        if (ilvRule == null) {
            return false;
        }
        IlvRule[] ilvRuleArray = ilvBuilderDocument.getRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            IlvRule ilvRule2 = ilvRuleArray[i];
            SimpleSelector[] simpleSelectorArray = ((IlvRuleImpl)ilvRule2).getRule().getSelector();
            if (!IlvRuleUtils.identicalUNUSED(simpleSelectorArray, ((IlvRuleImpl)ilvRule).getRule().getSelector())) continue;
            int n = JOptionPane.showOptionDialog(component, ilvBuilderDocument.getApplication().getString("Builder.Conflict.Message"), ilvBuilderDocument.getApplication().getString("Builder.Conflict.Title"), 0, 2, null, null, null);
            if (n == 0) {
                ilvBuilderDocument.deleteRule(ilvRule2);
                return true;
            }
            return false;
        }
        return true;
    }

    public static Rule getSameRuleUNUSED(Rule rule, Rule[] ruleArray) {
        if (rule == null || ruleArray == null || ruleArray.length == 0) {
            return null;
        }
        SimpleSelector[] simpleSelectorArray = rule.getSelector();
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule2 = ruleArray[i];
            if (!IlvRuleUtils.identicalUNUSED(simpleSelectorArray, rule2.getSelector())) continue;
            return ruleArray[i];
        }
        return null;
    }

    public static Collection getMoreSpecificRulesUNUSED(Rule rule, Rule[] ruleArray, boolean bl) {
        ArrayList arrayList = IlvRuleUtils.a(rule, ruleArray);
        int n = arrayList.indexOf(rule);
        if (n == -1) {
            arrayList.clear();
            if (bl) {
                arrayList.add(rule);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                arrayList.remove(0);
            }
            if (!bl) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    public static boolean identicalUNUSED(SimpleSelector[] simpleSelectorArray, SimpleSelector[] simpleSelectorArray2) {
        if (simpleSelectorArray.length != simpleSelectorArray2.length) {
            return false;
        }
        for (int i = 0; i < simpleSelectorArray.length; ++i) {
            SimpleSelector simpleSelector = simpleSelectorArray[i];
            SimpleSelector simpleSelector2 = simpleSelectorArray2[i];
            if (IlvRuleUtils.a(simpleSelector.getID(), simpleSelector2.getID()) && IlvRuleUtils.a(simpleSelector.getType(), simpleSelector2.getType()) && simpleSelector.getPreviousTransition() == simpleSelector2.getPreviousTransition() && IlvRuleUtils.a(simpleSelector.getCSSclasses(), simpleSelector2.getCSSclasses()) && IlvRuleUtils.a(simpleSelector.getPseudoClasses(), simpleSelector2.getPseudoClasses()) && IlvRuleUtils.b(simpleSelector.getAttributes(), simpleSelector2.getAttributes())) continue;
            return false;
        }
        return true;
    }

    private static boolean a(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        return IlvRuleUtils.b(stringArray, stringArray2);
    }

    private static boolean b(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean b(AttributeSelector[] attributeSelectorArray, AttributeSelector[] attributeSelectorArray2) {
        if (attributeSelectorArray == null) {
            return attributeSelectorArray2 == null;
        }
        if (attributeSelectorArray2 == null || attributeSelectorArray.length != attributeSelectorArray2.length) {
            return false;
        }
        return IlvRuleUtils.c(attributeSelectorArray, attributeSelectorArray2);
    }

    private static boolean c(AttributeSelector[] attributeSelectorArray, AttributeSelector[] attributeSelectorArray2) {
        if (attributeSelectorArray == null) {
            return attributeSelectorArray2 == null;
        }
        if (attributeSelectorArray2 == null) {
            return false;
        }
        for (int i = 0; i < attributeSelectorArray.length; ++i) {
            AttributeSelector attributeSelector = attributeSelectorArray[i];
            boolean bl = false;
            for (int j = 0; j < attributeSelectorArray2.length; ++j) {
                AttributeSelector attributeSelector2 = attributeSelectorArray2[j];
                if (!IlvRuleUtils.a(attributeSelector.getAttributeName(), attributeSelector2.getAttributeName()) || attributeSelector.getComparator() != attributeSelector2.getComparator() || !IlvRuleUtils.a(attributeSelector.getValue(), attributeSelector2.getValue())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean a(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static Rule[] withoutOverridingRulesUNUSED(Rule rule, Rule[] ruleArray) {
        Collection collection = IlvRuleUtils.getMoreSpecificRulesUNUSED(rule, ruleArray, false);
        if (collection.size() > 0) {
            ArrayList<Rule> arrayList = new ArrayList<Rule>(Arrays.asList(ruleArray));
            arrayList.removeAll(collection);
            ruleArray = arrayList.toArray(new Rule[arrayList.size()]);
        }
        return ruleArray;
    }

    public static String writeCSSUNUSED(Rule[] ruleArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule = ruleArray[i];
            boolean bl = true;
            Declaration[] declarationArray = rule.getMetadata();
            for (int j = 0; j < declarationArray.length; ++j) {
                Declaration declaration = declarationArray[j];
                if (declaration.getSource() != "_WRITABLE") continue;
                if (!declaration.getValue().equals("false")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            rule.printCSS(printWriter);
        }
        printWriter.flush();
        String string = stringWriter.toString();
        return string;
    }

    private static void a(String string, AttributeSelector[] attributeSelectorArray) {
        for (int i = 0; i < attributeSelectorArray.length; ++i) {
            if (attributeSelectorArray[i] == null || !string.equals(attributeSelectorArray[i]._root)) continue;
            attributeSelectorArray[i] = null;
        }
    }

    public static Map extractAttributesUNUSED(Rule rule) {
        AttributeSelector attributeSelector;
        AttributeSelector attributeSelector2;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        AttributeSelector[] attributeSelectorArray = IlvRuleUtils.getLastSelectorElement(rule).getAttributes();
        if (attributeSelectorArray.length == 0) {
            return hashMap;
        }
        AttributeSelector[] attributeSelectorArray2 = new AttributeSelector[attributeSelectorArray.length];
        System.arraycopy(attributeSelectorArray, 0, attributeSelectorArray2, 0, attributeSelectorArray.length);
        attributeSelectorArray = attributeSelectorArray2;
        for (n = 0; n < attributeSelectorArray.length; ++n) {
            attributeSelector2 = attributeSelectorArray[n];
            switch (attributeSelector2.getComparator()) {
                case 1: 
                case 7: {
                    hashMap.put(attributeSelector2._root, attributeSelector2.getValue());
                    IlvRuleUtils.a(attributeSelector2._root, attributeSelectorArray);
                }
            }
        }
        block32: for (n = 0; n < attributeSelectorArray.length; ++n) {
            attributeSelector2 = attributeSelectorArray[n];
            if (attributeSelector2 == null) continue;
            switch (attributeSelector2.getComparator()) {
                case 2: {
                    hashMap.put(attributeSelector2._root, attributeSelector2.getValue());
                    IlvRuleUtils.a(attributeSelector2._root, attributeSelectorArray);
                    continue block32;
                }
                case 5: 
                case 6: {
                    try {
                        double d = Double.parseDouble(attributeSelector2.getValue());
                        for (int i = 0; i < attributeSelectorArray.length; ++i) {
                            attributeSelector = attributeSelectorArray[i];
                            if (attributeSelector == null || !attributeSelector._root.equals(attributeSelector2._root)) continue;
                            switch (attributeSelector.getComparator()) {
                                case 5: 
                                case 6: {
                                    try {
                                        double d2 = Double.parseDouble(attributeSelector2.getValue());
                                        d = Math.min(d, d2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    attributeSelectorArray[i] = null;
                                }
                            }
                        }
                        double d3 = d - d / 1000.0;
                        if (d == 0.0) {
                            d3 = -0.001;
                        }
                        hashMap.put(attributeSelector2._root, new Double(d3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    attributeSelectorArray[n] = null;
                }
            }
        }
        for (n = 0; n < attributeSelectorArray.length; ++n) {
            attributeSelector2 = attributeSelectorArray[n];
            if (attributeSelector2 == null) continue;
            switch (attributeSelector2.getComparator()) {
                case 3: 
                case 4: {
                    try {
                        double d = 0.0;
                        d = Double.parseDouble(attributeSelector2.getValue());
                        for (int i = 0; i < attributeSelectorArray.length; ++i) {
                            attributeSelector = attributeSelectorArray[i];
                            if (attributeSelector == null || !attributeSelector._root.equals(attributeSelector2._root)) continue;
                            switch (attributeSelector.getComparator()) {
                                case 3: 
                                case 4: {
                                    try {
                                        double d4 = Double.parseDouble(attributeSelector2.getValue());
                                        d = Math.max(d, d4);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    attributeSelectorArray[i] = null;
                                }
                            }
                        }
                        Object v = hashMap.get(attributeSelector2._root);
                        if (v instanceof Double) {
                            d = (d + (Double)v) / 2.0;
                        } else if ((d += d / 1000.0) == 0.0) {
                            d = 0.001;
                        }
                        hashMap.put(attributeSelector2._root, new Double(d));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    attributeSelectorArray[n] = null;
                }
            }
        }
        block36: for (n = 0; n < attributeSelectorArray.length; ++n) {
            attributeSelector2 = attributeSelectorArray[n];
            if (attributeSelector2 == null) continue;
            String string = attributeSelector2._root;
            switch (attributeSelector2.getComparator()) {
                case 0: {
                    hashMap.put(string, "@" + string);
                    continue block36;
                }
                case 9: {
                    hashMap.put(string, "!^@%#@" + attributeSelector2.getValue());
                    continue block36;
                }
                case 8: {
                    Object v = hashMap.get(string);
                    if (v != null) continue block36;
                    try {
                        double d = Double.parseDouble(attributeSelector2.getValue()) + Double.MIN_VALUE;
                        hashMap.put(string, new Double(d));
                        continue block36;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return hashMap;
    }

    public static class SubRuleMethodsUNUSED {
        Rule[] a;
        HashMap b = new HashMap();

        public SubRuleMethodsUNUSED(Rule[] ruleArray) {
            this.a = ruleArray;
            if (ruleArray != null) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < ruleArray.length; ++i) {
                    Rule rule = ruleArray[i];
                    arrayList.clear();
                    this.a(rule, arrayList);
                    if (arrayList.size() <= 0) continue;
                    for (String string : arrayList) {
                        if (this.b.containsKey(string)) {
                            Rule[] ruleArray2 = (Rule[])this.b.get(string);
                            Rule[] ruleArray3 = new Rule[ruleArray2.length + 1];
                            System.arraycopy(ruleArray2, 0, ruleArray3, 1, ruleArray2.length);
                            ruleArray3[0] = rule;
                            this.b.put(string, ruleArray3);
                            continue;
                        }
                        this.b.put(string, new Rule[]{rule});
                    }
                }
            }
        }

        private void a(Rule rule, ArrayList arrayList) {
            if (rule != null) {
                Declaration[] declarationArray = rule.getDeclarations();
                for (int i = 0; i < declarationArray.length; ++i) {
                    Declaration declaration = declarationArray[i];
                    String string = IlvRuleUtils.getAtRuleId(declaration);
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
        }

        private ArrayList b(Rule rule, ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            this.a(rule, arrayList2);
            ListIterator listIterator = arrayList2.listIterator();
            block0: while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                if (!this.b.containsKey(string)) continue;
                Rule[] ruleArray = (Rule[])this.b.get(string);
                for (int i = 0; i < ruleArray.length; ++i) {
                    Rule rule2 = ruleArray[i];
                    if (arrayList.contains(rule2)) continue;
                    listIterator.remove();
                    continue block0;
                }
            }
            return arrayList2;
        }

        public Rule[] getLocalRules(Rule rule, Rule[] ruleArray, boolean bl) {
            Rule rule2;
            Rule[] ruleArray2 = this.a(rule, ruleArray);
            if (bl) {
                return ruleArray2;
            }
            SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(rule);
            ArrayList<Rule> arrayList = new ArrayList<Rule>(ruleArray2.length);
            arrayList.add(rule);
            ArrayList<Rule> arrayList2 = new ArrayList<Rule>(ruleArray2.length);
            for (int i = 0; i < ruleArray2.length; ++i) {
                rule2 = ruleArray2[i];
                if (IlvRuleUtils.b(simpleSelector, rule2, false)) {
                    arrayList.add(rule2);
                    continue;
                }
                arrayList2.add(rule2);
            }
            ListIterator listIterator = arrayList2.listIterator();
            block1: while (listIterator.hasNext()) {
                rule2 = (Rule)listIterator.next();
                String string = IlvRuleUtils.getLastSelectorElement(rule2).getID();
                if (!this.b.containsKey(string)) continue;
                Rule[] ruleArray3 = (Rule[])this.b.get(string);
                for (int i = 0; i < ruleArray3.length; ++i) {
                    Rule rule3 = ruleArray3[i];
                    if (arrayList.contains(rule3)) continue;
                    listIterator.remove();
                    continue block1;
                }
            }
            arrayList.addAll(arrayList2);
            arrayList.remove(rule);
            this.a(arrayList);
            return arrayList.toArray(new Rule[arrayList.size()]);
        }

        private Rule[] a(Rule rule, Rule[] ruleArray) {
            SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(rule);
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            ArrayList<Rule> arrayList2 = new ArrayList<Rule>();
            arrayList.add(rule);
            this.a(rule, arrayList, arrayList2);
            if (ruleArray != null) {
                Object object;
                ArrayList arrayList3 = new ArrayList();
                for (int i = 0; i < ruleArray.length; ++i) {
                    object = ruleArray[i];
                    this.a((Rule)object, arrayList3);
                }
                this.a(arrayList3);
                ListIterator listIterator = arrayList3.listIterator();
                while (listIterator.hasNext()) {
                    object = (String)listIterator.next();
                    Rule[] ruleArray2 = IlvRuleUtils.getRulesFromIdUNUSED(this.a, (String)object);
                    for (int i = 0; i < ruleArray2.length; ++i) {
                        Rule rule2 = ruleArray2[i];
                        arrayList.add(rule2);
                        if (IlvRuleUtils.b(simpleSelector, rule2, false)) {
                            arrayList2.add(rule2);
                            this.a(rule2, arrayList, arrayList2);
                            continue;
                        }
                        ArrayList arrayList4 = new ArrayList();
                        this.a(rule2, arrayList, arrayList4);
                        arrayList2.addAll(arrayList4);
                        arrayList2.add(rule2);
                    }
                }
            }
            this.a(arrayList2);
            return arrayList2.toArray(new Rule[arrayList2.size()]);
        }

        private void a(ArrayList arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = -1;
                Object e = arrayList.get(i);
                while ((n = arrayList.lastIndexOf(e)) != i) {
                    arrayList.remove(n);
                }
            }
        }

        private void a(Rule rule, ArrayList arrayList, ArrayList arrayList2) {
            ArrayList arrayList3 = this.b(rule, arrayList);
            ListIterator listIterator = arrayList3.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Rule[] ruleArray = IlvRuleUtils.getRulesFromIdUNUSED(this.a, string);
                List<Rule> list = Arrays.asList(ruleArray);
                arrayList2.addAll(list);
                arrayList.addAll(list);
                for (int i = 0; i < ruleArray.length; ++i) {
                    Rule rule2 = ruleArray[i];
                    this.a(rule2, arrayList, arrayList2);
                }
            }
        }
    }

    public static class SingletonCSSModelUNUSED
    implements IlvCSSModel {
        private Rule a;
        private String b;
        private String c;
        private String d;
        private Map e;

        public SingletonCSSModelUNUSED(Rule rule) {
            this.a = rule;
            SimpleSelector simpleSelector = IlvRuleUtils.getLastSelectorElement(this.a);
            this.c = simpleSelector.getID();
            this.b = simpleSelector.getType();
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = simpleSelector.getCSSclasses();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(' ');
            }
            this.d = stringBuffer.toString();
            this.e = IlvRuleUtils.extractAttributesUNUSED(rule);
        }

        @Override
        public Object[] getChildrenAsArray(Object object) {
            return null;
        }

        @Override
        public String getType(Object object) {
            if (object == this.a) {
                return this.b;
            }
            return null;
        }

        @Override
        public String getCSSclasses(Object object) {
            if (object == this.a) {
                return this.d;
            }
            return null;
        }

        @Override
        public String getID(Object object) {
            if (object == this.a) {
                return this.c;
            }
            return null;
        }

        @Override
        public String getValue(Object object, String string) {
            if (object != this.a) {
                return null;
            }
            Object v = this.e.get(string);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        @Override
        public Object getValueAsObject(Object object, String string) {
            if (object != this.a) {
                return null;
            }
            Object v = this.e.get(string);
            if (v != null) {
                return v;
            }
            return "@" + string;
        }

        @Override
        public ULocale getULocale(Object object) {
            return IlvLocaleUtil.getCurrentULocale();
        }

        @Override
        public ComponentOrientation getComponentOrientation(Object object) {
            return ComponentOrientation.UNKNOWN;
        }
    }

    public static class TargetModelUNUSED
    implements IlvCSSModel.Tree {
        private SimpleSelector a;
        private String b;

        public TargetModelUNUSED(Rule rule) {
            SimpleSelector[] simpleSelectorArray = rule.getSelector();
            this.a = simpleSelectorArray[simpleSelectorArray.length - 1];
            String[] stringArray = this.a.getCSSclasses();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            this.b = stringBuffer.toString();
        }

        @Override
        public Object[] getChildrenAsArray(Object object) {
            return new Object[0];
        }

        @Override
        public String getCSSclasses(Object object) {
            return this.b;
        }

        @Override
        public String getID(Object object) {
            return this.a.getID();
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public String getType(Object object) {
            return this.a.getType();
        }

        @Override
        public String getValue(Object object, String string) {
            Object object2 = this.getValueAsObject(object, string);
            return object2 == null ? null : object2.toString();
        }

        @Override
        public Object getValueAsObject(Object object, String string) {
            AttributeSelector[] attributeSelectorArray = this.a.getAttributes();
            for (int i = 0; i < attributeSelectorArray.length; ++i) {
                AttributeSelector attributeSelector = attributeSelectorArray[i];
                if (string != attributeSelector.getAttributeName()) continue;
                switch (attributeSelector.getComparator()) {
                    case 0: {
                        return "ok";
                    }
                    case 1: 
                    case 2: {
                        return attributeSelector.getValue();
                    }
                    case 9: {
                        return "+" + attributeSelector.getValue();
                    }
                    case 4: 
                    case 6: 
                    case 7: {
                        return new Double(attributeSelector.getValue());
                    }
                    case 5: 
                    case 8: {
                        double d = Double.parseDouble(attributeSelector.getValue());
                        return new Double(d - d / 100.0);
                    }
                    case 3: {
                        double d = Double.parseDouble(attributeSelector.getValue());
                        return new Double(d + d / 100.0);
                    }
                }
            }
            return null;
        }

        @Override
        public ULocale getULocale(Object object) {
            return IlvLocaleUtil.getCurrentULocale();
        }

        @Override
        public ComponentOrientation getComponentOrientation(Object object) {
            return ComponentOrientation.UNKNOWN;
        }
    }
}

