/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.builder.editor.IlvCSSMicroCustomizer;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.css.model.IlvRule;
import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.cssbeans.IlvCSSBeans;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderCustomizer
extends JSlider
implements IlvCSSMicroCustomizer {
    private static final NumberFormat a = NumberFormat.getInstance((ULocale)ULocale.US);
    private int b;
    private String c;
    private String d;
    private JLabel e;
    private String f;
    private IlvStyleChangeSupport g = new IlvStyleChangeSupport(this);
    private MessageFormat h;

    public SliderCustomizer() {
        this(0, 100, 10, null, null, null);
    }

    public SliderCustomizer(int n, int n2, int n3, String string, JLabel jLabel) {
        this(n, n2, n3, string, jLabel, null);
    }

    public SliderCustomizer(int n, int n2, int n3, String string, JLabel jLabel, MessageFormat messageFormat) {
        super(n, n2, n);
        if (n3 <= 0) {
            throw new IllegalArgumentException("increment cannot be 0");
        }
        this.b = n3;
        this.c = string;
        this.setLabel(jLabel);
        this.h = messageFormat;
        this.setPaintTicks(true);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
        this.addChangeListener(new ChangeListener(){
            int a = Integer.MIN_VALUE;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ((SliderCustomizer)changeEvent.getSource()).getValue();
                if (n == this.a) {
                    return;
                }
                this.a = n;
                SliderCustomizer.this.fireStyleChangeEvent(true);
            }
        });
    }

    @Override
    public void fireStyleChangeEvent(boolean bl) {
        int n = this.getValue();
        float f = 1.0f * (float)n / (float)this.b;
        this.d = a.format((double)f);
        if (this.e != null) {
            String string = this.h != null ? this.h.format(new Object[]{new Float(f)}) : this.d;
            this.e.setText(new StringBuffer(this.f).append(string).toString());
        }
        this.g.fireStyleChangeEvent(null, this.getDeclarations(), !bl, this.a());
    }

    public void setPropertyName(String string) {
        this.c = string;
    }

    public String getPropertyName() {
        return this.c;
    }

    public int getIncrement() {
        return this.b;
    }

    public void setIncrement(int n) {
        this.b = n;
    }

    @Override
    public void setMaximum(int n) {
        super.setMaximum(n);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
    }

    @Override
    public void setMinimum(int n) {
        super.setMaximum(n);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
    }

    public void setLabel(JLabel jLabel) {
        this.e = jLabel;
        this.f = jLabel == null ? "" : this.e.getText() + " ";
    }

    public JLabel getLabel() {
        return this.e;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.h = messageFormat;
    }

    public MessageFormat getMessageFormat() {
        return this.h;
    }

    protected Declaration[] getDeclarations() {
        Declaration declaration = null;
        if (this.c != null) {
            IlvCSSDOMImplementation ilvCSSDOMImplementation = IlvCSSBeans.createDOMImplementation();
            declaration = ilvCSSDOMImplementation.createDeclaration(this.c);
            declaration.setValue(this.d);
        }
        return new Declaration[]{declaration};
    }

    private IlvRule[] a() {
        return new IlvRule[0];
    }

    public void setNormalizedValue(int n) {
        super.setValue(n * this.b);
    }

    public int getNormalizedValue() {
        return super.getValue() / this.b;
    }

    @Override
    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.g.addStyleChangeListener(styleChangeListener);
    }

    @Override
    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.g.removeStyleChangeListener(styleChangeListener);
    }

    public String getStateName() {
        return this.d;
    }

    @Override
    public void setObject(Object object) {
    }

    public Component getPreviewComponent() {
        return null;
    }
}

