/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.appframe.form.IlvFormReaderContext;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.event.StyleChangeEvent;
import ilog.views.builder.gui.CustomCustomizer;
import ilog.views.builder.gui.IlvObjectFormCustomizer;
import ilog.views.builder.gui.csseditors.IlvCSSFloatPointPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSNumberEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPaintPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPropertyEditorManager;
import ilog.views.builder.gui.csseditors.IlvCSSShapeEditor;
import ilog.views.builder.gui.csseditors.IlvCSSURLStringPropertyEditor;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.graphic.composite.decoration.IlvRectBalloon;
import ilog.views.graphic.composite.decoration.IlvRoundRectBalloon;
import ilog.views.util.beans.IlvCommonPropertyEditors;
import ilog.views.util.beans.IlvPropertyEditorManager;
import ilog.views.util.beans.editor.IlvBlinkingColorPropertyEditor;
import ilog.views.util.beans.editor.IlvBlinkingPaintPropertyEditor;
import ilog.views.util.beans.editor.IlvPaintPropertyEditor;
import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.IlvMapBasedApplicableDeclarationCollection;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.cssbeans.IlvApplicableDeclarationsStatus;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.java2d.IlvLinearGradientPaint;
import ilog.views.util.java2d.IlvRadialGradientPaint;
import ilog.views.util.java2d.internal.IlvPaintChooser;
import ilog.views.util.java2d.internal.PaintSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.beans.PropertyEditor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Element;

public class IlvGraphicEditor
extends IlvObjectFormCustomizer {
    private IlvGraphic a;
    private IlvRuleUtils.CSSBeansEngineOptionalExpression b = new IlvRuleUtils.CSSBeansEngineOptionalExpression(new IlvCSSEngine(IlvCSSBeans.createDOMImplementation(), null, null));
    private IlvManagerView c;
    private static List d = new ArrayList();

    public IlvGraphicEditor() {
        this.getPreviewComponent();
    }

    @Override
    public Component getPreviewComponent() {
        if (this.c != null) {
            return this.c;
        }
        this.a = this.createPreviewGraphic();
        if (this.a == null) {
            return null;
        }
        IlvManager ilvManager = new IlvManager();
        ilvManager.addObject(this.a, false);
        IlvManagerView ilvManagerView = new IlvManagerView(ilvManager);
        ilvManagerView.setAutoFitToContents(true);
        ilvManagerView.setKeepingAspectRatio(true);
        ilvManagerView.setMaxZoomXFactor(1.0);
        ilvManagerView.setMinZoomXFactor(1.0);
        ilvManagerView.setAntialiasing(true);
        this.c = ilvManagerView;
        return this.c;
    }

    @Override
    protected URL resolveFormResourceURL(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return uRL;
        }
        uRL = IlvGraphicEditor.class.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        return super.resolveFormResourceURL(string);
    }

    protected IlvGraphic createPreviewGraphic() {
        return null;
    }

    @Override
    protected void applyDeclarations(StyleChangeEvent styleChangeEvent) {
        this.a((Declaration[])styleChangeEvent.getDeclarations());
        super.applyDeclarations(styleChangeEvent);
    }

    private void a(Declaration[] declarationArray) {
        if (this.a != null) {
            final IlvMapBasedApplicableDeclarationCollection ilvMapBasedApplicableDeclarationCollection = new IlvMapBasedApplicableDeclarationCollection();
            for (int i = 0; i < declarationArray.length; ++i) {
                Declaration declaration = declarationArray[i];
                ilvMapBasedApplicableDeclarationCollection.put(declaration.getSource(), declaration.getDeclarationValue());
            }
            this.a.getGraphicBag().applyToObject(this.a, new IlvApplyObject(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicEditor.this.b.setResolvingExpression(false);
                    boolean bl = IlvCSSBeans.isLoggingEnabled();
                    try {
                        IlvCSSBeans.setLoggingEnabled(false);
                        IlvGraphicEditor.this.b.applyDeclarations(null, null, IlvGraphicEditor.this.a, ilvMapBasedApplicableDeclarationCollection, new IlvApplicableDeclarationsStatus(), null);
                    }
                    finally {
                        IlvCSSBeans.setLoggingEnabled(bl);
                    }
                }
            }, null, true);
        }
    }

    @Override
    protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
        if ("width".equals(string)) {
            return new SizeEditor(string, Integer.class, element, true, ilvFormReaderContext);
        }
        if ("height".equals(string)) {
            return new SizeEditor(string, Integer.class, element, false, ilvFormReaderContext);
        }
        if (clazz2 == Color.class) {
            CustomCustomizer.Color color = (CustomCustomizer.Color)((Object)super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext));
            if ("true".equalsIgnoreCase(element.getAttribute("supportsBlinking"))) {
                color.setPropertyEditor(new IlvBlinkingColorPropertyEditor());
            }
            return (IlvCSSPropertyEditor)((Object)color);
        }
        if (clazz2 == Paint.class) {
            IlvCSSPaintPropertyEditor ilvCSSPaintPropertyEditor = (IlvCSSPaintPropertyEditor)super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
            PropertyEditor propertyEditor = ilvCSSPaintPropertyEditor.getPropertyEditor();
            if (!(propertyEditor instanceof GFPaintEditor)) {
                ilvCSSPaintPropertyEditor.setPropertyEditor(new GFPaintEditor());
            }
            if ("true".equalsIgnoreCase(element.getAttribute("supportsBlinking"))) {
                ilvCSSPaintPropertyEditor.setPropertyEditor(new GFBPaintEditor());
            }
            return ilvCSSPaintPropertyEditor;
        }
        return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
    }

    private static Paint c(Paint paint) {
        if (paint instanceof IlvLinearGradientPaint) {
            IlvLinearGradientPaint ilvLinearGradientPaint = (IlvLinearGradientPaint)paint;
            paint = new ilog.views.java2d.IlvLinearGradientPaint(ilvLinearGradientPaint);
        } else if (paint instanceof IlvRadialGradientPaint) {
            IlvRadialGradientPaint ilvRadialGradientPaint = (IlvRadialGradientPaint)paint;
            paint = new ilog.views.java2d.IlvRadialGradientPaint(ilvRadialGradientPaint);
        }
        return paint;
    }

    private static Paint d(Paint paint) {
        if (paint instanceof ilog.views.java2d.IlvLinearGradientPaint) {
            ilog.views.java2d.IlvLinearGradientPaint ilvLinearGradientPaint = (ilog.views.java2d.IlvLinearGradientPaint)paint;
            paint = new IlvLinearGradientPaint(ilvLinearGradientPaint);
        } else if (paint instanceof ilog.views.java2d.IlvRadialGradientPaint) {
            ilog.views.java2d.IlvRadialGradientPaint ilvRadialGradientPaint = (ilog.views.java2d.IlvRadialGradientPaint)paint;
            paint = new IlvRadialGradientPaint(ilvRadialGradientPaint);
        }
        return paint;
    }

    public static void RegisterEditorFactory(Class clazz, IlvObjectFormCustomizer.EditorFactory editorFactory) {
        d.add(clazz);
        d.add(editorFactory);
    }

    public static void UnregisterEditorFactory(Class clazz) {
        int n = d.lastIndexOf(clazz);
        if (n < 0) {
            return;
        }
        d.remove(n + 1);
        d.remove(n);
    }

    static {
        IlvGraphicEditor.RegisterEditorFactory(IlvText.class, new IlvObjectFormCustomizer.EditorFactory(){

            @Override
            public IlvObjectFormCustomizer createEditor(Object object) {
                return new TextEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvZoomableLabel.class, new IlvObjectFormCustomizer.EditorFactory(){

            @Override
            public IlvObjectFormCustomizer createEditor(Object object) {
                return new ZoomableLabelEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvIcon.class, new IlvObjectFormCustomizer.EditorFactory(){

            @Override
            public IlvObjectFormCustomizer createEditor(Object object) {
                return new IconEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvRoundRectBalloon.class, new IlvObjectFormCustomizer.EditorFactory(){

            @Override
            public IlvObjectFormCustomizer createEditor(Object object) {
                return new RoundRectBalloonEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvRectBalloon.class, new IlvObjectFormCustomizer.EditorFactory(){

            @Override
            public IlvObjectFormCustomizer createEditor(Object object) {
                return new RectBalloonEditor();
            }
        });
        IlvCommonPropertyEditors.initializePropertyEditors(true);
        IlvPropertyEditorManager.registerEditor(IlvPoint.class, IlvCSSFloatPointPropertyEditor.class);
        IlvCSSPropertyEditorManager.RegisterMicroEditorFactory(Shape.class, new IlvCSSPropertyEditorManager.CSSPropertyEditorFactory(){

            @Override
            public IlvCSSPropertyEditor createPropertyEditor(Element element, IlvFormReaderContext ilvFormReaderContext) {
                return new IlvCSSShapeEditor(element.getAttribute("name").intern());
            }
        });
        IlvCSSWriter.setConstructorDescriptor(ilog.views.java2d.IlvLinearGradientPaint.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[8];
                stringArray[0] = "start";
                stringArray[1] = "end";
                stringArray[2] = "stops";
                stringArray[3] = "colors";
                stringArray[4] = "spreadMethod";
                stringArray[5] = "colorSpace";
                stringArray[6] = "transform";
                stringArray[7] = "adapting";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(ilog.views.java2d.IlvRadialGradientPaint.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[9];
                stringArray[0] = "center";
                stringArray[1] = "radius";
                stringArray[2] = "stops";
                stringArray[3] = "colors";
                stringArray[4] = "focal";
                stringArray[5] = "spreadMethod";
                stringArray[6] = "colorSpace";
                stringArray[7] = "transform";
                stringArray[8] = "adapting";
                return stringArray;
            }
        });
    }

    public static class Handler
    extends IlvObjectFormCustomizer.CustomizerHandler {
        public Handler(IlvBuilderDocument ilvBuilderDocument) {
            super(ilvBuilderDocument);
        }

        @Override
        protected List getFactories() {
            return d;
        }
    }

    public static class RectBalloonEditor
    extends IlvGraphicEditor {
        @Override
        protected IlvGraphic createPreviewGraphic() {
            return new IlvRectBalloon();
        }
    }

    public static class RoundRectBalloonEditor
    extends IlvGraphicEditor {
        @Override
        protected IlvGraphic createPreviewGraphic() {
            return new IlvRoundRectBalloon();
        }
    }

    public static class IconEditor
    extends IlvGraphicEditor {
        @Override
        protected IlvGraphic createPreviewGraphic() {
            return new IlvIcon();
        }

        @Override
        protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
            if ("imageLocation".equals(string)) {
                return new IlvCSSURLStringPropertyEditor(string, "image");
            }
            return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
        }
    }

    public static class ZoomableLabelEditor
    extends IlvGraphicEditor {
        public ZoomableLabelEditor() {
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(this, true), "fillPaint", "fillOn");
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(this, true), "backgroundPaint", "backgroundOn");
            IlvObjectFormCustomizer.Enabler enabler = new IlvObjectFormCustomizer.Enabler(){

                @Override
                public boolean isEnabled(Object object, Object object2) {
                    if (object instanceof IlvZoomableLabel) {
                        IlvZoomableLabel ilvZoomableLabel = (IlvZoomableLabel)object;
                        return ilvZoomableLabel.isStrokeOn() || ilvZoomableLabel.isBorderOn();
                    }
                    return false;
                }
            };
            this.addEnabler(enabler, "strokePaint", "strokeOn");
            this.addEnabler(enabler, "stroke", "strokeOn");
        }

        @Override
        protected IlvGraphic createPreviewGraphic() {
            return new IlvZoomableLabel();
        }
    }

    public static class TextEditor
    extends IlvGraphicEditor {
        public TextEditor() {
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(this, true), "fillPaint", "fillOn");
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(this, true), "paintAbsolute", "fillOn");
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(this, true), "strokeColor", "strokeOn");
            IlvObjectFormCustomizer.Enabler enabler = new IlvObjectFormCustomizer.Enabler(){

                @Override
                public boolean isEnabled(Object object, Object object2) {
                    return (Short)object2 != 0;
                }
            };
            this.addEnabler(enabler, "wrappingWidth", "wrappingMode");
            this.addEnabler(enabler, "wrappingHeight", "wrappingMode");
            IlvObjectFormCustomizer.Enabler enabler2 = new IlvObjectFormCustomizer.Enabler(){

                @Override
                public boolean isEnabled(Object object, Object object2) {
                    return (Integer)object2 != 0;
                }
            };
            this.addEnabler(enabler2, "outlineColor", "outlineMode");
            this.addEnabler(enabler2, "outlineThickness", "outlineMode");
            IlvObjectFormCustomizer.Enabler enabler3 = new IlvObjectFormCustomizer.Enabler(){

                @Override
                public boolean isEnabled(Object object, Object object2) {
                    return (Integer)object2 != 2048;
                }
            };
            this.addEnabler(enabler3, "foreground", "outlineMode");
        }

        @Override
        protected IlvGraphic createPreviewGraphic() {
            return new IlvText();
        }

        @Override
        protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
            return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
        }
    }

    private static class GFBPaintEditor
    extends IlvBlinkingPaintPropertyEditor {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Paint paint = ((PaintSelectionModel)changeEvent.getSource()).getSelectedPaint();
            paint = IlvGraphicEditor.c(paint);
            this.setValue(paint);
        }

        @Override
        public Component getCustomEditor() {
            IlvPaintChooser ilvPaintChooser = (IlvPaintChooser)super.getCustomEditor();
            Paint paint = ilvPaintChooser.getPaint();
            paint = IlvGraphicEditor.d(paint);
            ilvPaintChooser.setPaint(paint);
            return ilvPaintChooser;
        }
    }

    private static class GFPaintEditor
    extends IlvPaintPropertyEditor {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Paint paint = ((PaintSelectionModel)changeEvent.getSource()).getSelectedPaint();
            paint = IlvGraphicEditor.c(paint);
            this.setValue(paint);
        }

        @Override
        public Component getCustomEditor() {
            IlvPaintChooser ilvPaintChooser = (IlvPaintChooser)super.getCustomEditor();
            Paint paint = ilvPaintChooser.getPaint();
            paint = IlvGraphicEditor.d(paint);
            ilvPaintChooser.setPaint(paint);
            return ilvPaintChooser;
        }
    }

    private static class SizeEditor
    extends IlvCSSNumberEditor {
        private boolean a;

        public SizeEditor(String string, Class clazz, Element element, boolean bl, IlvFormReaderContext ilvFormReaderContext) {
            super(string, clazz, element, ilvFormReaderContext);
            this.a = bl;
        }

        @Override
        public void setPropertyValue(Object object, Object object2) {
            IlvRect ilvRect = ((IlvGraphic)object).boundingBox();
            super.setPropertyValue(object, new Integer(this.a ? (int)ilvRect.width : (int)ilvRect.height));
        }

        @Override
        protected String getStringValue(double d) {
            return Integer.toString((int)d);
        }

        @Override
        public Declaration[] getDeclarations() {
            IlvCSSDOMImplementation ilvCSSDOMImplementation = IlvCSSBeans.createDOMImplementation();
            Declaration declaration = ilvCSSDOMImplementation.createDeclaration(this.a ? "width" : "height");
            int n = (int)this.getValue();
            declaration.setValue(this.getStringValue(n));
            return new Declaration[]{declaration};
        }
    }
}

