/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvAbstractFileDocument;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvFileDocumentTemplate;
import ilog.views.appframe.event.ApplicationEvent;
import ilog.views.appframe.event.ApplicationListener;
import ilog.views.appframe.event.IlvApplicationAdapter;
import ilog.views.appframe.event.IlvSingleActionHandler;
import ilog.views.appframe.plugin.IlvPlugin;
import ilog.views.appframe.plugin.IlvPluginManager;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.swing.IlvMenuBar;
import ilog.views.appframe.swing.IlvSplashWindow;
import ilog.views.appframe.swing.IlvSwingMainWindow;
import ilog.views.appframe.swing.IlvToolBar;
import ilog.views.appframe.swing.docking.IlvDockingArea;
import ilog.views.appframe.swing.mdi.IlvMDITabbedPane;
import ilog.views.appframe.util.IlvFileChooserSelection;
import ilog.views.appframe.util.IlvResourceClassResolver;
import ilog.views.builder.IlvBuilderPluginInstaller;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.builder.gui.IlvContextualFileChooser;
import ilog.views.builder.gui.Utils;
import ilog.views.util.IlvFrameworkProduct;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.internal.IlvEnvironmentUtil;
import ilog.views.util.internal.IlvPopUserBrowser;
import ilog.views.util.internal.IlvSplash;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import ilog.views.util.swing.layout.IlvBetterFlowLayout;
import ilog.views.util.waitcursor.IlvWaitCursorManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class IlvBuilder {
    public static final String PREFERENCES_SETTING_ELT = "preferences";
    public static final String OPEN_DOCUMENT_LIST_ELT = "lastDocuments";
    public static final String OPEN_DOCUMENT_ELT = "document";
    public static final String OPEN_DOCUMENT_PATHNAME_ATT = "pathname";
    public static final String OPEN_DOCUMENT_ACTIVE_ATT = "active";
    public static final String WIZARD_SETTING_ELEMENT = "wizard";
    public static final String SHOW_AT_STARTUP_ATT = "showAtStartup";
    public static final String ALLOW_STARTUP_WIZARD = "allow-startup-wizard";
    private BuilderApplication a;
    private JFrame b;
    private IlvSwingMainWindow c;
    private ApplicationListener d;
    private IlvToolBar e;
    private JPanel f;
    private ApplicationListener g;
    private boolean h = true;
    private boolean i = true;
    private String j = null;
    public static final String DESIGNER_CLOSED = "DesignerClosed";
    private JDialog k;
    private JDialog l;
    private static final String m = "IlvBuilder";
    private static final String n = "data/plugins";
    private static final String o = "JVIEWS_BUILDER_HOME";
    private static final String p = "Builder.Help.File";
    private static final String q = "Builder.Fallback.Help.File";
    private static final String r = "Builder.Help.File.Missing";
    private static final String s = "Builder.Help.File.Failed";
    private static final String t = "Builder.Demo.File";
    private static final String u = "Builder.Fallback.Demo.File";
    private static final String v = "Builder.Demo.File.Missing";
    private static final String w = "Builder.Demo.File.Failed";
    private static final String x = "Builder.About.Dialog.Title";
    private static final String y = "Builder.Dialog.Ok.Button.Label";
    private static final String z = "Builder.License.Dialog.Title";
    private static final String aa = "Builder.License.Dialog.Explanation";
    private static final String ab = "Builder.License.Dialog.LicensesTable.Column.Header.ProductName";
    private static final String ac = "Builder.License.Dialog.LicensesTable.Column.Header.ProductVersion";
    private static final String ad = "Builder.License.Dialog.LicensesTable.Column.Header.Type";
    private static final String ae = "Builder.License.Dialog.LicensesTable.Column.Header.Expiration";
    private static final String af = "Builder.License.Dialog.LicensesTable.Column.Header.MaintenanceEnd";
    private static final String ag = "Builder.License.Dialog.LicensesTable.Column.Header.SiteName";
    private static final String ah = "Builder.License.Dialog.LicensesTable.Column.Header.Application";
    private static final String ai = "Builder.License.Dialog.LicensesTable.Column.Header.HostID";
    private static final String aj = "Builder.License.Dialog.LicensesTable.Column.Header.Banner";
    private static final String ak = "Builder.License.Dialog.LicensesTable.Column.Header.LicenseID";
    private static final String al = "Builder.License.Dialog.DisabledExplanation";
    private String am;
    private Logger an;
    private URL ao;
    private static final boolean ap = true;
    private static ArrayList aq;

    public static void main(String[] stringArray) {
        Parser.setOptimized(false);
        final IlvBuilder ilvBuilder = new IlvBuilder(stringArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ilvBuilder.getFrame().setVisible(true);
            }
        });
    }

    public IlvBuilder(String[] stringArray) {
        this(stringArray, null);
    }

    public IlvBuilder(String[] stringArray, String string) {
        this.am = string;
        this.init(stringArray);
    }

    public void setStandalone(boolean bl) {
        this.h = bl;
    }

    public boolean isStandalone() {
        return this.h;
    }

    public void setFixBadProjectPaths(boolean bl) {
        this.i = bl;
    }

    public boolean isFixBadProjectPaths() {
        return this.i;
    }

    protected IlvFileChooserSelection[] showFileChooser(String string, String string2, int n, IlvFileDocumentTemplate ilvFileDocumentTemplate, Component component) {
        return this.a.a(string, string2, n, ilvFileDocumentTemplate, component);
    }

    protected synchronized void init(final String[] stringArray) {
        IlvWaitCursorManager.init();
        ToolTipManager.sharedInstance().setDismissDelay(12000);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if ("ja".equals(Locale.getDefault().getLanguage())) {
                    IlvEnvironmentUtil.preferLocaleFonts();
                }
                String string = IlvBuilder.class.getName();
                string = string.substring(0, string.lastIndexOf(46));
                IlvBuilder.this.an = Logger.getLogger(string);
                IlvBuilder.this.b = new JFrame();
                IlvBuilder.this.a = new BuilderApplication(stringArray);
                IlvBuilder.this.a.setProperty(IlvBuilder.m, IlvBuilder.this);
                IlvBuilder.this.a.addURLResolver(new IlvResourceClassResolver(IlvBuilder.class));
                IlvBuilder.this.a.addXMLSettings("resources/settings.xml");
                IlvBuilder.this.a.addResourcePropertyFile("resources/builder");
                IlvSplashWindow ilvSplashWindow = new IlvSplashWindow(IlvBuilder.this.b){

                    @Override
                    public void setImage(URL uRL) {
                        if (uRL != null) {
                            try {
                                uRL = IlvURLUtil.prepare(uRL);
                            }
                            catch (MalformedURLException malformedURLException) {
                                uRL = null;
                            }
                        }
                        if (uRL != null) {
                            IlvBuilder.this.ao = uRL;
                            this.a(new ImageIcon(uRL));
                        }
                    }

                    private void a(ImageIcon imageIcon) {
                        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
                        bufferedImage.createGraphics().drawImage(imageIcon.getImage(), 0, 0, null);
                        super.setImage(bufferedImage);
                    }

                    @Override
                    protected void addImageComponent(Component component, ImageIcon imageIcon) {
                        IlvBuilder.this.a();
                        JComponent jComponent = IlvSplash.createSplashComponent(IlvBuilder.this.a.getResourceBundleManager(), IlvBuilder.this.ao, null, IlvBuilder.this.j, IlvFrameworkProduct.getVersion(), IlvFrameworkProduct.getMinorVersion(), IlvFrameworkProduct.getSubMinorVersion(), IlvFrameworkProduct.getPatchLevel(), 0L, 0);
                        this.add(jComponent);
                    }
                };
                IlvBuilder.this.a.setSplashWindow(ilvSplashWindow);
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
        final IlvPluginManager ilvPluginManager = new IlvPluginManager();
        runnable = new Runnable(){

            @Override
            public void run() {
                URL[] uRLArray = IlvBuilder.this.getPluginURLs();
                if (uRLArray != null) {
                    for (int i = 0; i < uRLArray.length; ++i) {
                        ilvPluginManager.addRootURL(uRLArray[i]);
                    }
                }
                ilvPluginManager.setApplication(IlvBuilder.this.a);
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
        runnable = new Runnable(){

            @Override
            public void run() {
                IlvSingleActionHandler ilvSingleActionHandler = new IlvSingleActionHandler("HelpHelpAction"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IlvBuilder.this.doHelp();
                    }
                };
                IlvBuilder.this.a.addActionHandler(ilvSingleActionHandler);
                IlvSingleActionHandler ilvSingleActionHandler2 = new IlvSingleActionHandler("HelpDemoAction"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IlvBuilder.this.doDemo();
                    }
                };
                IlvBuilder.this.a.addActionHandler(ilvSingleActionHandler2);
                IlvSingleActionHandler ilvSingleActionHandler3 = new IlvSingleActionHandler("HelpAboutAction"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IlvBuilder.this.doAbout();
                    }
                };
                IlvBuilder.this.a.addActionHandler(ilvSingleActionHandler3);
                IlvSingleActionHandler ilvSingleActionHandler4 = new IlvSingleActionHandler("HelpLicenseAction"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IlvBuilder.this.doLicense();
                    }
                };
                IlvBuilder.this.a.addActionHandler(ilvSingleActionHandler4);
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
        runnable = new Runnable(){

            @Override
            public void run() {
                IlvBuilder.this.a.initialize();
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
        runnable = new Runnable(){

            @Override
            public void run() {
                String string = null;
                IlvSettingsElement ilvSettingsElement = IlvBuilder.this.a.selectElement("lookAndFeel", null, null);
                if (ilvSettingsElement != null) {
                    string = ilvSettingsElement.getString("name", null);
                }
                if (string == null) {
                    string = IlvSwingUtil.getDefaultAppropriateLookAndFeelClassName();
                }
                try {
                    UIManager.setLookAndFeel(string);
                }
                catch (Exception exception) {
                    System.err.println("Incorrect look and feel name. Using cross platform look and feel.");
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                IlvBuilder.this.c = new IlvSwingMainWindow(IlvBuilder.this.b, false, true);
                IlvDockingArea ilvDockingArea = IlvBuilder.this.c.getDockingArea();
                ilvDockingArea.setMDIPane("MDI");
                Utils.installDropTarget(IlvBuilder.this.a, IlvBuilder.this.b.getRootPane());
                IlvMDITabbedPane ilvMDITabbedPane = new IlvMDITabbedPane();
                ilvDockingArea.setDockableComponent("MDI", ilvMDITabbedPane);
                IlvBuilder.this.c.setMDIClient(ilvMDITabbedPane);
                IlvMenuBar ilvMenuBar = new IlvMenuBar();
                ilvMenuBar.setApplication(IlvBuilder.this.a);
                IlvBuilder.this.b.setJMenuBar(ilvMenuBar);
                IlvBuilder.this.e = new IlvToolBar();
                IlvBuilder.this.e.setApplication(IlvBuilder.this.a);
                IlvBuilder.this.e.setUndockedTitle(IlvBuilder.this.a.getString("Builder.standardToolbar.title"));
                IlvBuilder.this.b.getContentPane().add((Component)IlvBuilder.this.e, "North");
                ilvDockingArea.setWorkspaceConfiguration("default");
                ilvDockingArea.setDockableVisibilityAction("PropertySheetView", "PropertySheetView");
                ilvDockingArea.setDockableVisibilityAction("DataModelView", "DataModelView");
                ilvDockingArea.setDockableVisibilityAction("CustomizerView", "CustomizerView");
                ilvDockingArea.setDockableVisibilityAction("RuleTreeView", "RuleTreeView");
                ilvDockingArea.setDockableVisibilityAction("MessageView", "MessageView");
                ilvDockingArea.setConstraintFloatable(false);
                IlvBuilder.this.a.setMainWindow(IlvBuilder.this.c);
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
        runnable = new Runnable(){

            @Override
            public void run() {
                IlvMessageView.initialize(IlvBuilder.this.a);
                IlvToolBar ilvToolBar = new IlvToolBar(1);
                ilvToolBar.setFloatable(false);
                ilvToolBar.setSettingsName("modes");
                ilvToolBar.setApplication(IlvBuilder.this.a);
                IlvBuilder.getBuilder(IlvBuilder.this.a).getFrame().getContentPane().add((Component)ilvToolBar, "Before");
                if (stringArray != null && stringArray.length != 0) {
                    IlvBuilder.this.d = new ApplicationListener(){

                        @Override
                        public void applicationEventReceived(ApplicationEvent applicationEvent) {
                            if (applicationEvent.getID() == 124) {
                                IlvBuilder.this.a(stringArray);
                                IlvBuilder.this.a.removeApplicationListener(IlvBuilder.this.d);
                            }
                        }
                    };
                    IlvBuilder.this.a.addApplicationListener(IlvBuilder.this.d);
                } else {
                    IlvBuilder.this.d = new ApplicationListener(){

                        @Override
                        public void applicationEventReceived(ApplicationEvent applicationEvent) {
                            if (applicationEvent.getID() == 124) {
                                IlvBuilder.this.a.removeApplicationListener(IlvBuilder.this.d);
                            }
                        }
                    };
                    IlvBuilder.this.a.addApplicationListener(IlvBuilder.this.d);
                }
                int n = ilvPluginManager.getPluginCount();
                for (int i = 0; i < n; ++i) {
                    IlvBuilder.this.a.addApplicationListener((IlvBuilderPluginInstaller)ilvPluginManager.getPlugin(i).getInstaller());
                }
                IlvBuilder.this.g = new ApplicationListener(){
                    IlvDocument[] a;
                    IlvDocument b;

                    @Override
                    public void applicationEventReceived(ApplicationEvent applicationEvent) {
                        if (applicationEvent.getID() == 122) {
                            if (IlvBuilder.this.a.isHideOnQuit()) {
                                return;
                            }
                            this.a = IlvBuilder.this.a.getOpenDocuments();
                            this.b = IlvBuilder.this.a.getActiveDocument(true);
                        } else if (applicationEvent.getID() == 123) {
                            if (IlvBuilder.this.a.isHideOnQuit()) {
                                return;
                            }
                            IlvSettingsElement ilvSettingsElement = IlvBuilder.this.a.selectElement(IlvBuilder.PREFERENCES_SETTING_ELT, null, null);
                            IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.ensureChildElement(IlvBuilder.OPEN_DOCUMENT_LIST_ELT);
                            ilvSettingsElement2.removeAll(null);
                            if (this.a != null && this.a.length > 0) {
                                for (int i = 0; i < this.a.length; ++i) {
                                    URL uRL = ((IlvAbstractFileDocument)this.a[i]).getPathName();
                                    if (uRL == null) continue;
                                    IlvSettingsElement ilvSettingsElement3 = ilvSettingsElement2.getSettings().createSettingsElement(IlvBuilder.OPEN_DOCUMENT_ELT);
                                    ilvSettingsElement2.add(ilvSettingsElement3);
                                    ilvSettingsElement3.setAttributeValue(IlvBuilder.OPEN_DOCUMENT_PATHNAME_ATT, uRL);
                                    if (this.b != this.a[i]) continue;
                                    ilvSettingsElement3.setAttribute(IlvBuilder.OPEN_DOCUMENT_ACTIVE_ATT, "true");
                                }
                            }
                        }
                    }
                };
                IlvBuilder.this.a.addApplicationListener(IlvBuilder.this.g);
            }
        };
        IlvSwingUtil.invokeAndWaitForIdle(runnable);
    }

    private void a() {
        if (this.j != null) {
            return;
        }
        String string = this.a(this.a);
        if (string != null) {
            this.j = this.a.getString("Builder.ApplicationName." + string);
        }
    }

    private String a(IlvApplication ilvApplication) {
        String string = null;
        ArrayList arrayList = IlvPluginManager.getPluginManagers(ilvApplication);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            IlvPluginManager ilvPluginManager = (IlvPluginManager)arrayList.get(i);
            int n2 = ilvPluginManager.getPluginCount();
            for (int j = 0; j < n2; ++j) {
                IlvPlugin ilvPlugin = ilvPluginManager.getPlugin(j);
                if (string == null) {
                    string = ilvPlugin.getNameKey();
                    continue;
                }
                if (!ilvPlugin.getNameKey().startsWith("Builder.")) continue;
                string = ilvPlugin.getNameKey();
            }
        }
        return string;
    }

    private synchronized void b() {
    }

    private synchronized void a(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) continue;
            SwingUtilities.invokeLater(new LoadLater(stringArray[i]));
        }
    }

    public IlvApplication getApplication() {
        return this.a;
    }

    public JFrame getFrame() {
        return this.b;
    }

    public IlvSwingMainWindow getMainWindow() {
        return this.c;
    }

    protected void popBrowser(String string, String string2, String string3, String string4) {
        File file = null;
        try {
            if (string != null && string.trim().length() > 0) {
                file = new File(string.trim()).getAbsoluteFile();
            }
            if (file == null || !file.exists()) {
                string = string2;
                file = new File(string.trim()).getAbsoluteFile();
            }
            if (!file.exists()) {
                Object[] objectArray = new Object[]{file};
                String string5 = MessageFormat.format(string3, objectArray);
                IlvBuilder.showErrorBox(this.getApplication(), string5, null);
                return;
            }
            IlvPopUserBrowser.pop(file);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{file};
            String string6 = MessageFormat.format(string4, objectArray);
            String string7 = exception.getMessage();
            if (string7 == null || string7.trim().length() < 1) {
                string7 = exception.toString();
            }
            IlvBuilder.showErrorBox(this.getApplication(), string6 + '\n' + string7, null);
        }
    }

    public void doHelp() {
        this.popBrowser(this.a.getString(p), this.a.getString(q), this.a.getString(r), this.a.getString(s));
    }

    public void doDemo() {
        this.popBrowser(this.a.getString(t), this.a.getString(u), this.a.getString(v), this.a.getString(w));
    }

    public void doAbout() {
        if (this.k == null) {
            String string = this.a.getString(x);
            IlvBuilderPluginInstaller ilvBuilderPluginInstaller = IlvBuilderPluginInstaller.getInstaller(this);
            this.a();
            this.k = IlvSplash.createSplashDialog(this.getFrame(), string, this.a.getResourceBundleManager(), this.ao, null, this.j, ilvBuilderPluginInstaller.getMajorVersion(), ilvBuilderPluginInstaller.getMinorVersion(), ilvBuilderPluginInstaller.getSubMinorVersion(), ilvBuilderPluginInstaller.getPatchLevel(), ilvBuilderPluginInstaller.getBuildNumber(), ilvBuilderPluginInstaller.getReleaseDate());
        }
        this.k.setVisible(true);
    }

    public void doLicense() {
        if (this.l == null) {
            String string = this.a.getString(z);
            this.l = new JDialog(this.getFrame(), string, false);
            Container container = this.l.getContentPane();
            container.setLayout(new BorderLayout());
            Box box = new Box(2);
            box.add(Box.createHorizontalStrut(5));
            box.setBorder(BorderFactory.createCompoundBorder(new IlvEtchedLineBorder(2), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Utils.LABEL_FOREGROUND_COLOR);
            jLabel.setFont(Utils.TITLE_FONT);
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            container.add((Component)box, "North");
            JComponent jComponent = new Box(3);
            jComponent.add(Box.createVerticalStrut(3));
            Object object = this.a.getString(al);
            Box box2 = new Box(2);
            box2.add(Box.createHorizontalStrut(5));
            JLabel jLabel2 = new JLabel((String)object);
            jLabel2.setForeground(Utils.LABEL_FOREGROUND_COLOR);
            box2.add(jLabel2);
            box2.add(Box.createHorizontalStrut(5));
            jComponent.add(box2);
            jComponent.add(Box.createVerticalStrut(5));
            container.add((Component)jComponent, "Center");
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout());
            jComponent.setBorder(new IlvEtchedLineBorder());
            final JButton jButton = new JButton(this.a.getString(y));
            jComponent.add(jButton);
            container.add((Component)jComponent, "South");
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IlvBuilder.this.l.setVisible(false);
                }
            };
            jButton.addActionListener((ActionListener)object);
            this.l.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jButton.doClick(50);
                }
            }, "ok", KeyStroke.getKeyStroke(27, 0), 2);
            this.l.pack();
            this.l.setLocationRelativeTo(this.getFrame());
        }
        this.l.setVisible(true);
    }

    public void addToolbar(JToolBar jToolBar) {
        if (this.f == null) {
            this.f = new JPanel(new IlvBetterFlowLayout(3, 0, 0));
            this.b.getContentPane().remove(this.e);
            this.f.add(this.e);
            this.b.getContentPane().add((Component)this.f, "North");
        }
        this.f.add(jToolBar);
        this.f.revalidate();
        this.f.repaint();
    }

    public void removeToolbar(JToolBar jToolBar) {
        if (this.f != null) {
            this.f.remove(jToolBar);
            if (this.f.getComponentCount() == 1 && this.f.getComponent(0) == this.e) {
                this.f.remove(this.e);
                this.b.getContentPane().remove(this.f);
                this.b.getContentPane().add((Component)this.e, "North");
                this.f = null;
            } else {
                this.f.revalidate();
                this.f.repaint();
            }
        }
    }

    protected File getPluginsDirectory() {
        String string = this.am;
        if (string == null) {
            string = System.getProperty(o);
        }
        File file = string != null ? new File(string + File.separatorChar + n) : new File(n);
        if (!file.exists()) {
            IlvBuilder.showErrorBox(this.getApplication(), "Builder.NoPluginsDir", null);
            throw new IllegalArgumentException(this.getApplication().getString("Builder.NoPluginsDir"));
        }
        return file;
    }

    protected URL[] getPluginURLs() {
        try {
            return new URL[]{IlvURLUtil.convertFileToAbsoluteURL(this.getPluginsDirectory())};
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getExamplesDirectory() {
        File file = new File("data/examples");
        if (file.exists()) {
            return file;
        }
        File file2 = new File("../jviews-chart/demos/gallery/data");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File("../../samples/gallery/data");
        if (file3.exists()) {
            return file3;
        }
        URL uRL = this.a.getUserHomeDirectory();
        if (uRL != null) {
            if ("file".equals(uRL.getProtocol())) {
                return IlvURLUtil.convertFileURLToFile(uRL);
            }
        }
        return new File(this.am);
    }

    public static IlvBuilder getBuilder(IlvApplication ilvApplication) {
        return (IlvBuilder)ilvApplication.getProperty(m);
    }

    public static void showErrorBox(IlvApplication ilvApplication, String string, Exception exception) {
        IlvBuilder ilvBuilder = IlvBuilder.getBuilder(ilvApplication);
        String string2 = ilvApplication.getString(string);
        ilvBuilder.an.log(Level.SEVERE, string2, exception);
    }

    public static IlvBuilder callBuilder(final String string, String string2, final PropertyChangeListener propertyChangeListener) {
        if (aq == null) {
            aq = new ArrayList();
        }
        IlvBuilder ilvBuilder = null;
        for (int i = 0; i < aq.size(); ++i) {
            IlvBuilder ilvBuilder2 = (IlvBuilder)aq.get(i);
            if ((string2 != null || ilvBuilder2.am != null) && (string2 == null || !string2.equals(ilvBuilder2.am))) continue;
            ilvBuilder = ilvBuilder2;
            break;
        }
        if (ilvBuilder == null) {
            try {
                ilvBuilder = new IlvBuilder(new String[0], string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            ((BuilderApplication)ilvBuilder.getApplication()).setHideOnQuit(true);
            aq.add(ilvBuilder);
        }
        ilvBuilder.getFrame().setVisible(true);
        if (ilvBuilder.getFrame().getState() == 1) {
            ilvBuilder.getFrame().setState(0);
        }
        final IlvBuilder ilvBuilder3 = ilvBuilder;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ilvBuilder3.a(string, propertyChangeListener);
            }
        });
        return ilvBuilder;
    }

    private static void n(IlvBuilder ilvBuilder) {
        aq.remove(ilvBuilder);
    }

    private void a(String string, PropertyChangeListener propertyChangeListener) {
        IlvBuilderDocument ilvBuilderDocument = (IlvBuilderDocument)this.getApplication().openDocumentFile(string, true, false);
        SaveListener saveListener = new SaveListener(ilvBuilderDocument, propertyChangeListener);
        this.getApplication().addApplicationListener(saveListener);
    }

    private class SaveListener
    extends IlvApplicationAdapter
    implements Runnable {
        private IlvBuilderDocument a;
        private PropertyChangeListener b;

        public SaveListener(IlvBuilderDocument ilvBuilderDocument, PropertyChangeListener propertyChangeListener) {
            this.a = ilvBuilderDocument;
            this.b = propertyChangeListener;
        }

        @Override
        public void documentSaved(ApplicationEvent applicationEvent) {
            if (applicationEvent.getDocument() == this.a) {
                URL uRL = this.a.getPathName();
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.a, "projectURL", uRL, uRL);
                this.b.propertyChange(propertyChangeEvent);
            }
        }

        @Override
        public void documentClosed(ApplicationEvent applicationEvent) {
            if (applicationEvent.getDocument() == this.a) {
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            this.a.getApplication().removeApplicationListener(this);
        }
    }

    class LoadLater
    implements Runnable {
        private String a;

        public LoadLater(String string) {
            this.a = string;
        }

        @Override
        public void run() {
            IlvBuilder.this.a.openDocumentFile(this.a, true, true);
        }
    }

    private class BuilderApplication
    extends IlvApplication {
        private boolean a;

        public BuilderApplication(String[] stringArray) {
            super(stringArray);
            this.setProperty(IlvBuilder.ALLOW_STARTUP_WIZARD, Boolean.TRUE);
        }

        @Override
        public IlvDocument openDocumentFile(String string, boolean bl, boolean bl2) {
            if (IlvBuilder.this.i) {
                File file = null;
                File file2 = null;
                try {
                    URL uRL = this.resolveURL(string);
                    if (uRL == null) {
                        file = new File(string);
                        uRL = IlvURLUtil.convertFileToAbsoluteURL(file);
                    } else {
                        file = IlvURLUtil.convertFileURLToFile(uRL);
                    }
                    file2 = file.getParentFile();
                    IlvURLUtil.openStream(uRL).close();
                }
                catch (Exception exception) {
                    this.addResourcePropertyFile("ilog.views.builder.gui.editors");
                    String string2 = this.getString("IlvBuilder.badProjectFile.warning");
                    if (IlvContextualFileChooser.showQuestionDialog(IlvBuilder.this.getFrame(), string2, this.getString("IlvBuilder.badProjectFile.title"))) {
                        String string3 = this.getFormattedString("IlvBuilder.badProjectFile.helpDescription", new String[]{string});
                        URL uRL = IlvContextualFileChooser.requestURL(IlvBuilder.this.getFrame(), file2, file, string3);
                        if (uRL != null) {
                            string = uRL.toString();
                        }
                        return null;
                    }
                    return null;
                }
            }
            this.setProperty(IlvBuilder.ALLOW_STARTUP_WIZARD, Boolean.FALSE);
            return super.openDocumentFile(string, bl, bl2);
        }

        public boolean isHideOnQuit() {
            return this.a;
        }

        public void setHideOnQuit(boolean bl) {
            this.a = bl;
        }

        @Override
        protected void quit() {
            if (this.isHideOnQuit()) {
                IlvBuilder.this.getFrame().setVisible(false);
                IlvBuilder.this.getFrame().dispose();
                IlvBuilder.n(IlvBuilder.this);
            } else {
                super.quit();
            }
        }

        @Override
        public boolean close(boolean bl) {
            if (IlvBuilder.this.h) {
                return super.close(bl);
            }
            if (this.closeAllDocuments(false)) {
                IlvBuilder.this.getFrame().setVisible(false);
                this.sendMessage(null, IlvBuilder.this, IlvBuilder.DESIGNER_CLOSED, new Object[0]);
                return true;
            }
            return false;
        }

        @Override
        public IlvFileChooserSelection[] showFileChooser(String string, String string2, int n, IlvFileDocumentTemplate ilvFileDocumentTemplate, Component component) {
            return IlvBuilder.this.showFileChooser(string, string2, n, ilvFileDocumentTemplate, component);
        }

        private IlvFileChooserSelection[] a(String string, String string2, int n, IlvFileDocumentTemplate ilvFileDocumentTemplate, Component component) {
            return super.showFileChooser(string, string2, n, ilvFileDocumentTemplate, component);
        }
    }
}

