/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.awt;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerLayerVisibilityEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.internal.IlvUtility;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;

public class IlvScrollManagerView
extends Panel {
    private scrollListener a = new scrollListener();
    private IlvManagerView b;
    private Adjustable c;
    private Adjustable d;
    private int e;
    private int f;
    private boolean g = true;
    private boolean h = true;
    private boolean i = false;
    private int j;
    private IlvManager k;
    private boolean l = false;
    private Object m;

    public IlvScrollManagerView() {
        this(new IlvManager(), new IlvTransformer());
    }

    public IlvScrollManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        this(ilvManager, ilvTransformer, null, null);
    }

    public IlvScrollManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer, Adjustable adjustable, Adjustable adjustable2) {
        this.b = this.createManagerView(ilvManager, ilvTransformer);
        this.a(adjustable, adjustable2);
    }

    public IlvScrollManagerView(IlvManagerView ilvManagerView) {
        this(ilvManagerView, null, null);
    }

    public IlvScrollManagerView(IlvManagerView ilvManagerView, Adjustable adjustable, Adjustable adjustable2) {
        this.b = ilvManagerView;
        this.a(adjustable, adjustable2);
    }

    public final int getBorderThickness() {
        return this.j;
    }

    public final void setBorderThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("thickness should be positive");
        }
        this.j = n;
    }

    public final Adjustable getVerticalAdjustable() {
        return this.c;
    }

    public final Adjustable getHorizontalAdjustable() {
        return (Scrollbar)this.d;
    }

    protected IlvManagerView createManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        return new IlvManagerView(ilvManager, ilvTransformer);
    }

    private final void a(Adjustable adjustable, Adjustable adjustable2) {
        this.enableEvents(4L);
        this.setLayout(null);
        this.j = 2;
        this.add(this.b);
        if (adjustable == null) {
            this.c = new Scrollbar(1);
        } else if (adjustable instanceof Component) {
            this.c = adjustable;
        } else {
            throw new IllegalArgumentException("scrollbar must be a Component");
        }
        this.c.setUnitIncrement(10);
        this.add((Component)((Object)this.c));
        if (adjustable2 == null) {
            this.d = new Scrollbar(0);
        } else if (adjustable instanceof Component) {
            this.d = adjustable2;
        } else {
            throw new IllegalArgumentException("scrollbar must be a Component");
        }
        this.d.setUnitIncrement(10);
        this.add((Component)((Object)this.d));
    }

    @Override
    public void update(Graphics graphics) {
        if (!this.isDoubleBuffering() && this.getView().getBackgroundPattern() == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.getForeground());
        }
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.g ? ((Component)((Object)this.c)).getPreferredSize().width : 0;
        int n4 = this.h ? ((Component)((Object)this.d)).getPreferredSize().height : 0;
        if ((n -= n3) <= 0 && (n2 -= n4) <= 0) {
            return;
        }
        int n5 = this.getBorderThickness();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, n, n2);
        }
        if (rectangle.x <= n5 + 1 || rectangle.x + rectangle.width >= n - n5 - 1 || rectangle.y <= n5 + 1 || rectangle.y + rectangle.height >= n2 - n5 - 1) {
            graphics.setColor(this.getBackground());
            if (n > 0 && n2 > 0) {
                for (int i = 0; i < n5; ++i) {
                    graphics.draw3DRect(i, i, n - 2 * i - 1, n2 - 2 * i - 1, false);
                }
            }
        }
        super.paint(graphics);
    }

    @Override
    public void removeNotify() {
        this.l = false;
        this.d.removeAdjustmentListener(this.a);
        this.c.removeAdjustmentListener(this.a);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.d.addAdjustmentListener(this.a);
        this.c.addAdjustmentListener(this.a);
        this.l = true;
        this.adjustScrollbars();
    }

    @Override
    public void doLayout() {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = this.g ? ((Component)((Object)this.c)).getPreferredSize().width : 0;
        int n4 = this.h ? ((Component)((Object)this.d)).getPreferredSize().height : 0;
        int n5 = this.getBorderThickness();
        if (this.b != null) {
            this.b.setBounds(n5, n5, Math.max(0, n2 - n3 - 2 * n5), Math.max(0, n - n4 - 2 * n5));
        }
        if (this.g) {
            ((Component)((Object)this.c)).setBounds(n2 - n3, 0, n3, n - n4);
        }
        if (this.h) {
            ((Component)((Object)this.d)).setBounds(0, n - n4, n2 - n3, n4);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.b != null) {
            int n = this.getBorderThickness();
            Dimension dimension = this.b.getPreferredSize();
            if (this.g) {
                dimension.width += ((Component)((Object)this.c)).getPreferredSize().width;
            }
            if (this.h) {
                dimension.height += ((Component)((Object)this.d)).getPreferredSize().height;
            }
            dimension.height += 2 * n;
            dimension.width += 2 * n;
            return dimension;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.b != null) {
            int n = this.getBorderThickness();
            Dimension dimension = this.b.getMinimumSize();
            if (this.g) {
                dimension.width += ((Component)((Object)this.c)).getMinimumSize().width;
            }
            if (this.h) {
                dimension.height += ((Component)((Object)this.d)).getMinimumSize().height;
            }
            dimension.height += 2 * n;
            dimension.width += 2 * n;
            return dimension;
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.b != null) {
            int n = this.getBorderThickness();
            Dimension dimension = this.b.getMaximumSize();
            if (this.g) {
                dimension.width += ((Component)((Object)this.c)).getMaximumSize().width;
            }
            if (this.h) {
                dimension.height += ((Component)((Object)this.d)).getMaximumSize().height;
            }
            dimension.height += 2 * n;
            dimension.width += 2 * n;
            return dimension;
        }
        return super.getMaximumSize();
    }

    public final IlvManagerView getView() {
        return this.b;
    }

    public void adjustScrollbars() {
        Scrollbar scrollbar;
        if (!this.l) {
            return;
        }
        IlvRect ilvRect = this.getView().computeBBox();
        int n = this.b.getHeight();
        int n2 = this.b.getWidth();
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, n2, n);
        ilvRect.width = (float)Math.floor((double)ilvRect.width + 1.0);
        ilvRect.height = (float)Math.floor((double)ilvRect.height + 1.0);
        ilvRect.x = (float)Math.floor(ilvRect.x);
        ilvRect.y = (float)Math.floor(ilvRect.y);
        ilvRect.add(ilvRect2);
        this.e = -((int)ilvRect.x);
        this.f = -((int)ilvRect.y);
        this.d.removeAdjustmentListener(this.a);
        this.c.removeAdjustmentListener(this.a);
        if (this.c != null && this.g && (this.c.getValue() != this.f || this.c.getVisibleAmount() != n || (float)this.c.getMaximum() != ilvRect.height)) {
            if (this.c instanceof Scrollbar) {
                scrollbar = (Scrollbar)this.c;
                scrollbar.setValues(this.f, Math.max(n, 1), 0, (int)ilvRect.height);
            } else {
                this.c.setMinimum(0);
                this.c.setMaximum((int)ilvRect.height);
                this.c.setVisibleAmount(0);
                this.c.setValue(this.f);
                this.c.setVisibleAmount(Math.max(n, 1));
                this.c.setBlockIncrement(Math.max(n, 1));
            }
        }
        if (this.d != null && this.h && (this.d.getValue() != this.e || this.d.getVisibleAmount() != n2 || (float)this.d.getMaximum() != ilvRect.width)) {
            if (this.d instanceof Scrollbar) {
                scrollbar = (Scrollbar)this.d;
                scrollbar.setValues(this.e, Math.max(n2, 1), 0, (int)ilvRect.width);
            } else {
                this.d.setMinimum(0);
                this.d.setMaximum((int)ilvRect.width);
                this.d.setVisibleAmount(0);
                this.d.setValue(this.e);
                this.d.setVisibleAmount(Math.max(n2, 1));
                this.d.setBlockIncrement(Math.max(n2, 1));
            }
        }
        this.d.addAdjustmentListener(this.a);
        this.c.addAdjustmentListener(this.a);
        if (this.d != null) {
            this.e = this.d.getValue();
        }
        if (this.c != null) {
            this.f = this.c.getValue();
        }
    }

    public void adjustView() {
        if (this.d.getValue() != this.e || this.c.getValue() != this.f) {
            this.getView().removeTransformerListener(this.a);
            this.getView().removeComponentListener(this.a);
            this.getView().translate(this.d != null && this.h ? (float)(-(this.d.getValue() - this.e)) : 0.0f, this.c != null && this.g ? (float)(-(this.c.getValue() - this.f)) : 0.0f, true);
            this.getView().addTransformerListener(this.a);
            this.getView().addComponentListener(this.a);
            float f = ((Component)((Object)this.c)).getHeight();
            float f2 = ((Component)((Object)this.c)).getWidth();
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, f2, f);
            IlvRect ilvRect2 = this.getView().computeBBox();
            ilvRect2.add(ilvRect);
            ilvRect2.width = (float)Math.floor((double)ilvRect2.width + 1.0);
            ilvRect2.height = (float)Math.floor((double)ilvRect2.height + 1.0);
            ilvRect2.x = (float)Math.floor(ilvRect2.x);
            ilvRect2.y = (float)Math.floor(ilvRect2.y);
            this.e = this.d.getValue();
            this.f = this.c.getValue();
        }
    }

    public final boolean isDoubleBuffering() {
        return this.b.isDoubleBuffering();
    }

    public final void setDoubleBuffering(boolean bl) {
        this.b.setDoubleBuffering(bl);
        this.i = bl;
    }

    public boolean isVerticalScrollbarVisible() {
        return this.g;
    }

    public void setVerticalScrollbarVisible(boolean bl) {
        if (bl == this.g) {
            return;
        }
        this.g = bl;
        if (bl) {
            this.adjustScrollbars();
            this.invalidate();
            this.add((Component)((Object)this.c));
            this.validate();
        } else {
            this.remove((Component)((Object)this.c));
            this.invalidate();
            this.validate();
        }
    }

    public boolean isHorizontalScrollbarVisible() {
        return this.h;
    }

    public void setHorizontalScrollbarVisible(boolean bl) {
        if (bl == this.h) {
            return;
        }
        this.h = bl;
        if (bl) {
            this.adjustScrollbars();
            this.invalidate();
            this.add((Component)((Object)this.d));
            this.validate();
        } else {
            this.remove((Component)((Object)this.d));
            this.invalidate();
            this.validate();
        }
    }

    public boolean isWheelScrollingEnabled() {
        return this.m != null;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl) {
            if (this.m == null) {
                this.m = new IlvUtility.MouseWheelAdapter(this);
                this.addMouseWheelListener((MouseWheelListener)this.m);
            }
        } else if (this.m != null) {
            this.removeMouseWheelListener((MouseWheelListener)this.m);
            this.m = null;
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && !GraphicsEnvironment.isHeadless()) {
            this.getView().requestFocus();
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof IlvManagerView) {
            if (this.b != null && this.b.getParent() == this) {
                this.remove(this.b);
                this.b.removeTransformerListener(this.a);
                this.b.removeComponentListener(this.a);
                this.b.removeManagerChangedListener(this.a);
                this.b.getManager().removeManagerContentChangedListener(this.a);
                this.b.getManager().removeManagerLayerListener(this.a);
            }
            this.b = (IlvManagerView)component;
            if (!this.b.isDoubleBuffering() && this.i) {
                this.b.setDoubleBuffering(true);
            }
            this.b.addTransformerListener(this.a);
            this.b.addComponentListener(this.a);
            this.b.addManagerChangedListener(this.a);
            this.b.getManager().addManagerContentChangedListener(this.a);
            this.b.getManager().addManagerLayerListener(this.a);
        }
        super.addImpl(component, object, n);
    }

    private class scrollListener
    extends ComponentAdapter
    implements TransformerListener,
    ManagerContentChangedListener,
    ManagerLayerListener,
    AdjustmentListener,
    Serializable,
    ManagerChangedListener {
        private scrollListener() {
        }

        @Override
        public void managerChanged(ManagerChangedEvent managerChangedEvent) {
            if (managerChangedEvent.getOldValue() != null) {
                managerChangedEvent.getOldValue().removeManagerContentChangedListener(this);
                managerChangedEvent.getOldValue().removeManagerLayerListener(this);
            }
            if (managerChangedEvent.getNewValue() != null) {
                managerChangedEvent.getNewValue().addManagerContentChangedListener(this);
                managerChangedEvent.getNewValue().addManagerLayerListener(this);
            }
            IlvScrollManagerView.this.adjustScrollbars();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            IlvScrollManagerView.this.adjustScrollbars();
        }

        @Override
        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            IlvScrollManagerView.this.adjustScrollbars();
        }

        @Override
        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            if (!managerContentChangedEvent.isAdjusting()) {
                IlvScrollManagerView.this.adjustScrollbars();
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            IlvScrollManagerView.this.adjustView();
        }

        @Override
        public void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
            IlvScrollManagerView.this.adjustScrollbars();
        }

        @Override
        public void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
            IlvScrollManagerView.this.adjustScrollbars();
        }

        @Override
        public void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
        }

        @Override
        public void layerChanged(ManagerLayerEvent managerLayerEvent) {
            if (managerLayerEvent instanceof ManagerLayerVisibilityEvent) {
                IlvScrollManagerView.this.adjustScrollbars();
            }
        }
    }
}

