/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.applications.util.java2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.AbstractButton;

class IlvStrokeButton
extends AbstractButton {
    private Stroke a;
    private static Rectangle b = new Rectangle(0, 0, 64, 12);

    public IlvStrokeButton() {
        this(null);
    }

    public IlvStrokeButton(Stroke stroke) {
        this.setForeground(Color.black);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setStroke(stroke);
    }

    public void setStroke(Stroke stroke) {
        this.a = stroke;
        if (this.a != null) {
            Shape shape = stroke.createStrokedShape(b);
            this.setPreferredSize(new Dimension(64, shape.getBounds().height));
            this.revalidate();
            this.repaint();
        }
    }

    public Stroke getStroke() {
        return this.a;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle = this.getBounds();
        if (this.a != null) {
            graphics2D.setStroke(this.a);
        }
        graphics2D.setColor(this.getForeground());
        Insets insets = this.getInsets();
        if (this.getForeground().equals(Color.white)) {
            graphics2D.setColor(Color.black);
        }
        graphics2D.draw(new Line2D.Float(insets.left, insets.top + rectangle.height / 2 - insets.bottom, rectangle.width - insets.right, insets.top + rectangle.height / 2 - insets.bottom));
        graphics2D.dispose();
    }
}

