/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.event.MessageListener;
import ilog.views.appframe.swing.util.IlvThinBorder;
import ilog.views.appframe.util.IlvProgressMonitor;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.SwingFactories;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.UIResource;

public class IlvStatusBar
extends JPanel
implements MessageListener {
    private HashMap a = new HashMap();
    private HashMap b = new HashMap();
    private ArrayList c = new ArrayList();
    private BorderLayout d = new BorderLayout();
    private JPanel e = new JPanel();
    private JPanel f = new JPanel();
    public static final String DEFAULT_CONFIGURATION = "DefaultConfiguration";
    public static final String PROGRESS_BAR_CONFIGURATION = "ProgressBarConfiguration";
    public static final String STATUS_LISTENER_NAME = "Status";

    public IlvStatusBar() {
        this.f.setLayout(new BorderLayout());
        this.setLayout(this.d);
        this.add((Component)this.f, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(IlvThinBorder.LOWERED_BORDER);
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, "Center");
        this.addConfiguration(DEFAULT_CONFIGURATION, jPanel, new StatusLabelListener("MainStatusMessage", jLabel));
        ProgressTaskPanel progressTaskPanel = new ProgressTaskPanel();
        this.addConfiguration(PROGRESS_BAR_CONFIGURATION, progressTaskPanel, progressTaskPanel);
        this.activateConfiguration(DEFAULT_CONFIGURATION);
    }

    public void addConfiguration(String string, Component component, MessageListener messageListener) {
        this.a.put(string, component);
        this.b.put(string, messageListener);
    }

    public boolean activateConfiguration(String string) {
        int n = this.c.indexOf(string);
        Component component = (Component)this.a.get(string);
        if (component == null) {
            return false;
        }
        if (n != -1) {
            if (n == 0) {
                return true;
            }
            this.c.remove(n);
        }
        this.c.add(0, string);
        this.f.removeAll();
        this.f.add(component, "Center");
        this.a();
        return true;
    }

    public boolean deactivateConfiguration(String string) {
        int n = this.c.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.c.remove(n);
        if (n != 0) {
            return true;
        }
        this.f.removeAll();
        if (this.c.size() == 0) {
            this.a();
            return true;
        }
        string = (String)this.c.get(0);
        Component component = (Component)this.a.get(string);
        this.f.add(component, "Center");
        this.a();
        return true;
    }

    void a() {
        this.f.getLayout().layoutContainer(this.f);
        this.f.invalidate();
        this.f.repaint();
    }

    public JPanel getConfigurationsPanel() {
        return this.f;
    }

    public void setStatusText(String string) {
        this.receiveMessage(new MessageEvent(this, "MainStatusMessage", new Object[]{string}));
    }

    @Override
    public void receiveMessage(final MessageEvent messageEvent) {
        if (messageEvent.getMessageName().equals("StartProgressTask")) {
            if (IlvSwingUtil.isDispatchThread()) {
                this.activateConfiguration(PROGRESS_BAR_CONFIGURATION);
                MessageListener messageListener = (MessageListener)this.b.get(PROGRESS_BAR_CONFIGURATION);
                if (messageListener != null) {
                    messageListener.receiveMessage(messageEvent);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvStatusBar.this.activateConfiguration(IlvStatusBar.PROGRESS_BAR_CONFIGURATION);
                        MessageListener messageListener = (MessageListener)IlvStatusBar.this.b.get(IlvStatusBar.PROGRESS_BAR_CONFIGURATION);
                        if (messageListener != null) {
                            messageListener.receiveMessage(messageEvent);
                        }
                    }
                });
            }
            return;
        }
        if (messageEvent.getMessageName().equals("EndProgressTask")) {
            if (IlvSwingUtil.isDispatchThread()) {
                this.deactivateConfiguration(PROGRESS_BAR_CONFIGURATION);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvStatusBar.this.deactivateConfiguration(IlvStatusBar.PROGRESS_BAR_CONFIGURATION);
                    }
                });
            }
            return;
        }
        if (this.c.size() == 0) {
            return;
        }
        MessageListener messageListener = (MessageListener)this.b.get((String)this.c.get(0));
        if (messageListener != null) {
            messageListener.receiveMessage(messageEvent);
        }
    }

    public void startProgressTask(String string, int n, int n2) {
    }

    static class ThinBorder
    extends BevelBorder {
        public ThinBorder(int n) {
            super(n);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }
    }

    private static class RightToLeftToolBarLayout
    extends FlowLayout
    implements UIResource {
        private RightToLeftToolBarLayout() {
            super(3, 0, 0);
        }
    }

    static class Separator
    extends JSeparator {
        public Separator() {
            super(0);
        }
    }

    static class ProgressTaskPanel
    extends JPanel
    implements MessageListener {
        final JProgressBar a;
        JPanel b = new JPanel();
        JLabel c = new JLabel();
        JPanel d = new JPanel();
        boolean e = true;

        public ProgressTaskPanel() {
            this.setBorder(IlvThinBorder.LOWERED_BORDER);
            this.a = new JProgressBar(0);
            this.a.setBorderPainted(false);
            if (this.getComponentOrientation().isLeftToRight()) {
                this.setLayout(new BoxLayout(this, SwingFactories.getBoxLayoutLineAxis()));
            } else {
                this.setLayout(new RightToLeftToolBarLayout());
            }
            this.d.setLayout(new BorderLayout(0, 0));
            this.d.setBorder(IlvThinBorder.LOWERED_BORDER);
            this.d.add(this.c);
            this.add(this.d);
            this.b.setLayout(new BorderLayout(0, 0));
            this.b.setBorder(IlvThinBorder.LOWERED_BORDER);
            this.b.add((Component)this.a, "Center");
            this.add(this.b);
        }

        @Override
        public void receiveMessage(MessageEvent messageEvent) {
            final Object[] objectArray = messageEvent.getMessageParameters();
            if (messageEvent.getMessageName().equals("NewProgressTaskValueMessage")) {
                if (objectArray != null && objectArray.length > 0) {
                    if (IlvSwingUtil.isDispatchThread()) {
                        this.a.setValue((Integer)objectArray[1]);
                        Dimension dimension = this.getSize();
                        this.paintImmediately(0, 0, dimension.width, dimension.height);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProgressTaskPanel.this.a.setValue((Integer)objectArray[1]);
                            }
                        });
                    }
                }
            } else if (messageEvent.getMessageName().equals("StartProgressTask") && objectArray != null && objectArray.length > 1) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IlvProgressMonitor ilvProgressMonitor = (IlvProgressMonitor)objectArray[0];
                        String string = ilvProgressMonitor.getMessage();
                        if (string != null && string.length() != 0) {
                            ProgressTaskPanel.this.c.setText(string);
                            if (!ProgressTaskPanel.this.e) {
                                ProgressTaskPanel.this.remove(ProgressTaskPanel.this.b);
                                ProgressTaskPanel.this.add(ProgressTaskPanel.this.d);
                                ProgressTaskPanel.this.add(ProgressTaskPanel.this.b);
                                ProgressTaskPanel.this.e = true;
                            }
                        } else if (ProgressTaskPanel.this.e) {
                            ProgressTaskPanel.this.remove(ProgressTaskPanel.this.d);
                            ProgressTaskPanel.this.e = true;
                        }
                        ProgressTaskPanel.this.validate();
                        ProgressTaskPanel.this.a.setMinimum((Integer)objectArray[1]);
                        ProgressTaskPanel.this.a.setMaximum((Integer)objectArray[2]);
                    }
                };
                if (IlvSwingUtil.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }

    static class StatusLabelListener
    implements MessageListener {
        JLabel a;
        String b;

        public StatusLabelListener(String string, JLabel jLabel) {
            this.a = jLabel;
            this.b = string;
        }

        @Override
        public void receiveMessage(MessageEvent messageEvent) {
            Object[] objectArray;
            if (messageEvent.getMessageName().equals(this.b) && (objectArray = messageEvent.getMessageParameters()) != null && objectArray.length > 0) {
                if (messageEvent.getMessageParameters()[0] == null) {
                    this.a.setText(" ");
                } else {
                    String string = messageEvent.getMessageParameters()[0].toString();
                    if (string.length() == 0) {
                        this.a.setText(" ");
                    } else {
                        this.a.setText(string);
                    }
                }
            }
        }
    }
}

