/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.layout;

import ilog.views.appframe.form.layout.Anchor;
import ilog.views.appframe.form.layout.AttachmentConstants;
import ilog.views.appframe.form.layout.IlvAttachment;
import ilog.views.appframe.form.layout.IlvControlAnchor;
import ilog.views.appframe.form.layout.IlvControlNode;
import ilog.views.appframe.form.layout.IlvFormDimension;
import ilog.views.appframe.form.layout.IlvFormInsets;
import ilog.views.appframe.form.layout.IlvFormRect;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IlvFormLayout {
    private List a = new ArrayList(10);
    private boolean b = false;
    private ComponentOrientation c = ComponentOrientation.UNKNOWN;
    private ContainerSizeAttachment d;
    private ContainerSizeAttachment e;
    private Object f;
    private Map g;
    private IlvFormLayout h;
    public static final int DEFAUT_SIZE_MODE = 0;
    public static final int PREFERRED_SIZE_MODE = 1;
    public static final int MINIMUM_SIZE_MODE = 2;
    public static final int MAXIMUM_SIZE_MODE = 4;
    private static Map i;
    private static Map j;
    private static Map k;
    public static final int DEFAULT_BORDER_INSET = 3;
    public static final int DEFAULT_INSET = 3;
    private static final int l = 17;
    private static final int m = 21;
    private static final int n = 27;
    private static final int o = 21;
    private static final int p = 2;
    private static final int q = 10;
    public static final String PARENT_NAME = "${Parent}";

    public void setConstantValue(String string, Number number) {
        if (this.g == null) {
            this.g = new HashMap();
        }
        this.g.put(string, number);
    }

    public Number removeConstantValue(String string) {
        return this.g == null ? (Number)null : (Number)((Number)this.g.remove(string));
    }

    public Number getConstantValue(String string) {
        Number number;
        if (this.g != null && (number = (Number)this.g.get(string)) != null) {
            return number;
        }
        number = (Number)k.get(string);
        if (number != null) {
            return number;
        }
        return this.h == null ? (Number)null : (Number)this.h.getConstantValue(string);
    }

    public void setGroup(Object object) {
        this.f = object;
    }

    public Object getGroup() {
        return this.f;
    }

    protected void initialize(Object object, int n) {
        int n2;
        IlvControlNode ilvControlNode;
        ComponentOrientation componentOrientation = this.getComponentOrientation(object);
        if (!this.b || !componentOrientation.equals(this.c)) {
            IlvControlNode ilvControlNode2;
            this.c = componentOrientation;
            ilvControlNode = this.b(object);
            if (ilvControlNode == null) {
                ilvControlNode = this.a(PARENT_NAME);
                ilvControlNode.setControl(object, true);
            } else {
                ilvControlNode.setControlName(PARENT_NAME);
            }
            if (this.d == null) {
                this.d = new ContainerSizeAttachment(ilvControlNode.getComponentAnchor(AttachmentConstants.WIDTH_ANCHOR));
                this.e = new ContainerSizeAttachment(ilvControlNode.getComponentAnchor(AttachmentConstants.HEIGHT_ANCHOR));
                ilvControlNode.addAttachment(this.d);
                ilvControlNode.addAttachment(this.e);
            }
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                ilvControlNode2 = (IlvControlNode)this.a.get(n2);
                ilvControlNode2.resetDepedencies(this);
            }
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                ilvControlNode2 = (IlvControlNode)this.a.get(n2);
                ilvControlNode2.initializeDepedencies(this);
            }
            this.b = true;
        }
        this.d.setMode(n);
        this.e.setMode(n);
        for (n2 = 0; n2 < this.a.size(); ++n2) {
            ilvControlNode = (IlvControlNode)this.a.get(n2);
            ilvControlNode.initialize(object, n);
        }
    }

    public void layout(Object object) {
        IlvControlNode ilvControlNode;
        int n;
        this.setGroup(object);
        IlvFormRect ilvFormRect = this.getControlBounds(object);
        if (ilvFormRect.width == 0.0f || ilvFormRect.height == 0.0f) {
            return;
        }
        this.initialize(object, 0);
        IlvFormInsets ilvFormInsets = this.getControlInsets(object);
        this.d.setSize(ilvFormRect.width - ilvFormInsets.left - ilvFormInsets.right);
        this.e.setSize(ilvFormRect.height - ilvFormInsets.top - ilvFormInsets.bottom);
        try {
            for (n = 0; n < this.a.size(); ++n) {
                ilvControlNode = (IlvControlNode)this.a.get(n);
                ilvControlNode.applyAttachments(object, this, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (n = 0; n < this.a.size(); ++n) {
            ilvControlNode = (IlvControlNode)this.a.get(n);
            Object object2 = ilvControlNode.getControl();
            if (object2 == null || object2 == object) continue;
            IlvFormRect ilvFormRect2 = ilvControlNode.getBounds();
            ilvFormRect2.x += ilvFormInsets.left;
            ilvFormRect2.y += ilvFormInsets.top;
            this.setControlBounds(object2, ilvFormRect2);
        }
    }

    public IlvFormDimension calculateGroupSize(Object object, int n) {
        Object object2;
        Object object3;
        IlvControlNode ilvControlNode;
        int n2;
        this.setGroup(object);
        this.initialize(object, n);
        try {
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                ilvControlNode = (IlvControlNode)this.a.get(n2);
                ilvControlNode.applyAttachments(object, this, 0);
            }
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                ilvControlNode = (IlvControlNode)this.a.get(n2);
                int n3 = ilvControlNode.getAttachmentCount();
                for (int i = 0; i < n3; ++i) {
                    object3 = ilvControlNode.getAttachment(i);
                    if (!((IlvAttachment)object3).a()) continue;
                    ((IlvAttachment)object3).reverseCalc(object, this, n);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        IlvControlNode ilvControlNode2 = this.b(object);
        IlvFormRect ilvFormRect = ilvControlNode2.getBounds();
        object3 = this.getControlInsets(object);
        float f = 0.0f;
        float f2 = 0.0f;
        for (n2 = 0; n2 < this.a.size(); ++n2) {
            ilvControlNode = (IlvControlNode)this.a.get(n2);
            if (ilvControlNode == ilvControlNode2) continue;
            object2 = ilvControlNode.getBounds();
            ((IlvFormRect)object2).x += ((IlvFormInsets)object3).left;
            ((IlvFormRect)object2).y += ((IlvFormInsets)object3).top;
            if (((IlvFormRect)object2).x < f) {
                f = ((IlvFormRect)object2).x;
            }
            if (((IlvFormRect)object2).y < f2) {
                f2 = ((IlvFormRect)object2).y;
            }
            if (((IlvFormRect)object2).x + ((IlvFormRect)object2).width > ilvFormRect.width) {
                ilvFormRect.width = ((IlvFormRect)object2).x + ((IlvFormRect)object2).width;
            }
            if (!(((IlvFormRect)object2).y + ((IlvFormRect)object2).height > ilvFormRect.height)) continue;
            ilvFormRect.height = ((IlvFormRect)object2).y + ((IlvFormRect)object2).height;
        }
        if (f < 0.0f) {
            ilvFormRect.width -= f;
        }
        if (f2 < 0.0f) {
            ilvFormRect.height -= f2;
        }
        if (n == 1) {
            object2 = this.getControlMinimumSize(object);
            ((IlvFormDimension)object2).width -= ((IlvFormInsets)object3).right;
            ((IlvFormDimension)object2).height -= ((IlvFormInsets)object3).bottom;
            if (object2 != null) {
                if (((IlvFormDimension)object2).width > ilvFormRect.width) {
                    ilvFormRect.width = ((IlvFormDimension)object2).width;
                }
                if (((IlvFormDimension)object2).height > ilvFormRect.height) {
                    ilvFormRect.height = ((IlvFormDimension)object2).height;
                }
            }
            object2 = this.getControlMaximumSize(object);
            ((IlvFormDimension)object2).width -= ((IlvFormInsets)object3).right;
            ((IlvFormDimension)object2).height -= ((IlvFormInsets)object3).bottom;
            if (object2 != null) {
                if (ilvFormRect.width > ((IlvFormDimension)object2).width) {
                    ilvFormRect.width = ((IlvFormDimension)object2).width;
                }
                if (ilvFormRect.height > ((IlvFormDimension)object2).height) {
                    ilvFormRect.height = ((IlvFormDimension)object2).height;
                }
            }
        }
        ilvFormRect.width += ((IlvFormInsets)object3).right;
        ilvFormRect.height += ((IlvFormInsets)object3).bottom;
        ilvControlNode2.setBounds(ilvFormRect);
        return ilvFormRect.getSize();
    }

    public void addAttachment(IlvAttachment ilvAttachment) {
        IlvControlAnchor ilvControlAnchor = ilvAttachment.getAttachedAnchor();
        if (ilvControlAnchor == null) {
            return;
        }
        ilvControlAnchor.a().addAttachment(ilvAttachment);
    }

    public void addAttachment(IlvControlAnchor ilvControlAnchor, IlvControlAnchor ilvControlAnchor2, Function function) {
        this.addAttachment(new IlvAttachment(ilvControlAnchor, ilvControlAnchor2, function));
    }

    public IlvControlAnchor getControlAnchor(Object object, String string) {
        IlvControlNode ilvControlNode = this.a(object);
        Anchor anchor = (Anchor)i.get(string);
        if (anchor == null) {
            throw new RuntimeException("Unknown anchor " + string);
        }
        return ilvControlNode.getComponentAnchor(anchor);
    }

    public IlvControlAnchor getControlAnchor(String string, String string2) {
        IlvControlNode ilvControlNode = this.a(string);
        Anchor anchor = (Anchor)i.get(string2);
        if (anchor == null) {
            throw new RuntimeException("Unknown anchor " + string2);
        }
        return ilvControlNode.getComponentAnchor(anchor);
    }

    public IlvControlAnchor getControlAnchor(String string, Anchor anchor) {
        IlvControlNode ilvControlNode = this.a(string);
        if (anchor == null) {
            throw new RuntimeException("Unknown anchor " + anchor.toString());
        }
        return ilvControlNode.getComponentAnchor(anchor);
    }

    public IlvControlAnchor leftOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.LEFT_ANCHOR);
    }

    public IlvControlAnchor leadingOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.LEADING_ANCHOR);
    }

    public IlvControlAnchor rightOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.RIGHT_ANCHOR);
    }

    public IlvControlAnchor trailingOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.TRAILING_ANCHOR);
    }

    public IlvControlAnchor topOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.TOP_ANCHOR);
    }

    public IlvControlAnchor bottomOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.BOTTOM_ANCHOR);
    }

    public IlvControlAnchor widthOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.WIDTH_ANCHOR);
    }

    public IlvControlAnchor heightOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.HEIGHT_ANCHOR);
    }

    public IlvControlAnchor extensibleRightOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.EXTENSIBLE_RIGHT_ANCHOR);
    }

    public IlvControlAnchor extensibleTrailingOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.EXTENSIBLE_TRAILING_ANCHOR);
    }

    public IlvControlAnchor extensibleBottomOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.EXTENSIBLE_BOTTOM_ANCHOR);
    }

    public IlvControlAnchor preferredHeightOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.PREFERRED_HEIGHT_ANCHOR);
    }

    public IlvControlAnchor preferredWidthOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.PREFERRED_WIDTH_ANCHOR);
    }

    public IlvControlAnchor verticalCenterOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.VERTICAL_CENTER_ANCHOR);
    }

    public IlvControlAnchor horizontalCenterOf(Object object) {
        IlvControlNode ilvControlNode = this.a(object);
        return ilvControlNode.getComponentAnchor(AttachmentConstants.HORIZONTAL_CENTER_ANCHOR);
    }

    IlvControlNode[] a() {
        if (this.a == null || this.a.size() == 0) {
            return new IlvControlNode[0];
        }
        IlvControlNode[] ilvControlNodeArray = new IlvControlNode[this.a.size()];
        for (int i = 0; i < this.a.size(); ++i) {
            ilvControlNodeArray[i] = (IlvControlNode)this.a.get(i);
        }
        return ilvControlNodeArray;
    }

    public ComponentOrientation getComponentOrientation() {
        return this.c;
    }

    private IlvControlNode b(String string) {
        for (int i = 0; i < this.a.size(); ++i) {
            IlvControlNode ilvControlNode = (IlvControlNode)this.a.get(i);
            String string2 = ilvControlNode.getControlName();
            if (string2 == null || !string2.equals(string)) continue;
            return ilvControlNode;
        }
        return null;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.a.size(); ++i) {
            IlvControlNode ilvControlNode = (IlvControlNode)this.a.get(i);
            string = string + (i != 0 ? "\n" : "") + ilvControlNode.toString();
        }
        return string;
    }

    public void setParentLayout(IlvFormLayout ilvFormLayout) {
        this.h = ilvFormLayout;
    }

    public IlvFormLayout getParentLayout() {
        return this.h;
    }

    public static Anchor GetAnchor(String string) {
        return (Anchor)i.get(string);
    }

    public static Collection GetAnchors() {
        return i.values();
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (this.c.equals(componentOrientation)) {
            return;
        }
        this.c = componentOrientation;
        for (int i = 0; i < this.a.size(); ++i) {
            IlvControlNode ilvControlNode = (IlvControlNode)this.a.get(i);
            ilvControlNode.setComponentOrientation(componentOrientation);
        }
        this.b = false;
        this.doControlLayout(this.f);
    }

    public static Function CreateFunction(String string, float f) {
        FunctionFactory functionFactory = (FunctionFactory)j.get(string);
        return functionFactory == null ? null : functionFactory.create(f);
    }

    public static void RegisterFunctionFactory(String string, FunctionFactory functionFactory) {
        j.put(string, functionFactory);
    }

    IlvControlNode a(Object object) {
        IlvControlNode ilvControlNode = this.b(object);
        if (ilvControlNode != null) {
            return ilvControlNode;
        }
        ilvControlNode = new IlvControlNode(this, object, this.getControlName(object), object == this.f);
        this.a.add(ilvControlNode);
        return ilvControlNode;
    }

    IlvControlNode a(String string) {
        IlvControlNode ilvControlNode = this.b(string);
        if (ilvControlNode != null) {
            return ilvControlNode;
        }
        ilvControlNode = new IlvControlNode(this, null, string, PARENT_NAME.equals(string));
        this.a.add(ilvControlNode);
        return ilvControlNode;
    }

    IlvControlNode b(Object object) {
        for (int i = 0; i < this.a.size(); ++i) {
            IlvControlNode ilvControlNode = (IlvControlNode)this.a.get(i);
            if (ilvControlNode.getControl() != object) continue;
            return ilvControlNode;
        }
        String string = this.getControlName(object);
        if (string == null || string.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            IlvControlNode ilvControlNode = (IlvControlNode)this.a.get(i);
            if (!string.equals(ilvControlNode.getControlName())) continue;
            ilvControlNode.setControl(object, this.f == object);
            return ilvControlNode;
        }
        return null;
    }

    protected abstract Object findControl(Object var1, String var2);

    protected abstract void doControlLayout(Object var1);

    protected abstract String getControlName(Object var1);

    protected abstract IlvFormRect getControlBounds(Object var1);

    protected abstract void setControlBounds(Object var1, IlvFormRect var2);

    protected abstract IlvFormDimension getControlSize(Object var1);

    protected abstract IlvFormDimension getControlPreferredSize(Object var1);

    protected abstract IlvFormDimension getControlMinimumSize(Object var1);

    protected abstract IlvFormDimension getControlMaximumSize(Object var1);

    protected abstract IlvFormInsets getControlInsets(Object var1);

    protected abstract ComponentOrientation getComponentOrientation(Object var1);

    static {
        k = new HashMap(7);
        k.put("Inset", new Float(3.0f));
        k.put("BorderInset", new Float(3.0f));
        k.put("LabelHeight", new Float(17.0f));
        k.put("ComboHeight", new Float(21.0f));
        k.put("ButtonHeight", new Float(27.0f));
        k.put("TextFieldHeight", new Float(21.0f));
        k.put("LabelToComponentVGap", new Float(2.0f));
        k.put("VComponentSpace", new Float(13.0f));
        k.put("LabelToComponentHGap", new Float(10.0f));
        j = new HashMap(10);
        j.put("Identity", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new IdentityFunction();
            }
        });
        j.put("Constant", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new ConstantFunction(f);
            }
        });
        j.put("Sum", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new SumFunction(f);
            }
        });
        j.put("Mul", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new MulFunction(f);
            }
        });
        j.put("Div", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new DivFunction(f);
            }
        });
        j.put("Percentage", new FunctionFactory(){

            @Override
            public Function create(float f) {
                return new PercentageFunction(f);
            }
        });
        i = new HashMap(12);
        i.put("left", AttachmentConstants.LEFT_ANCHOR);
        i.put("leading", AttachmentConstants.LEADING_ANCHOR);
        i.put("trailing", AttachmentConstants.TRAILING_ANCHOR);
        i.put("top", AttachmentConstants.TOP_ANCHOR);
        i.put("width", AttachmentConstants.WIDTH_ANCHOR);
        i.put("height", AttachmentConstants.HEIGHT_ANCHOR);
        i.put("right", AttachmentConstants.RIGHT_ANCHOR);
        i.put("extensibleRight", AttachmentConstants.EXTENSIBLE_RIGHT_ANCHOR);
        i.put("extensibleTrailing", AttachmentConstants.EXTENSIBLE_TRAILING_ANCHOR);
        i.put("bottom", AttachmentConstants.BOTTOM_ANCHOR);
        i.put("extensibleBottom", AttachmentConstants.EXTENSIBLE_BOTTOM_ANCHOR);
        i.put("preferredHeight", AttachmentConstants.PREFERRED_HEIGHT_ANCHOR);
        i.put("preferredWidth", AttachmentConstants.PREFERRED_WIDTH_ANCHOR);
        i.put("verticalCenter", AttachmentConstants.VERTICAL_CENTER_ANCHOR);
        i.put("horizontalCenter", AttachmentConstants.HORIZONTAL_CENTER_ANCHOR);
    }

    private static class ContainerSizeAttachment
    extends IlvAttachment {
        private int a;

        public ContainerSizeAttachment(IlvControlAnchor ilvControlAnchor) {
            super(ilvControlAnchor, null, new ContainerSizeFunction());
        }

        public void setMode(int n) {
            this.a = n;
            ((ContainerSizeFunction)this.getFunction()).setMode(n);
        }

        public void setSize(float f) {
            ((ContainerSizeFunction)this.getFunction()).setConstant(f);
        }

        @Override
        boolean a() {
            return this.a != 0;
        }

        private static class ContainerSizeFunction
        extends ConstantFunction {
            private int a;

            public ContainerSizeFunction() {
                super(0.0f);
            }

            @Override
            public float calcValue(float f, float f2) {
                if (this.a == 0) {
                    return this.getConstant();
                }
                if (this.a == 4) {
                    return f2 > f ? f2 : f;
                }
                return f2 < f ? f2 : f;
            }

            @Override
            public float calcInverseValue(float f, float f2) {
                return this.getConstant();
            }

            @Override
            public String getDescription(String string, String string2) {
                return string;
            }

            public void setMode(int n) {
                this.a = n;
            }
        }
    }

    public static class PercentageFunction
    implements Function {
        protected float percentage;

        public PercentageFunction(float f) {
            this.percentage = f / 100.0f;
        }

        @Override
        public float calcValue(float f, float f2) {
            return f2 * this.percentage;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return f2 / this.percentage;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
        }

        @Override
        public String getDescription(String string, String string2) {
            if (this.percentage == 1.0f) {
                return string + " equals " + string2;
            }
            return string + " is " + this.percentage * 100.0f + " percent of " + string2;
        }
    }

    public static class DivFunction
    implements Function {
        protected float divisor;

        public DivFunction(float f) {
            this.divisor = f;
        }

        @Override
        public float calcValue(float f, float f2) {
            return f2 / this.divisor;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return f2 * this.divisor;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
        }

        @Override
        public String getDescription(String string, String string2) {
            if (this.divisor == 1.0f) {
                return string + " equals " + string2;
            }
            return string + " is " + this.divisor + " times less than the " + string2;
        }
    }

    public static class MulFunction
    implements Function {
        protected float factor;

        public MulFunction(float f) {
            this.factor = f;
        }

        @Override
        public float calcValue(float f, float f2) {
            return this.factor * f2;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return f2 / this.factor;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
        }

        @Override
        public String getDescription(String string, String string2) {
            if (this.factor == 1.0f) {
                return string + " equals " + string2;
            }
            return string + " is " + this.factor + " times the " + string2;
        }
    }

    public static class SumFunction
    implements Function {
        private float a;
        private float b;

        public SumFunction(float f) {
            this.a = this.b = f;
        }

        @Override
        public float calcValue(float f, float f2) {
            return this.b + f2;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return f2 - this.b;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
            this.b = componentOrientation.isLeftToRight() ? this.a : -this.a;
        }

        public float getSumParameter() {
            return this.b;
        }

        public String toString() {
            return "Sum [" + this.b + "]";
        }

        @Override
        public String getDescription(String string, String string2) {
            return string + " is at " + this.b + " from " + string2;
        }
    }

    public static class ConstantFunction
    implements Function {
        private float a;

        public ConstantFunction(float f) {
            this.a = f;
        }

        @Override
        public float calcValue(float f, float f2) {
            return this.a;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return this.a;
        }

        public float getConstant() {
            return this.a;
        }

        public void setConstant(float f) {
            this.a = f;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
        }

        public String toString() {
            return "equals " + this.a;
        }

        @Override
        public String getDescription(String string, String string2) {
            return string + " equals " + this.a;
        }
    }

    public static class IdentityFunction
    implements Function {
        @Override
        public float calcValue(float f, float f2) {
            return f2;
        }

        @Override
        public float calcInverseValue(float f, float f2) {
            return f2;
        }

        @Override
        public void setComponentOrientation(ComponentOrientation componentOrientation) {
        }

        @Override
        public String getDescription(String string, String string2) {
            return string + " is same than " + string2;
        }
    }

    public static interface FunctionFactory {
        public Function create(float var1);
    }

    public static interface Function {
        public float calcValue(float var1, float var2);

        public float calcInverseValue(float var1, float var2);

        public void setComponentOrientation(ComponentOrientation var1);

        public String getDescription(String var1, String var2);
    }
}

