/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.layout;

import ilog.views.appframe.form.layout.Anchor;
import ilog.views.appframe.form.layout.IlvControlNode;
import java.awt.ComponentOrientation;

public interface AttachmentConstants {
    public static final Anchor LEFT_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getX();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setX(f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Left";
        }
    };
    public static final Anchor TOP_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getY();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setY(f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Top";
        }
    };
    public static final Anchor WIDTH_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getWidth();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setWidth(f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Width";
        }
    };
    public static final Anchor HEIGHT_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getHeight();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setHeight(f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Height";
        }
    };
    public static final Anchor RIGHT_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getX()) + ilvControlNode.getWidth();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setX(f - ilvControlNode.getWidth());
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Right";
        }
    };
    public static final Anchor EXTENSIBLE_RIGHT_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getX()) + ilvControlNode.getWidth();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setWidth(f - ilvControlNode.getX());
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return RIGHT_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "ExtensibleRight";
        }
    };
    public static final Anchor BOTTOM_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{TOP_ANCHOR, HEIGHT_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getY()) + ilvControlNode.getHeight();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setY(f - ilvControlNode.getHeight());
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return HEIGHT_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "Bottom";
        }
    };
    public static final Anchor EXTENSIBLE_BOTTOM_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{TOP_ANCHOR, HEIGHT_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getY()) + ilvControlNode.getHeight();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setHeight(f - ilvControlNode.getY());
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return HEIGHT_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "ExtensibleBottom";
        }
    };
    public static final Anchor PREFERRED_HEIGHT_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getPreferredHeight();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            System.err.println("Can not change preferred size of a component");
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "PreferredHeight";
        }
    };
    public static final Anchor PREFERRED_WIDTH_ANCHOR = new Anchor(){

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getPreferredWidth();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            System.err.println("Can not change preferred size of a component");
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "PreferredWidth";
        }
    };
    public static final Anchor VERTICAL_CENTER_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{TOP_ANCHOR, HEIGHT_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getY() + ilvControlNode.getHeight() / 2.0f;
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setY(f - ilvControlNode.getHeight() / 2.0f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "VerticalCenter";
        }
    };
    public static final Anchor HORIZONTAL_CENTER_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.getX() + ilvControlNode.getWidth() / 2.0f;
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            ilvControlNode.setX(f - ilvControlNode.getWidth() / 2.0f);
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return null;
        }

        @Override
        public boolean isBIDISensitive() {
            return false;
        }

        public String toString() {
            return "HorizontalCenter";
        }
    };
    public static final Anchor LEADING_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getX()) + (ilvControlNode.isLeftToRight() ? 0.0f : ilvControlNode.getWidth());
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            if (ilvControlNode.isLeftToRight()) {
                ilvControlNode.setX(f);
            } else {
                ilvControlNode.setX(f - ilvControlNode.getWidth());
            }
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return componentOrientation.isLeftToRight() ? null : this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return LEADING_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return true;
        }

        public String toString() {
            return "Leading";
        }
    };
    public static final Anchor TRAILING_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return (ilvControlNode.isParentContainer() ? 0.0f : ilvControlNode.getX()) + (ilvControlNode.isLeftToRight() ? ilvControlNode.getWidth() : 0.0f);
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            if (ilvControlNode.isLeftToRight()) {
                ilvControlNode.setX(f - ilvControlNode.getWidth());
            } else {
                ilvControlNode.setX(f);
            }
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return componentOrientation.isLeftToRight() ? this.a : null;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return TRAILING_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return true;
        }

        public String toString() {
            return "Trailing";
        }
    };
    public static final Anchor EXTENSIBLE_TRAILING_ANCHOR = new Anchor(){
        private Anchor[] a = new Anchor[]{LEFT_ANCHOR, WIDTH_ANCHOR};

        @Override
        public float getValue(IlvControlNode ilvControlNode) {
            return ilvControlNode.isLeftToRight() ? ilvControlNode.getX() + ilvControlNode.getWidth() : ilvControlNode.getX();
        }

        @Override
        public void setValue(IlvControlNode ilvControlNode, float f) {
            if (ilvControlNode.isLeftToRight()) {
                ilvControlNode.setWidth(f - ilvControlNode.getX());
            } else {
                float f2 = ilvControlNode.getX() + ilvControlNode.getWidth();
                ilvControlNode.setX(f);
                ilvControlNode.setWidth(f2 - f);
            }
        }

        @Override
        public Anchor[] getComposedAnchors(ComponentOrientation componentOrientation) {
            return this.a;
        }

        @Override
        public Anchor getDefaultReferenceAnchor(ComponentOrientation componentOrientation) {
            return TRAILING_ANCHOR;
        }

        @Override
        public boolean isBIDISensitive() {
            return true;
        }

        public String toString() {
            return "ExtensibleTrailing";
        }
    };
}

