/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.technology;

import java.util.Collection;
import java.util.Collections;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;

class LibrariesProjectChangeListener
extends ProjectChangeListener {
    LibrariesProjectChangeListener() {
    }

    public void projectPropertiesChanged(ProjectChangeEvent e) {
        ChangeInfo[] changeInfos = e.getChangeDetails();
        Project project = e.getProject();
        for (ChangeInfo changeInfo : changeInfos) {
            if (changeInfo.getChangeType() != 1) continue;
            HashStructure newHash = changeInfo.getNewValueAsHashStructure();
            if (newHash != null) {
                this.addLibrary(project, newHash);
                continue;
            }
            ListStructure list = changeInfo.getNewValueAsListStructure();
            if (list == null) continue;
            for (Object obj : list) {
                if (!(obj instanceof HashStructure)) continue;
                this.addLibrary(project, (HashStructure)obj);
            }
        }
    }

    private void addLibrary(Project project, HashStructure newHash) {
        JLibrary library;
        String libraryName = newHash.getString("id");
        if (libraryName != null && (library = JLibraryManager.findLibrary((Object)libraryName)) instanceof ExtensionLibrary && ((ExtensionLibrary)library).getForceExtensionInitialization()) {
            String extensionId = ((ExtensionLibrary)library).getProviderExtensionId();
            Collection techIds = TechnologyRegistry.getInstance().getTechnologiesOfGroupByMemberExtension(Collections.singleton(extensionId));
            if (!techIds.isEmpty()) {
                TechnologyScopeConfiguration.getInstance((PropertyStorage)project).updateTechnologyScope(techIds.toArray(new String[techIds.size()]));
            }
        }
    }
}

