/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.technology;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileTable;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.jdevimpl.technology.FileChangeListenerImpl;

public class ChangedURLsCallable
implements Callable<Collection<URL>> {
    private static String NAMESPACE = "oracle.ide.techScopeTracker";
    private final Storage m_storage;
    private final String m_key;
    private final FileTable m_table;
    private final Boolean m_requeryAll;
    private final Logger LOG;
    private static Collection<URL> COULD_NOT_DETERMINE_CHANGES = Collections.unmodifiableCollection(new ArrayList());

    public ChangedURLsCallable(Storage storage, String key, FileTable table, Logger log, boolean requeryAll) {
        this.m_storage = storage;
        this.m_key = key;
        this.m_table = table;
        this.m_requeryAll = requeryAll;
        this.LOG = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<URL> call() throws InterruptedException {
        Collection<URL> changedURLs = COULD_NOT_DETERMINE_CHANGES;
        NameSpace nameSpace = this.m_storage.getNameSpace(NAMESPACE);
        if (nameSpace.checkRecord(this.m_key) && !this.m_requeryAll.booleanValue()) {
            byte[] storagedBytes = nameSpace.getRecord(this.m_key);
            int version = 0;
            long cookie = -1L;
            try {
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(storagedBytes));){
                    version = ois.readInt();
                    cookie = ois.readLong();
                }
                FileChangeListenerImpl impl = new FileChangeListenerImpl();
                this.m_table.getChangesSince(version, cookie, (FileChangeListener)impl);
                changedURLs = impl.getChanges();
                if (changedURLs.size() <= 0) return changedURLs;
                this.writeOutFileTableChanges(impl.getVersion(), impl.getCookie(), nameSpace);
                return changedURLs;
            }
            catch (FileChangesExpiredException fileChangeException) {
                try {
                    return this.getAllURLs(nameSpace);
                }
                catch (FileChangesExpiredException e) {
                    this.LOG.log(Level.SEVERE, FileChangesExpiredException.class.getSimpleName() + " should never be thrown if we queried file changes with FIRST_VERSION and still failed " + this.m_key + ". But it was.", e);
                    return changedURLs;
                }
                catch (Exception e) {
                    this.LOG.log(Level.SEVERE, "Exception thrown while trying to query project changes for key " + this.m_key, e);
                }
                return changedURLs;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                this.LOG.log(Level.SEVERE, "Exception thrown while trying to query project changes for key " + this.m_key, e);
                return changedURLs;
            }
        }
        try {
            return this.getAllURLs(nameSpace);
        }
        catch (FileChangesExpiredException e) {
            this.LOG.log(Level.SEVERE, FileChangesExpiredException.class.getSimpleName() + " should never be thrown if we queried file changes with FIRST_VERSION and still failed " + this.m_key + ". But it was.", e);
            return changedURLs;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Exception thrown while trying to query project changes for key " + this.m_key, e);
        }
        return changedURLs;
    }

    private Collection<URL> getAllURLs(NameSpace nameSpace) throws InterruptedException, FileChangesExpiredException, IOException {
        HashSet<URL> all = new HashSet<URL>();
        FileChangeListenerImpl impl = new FileChangeListenerImpl();
        this.m_table.getChangesSince(0, -1L, (FileChangeListener)impl);
        if (!impl.getChanges().isEmpty()) {
            all.addAll(impl.getChanges());
            this.writeOutFileTableChanges(impl.getVersion(), impl.getCookie(), nameSpace);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutFileTableChanges(int version, long cookie, NameSpace nameSpace) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeInt(version);
                oos.writeLong(cookie);
                oos.flush();
                byte[] bytes = bos.toByteArray();
                nameSpace.putRecord(this.m_key, bytes);
                nameSpace.flush();
            }
        }
        catch (IOException e) {
            this.LOG.log(Level.SEVERE, "Failed while marshalling a record for " + nameSpace, e);
        }
    }
}

