/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.util.Assert;
import oracle.jdeveloper.model.JDevTechnologyInfo;

public class JDevTechnologyRegistry {
    private final TechnologyRegistry techRegistry_;
    private static JDevTechnologyRegistry defaultInstance_ = null;
    private Map<String, JDevTechnologyInfo> jdevTechnologies_ = new HashMap<String, JDevTechnologyInfo>();

    private JDevTechnologyRegistry(TechnologyRegistry registry) {
        this.techRegistry_ = registry;
    }

    public static synchronized JDevTechnologyRegistry getInstance(TechnologyRegistry registry) {
        return new JDevTechnologyRegistry(registry);
    }

    public static synchronized JDevTechnologyRegistry getInstance() {
        if (defaultInstance_ == null) {
            defaultInstance_ = JDevTechnologyRegistry.getInstance(TechnologyRegistry.getInstance());
        }
        return defaultInstance_;
    }

    public void registerTechnologyInfo(JDevTechnologyInfo jdevTechInfo) {
        Assert.precondition((jdevTechInfo.getTechId() != null ? 1 : 0) != 0);
        String key = jdevTechInfo.getTechId().getKey();
        Assert.check((key != null ? 1 : 0) != 0);
        this.jdevTechnologies_.put(key, jdevTechInfo);
    }

    public void registerPseudoTechnology(String key, PseudoTechnologyCallback callback) {
        this.techRegistry_.registerPseudoTechnology(key, callback);
    }

    public void unregisterTechnology(String key) {
        this.techRegistry_.unregisterTechnology(key);
        this.jdevTechnologies_.remove(key);
    }

    public JDevTechnologyInfo getJDevTechnologyInfo(String key) {
        return this.jdevTechnologies_.get(key);
    }

    public JDevTechnologyInfo getJDevTechnologyInfo(TechId id) {
        return this.getJDevTechnologyInfo(id.getKey());
    }
}

