/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;

public class TimeAxis
extends JPanel
implements HelpContext,
ItemListener {
    protected HelpProvider m_helpProvider = null;
    protected String m_strHelpContextID = null;
    protected Graph m_graph;
    protected JComboBox m_yearComboBox;
    protected JComboBox m_monthComboBox;
    protected JComboBox m_dayComboBox;
    protected JComboBox m_timeComboBox;
    private ResourceBundle rBundle;
    private boolean m_bYearFormatChanged = false;
    private boolean m_bMonthFormatChanged = false;
    private boolean m_bDayFormatChanged = false;
    private boolean m_bTimeFormatChanged = false;

    public TimeAxis(Graph graph) {
        this.m_graph = graph;
        this.constructPanel();
        this._init();
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this._init();
    }

    @Override
    public String getHelpContextID() {
        if (this.m_strHelpContextID == null) {
            return this.getClass().getName();
        }
        return this.m_strHelpContextID;
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_yearComboBox) {
            this.m_bYearFormatChanged = true;
        } else if (e.getSource() == this.m_monthComboBox) {
            this.m_bMonthFormatChanged = true;
        } else if (e.getSource() == this.m_dayComboBox) {
            this.m_bDayFormatChanged = true;
        } else if (e.getSource() == this.m_timeComboBox) {
            this.m_bTimeFormatChanged = true;
        }
    }

    public void apply() {
        int index;
        if (this.m_bYearFormatChanged) {
            index = this.m_yearComboBox.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(0, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(0, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(0, "YYYY");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(0, "Y,YYY");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(0, "YY");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(0, "'YY");
                }
            }
        }
        if (this.m_bMonthFormatChanged) {
            index = this.m_monthComboBox.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(1, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(1, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(1, "Month");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(1, "Mon");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(1, "M");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(1, "MM");
                }
            }
        }
        if (this.m_bDayFormatChanged) {
            index = this.m_dayComboBox.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(2, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(2, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(2, "DD");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(2, "Day");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(2, "Dy");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(2, "DS");
                    break;
                }
                case 6: {
                    this.m_graph.setTimeAxisDateFormat(2, "D");
                }
            }
        }
        if (this.m_bTimeFormatChanged) {
            index = this.m_timeComboBox.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(3, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(3, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH:MI");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24:MI");
                    break;
                }
                case 6: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH:MI:SS");
                    break;
                }
                case 7: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24:MI:SS");
                }
            }
        }
    }

    public void cleanUp() {
    }

    private void constructPanel() {
        this.removeAll();
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String translatedText = this.rBundle.getString("TimeAxisLabel");
        MultiLineLabel label = new MultiLineLabel();
        label.setTextWrapper(WordWrapper.getTextWrapper());
        label.setText(StringUtils.stripMnemonic((String)translatedText));
        label.setAlignmentX(0.0f);
        this.add((Component)label);
        this.add(Box.createVerticalStrut(10));
        translatedText = this.rBundle.getString("TimeAxisYear");
        JLabel yearLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        yearLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        yearLabel.setAlignmentX(0.0f);
        int maxWidth = yearLabel.getPreferredSize().width;
        translatedText = this.rBundle.getString("TimeAxisMonth");
        JLabel monthLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        monthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        monthLabel.setAlignmentX(0.0f);
        if (monthLabel.getPreferredSize().width > maxWidth) {
            maxWidth = monthLabel.getPreferredSize().width;
        }
        translatedText = this.rBundle.getString("TimeAxisDay");
        JLabel dayLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        dayLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        dayLabel.setAlignmentX(0.0f);
        if (dayLabel.getPreferredSize().width > maxWidth) {
            maxWidth = dayLabel.getPreferredSize().width;
        }
        translatedText = this.rBundle.getString("TimeAxisHour");
        JLabel timeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        timeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        timeLabel.setAlignmentX(0.0f);
        if (timeLabel.getPreferredSize().width > maxWidth) {
            maxWidth = timeLabel.getPreferredSize().width;
        }
        JPanel yearPanel = new JPanel();
        yearPanel.setLayout(new BoxLayout(yearPanel, 0));
        yearLabel.setPreferredSize(new Dimension(maxWidth, yearLabel.getPreferredSize().height));
        yearLabel.setMaximumSize(yearLabel.getPreferredSize());
        yearLabel.setMinimumSize(yearLabel.getPreferredSize());
        yearPanel.add(Box.createHorizontalStrut(6));
        yearPanel.add(yearLabel);
        yearPanel.setAlignmentX(0.0f);
        String[] yearItems = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("YearLong"), this.rBundle.getString("YearLongComma"), this.rBundle.getString("YearShort"), this.rBundle.getString("YearShortApostrophe")};
        this.m_yearComboBox = new JComboBox<String>(yearItems);
        yearLabel.setLabelFor(this.m_yearComboBox);
        yearPanel.add(Box.createHorizontalStrut(6));
        yearPanel.add(this.m_yearComboBox);
        JPanel monthPanel = new JPanel();
        monthPanel.setLayout(new BoxLayout(monthPanel, 0));
        monthLabel.setPreferredSize(new Dimension(maxWidth, monthLabel.getPreferredSize().height));
        monthLabel.setMaximumSize(monthLabel.getPreferredSize());
        monthLabel.setMinimumSize(monthLabel.getPreferredSize());
        monthPanel.add(Box.createHorizontalStrut(6));
        monthPanel.add(monthLabel);
        monthPanel.setAlignmentX(0.0f);
        String[] monthItems = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("MonthLong"), this.rBundle.getString("MonthShort"), this.rBundle.getString("MonthSingleLetter"), this.rBundle.getString("MonthNumber")};
        this.m_monthComboBox = new JComboBox<String>(monthItems);
        monthLabel.setLabelFor(this.m_monthComboBox);
        monthPanel.add(Box.createHorizontalStrut(6));
        monthPanel.add(this.m_monthComboBox);
        JPanel dayPanel = new JPanel();
        dayPanel.setLayout(new BoxLayout(dayPanel, 0));
        dayLabel.setPreferredSize(new Dimension(maxWidth, dayLabel.getPreferredSize().height));
        dayLabel.setMaximumSize(dayLabel.getPreferredSize());
        dayLabel.setMinimumSize(dayLabel.getPreferredSize());
        dayPanel.add(Box.createHorizontalStrut(6));
        dayPanel.add(dayLabel);
        dayPanel.setAlignmentX(0.0f);
        String[] dayItems = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("DayMonth"), this.rBundle.getString("DayWeek"), this.rBundle.getString("DayWeekAbbr"), this.rBundle.getString("DaySingleLetter"), this.rBundle.getString("DayWeekNumber")};
        this.m_dayComboBox = new JComboBox<String>(dayItems);
        dayLabel.setLabelFor(this.m_dayComboBox);
        dayPanel.add(Box.createHorizontalStrut(6));
        dayPanel.add(this.m_dayComboBox);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new BoxLayout(timePanel, 0));
        timeLabel.setPreferredSize(new Dimension(maxWidth, timeLabel.getPreferredSize().height));
        timeLabel.setMaximumSize(timeLabel.getPreferredSize());
        timeLabel.setMinimumSize(timeLabel.getPreferredSize());
        timePanel.add(Box.createHorizontalStrut(6));
        timePanel.add(timeLabel);
        timePanel.setAlignmentX(0.0f);
        String[] timeItems = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("Hour"), this.rBundle.getString("Hour24"), this.rBundle.getString("HourMinute"), this.rBundle.getString("Hour24Minute"), this.rBundle.getString("HourMinuteSec"), this.rBundle.getString("Hour24MinuteSec")};
        this.m_timeComboBox = new JComboBox<String>(timeItems);
        timeLabel.setLabelFor(this.m_timeComboBox);
        timePanel.add(Box.createHorizontalStrut(6));
        timePanel.add(this.m_timeComboBox);
        this.add(yearPanel);
        maxWidth = yearPanel.getPreferredSize().width;
        this.add(Box.createVerticalStrut(6));
        this.add(monthPanel);
        maxWidth = Math.max(maxWidth, monthPanel.getPreferredSize().width);
        this.add(Box.createVerticalStrut(6));
        this.add(dayPanel);
        maxWidth = Math.max(maxWidth, dayPanel.getPreferredSize().width);
        this.add(Box.createVerticalStrut(6));
        maxWidth = Math.max(maxWidth, timePanel.getPreferredSize().width);
        this.add(timePanel);
        yearPanel.setPreferredSize(new Dimension(maxWidth, yearPanel.getPreferredSize().height));
        yearPanel.setMaximumSize(yearPanel.getPreferredSize());
        yearPanel.setMinimumSize(yearPanel.getPreferredSize());
        monthPanel.setPreferredSize(new Dimension(maxWidth, monthPanel.getPreferredSize().height));
        monthPanel.setMaximumSize(monthPanel.getPreferredSize());
        monthPanel.setMinimumSize(monthPanel.getPreferredSize());
        dayPanel.setPreferredSize(new Dimension(maxWidth, dayPanel.getPreferredSize().height));
        dayPanel.setMaximumSize(dayPanel.getPreferredSize());
        dayPanel.setMinimumSize(dayPanel.getPreferredSize());
        timePanel.setPreferredSize(new Dimension(maxWidth, timePanel.getPreferredSize().height));
        timePanel.setMaximumSize(timePanel.getPreferredSize());
        timePanel.setMinimumSize(timePanel.getPreferredSize());
        double textwidth = this.getToolkit().getFontMetrics(label.getFont()).stringWidth(label.getText());
        int rows = (int)Math.ceil(textwidth / (double)(maxWidth + 10));
        label.setPreferredRows(rows);
        label.setMinimumRows(rows);
        label.setMaximumRows(rows);
        int height = 20 + label.getPreferredSize().height + 10 + (yearPanel.getPreferredSize().height + 6) * 4 - 6;
        this.setPreferredSize(new Dimension(maxWidth + 30, height));
        this.m_yearComboBox.addItemListener(this);
        this.m_monthComboBox.addItemListener(this);
        this.m_dayComboBox.addItemListener(this);
        this.m_timeComboBox.addItemListener(this);
    }

    private void _init() {
        String year = this.m_graph.getTimeAxisDateFormat(0);
        if (year.equals("AUTO")) {
            this.m_yearComboBox.setSelectedIndex(0);
        } else if (year.equals("NONE")) {
            this.m_yearComboBox.setSelectedIndex(1);
        } else if (year.equals("YYYY")) {
            this.m_yearComboBox.setSelectedIndex(2);
        } else if (year.equals("Y,YYY")) {
            this.m_yearComboBox.setSelectedIndex(3);
        } else if (year.equals("YY")) {
            this.m_yearComboBox.setSelectedIndex(4);
        } else if (year.equals("'YY")) {
            this.m_yearComboBox.setSelectedIndex(5);
        }
        String month = this.m_graph.getTimeAxisDateFormat(1);
        if (month.equals("AUTO")) {
            this.m_monthComboBox.setSelectedIndex(0);
        } else if (month.equals("NONE")) {
            this.m_monthComboBox.setSelectedIndex(1);
        } else if (month.equals("Month")) {
            this.m_monthComboBox.setSelectedIndex(2);
        } else if (month.equals("Mon")) {
            this.m_monthComboBox.setSelectedIndex(3);
        } else if (month.equals("M")) {
            this.m_monthComboBox.setSelectedIndex(4);
        } else if (month.equals("MM")) {
            this.m_monthComboBox.setSelectedIndex(5);
        }
        String day = this.m_graph.getTimeAxisDateFormat(2);
        if (day.equals("AUTO")) {
            this.m_dayComboBox.setSelectedIndex(0);
        } else if (day.equals("NONE")) {
            this.m_dayComboBox.setSelectedIndex(1);
        } else if (day.equals("DD")) {
            this.m_dayComboBox.setSelectedIndex(2);
        } else if (day.equals("Day")) {
            this.m_dayComboBox.setSelectedIndex(3);
        } else if (day.equals("Dy")) {
            this.m_dayComboBox.setSelectedIndex(4);
        } else if (day.equals("DS")) {
            this.m_dayComboBox.setSelectedIndex(5);
        } else if (day.equals("D")) {
            this.m_dayComboBox.setSelectedIndex(6);
        }
        String time = this.m_graph.getTimeAxisDateFormat(3);
        if (time.equals("AUTO")) {
            this.m_timeComboBox.setSelectedIndex(0);
        } else if (time.equals("NONE")) {
            this.m_timeComboBox.setSelectedIndex(1);
        } else if (time.equals("HH")) {
            this.m_timeComboBox.setSelectedIndex(2);
        } else if (time.equals("HH24")) {
            this.m_timeComboBox.setSelectedIndex(3);
        } else if (time.equals("HH:MI")) {
            this.m_timeComboBox.setSelectedIndex(4);
        } else if (time.equals("HH24:MI")) {
            this.m_timeComboBox.setSelectedIndex(5);
        } else if (time.equals("HH:MI:SS")) {
            this.m_timeComboBox.setSelectedIndex(6);
        } else if (time.equals("HH24:MI:SS")) {
            this.m_timeComboBox.setSelectedIndex(7);
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }
}

