/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;

public class GraphTypeConverterAdapter
implements GraphTypeConverter {
    public static final int TYPE_BAR = 0;
    public static final int TYPE_HORIZONTAL_BAR = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_HORIZONTAL_LINE = 3;
    public static final int TYPE_AREA = 5;
    public static final int TYPE_HORIZONTAL_AREA = 6;
    public static final int TYPE_COMBINATION = 7;
    public static final int TYPE_PARETO = 8;
    public static final int TYPE_PIE = 9;
    public static final int TYPE_STOCK = 14;
    public static final int TYPE_THREED = 15;
    public static final int TYPE_HISTOGRAM = 16;
    public static final int TYPE_SPECTRAL = 17;
    public static final int TYPE_CIRCULAR = 18;
    public static final int TYPE_SCATTER_BUBBLE = 19;
    public static final int TYPE_LINE_SELECT_POINT = 20;
    public static final int TYPE_FUNNEL = 21;
    protected static final int MAX_TYPE = 21;
    public static final int BAR_VERT_CLUST = 0;
    public static final int BAR_VERT_CLUST2Y = 1;
    public static final int BAR_VERT_CLUST_SPLIT2Y = 2;
    public static final int BAR_VERT_PERCENT = 3;
    public static final int BAR_VERT_STACK = 4;
    public static final int BAR_VERT_STACK2Y = 5;
    public static final int BAR_VERT_STACK_SPLIT2Y = 6;
    public static final int BAR_HORIZ_CLUST = 7;
    public static final int BAR_HORIZ_CLUST_2Y = 8;
    public static final int BAR_HORIZ_CLUST_SPLIT2Y = 9;
    public static final int BAR_HORIZ_PERCENT = 10;
    public static final int BAR_HORIZ_STACK = 11;
    public static final int BAR_HORIZ_STACK_2Y = 12;
    public static final int BAR_HORIZ_STACK_SPLIT2Y = 13;
    public static final int LINE_VERT_ABS = 14;
    public static final int LINE_VERT_ABS_2Y = 15;
    public static final int LINE_VERT_ABS_SPLIT2Y = 16;
    public static final int LINE_VERT_PERCENT = 17;
    public static final int LINE_VERT_STACK = 18;
    public static final int LINE_VERT_STACK_2Y = 19;
    public static final int LINE_VERT_STACK_SPLIT2Y = 20;
    public static final int LINE_HORIZ_ABS = 21;
    public static final int LINE_HORIZ_ABS_2Y = 22;
    public static final int LINE_HORIZ_ABS_SPLIT2Y = 23;
    public static final int LINE_HORIZ_PERCENT = 24;
    public static final int LINE_HORIZ_STACK = 25;
    public static final int LINE_HORIZ_STACK_2Y = 26;
    public static final int LINE_HORIZ_STACK_SPLIT2Y = 27;
    public static final int AREA_VERT_ABS = 31;
    public static final int AREA_VERT_ABS_SPLIT2Y = 32;
    public static final int AREA_VERT_PERCENT = 33;
    public static final int AREA_VERT_STACK = 34;
    public static final int AREA_VERT_STACK_SPLIT2Y = 35;
    public static final int AREA_HORIZ_ABS = 36;
    public static final int AREA_HORIZ_ABS_SPLIT2Y = 37;
    public static final int AREA_HORIZ_PERCENT = 38;
    public static final int AREA_HORIZ_STACK = 39;
    public static final int AREA_HORIZ_STACK_SPLIT2Y = 40;
    public static final int COMBO_GRAPH = 41;
    public static final int COMBO_GRAPH_2Y = 42;
    public static final int PARETO = 43;
    public static final int PIE = 44;
    public static final int PIE_MULTI = 45;
    public static final int PIE_BAR = 46;
    public static final int RING = 47;
    public static final int RING_MULTI = 48;
    public static final int RING_BAR = 49;
    public static final int PIE_MULTI_PROP = 50;
    public static final int RING_MULTI_PROP = 51;
    public static final int POLAR = 52;
    public static final int POLAR_2Y = 53;
    public static final int RADAR_LINE = 54;
    public static final int RADAR_AREA = 55;
    public static final int RADAR_LINE_2Y = 56;
    public static final int SCATTER = 57;
    public static final int SCATTER_2Y = 58;
    public static final int SCATTER_LABELS = 59;
    public static final int SCATTER_LABELS_2Y = 60;
    public static final int BUBBLE = 61;
    public static final int BUBBLE_2Y = 62;
    public static final int BUBBLE_LABELS = 63;
    public static final int BUBBLE_LABELS_2Y = 64;
    public static final int STOCK_HILO_CLOSE = 65;
    public static final int STOCK_HILO_CLOSE_VOLUME = 66;
    public static final int STOCK_OHLC_CANDLE = 67;
    public static final int STOCK_OHLC_CANDLE_VOLUME = 68;
    public static final int STOCK_OPEN_HILO_CLOSE = 69;
    public static final int STOCK_2Y = 70;
    public static final int STOCK_CANDLE = 71;
    public static final int STOCK_CANDLE_VOLUME = 72;
    public static final int STOCK_HILO = 73;
    public static final int STOCK_HILO_2Y = 74;
    public static final int STOCK_HILO_CLOSE2Y = 75;
    public static final int STOCK_HILO_CLOSE_SPLIT2Y = 76;
    public static final int STOCK_HILO_SPLIT2Y = 77;
    public static final int STOCK_HILO_VOLUME = 78;
    public static final int STOCK_SPLIT_2Y = 79;
    public static final int STOCK_VOLUME = 80;
    public static final int THREED_BAR = 81;
    public static final int THREED_CUBE = 82;
    public static final int THREED_AREA_SERIES = 83;
    public static final int THREED_RIBBON_SERIES = 84;
    public static final int THREED_SURFACE = 85;
    public static final int THREED_SURFACE_SIDES = 86;
    public static final int THREED_AREA_GROUP = 87;
    public static final int THREED_DIAMOND = 88;
    public static final int THREED_OCTAGON = 89;
    public static final int THREED_PYRAMID = 90;
    public static final int THREED_RIBBON_GROUP = 91;
    public static final int THREED_SURFACE_HONEYCOMB = 92;
    public static final int HIST_HORIZ = 93;
    public static final int HIST_VERT = 94;
    public static final int SPECTRAL = 95;
    public static final int BAR_VERT_FLOAT_STACK = 96;
    public static final int LINE_SELECT_POINT = 97;
    public static final int FUNNEL = 98;
    protected static final int MAX_SUBTYPE = 98;
    protected static final int RESOURCE_TYPE_NAME = 0;
    protected static final int RESOURCE_SUBTYPE_NAME = 0;
    protected static final int RESOURCE_SUBTYPE_DESC = 1;
    protected UIGraphType m_graph = null;
    protected int m_type = 0;
    protected int m_subtype = 0;
    protected int m_graphType = 17;
    protected Vector m_types;
    private boolean m_isThin = false;
    private ResourceBundle rBundle = null;

    public GraphTypeConverterAdapter() {
        this.updateResourceBundle(null);
    }

    public GraphTypeAndSubtype getTypeAndSubtype(UIGraphType graph) {
        GraphTypeAndSubtype graphTypeAndSubtype = this.initialize(graph);
        return graphTypeAndSubtype;
    }

    public void setTypeAndSubtype(UIGraphType graph, GraphTypeAndSubtype typeSubtype) {
        int type = 0;
        int subtype = 0;
        type = typeSubtype.type;
        subtype = typeSubtype.subtype;
        this.apply(graph, type, subtype);
    }

    public void addType(Type newType) {
        this.getTypes().addElement(newType);
    }

    public void addType(Type newType, int afterType) {
        int index = 0;
        if (afterType > -1) {
            index = this.getTypeIndex(afterType) + 1;
        }
        if (index == -1) {
            this.getTypes().addElement(newType);
        } else {
            this.getTypes().insertElementAt(newType, index);
        }
    }

    public void removeType(int typeID) {
        int index = this.getTypeIndex(typeID);
        if (index > -1) {
            this.getTypes().removeElementAt(index);
        }
    }

    public Type getType(int typeID) {
        int index = this.getTypeIndex(typeID);
        if (index == -1) {
            return null;
        }
        return (Type)this.getTypes().elementAt(index);
    }

    public int getNumberOfTypes() {
        return this.getTypes().size();
    }

    public Vector getTypes() {
        if (this.m_types == null) {
            this.initializeTypeList();
            this.loadStringResources();
        }
        return this.m_types;
    }

    public void setLocale(Locale loc) {
        this.updateResourceBundle(loc);
        if (this.m_types != null) {
            this.loadStringResources();
        }
    }

    protected void initializeTypeList() {
        Vector<Subtype> bar = new Vector<Subtype>();
        bar.addElement(new Subtype(0, null, null, "images/BAR_VERT_CLUST_3D.gif", "images/bar_large.png"));
        bar.addElement(new Subtype(1, null, null, "images/BAR_VERT_CLUST2Y_3D.gif", "images/bar_dual_Y.png"));
        bar.addElement(new Subtype(2, null, null, "images/BAR_VERT_CLUST_SPLIT2Y_3D.gif", "images/bar_split_dual_Y.png"));
        bar.addElement(new Subtype(3, null, null, "images/BAR_VERT_PERCENT_3D.gif", "images/bar_percent.png"));
        bar.addElement(new Subtype(4, null, null, "images/BAR_VERT_STACK_3D.gif", "images/bar_stacked.png"));
        bar.addElement(new Subtype(5, null, null, "images/BAR_VERT_STACK2Y_3D.gif", "images/bar_stacked_dual_y.png"));
        bar.addElement(new Subtype(6, null, null, "images/BAR_VERT_STACK_SPLIT2Y_3D.gif", "images/bar_split_dual_y_stacked.png"));
        bar.addElement(new Subtype(96, null, null, "images/BAR_VERT_FLOAT_STACK.gif", "images/bar_floating_stacked.png"));
        Vector<Subtype> hbar = new Vector<Subtype>();
        hbar.addElement(new Subtype(7, null, null, "images/BAR_HORIZ_CLUST_3D.gif", "images/horz_bar.png"));
        hbar.addElement(new Subtype(8, null, null, "images/BAR_HORIZ_CLUST2Y_3D.gif", "images/horz_bar_dual_y.png"));
        hbar.addElement(new Subtype(9, null, null, "images/BAR_HORIZ_CLUST_SPLIT2Y_3D.gif", "images/horz_bar_split_dual_y.png"));
        hbar.addElement(new Subtype(10, null, null, "images/BAR_HORIZ_PERCENT_3D.gif", "images/horz_bar_percent.png"));
        hbar.addElement(new Subtype(11, null, null, "images/BAR_HORIZ_STACK_3D.gif", "images/horz_bar_stacked.png"));
        hbar.addElement(new Subtype(12, null, null, "images/BAR_HORIZ_STACK2Y_3D.gif", "images/horz_bar_stacked_dual_y.png"));
        hbar.addElement(new Subtype(13, null, null, "images/BAR_HORIZ_STACK_SPLIT2Y_3D.gif", "images/horz_bar_split_dual_y.png"));
        Vector<Subtype> line = new Vector<Subtype>();
        line.addElement(new Subtype(14, null, null, "images/LINE_VERT_ABS_3D.gif", "images/line_large.png"));
        line.addElement(new Subtype(15, null, null, "images/LINE_VERT_ABS_2Y_3D.gif", "images/line_dual_y.png"));
        line.addElement(new Subtype(16, null, null, "images/LINE_VERT_ABS_SPLIT2Y_3D.gif", "images/line_split_dual_y.png"));
        line.addElement(new Subtype(17, null, null, "images/LINE_VERT_PERCENT_3D.gif", "images/line_percent.png"));
        line.addElement(new Subtype(18, null, null, "images/LINE_VERT_STACK_3D.gif", "images/line_stacked.png"));
        line.addElement(new Subtype(19, null, null, "images/LINE_VERT_STACK_2Y_3D.gif", "images/line_dual_Y_stacked.png"));
        line.addElement(new Subtype(20, null, null, "images/LINE_VERT_STACK_SPLIT2Y_3D.gif", "images/line_split_dual_y_stacked.png"));
        Vector<Subtype> area = new Vector<Subtype>();
        area.addElement(new Subtype(31, null, null, "images/AREA_VERT_ABS_3D.gif", "images/area_large.png"));
        area.addElement(new Subtype(32, null, null, "images/AREA_VERT_ABS_SPLIT2Y_3D.gif", "images/area_split_y.png"));
        area.addElement(new Subtype(33, null, null, "images/AREA_VERT_PERCENT_3D.gif", "images/area_percent.png"));
        area.addElement(new Subtype(34, null, null, "images/AREA_VERT_STACK_3D.gif", "images/area_stack.png"));
        area.addElement(new Subtype(35, null, null, "images/AREA_VERT_STACK_SPLIT2Y_3D.gif", "images/area_split_y_stack.png"));
        Vector<Subtype> combination = new Vector<Subtype>();
        combination.addElement(new Subtype(41, null, null, "images/COMBO_GRAPH_3D.gif", "images/combo.png"));
        combination.addElement(new Subtype(42, null, null, "images/COMBO_GRAPH_2Y_3D.gif", "images/dual_y_combo.png"));
        Vector<Subtype> pareto = new Vector<Subtype>();
        pareto.addElement(new Subtype(43, null, null, "images/THREED_PARETO.gif", "images/pareto.png"));
        Vector<Subtype> pie = new Vector<Subtype>();
        pie.addElement(new Subtype(44, null, null, "images/PIE_3D.gif", "images/pie_large.png"));
        pie.addElement(new Subtype(45, null, null, "images/PIE_MULTI_3D.gif", "images/pie_multi.png"));
        pie.addElement(new Subtype(46, null, null, "images/PIE_BAR_3D.gif", "images/pie_bar.png"));
        pie.addElement(new Subtype(47, null, null, "images/RING_3D.gif", "images/pie_ring.png"));
        pie.addElement(new Subtype(48, null, null, "images/RING_MULTI_3D.gif", "images/pie_ring_multi.png"));
        pie.addElement(new Subtype(49, null, null, "images/RING_BAR_3D.gif", "images/pie_ring_bar.png"));
        Vector<Subtype> circular = new Vector<Subtype>();
        circular.addElement(new Subtype(52, null, null, "images/POLAR_3D.gif", "images/circular_polar.png"));
        circular.addElement(new Subtype(54, null, null, "images/RADAR_LINE.gif", "images/circular_radar.png"));
        Vector<Subtype> scatterBubble = new Vector<Subtype>();
        scatterBubble.addElement(new Subtype(57, null, null, "images/SCATTER_3D.gif", "images/scatter.png"));
        scatterBubble.addElement(new Subtype(58, null, null, "images/SCATTER_2Y_3D.gif", "images/dual_scatter.png"));
        scatterBubble.addElement(new Subtype(61, null, null, "images/BUBBLE_3D.gif", "images/bubble.png"));
        scatterBubble.addElement(new Subtype(62, null, null, "images/BUBBLE_2Y_3D.gif", "images/bubble_dual_y.png"));
        Vector<Subtype> stockmkt = new Vector<Subtype>();
        stockmkt.addElement(new Subtype(65, null, null, "images/STOCK_HILO_CLOSE.gif", "images/hi_low_close.png"));
        stockmkt.addElement(new Subtype(66, null, null, "images/STOCK_HILO_CLOSE_VOLUME.gif", "images/hi_lo_close_w_volume.png"));
        stockmkt.addElement(new Subtype(69, null, null, "images/STOCK_OPEN_HILO_CLOSE.gif", "images/open_hi_lo_close.png"));
        stockmkt.addElement(new Subtype(80, null, null, "images/STOCK_VOLUME.gif", "images/open_hi_lo_close_w_vol.png"));
        stockmkt.addElement(new Subtype(71, null, null, "images/STOCK_CANDLE.gif", "images/open_close_candle.png"));
        stockmkt.addElement(new Subtype(72, null, null, "images/STOCK_CANDLE_VOLUME.gif", "images/open_close_candle_w_vol.png"));
        stockmkt.addElement(new Subtype(67, null, null, "images/STOCK_OHLC_CANDLE.gif", "images/open_hi_lo_close_candle.png"));
        stockmkt.addElement(new Subtype(68, null, null, "images/STOCK_OHLC_CANDLE_VOLUME.gif", "images/open_hi_lo_close_candle_w_vol.png"));
        Vector<Subtype> threeD = new Vector<Subtype>();
        threeD.addElement(new Subtype(81, null, null, "images/THREED_BAR.gif", "images/3d_bar.png"));
        threeD.addElement(new Subtype(82, null, null, "images/THREED_CUBE.gif", "images/3d_cube.png"));
        threeD.addElement(new Subtype(83, null, null, "images/THREED_AREA_SERIES.gif", "images/3d_area.png"));
        threeD.addElement(new Subtype(84, null, null, "images/THREED_RIBBON_SERIES.gif", "images/3d_ribbon.png"));
        threeD.addElement(new Subtype(85, null, null, "images/THREED_SURFACE.gif", "images/3d_surface.png"));
        Vector<Subtype> funnel = new Vector<Subtype>();
        funnel.addElement(new Subtype(98, null, null, "images/FUNNEL.gif", "images/funnel_large.png"));
        this.m_types = new Vector();
        this.m_types.addElement(new Type(0, null, "images/bar.png", new String("images/es_bar_vert_clust.gif"), bar, true, true));
        this.m_types.addElement(new Type(1, null, "images/horizontalbar.png", "images/es_bar_horiz_clust.gif", hbar, true, true));
        this.m_types.addElement(new Type(9, null, "images/pie.png", "images/es_pie.gif", pie, true, true));
        this.m_types.addElement(new Type(2, null, "images/line.png", "images/es_line_vert_abs.gif", line, true, true));
        this.m_types.addElement(new Type(5, null, "images/area.png", "images/es_area_vert_abs.gif", area, true, true));
        this.m_types.addElement(new Type(7, null, "images/combination.png", "images/es_combo_graph.gif", combination, true, true));
        this.m_types.addElement(new Type(19, null, "images/scatterbubble.png", "images/es_scatter_bubble.gif", scatterBubble, true, true));
        this.m_types.addElement(new Type(14, null, "images/stockgraph.png", "images/es_stock_hilo_close.gif", stockmkt, false, true));
        this.m_types.addElement(new Type(18, null, "images/circular.png", "images/es_circular.gif", circular, true, true));
        this.m_types.addElement(new Type(8, null, "images/paretograph.png", "images/es_pareto.gif", pareto, true, true));
        this.m_types.addElement(new Type(15, null, "images/3Dbargraph.png", "images/es_threed_bar.gif", threeD, true, false));
        this.m_types.addElement(new Type(21, null, "images/funnel.png", "images/es_funnel.gif", funnel, true, false));
    }

    protected void loadStringResources() {
        Vector types = this.getTypes();
        for (int t = 0; t < types.size(); ++t) {
            Type type = (Type)types.elementAt(t);
            String typeName = this.getTypeResource(type.id, 0);
            if (typeName != null) {
                type.name = typeName;
            }
            for (int s = 0; s < type.subtypes.size(); ++s) {
                String subtypeDesc;
                Subtype subtype = (Subtype)type.subtypes.elementAt(s);
                String subtypeName = this.getSubtypeResource(subtype.id, 0);
                if (subtypeName != null) {
                    subtype.name = subtypeName;
                }
                if ((subtypeDesc = this.getSubtypeResource(subtype.id, 1)) == null) continue;
                subtype.description = subtypeDesc;
            }
        }
    }

    protected String getTypeResource(int typeID, int resourceType) {
        String resource = null;
        switch (typeID) {
            case 0: {
                resource = this.rBundle.getString("GraphTypeBar");
                break;
            }
            case 1: {
                resource = this.rBundle.getString("Horizontal Bar");
                break;
            }
            case 2: {
                resource = this.rBundle.getString("GraphTypeLine");
                break;
            }
            case 5: {
                resource = this.rBundle.getString("GraphTypeArea");
                break;
            }
            case 7: {
                resource = this.rBundle.getString("Combination");
                break;
            }
            case 8: {
                resource = this.rBundle.getString("Pareto");
                break;
            }
            case 9: {
                resource = this.rBundle.getString("Pie");
                break;
            }
            case 14: {
                resource = this.rBundle.getString("Stock Market");
                break;
            }
            case 15: {
                resource = this.rBundle.getString("ThreeD");
                break;
            }
            case 18: {
                if (this.m_isThin) {
                    resource = this.rBundle.getString("ThinCircular");
                    break;
                }
                resource = this.rBundle.getString("Circular");
                break;
            }
            case 19: {
                if (this.m_isThin) {
                    resource = this.rBundle.getString("ThinScatterBubble");
                    break;
                }
                resource = this.rBundle.getString("ScatterBubble");
                break;
            }
            case 21: {
                resource = this.rBundle.getString("Funnel");
                break;
            }
        }
        return resource;
    }

    protected String getSubtypeResource(int subtypeID, int resourceType) {
        String resource = null;
        switch (subtypeID) {
            case 0: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST_desc");
                break;
            }
            case 1: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST2Y_desc");
                break;
            }
            case 2: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_desc");
                break;
            }
            case 3: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_PERCENT_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_PERCENT_desc");
                break;
            }
            case 4: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK_desc");
                break;
            }
            case 5: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK2Y_desc");
                break;
            }
            case 6: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 96: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_FLOAT_STACK_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_FLOAT_STACK_desc");
                break;
            }
            case 7: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST_desc");
                break;
            }
            case 8: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST2Y_desc");
                break;
            }
            case 9: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_desc");
                break;
            }
            case 10: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_PERCENT_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_PERCENT_desc");
                break;
            }
            case 11: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK_desc");
                break;
            }
            case 12: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK2Y_desc");
                break;
            }
            case 13: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 14: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_ABS_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_ABS_desc");
                break;
            }
            case 15: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_ABS_2Y_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_ABS_2Y_desc");
                break;
            }
            case 16: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_ABS_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_ABS_SPLIT2Y_desc");
                break;
            }
            case 17: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_PERCENT_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_PERCENT_desc");
                break;
            }
            case 18: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_STACK_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_STACK_desc");
                break;
            }
            case 19: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_STACK_2Y_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_STACK_2Y_desc");
                break;
            }
            case 20: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("LINE_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("LINE_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 31: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("AREA_VERT_ABS_name");
                    break;
                }
                resource = this.rBundle.getString("AREA_VERT_ABS_desc");
                break;
            }
            case 32: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("AREA_VERT_ABS_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("AREA_VERT_ABS_SPLIT2Y_desc");
                break;
            }
            case 33: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("AREA_VERT_PERCENT_name");
                    break;
                }
                resource = this.rBundle.getString("AREA_VERT_PERCENT_desc");
                break;
            }
            case 34: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("AREA_VERT_STACK_name");
                    break;
                }
                resource = this.rBundle.getString("AREA_VERT_STACK_desc");
                break;
            }
            case 35: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("AREA_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                resource = this.rBundle.getString("AREA_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 41: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("COMBO_GRAPH_name");
                    break;
                }
                resource = this.rBundle.getString("COMBO_GRAPG_desc");
                break;
            }
            case 42: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("COMBO_GRAPH_2Y_name");
                    break;
                }
                resource = this.rBundle.getString("COMBO_GRAPG_2Y_desc");
                break;
            }
            case 43: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("PARETO_GRAPH_name");
                    break;
                }
                resource = this.rBundle.getString("PARETO_GRAPH_desc");
                break;
            }
            case 44: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("PIE_name");
                    break;
                }
                resource = this.rBundle.getString("PIE_desc");
                break;
            }
            case 45: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("PIE_MULTI_name");
                    break;
                }
                resource = this.rBundle.getString("PIE_MULTI_desc");
                break;
            }
            case 46: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("PIE_BAR_name");
                    break;
                }
                resource = this.rBundle.getString("PIE_BAR_desc");
                break;
            }
            case 47: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("RING_name");
                    break;
                }
                resource = this.rBundle.getString("RING_desc");
                break;
            }
            case 48: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("RING_MULTI_name");
                    break;
                }
                resource = this.rBundle.getString("RING_MULTI_desc");
                break;
            }
            case 49: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("RING_BAR_name");
                    break;
                }
                resource = this.rBundle.getString("RING_BAR_desc");
                break;
            }
            case 52: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("POLAR_name");
                    break;
                }
                resource = this.rBundle.getString("POLAR_desc");
                break;
            }
            case 54: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("RADAR_LINE_name");
                    break;
                }
                resource = this.rBundle.getString("RADAR_LINE_desc");
                break;
            }
            case 57: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("SCATTER_name");
                    break;
                }
                resource = this.rBundle.getString("SCATTER_desc");
                break;
            }
            case 58: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("SCATTER_2Y_name");
                    break;
                }
                resource = this.rBundle.getString("SCATTER_2Y_desc");
                break;
            }
            case 61: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BUBBLE_name");
                    break;
                }
                resource = this.rBundle.getString("BUBBLE_desc");
                break;
            }
            case 62: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("BUBBLE_2Y_name");
                    break;
                }
                resource = this.rBundle.getString("BUBBLE_2Y_desc");
                break;
            }
            case 65: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_HILO_CLOSE_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_HILO_CLOSE_desc");
                break;
            }
            case 66: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_HILO_CLOSE_VOLUME_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_HILO_CLOSE_VOLUME_desc");
                break;
            }
            case 67: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_OHLC_CANDLE_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_OHLC_CANDLE_desc");
                break;
            }
            case 68: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_OHLC_CANDLE_VOLUME_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_OHLC_CANDLE_VOLUME_desc");
                break;
            }
            case 71: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_CANDLE_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_CANDLE_desc");
                break;
            }
            case 72: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_CANDLE_VOLUME_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_CANDLE_VOLUME_desc");
                break;
            }
            case 69: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_OPEN_HILO_CLOSE_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_OPEN_HILO_CLOSE_desc");
                break;
            }
            case 80: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("STOCK_VOLUME_name");
                    break;
                }
                resource = this.rBundle.getString("STOCK_VOLUME_desc");
                break;
            }
            case 81: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("THREED_BAR_name");
                    break;
                }
                resource = this.rBundle.getString("THREED_BAR_desc");
                break;
            }
            case 82: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("THREED_CUBE_name");
                    break;
                }
                resource = this.rBundle.getString("THREED_CUBE_desc");
                break;
            }
            case 83: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("THREED_AREA_SERIES_name");
                    break;
                }
                resource = this.rBundle.getString("THREED_AREA_SERIES_desc");
                break;
            }
            case 84: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("THREED_RIBBON_SERIES_name");
                    break;
                }
                resource = this.rBundle.getString("THREED_RIBBON_SERIES_desc");
                break;
            }
            case 85: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("THREED_SURFACE_name");
                    break;
                }
                resource = this.rBundle.getString("THREED_SURFACE_desc");
                break;
            }
            case 98: {
                if (resourceType == 0) {
                    resource = this.rBundle.getString("FUNNEL_name");
                    break;
                }
                resource = this.rBundle.getString("FUNNEL_desc");
                break;
            }
        }
        return resource;
    }

    protected GraphTypeAndSubtype initialize(UIGraphType graph) {
        int type = 0;
        int subtype = 0;
        switch (graph.getGraphType()) {
            case 97: {
                type = 7;
                subtype = 41;
                break;
            }
            case 17: {
                type = 0;
                subtype = 0;
                break;
            }
            case 19: {
                type = 0;
                subtype = 1;
                break;
            }
            case 98: {
                type = 7;
                subtype = 42;
                break;
            }
            case 21: {
                type = 0;
                subtype = 2;
                break;
            }
            case 23: {
                type = 0;
                subtype = 3;
                break;
            }
            case 18: {
                type = 0;
                subtype = 4;
                break;
            }
            case 20: {
                type = 0;
                subtype = 5;
                break;
            }
            case 22: {
                type = 0;
                subtype = 6;
                break;
            }
            case 95: {
                type = 0;
                subtype = 96;
                break;
            }
            case 24: {
                type = 1;
                subtype = 7;
                break;
            }
            case 26: {
                type = 1;
                subtype = 8;
                break;
            }
            case 28: {
                type = 1;
                subtype = 9;
                break;
            }
            case 30: {
                type = 1;
                subtype = 10;
                break;
            }
            case 25: {
                type = 1;
                subtype = 11;
                break;
            }
            case 27: {
                type = 1;
                subtype = 12;
                break;
            }
            case 29: {
                type = 1;
                subtype = 13;
                break;
            }
            case 41: {
                type = 2;
                subtype = 14;
                break;
            }
            case 43: {
                type = 2;
                subtype = 15;
                break;
            }
            case 45: {
                type = 2;
                subtype = 16;
                break;
            }
            case 47: {
                type = 2;
                subtype = 17;
                break;
            }
            case 42: {
                type = 2;
                subtype = 18;
                break;
            }
            case 44: {
                type = 2;
                subtype = 19;
                break;
            }
            case 46: {
                type = 2;
                subtype = 20;
                break;
            }
            case 48: {
                type = 3;
                subtype = 21;
                break;
            }
            case 50: {
                type = 3;
                subtype = 22;
                break;
            }
            case 52: {
                type = 3;
                subtype = 23;
                break;
            }
            case 54: {
                type = 3;
                subtype = 24;
                break;
            }
            case 49: {
                type = 3;
                subtype = 25;
                break;
            }
            case 51: {
                type = 3;
                subtype = 26;
                break;
            }
            case 53: {
                type = 3;
                subtype = 27;
                break;
            }
            case 31: {
                type = 5;
                subtype = 31;
                break;
            }
            case 33: {
                type = 5;
                subtype = 32;
                break;
            }
            case 35: {
                type = 5;
                subtype = 33;
                break;
            }
            case 32: {
                type = 5;
                subtype = 34;
                break;
            }
            case 34: {
                type = 5;
                subtype = 35;
                break;
            }
            case 36: {
                type = 6;
                subtype = 36;
                break;
            }
            case 38: {
                type = 6;
                subtype = 37;
                break;
            }
            case 40: {
                type = 6;
                subtype = 38;
                break;
            }
            case 37: {
                type = 6;
                subtype = 39;
                break;
            }
            case 39: {
                type = 6;
                subtype = 40;
                break;
            }
            case 96: {
                type = 8;
                subtype = 43;
                break;
            }
            case 55: {
                type = 9;
                subtype = 44;
                break;
            }
            case 57: {
                type = 9;
                subtype = 45;
                break;
            }
            case 93: {
                type = 9;
                subtype = 46;
                break;
            }
            case 56: {
                type = 9;
                subtype = 47;
                break;
            }
            case 58: {
                type = 9;
                subtype = 48;
                break;
            }
            case 94: {
                type = 9;
                subtype = 49;
                break;
            }
            case 59: {
                type = 9;
                subtype = 50;
                break;
            }
            case 60: {
                type = 9;
                subtype = 51;
                break;
            }
            case 65: {
                type = 18;
                subtype = 52;
                break;
            }
            case 66: {
                type = 18;
                subtype = 53;
                break;
            }
            case 67: {
                type = 18;
                subtype = 54;
                break;
            }
            case 68: {
                type = 18;
                subtype = 55;
                break;
            }
            case 69: {
                type = 18;
                subtype = 56;
                break;
            }
            case 61: {
                type = 19;
                subtype = 57;
                break;
            }
            case 62: {
                type = 19;
                subtype = 58;
                break;
            }
            case 63: {
                type = 19;
                subtype = 59;
                break;
            }
            case 64: {
                type = 19;
                subtype = 60;
                break;
            }
            case 89: {
                type = 19;
                subtype = 61;
                break;
            }
            case 91: {
                type = 19;
                subtype = 62;
                break;
            }
            case 90: {
                type = 19;
                subtype = 63;
                break;
            }
            case 92: {
                type = 19;
                subtype = 64;
                break;
            }
            case 76: {
                type = 14;
                subtype = 65;
                break;
            }
            case 88: {
                type = 14;
                subtype = 66;
                break;
            }
            case 70: {
                type = 14;
                subtype = 67;
                break;
            }
            case 71: {
                type = 14;
                subtype = 68;
                break;
            }
            case 79: {
                type = 14;
                subtype = 69;
                break;
            }
            case 80: {
                type = 14;
                subtype = 70;
                break;
            }
            case 72: {
                type = 14;
                subtype = 71;
                break;
            }
            case 84: {
                type = 14;
                subtype = 72;
                break;
            }
            case 73: {
                type = 14;
                subtype = 73;
                break;
            }
            case 74: {
                type = 14;
                subtype = 74;
                break;
            }
            case 77: {
                type = 14;
                subtype = 75;
                break;
            }
            case 78: {
                type = 14;
                subtype = 76;
                break;
            }
            case 75: {
                type = 14;
                subtype = 77;
                break;
            }
            case 82: {
                type = 14;
                subtype = 78;
                break;
            }
            case 81: {
                type = 14;
                subtype = 79;
                break;
            }
            case 83: {
                type = 14;
                subtype = 80;
                break;
            }
            case 0: {
                type = 15;
                subtype = 81;
                break;
            }
            case 4: {
                type = 15;
                subtype = 82;
                break;
            }
            case 6: {
                type = 15;
                subtype = 83;
                break;
            }
            case 7: {
                type = 15;
                subtype = 84;
                break;
            }
            case 12: {
                type = 15;
                subtype = 85;
                break;
            }
            case 13: {
                type = 15;
                subtype = 86;
                break;
            }
            case 9: {
                type = 15;
                subtype = 87;
                break;
            }
            case 5: {
                type = 15;
                subtype = 88;
                break;
            }
            case 2: {
                type = 15;
                subtype = 89;
                break;
            }
            case 1: {
                type = 15;
                subtype = 90;
                break;
            }
            case 10: {
                type = 15;
                subtype = 91;
                break;
            }
            case 14: {
                type = 15;
                subtype = 92;
                break;
            }
            case 86: {
                type = 16;
                subtype = 93;
                break;
            }
            case 85: {
                type = 16;
                subtype = 94;
                break;
            }
            case 87: {
                type = 17;
                subtype = 95;
                break;
            }
            case 99: {
                type = 20;
                subtype = 97;
                break;
            }
            case 100: {
                type = 21;
                subtype = 98;
            }
        }
        return new GraphTypeAndSubtype(type, subtype);
    }

    protected void apply(UIGraphType graph, int type, int subtype) {
        int graphType = this.prepareToApply(graph, type, subtype);
        if (graph.getGraphType() != graphType) {
            graph.setGraphType(graphType);
        }
    }

    protected int prepareToApply(UIGraphType graph, int type, int subtype) {
        int graphType = 0;
        switch (type) {
            case 0: {
                switch (subtype) {
                    case 0: {
                        graphType = 17;
                        break;
                    }
                    case 1: {
                        graphType = 19;
                        break;
                    }
                    case 2: {
                        graphType = 21;
                        break;
                    }
                    case 3: {
                        graphType = 23;
                        break;
                    }
                    case 4: {
                        graphType = 18;
                        break;
                    }
                    case 5: {
                        graphType = 20;
                        break;
                    }
                    case 6: {
                        graphType = 22;
                        break;
                    }
                    case 96: {
                        graphType = 95;
                    }
                }
                break;
            }
            case 1: {
                switch (subtype) {
                    case 7: {
                        graphType = 24;
                        break;
                    }
                    case 8: {
                        graphType = 26;
                        break;
                    }
                    case 9: {
                        graphType = 28;
                        break;
                    }
                    case 10: {
                        graphType = 30;
                        break;
                    }
                    case 11: {
                        graphType = 25;
                        break;
                    }
                    case 12: {
                        graphType = 27;
                        break;
                    }
                    case 13: {
                        graphType = 29;
                    }
                }
                break;
            }
            case 2: {
                switch (subtype) {
                    case 14: {
                        graphType = 41;
                        break;
                    }
                    case 15: {
                        graphType = 43;
                        break;
                    }
                    case 16: {
                        graphType = 45;
                        break;
                    }
                    case 17: {
                        graphType = 47;
                        break;
                    }
                    case 18: {
                        graphType = 42;
                        break;
                    }
                    case 19: {
                        graphType = 44;
                        break;
                    }
                    case 20: {
                        graphType = 46;
                    }
                }
                break;
            }
            case 3: {
                switch (subtype) {
                    case 21: {
                        graphType = 48;
                        break;
                    }
                    case 22: {
                        graphType = 50;
                        break;
                    }
                    case 23: {
                        graphType = 52;
                        break;
                    }
                    case 24: {
                        graphType = 54;
                        break;
                    }
                    case 25: {
                        graphType = 49;
                        break;
                    }
                    case 26: {
                        graphType = 51;
                        break;
                    }
                    case 27: {
                        graphType = 53;
                    }
                }
                break;
            }
            case 5: {
                switch (subtype) {
                    case 31: {
                        graphType = 31;
                        break;
                    }
                    case 32: {
                        graphType = 33;
                        break;
                    }
                    case 33: {
                        graphType = 35;
                        break;
                    }
                    case 34: {
                        graphType = 32;
                        break;
                    }
                    case 35: {
                        graphType = 34;
                    }
                }
                break;
            }
            case 6: {
                switch (subtype) {
                    case 36: {
                        graphType = 36;
                        break;
                    }
                    case 37: {
                        graphType = 38;
                        break;
                    }
                    case 38: {
                        graphType = 40;
                        break;
                    }
                    case 39: {
                        graphType = 37;
                        break;
                    }
                    case 40: {
                        graphType = 39;
                    }
                }
                break;
            }
            case 7: {
                switch (subtype) {
                    case 41: {
                        graphType = 97;
                        break;
                    }
                    case 42: {
                        graphType = 98;
                    }
                }
                break;
            }
            case 8: {
                switch (subtype) {
                    case 43: {
                        graphType = 96;
                    }
                }
                break;
            }
            case 9: {
                switch (subtype) {
                    case 44: {
                        graphType = 55;
                        break;
                    }
                    case 45: {
                        graphType = 57;
                        break;
                    }
                    case 46: {
                        graphType = 93;
                        break;
                    }
                    case 47: {
                        graphType = 56;
                        break;
                    }
                    case 48: {
                        graphType = 58;
                        break;
                    }
                    case 49: {
                        graphType = 94;
                        break;
                    }
                    case 50: {
                        graphType = 59;
                        break;
                    }
                    case 51: {
                        graphType = 60;
                    }
                }
                break;
            }
            case 18: {
                switch (subtype) {
                    case 52: {
                        graphType = 65;
                        break;
                    }
                    case 53: {
                        graphType = 66;
                        break;
                    }
                    case 54: {
                        graphType = 67;
                        break;
                    }
                    case 55: {
                        graphType = 68;
                        break;
                    }
                    case 56: {
                        graphType = 69;
                    }
                }
                break;
            }
            case 19: {
                switch (subtype) {
                    case 57: {
                        graphType = 61;
                        break;
                    }
                    case 58: {
                        graphType = 62;
                        break;
                    }
                    case 59: {
                        graphType = 63;
                        break;
                    }
                    case 60: {
                        graphType = 64;
                        break;
                    }
                    case 61: {
                        graphType = 89;
                        break;
                    }
                    case 62: {
                        graphType = 91;
                        break;
                    }
                    case 63: {
                        graphType = 90;
                        break;
                    }
                    case 64: {
                        graphType = 92;
                    }
                }
                break;
            }
            case 14: {
                switch (subtype) {
                    case 65: {
                        graphType = 76;
                        break;
                    }
                    case 66: {
                        graphType = 88;
                        break;
                    }
                    case 67: {
                        graphType = 70;
                        break;
                    }
                    case 68: {
                        graphType = 71;
                        break;
                    }
                    case 69: {
                        graphType = 79;
                        break;
                    }
                    case 70: {
                        graphType = 80;
                        break;
                    }
                    case 71: {
                        graphType = 72;
                        break;
                    }
                    case 72: {
                        graphType = 84;
                        break;
                    }
                    case 73: {
                        graphType = 73;
                        break;
                    }
                    case 74: {
                        graphType = 74;
                        break;
                    }
                    case 75: {
                        graphType = 77;
                        break;
                    }
                    case 76: {
                        graphType = 78;
                        break;
                    }
                    case 77: {
                        graphType = 75;
                        break;
                    }
                    case 78: {
                        graphType = 82;
                        break;
                    }
                    case 79: {
                        graphType = 81;
                        break;
                    }
                    case 80: {
                        graphType = 83;
                    }
                }
                break;
            }
            case 15: {
                switch (subtype) {
                    case 81: {
                        graphType = 0;
                        break;
                    }
                    case 82: {
                        graphType = 4;
                        break;
                    }
                    case 83: {
                        graphType = 6;
                        break;
                    }
                    case 84: {
                        graphType = 7;
                        break;
                    }
                    case 85: {
                        graphType = 12;
                        break;
                    }
                    case 86: {
                        graphType = 13;
                        break;
                    }
                    case 87: {
                        graphType = 9;
                        break;
                    }
                    case 88: {
                        graphType = 5;
                        break;
                    }
                    case 89: {
                        graphType = 2;
                        break;
                    }
                    case 90: {
                        graphType = 1;
                        break;
                    }
                    case 91: {
                        graphType = 10;
                        break;
                    }
                    case 92: {
                        graphType = 14;
                    }
                }
                break;
            }
            case 16: {
                switch (subtype) {
                    case 93: {
                        graphType = 86;
                        break;
                    }
                    case 94: {
                        graphType = 85;
                    }
                }
                break;
            }
            case 17: {
                switch (subtype) {
                    case 95: {
                        graphType = 87;
                    }
                }
                break;
            }
            case 20: {
                switch (subtype) {
                    case 97: {
                        graphType = 99;
                    }
                }
                break;
            }
            case 21: {
                switch (subtype) {
                    case 98: {
                        graphType = 100;
                    }
                }
            }
        }
        return graphType;
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    protected int getTypeIndex(int typeID) {
        int length = this.getTypes().size();
        for (int i = 0; i < length; ++i) {
            Type type = (Type)this.getTypes().elementAt(i);
            if (typeID != type.id) continue;
            return i;
        }
        return -1;
    }

    protected void cleanUp() {
        this.m_graph = null;
        this.rBundle = null;
        if (this.m_types != null) {
            for (int t = 0; t < this.m_types.size(); ++t) {
                Type type = (Type)this.m_types.elementAt(t);
                if (type == null) continue;
                if (type.subtypes != null) {
                    type.subtypes.clear();
                }
                type.subtypes = null;
            }
            this.m_types.clear();
        }
        this.m_types = null;
    }

    public void setThin(boolean isThin) {
        this.m_isThin = isThin;
    }
}

