/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.adfdtinternal.model.dvt.util.gui.context.PropertyHashtable;
import oracle.adfdtinternal.model.dvt.util.gui.layout.ColumnHeader;
import oracle.adfdtinternal.model.dvt.util.gui.layout.DataPointGrid;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPageItem;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPagingComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPivotingEvent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutPivotingListener;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutSpreadTable;
import oracle.adfdtinternal.model.dvt.util.gui.layout.PagingComponent;
import oracle.adfdtinternal.model.dvt.util.gui.layout.RowHeader;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.PollingRequiredEvent;
import oracle.dss.util.WaitDataAvailableEvent;

public class Layout
extends JPanel
implements DataDirectorListener,
HelpContext {
    protected boolean m_bIsScrollingEnabled = true;
    protected LayoutContext m_layoutContext = null;
    protected LayoutAccess m_layoutAccess = null;
    protected DataDirector m_dataDirector;
    protected DataAccess m_dataAccess;
    protected PageComponentListener m_pageComponentListener;
    protected Vector m_vLayerNames = null;
    protected boolean m_bPagingControlVisible = false;
    protected boolean m_bHideAvailable = false;
    protected MultiLineLabel m_multiLineLabelDescription = null;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected JPanel m_jPanelTop;
    protected JPanel m_jPanelPagingControlOptions;
    protected JCheckBox m_showPageItemsChkBox;
    protected JLabel m_pagingLabel;
    protected JPanel m_jPanelPagingControl;
    protected JLabel m_pagingControlLabel;
    private StatusBar statusBar;
    private JLabel m_statusLabel;
    protected String m_rPageItems = "";
    protected LayoutPagingComponent m_pageEdgeLayers;
    protected PopupManager m_popupManager;
    protected Vector m_hiddenDimensions;
    protected Vector m_layoutPivotingListeners;
    protected ComponentListener m_componentListener;
    protected ResourceBundle m_rBundle = null;
    protected boolean m_hidePagingControl = false;
    protected String m_strDescriptionText = null;
    protected ErrorHandler m_eh = null;
    protected static final String m_method_pPivot = "performPivot";
    protected static final String m_method_getELayers = "getEdgeLayers";
    protected static final String m_method_initHDims = "initHiddenDimensions";
    public static final int HIDDEN_EDGE = 4;
    public static final String PAGEEDGEVISIBLE_CHANGED = "PageEdgeVisibleChanged";
    protected boolean m_bDelayChangesToLayoutAccess = false;
    protected boolean m_bCanPivotSupported = false;
    protected boolean m_bSuperCalled = true;
    protected String m_memberMetadataLabelType = "label";
    protected String m_layerMetadataLabelType = "layerLabel";
    private ArrowBox arrowBox;
    protected PropertyHashtable m_propertyHashtable = null;
    protected boolean m_bIsAllowDataPointGrid = false;

    public Layout() {
        this(true);
    }

    public Layout(boolean bInit) {
        if (bInit) {
            this.init();
        }
    }

    public Layout(boolean bInit, boolean bIsScrollingEnabled) {
        this.setScrollingEnabled(bIsScrollingEnabled);
        if (bInit) {
            this.init();
        }
    }

    public Layout(PropertyHashtable propertyHashtable) {
        this();
        this.m_propertyHashtable = propertyHashtable;
    }

    public PopupManager getPopupManager() {
        return this.m_popupManager;
    }

    public boolean isScrollingEnabled() {
        return this.m_bIsScrollingEnabled;
    }

    public void setScrollingEnabled(boolean bScrollingEnabled) {
        this.m_bIsScrollingEnabled = bScrollingEnabled;
    }

    public boolean isAllowDataPointGrid() {
        return this.m_bIsAllowDataPointGrid;
    }

    public void setAllowDataPointGrid(boolean bIsAllowDataPointGrid) {
        this.m_bIsAllowDataPointGrid = bIsAllowDataPointGrid;
    }

    public void setDelayChangesToLayoutAccess(boolean delayChanges) {
        this.m_bDelayChangesToLayoutAccess = delayChanges;
    }

    public String getDescriptionText() {
        return this.m_strDescriptionText;
    }

    public void setDescriptionText(String strDescriptionText) {
        this.m_strDescriptionText = strDescriptionText;
        if (this.getMultiLineLabelDescription() != null) {
            this.getMultiLineLabelDescription().setText(strDescriptionText);
        }
    }

    public void setPagingControlVisible(boolean bIsVisible) {
        this.m_bPagingControlVisible = bIsVisible;
        this.showPagingControl(bIsVisible);
        this.firePropertyChange(PAGEEDGEVISIBLE_CHANGED, !bIsVisible, bIsVisible);
    }

    public boolean isPagingControlVisible() {
        return this.m_bPagingControlVisible;
    }

    public void setHideAvailable(boolean hideAvailable) {
        this.m_bHideAvailable = hideAvailable;
        if (this.m_popupManager != null) {
            this.m_popupManager.setShowHideMenuItem(hideAvailable);
        }
    }

    public boolean isHideAvailable() {
        return this.m_bHideAvailable;
    }

    public void setTopPanel(JPanel jPanelTop) {
        this.m_jPanelTop = jPanelTop;
    }

    public JPanel getTopPanel() {
        return this.m_jPanelTop;
    }

    public void setPagingControlPanel(JPanel jPanelPagingControl) {
        this.m_jPanelPagingControl = jPanelPagingControl;
    }

    public JPanel getPagingControlPanel() {
        return this.m_jPanelPagingControl;
    }

    public void setPagingControlPanelOptions(JPanel jPanelPagingControlOptions) {
        this.m_jPanelPagingControlOptions = jPanelPagingControlOptions;
    }

    public JPanel getPagingControlPanelOptions() {
        return this.m_jPanelPagingControlOptions;
    }

    public void setLayoutContext(LayoutContext lc) {
        this.m_layoutContext = lc;
        this.setLayoutAccess(this.m_layoutContext.createCubeLayoutAccess());
    }

    public LayoutContext getLayoutContext() {
        return this.m_layoutContext;
    }

    public void setLayoutAccess(LayoutAccess layoutAccess) {
        if (this.m_layoutAccess == layoutAccess) {
            return;
        }
        if (this.m_layoutAccess != null) {
            this.m_layoutAccess.release();
        }
        this.m_layoutAccess = layoutAccess;
        this.m_layoutAccess.setCursorEvaluation(false);
        if (this.m_layoutAccess.getDataSource() != null) {
            this.m_dataDirector = this.m_layoutAccess.getDataSource().createCubeDataDirector();
            if (this.m_dataDirector != null) {
                this.m_dataDirector.removeDataDirectorListener((DataDirectorListener)this);
                this.m_dataDirector.addDataDirectorListener((DataDirectorListener)this);
            }
        }
        if (this.m_dataAccess == null) {
            return;
        }
        this.updateLayerDisplay();
    }

    public LayoutAccess getLayoutAccess() {
        return this.m_layoutAccess;
    }

    public boolean apply() {
        if (this.m_layoutContext != null) {
            return this.m_layoutContext.applyLayoutAccess(this.m_layoutAccess, true);
        }
        return false;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
    }

    public void addLayoutPivotingListener(LayoutPivotingListener l) {
        if (this.m_layoutPivotingListeners == null) {
            this.m_layoutPivotingListeners = new Vector();
        }
        this.m_layoutPivotingListeners.addElement(l);
    }

    public void removeLayoutPivotingListener(LayoutPivotingListener l) {
        if (this.m_layoutPivotingListeners != null) {
            this.m_layoutPivotingListeners.removeElement(l);
        }
    }

    @Override
    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            return this.getClass().getName() + "_PageCtrl";
        }
        return this.getClass().getName() + "_NoPageCtrl";
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void viewDataChanged(DataChangedEvent e) {
        this.setDataAccess(e.getDataAccess());
    }

    public void viewDataAvailable(DataAvailableEvent e) {
        this.setDataAccess(e.getDataAccess());
    }

    public void waitDataAvailable(WaitDataAvailableEvent e) {
    }

    public void pollingRequired(PollingRequiredEvent polling) {
    }

    @Override
    public boolean isShowing() {
        boolean flag = super.isShowing();
        if (flag && this.m_statusLabel != null) {
            this.m_statusLabel.setText("");
        }
        return flag;
    }

    public void setMemberMetadataLabelType(String type) {
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid member metadata label type", this.getClass().getName(), "public void setMemberMetadataLabelType(String type)");
            }
            return;
        }
        this.m_memberMetadataLabelType = type;
        if (this.m_dataAccess != null) {
            this.updateLayerDisplay();
        }
    }

    public String getMemberMetadataLabelType() {
        return this.m_memberMetadataLabelType;
    }

    public void setLayerMetadataLabelType(String type) {
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid layer metadata label type", this.getClass().getName(), "public void setLayerMetadataLabelType(String type)");
            }
            return;
        }
        this.m_layerMetadataLabelType = type;
        if (this.m_dataAccess != null) {
            this.updateLayerDisplay();
        }
    }

    public String getLayerMetadataLabelType() {
        return this.m_layerMetadataLabelType;
    }

    public void hidePagingControlOptions() {
        this.m_hidePagingControl = true;
        this.showPagingControlOptions(false);
    }

    public void showPagingControl(boolean bVisible) {
        if (this.getPagingControlPanel() != null) {
            this.getPagingControlPanel().setVisible(bVisible);
        }
        this.revalidate();
    }

    public void showPagingControlOptions(boolean bVisible) {
        if (this.getPagingControlPanelOptions() != null) {
            this.getPagingControlPanelOptions().setVisible(bVisible);
        }
        this.setPagingControlVisible(bVisible);
        this.revalidate();
    }

    public MultiLineLabel getMultiLineLabelDescription() {
        return this.m_multiLineLabelDescription;
    }

    public LayoutPagingComponent getLayoutPagingComponent() {
        return this.m_pageEdgeLayers;
    }

    protected void setMultiLineLabelDescription(MultiLineLabel multiLineLabelDescription) {
        this.m_multiLineLabelDescription = multiLineLabelDescription;
    }

    public void updateTextUsingCorrectLocale() {
        this.getMultiLineLabelDescription().setText(this.getDescriptionText());
        this.m_showPageItemsChkBox.setText(StringUtils.stripMnemonic((String)this.m_rBundle.getString("Show Page Items")));
        this.m_showPageItemsChkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rBundle.getString("Show Page Items")));
        this.m_rPageItems = this.m_rBundle.getString("Page items:");
        this.m_pagingLabel.setText(StringUtils.stripMnemonic((String)this.m_rPageItems));
        this.m_pagingLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rPageItems));
        this.m_popupManager.updateTextUsingCorrectLocale();
    }

    public void resizeDescriptionLabel() {
        int textwidth = this.getToolkit().getFontMetrics(this.getMultiLineLabelDescription().getFont()).stringWidth(this.getMultiLineLabelDescription().getText());
        int rows = 1;
        if (this.getSize().width < textwidth + 20) {
            rows = textwidth / (this.getSize().width - 20);
            int mod = Math.abs(textwidth / (this.getSize().width - 20));
            if (mod > 0) {
                ++rows;
            }
        }
        this.getMultiLineLabelDescription().setPreferredRows(rows);
        this.getMultiLineLabelDescription().setMinimumRows(this.getMultiLineLabelDescription().getPreferredRows());
        this.getMultiLineLabelDescription().setMaximumRows(this.getMultiLineLabelDescription().getPreferredRows());
    }

    protected boolean performPivot(int fromEdge, int toEdge, int fromLayer, int toLayer, boolean isPivot) {
        block14: {
            int flags = -1;
            try {
                boolean pivotOK;
                if (isPivot) {
                    if (fromEdge == toEdge) {
                        flags = fromLayer < toLayer ? 3 : 2;
                    } else {
                        int layerCount = 0;
                        if (toEdge < this.m_dataAccess.getEdgeCount()) {
                            try {
                                layerCount = this.m_dataAccess.getLayerCount(toEdge);
                            }
                            catch (EdgeOutOfRangeException e) {
                                return false;
                            }
                        }
                        if (toLayer == 0 && layerCount == 0) {
                            flags = 4;
                        } else if (toLayer >= layerCount) {
                            --toLayer;
                            flags = 3;
                        } else {
                            flags = 2;
                        }
                    }
                } else {
                    flags = 1;
                }
                if (this.m_dataDirector != null && (pivotOK = this.m_dataDirector.pivotOK(fromEdge, toEdge, fromLayer, toLayer, flags))) {
                    return this.m_dataDirector.pivot(fromEdge, toEdge, fromLayer, toLayer, flags);
                }
            }
            catch (Exception ex) {
                if (this.m_eh == null) break block14;
                this.m_eh.error((Throwable)ex, this.getClass().getName(), m_method_pPivot);
            }
        }
        return false;
    }

    protected void addLayersToPagingComponent(PagingComponent pagingComponent, int edge, boolean bRefresh, boolean bAddMeasureDimension) {
        this.addLayersToPagingComponent(pagingComponent, edge, bRefresh, bAddMeasureDimension, true);
    }

    protected void addLayersToPagingComponent(PagingComponent pagingComponent, int edge, boolean bRefresh, boolean bAddMeasureDimension, boolean bAddTimeDimension) {
        boolean bCheckForMeasureDimension = false;
        boolean measureLayer = false;
        if (pagingComponent != null) {
            if (bRefresh) {
                pagingComponent.removeAll();
            }
            if (!bAddMeasureDimension && edge == this.m_layoutAccess.getMeasureEdge()) {
                bCheckForMeasureDimension = true;
            }
            Vector vLayers = this.getEdgeLayers(edge);
            int i = 0;
            Enumeration layers = vLayers.elements();
            while (layers.hasMoreElements()) {
                block10: {
                    String strLayer = (String)layers.nextElement();
                    try {
                        if (!bAddTimeDimension && this.m_layoutAccess.isSpecialDimension(edge, i, "time")) {
                            ++i;
                            continue;
                        }
                        if (!bCheckForMeasureDimension || !this.m_layoutAccess.isSpecialDimension(edge, i, "measure")) {
                            pagingComponent.add((Component)((Object)new LayoutPageItem((String)this.m_vLayerNames.elementAt(i), strLayer)));
                        }
                    }
                    catch (Throwable t) {
                        if (this.m_eh == null) break block10;
                        this.m_eh.error(t, this.getClass().getName(), "addLayersToPagingComponent");
                    }
                }
                ++i;
            }
        }
        if (this.m_pageEdgeLayers != null && this.m_pageEdgeLayers.getItems().length != 0) {
            this.getPagingControlPanel().setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getPagingControlPanel().getPreferredSize().height));
            this.getPagingControlPanel().setMaximumSize(this.getPagingControlPanel().getPreferredSize());
            this.getPagingControlPanel().setMinimumSize(this.getPagingControlPanel().getPreferredSize());
        } else {
            this.getPagingControlPanel().setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_pagingLabel.getFont()).getHeight() + 23));
            this.getPagingControlPanel().setMaximumSize(this.getPagingControlPanel().getPreferredSize());
            this.getPagingControlPanel().setMinimumSize(this.getPagingControlPanel().getPreferredSize());
        }
    }

    protected Vector getEdgeLayers(int edge) {
        Vector<String> vLayers;
        block3: {
            vLayers = new Vector<String>();
            try {
                int layerCount = this.m_dataAccess == null ? 0 : this.m_dataAccess.getLayerCount(edge);
                this.m_vLayerNames = new Vector();
                for (int i = 0; i < layerCount; ++i) {
                    Object layerName = this.m_dataAccess.getLayerMetadata(edge, i, "layerName");
                    Object layerLongLabel = this.m_dataAccess.getLayerMetadata(edge, i, this.getLayerMetadataLabelType());
                    if (layerName == null || layerLongLabel == null) continue;
                    vLayers.addElement(layerLongLabel.toString());
                    this.m_vLayerNames.addElement(layerName.toString());
                }
            }
            catch (Throwable t) {
                if (this.m_eh == null) break block3;
                this.m_eh.error(t, this.getClass().getName(), m_method_getELayers);
            }
        }
        return vLayers;
    }

    protected void updateLayerDisplay() {
        this.initHiddenDimensions();
    }

    protected void initHiddenDimensions() {
        block5: {
            this.m_hiddenDimensions = new Vector();
            if (this.m_dataAccess != null) {
                int edgeCount = this.m_dataAccess.getEdgeCount();
                try {
                    if (4 < edgeCount) {
                        int layerCount = this.m_dataAccess.getLayerCount(4);
                        for (int i = 0; i < layerCount; ++i) {
                            Object layerName = this.m_dataAccess.getLayerMetadata(4, i, "layerName");
                            if (layerName == null) continue;
                            this.m_hiddenDimensions.addElement(new String(layerName.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    if (this.m_eh == null) break block5;
                    this.m_eh.error((Throwable)e, this.getClass().getName(), m_method_initHDims);
                }
            }
        }
    }

    protected JPanel createPagingComponentPanel(PagingComponent pc, JLabel l, boolean bEnableScrolling) {
        JPanel p = new JPanel();
        p.setAlignmentX(0.0f);
        p.setLayout(new BoxLayout(p, 0));
        l.setLabelFor((Component)((Object)pc));
        p.add(l);
        p.add(Box.createHorizontalStrut(10));
        pc.setSwapAllowed(true);
        pc.addPivotListener(this.m_pageComponentListener);
        if (bEnableScrolling) {
            this.arrowBox = new ArrowBox((Component)((Object)pc));
            p.add((Component)this.arrowBox);
        } else {
            p.add((Component)((Object)pc));
        }
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return p;
    }

    protected void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.m_rBundle = ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle", loc);
            this.updateTextUsingCorrectLocale();
        } else {
            this.m_rBundle = ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle");
        }
    }

    protected boolean processLayoutPivotingEvent(Object source, Object destination, int fromLayer, int toLayer, boolean isPivot) {
        if (source != null && source instanceof LayoutComponent) {
            LayoutPivotingEvent e;
            int fromEdge = ((LayoutComponent)source).getEdge();
            int toEdge = 4;
            if (destination != null && destination instanceof LayoutComponent) {
                toEdge = ((LayoutComponent)destination).getEdge();
            }
            if (!this.fireLayoutPivotingEvent(e = new LayoutPivotingEvent(this, fromEdge, toEdge, fromLayer, toLayer, !isPivot))) {
                return false;
            }
            if (!this.m_bDelayChangesToLayoutAccess) {
                this.performPivot(fromEdge, toEdge, fromLayer, toLayer, isPivot);
                this.fireLayoutPivotedEvent(e);
            }
        }
        return true;
    }

    protected void fireLayoutPivotedEvent(LayoutPivotingEvent e) {
        if (this.m_layoutPivotingListeners != null) {
            Enumeration listeners = this.m_layoutPivotingListeners.elements();
            while (listeners.hasMoreElements()) {
                ((LayoutPivotingListener)listeners.nextElement()).layoutPivoted(e);
            }
        }
    }

    protected boolean fireLayoutPivotingEvent(LayoutPivotingEvent e) {
        if (this.m_layoutPivotingListeners != null) {
            Enumeration listeners = this.m_layoutPivotingListeners.elements();
            while (listeners.hasMoreElements()) {
                ((LayoutPivotingListener)listeners.nextElement()).layoutPivoting(e);
                if (!e.isConsumed()) continue;
                return false;
            }
        }
        return true;
    }

    protected int getCanPivot(int edge, int layer) {
        int iPivotSupported;
        block6: {
            iPivotSupported = 1;
            if (this.m_bCanPivotSupported) {
                try {
                    Object oPivotSupported = this.m_dataAccess.getLayerMetadata(edge, layer, "dimCanPivot");
                    if (oPivotSupported != null && oPivotSupported instanceof Integer) {
                        iPivotSupported = (Integer)oPivotSupported;
                    }
                }
                catch (EdgeOutOfRangeException eoore) {
                    if (this.m_eh != null) {
                        this.m_eh.log("edge out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), "createPopup");
                    }
                }
                catch (LayerOutOfRangeException loore) {
                    if (this.m_eh == null) break block6;
                    this.m_eh.log("layer out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), "createPopup");
                }
            }
        }
        return iPivotSupported;
    }

    private void init() {
        this.updateResourceBundle(null);
        this.m_pageComponentListener = new PageComponentListener();
        this.m_popupManager = new PopupManager(this.m_pageComponentListener);
        this.m_popupManager.setShowHideMenuItem(this.isHideAvailable());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setTopPanel(new JPanel());
        this.getTopPanel().setLayout(new BoxLayout(this.getTopPanel(), 1));
        this.setMultiLineLabelDescription(new MultiLineLabel(WordWrapper.getTextWrapper(), null));
        this.getMultiLineLabelDescription().setPreferredAspectRatio(0.0f);
        this.getMultiLineLabelDescription().setAlignmentX(0.0f);
        this.getTopPanel().add((Component)this.getMultiLineLabelDescription());
        this.getTopPanel().add(Box.createVerticalStrut(15));
        this.m_showPageItemsChkBox = new JCheckBox();
        this.m_showPageItemsChkBox.setName("ShowPageItems");
        this.m_showPageItemsChkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Layout.this.setPagingControlVisible(e.getStateChange() == 1);
            }
        });
        this.setPagingControlPanelOptions(new JPanel());
        this.getPagingControlPanelOptions().setLayout(new BoxLayout(this.getPagingControlPanelOptions(), 0));
        this.getPagingControlPanelOptions().setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_showPageItemsChkBox.getPreferredSize().height));
        this.getPagingControlPanelOptions().setMaximumSize(this.getPagingControlPanelOptions().getPreferredSize());
        this.getPagingControlPanelOptions().setMinimumSize(this.getPagingControlPanelOptions().getPreferredSize());
        this.getPagingControlPanelOptions().add(this.m_showPageItemsChkBox);
        this.getPagingControlPanelOptions().setAlignmentX(0.0f);
        this.getTopPanel().add(this.getPagingControlPanelOptions());
        this.m_pageEdgeLayers = new LayoutPagingComponent(2);
        this.m_pageEdgeLayers.setName("PageItems");
        this.m_pagingLabel = new JLabel();
        this.setPagingControlPanel(this.createPagingComponentPanel(this.m_pageEdgeLayers, this.m_pagingLabel, this.isScrollingEnabled()));
        this.m_pageEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_pageEdgeLayers.setMouseListener(this.m_popupManager);
        this.getTopPanel().add(this.getPagingControlPanel());
        this.m_showPageItemsChkBox.setSelected(true);
        this.statusBar = new StatusBar();
        this.m_statusLabel = new JLabel(){

            @Override
            public void setText(String text) {
                if (text == this.getText()) {
                    return;
                }
                String oldName = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
                }
            }
        };
        this.statusBar.setAlignmentX(0.0f);
        this.statusBar.setPreferredSize(new Dimension(0, 0));
        this.statusBar.setMinimumSize(this.statusBar.getPreferredSize());
        this.statusBar.setMaximumSize(this.statusBar.getPreferredSize());
        this.statusBar.add((Component)this.m_statusLabel);
        this.statusBar.setVisible(false);
        this.add((Component)this.statusBar);
        ComponentAdapter m_componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (Layout.this.getDescriptionText() != null) {
                    Layout.this.m_statusLabel.setText(Layout.this.getDescriptionText());
                }
            }
        };
        this.addComponentListener(m_componentListener);
        AncestorListener m_ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (Layout.this.getDescriptionText() != null) {
                    Layout.this.m_statusLabel.setText(Layout.this.getDescriptionText());
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        };
        this.addAncestorListener(m_ancestorListener);
    }

    private void setDataAccess(DataAccess da) {
        LayerMetadataMap layerMap;
        this.m_dataAccess = da;
        if (!this.m_bDelayChangesToLayoutAccess) {
            this.updateLayerDisplay();
        }
        if (this.m_dataDirector != null && (layerMap = this.m_dataDirector.getSupportedLayerMetadataMap()) != null) {
            this.m_bCanPivotSupported = layerMap.contains((Object)"dimCanPivot");
        }
    }

    private boolean _isMemberMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("label") || type.equals("mediumName") || type.equals("value") || type.equals("shortName");
    }

    private boolean _isLayerMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("layerLabel") || type.equals("dimMediumName") || type.equals("layerName") || type.equals("dimShortName");
    }

    private class EnterToSpaceMenu
    extends JMenu {
        public EnterToSpaceMenu(String strText) {
            super(strText);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.setKeyCode(32);
            }
            super.processKeyEvent(e);
        }
    }

    public class PageComponentListener
    implements PagingPivotListener {
        public void pivot(PagingPivotEvent e) {
            this.processPagingPivotEvent(e, true);
        }

        public void swap(PagingPivotEvent e) {
            this.processPagingPivotEvent(e, false);
        }

        private void processPagingPivotEvent(PagingPivotEvent e, boolean isPivot) {
            int toLayer;
            int fromLayer;
            Object eventDestination;
            if (e.getSourceIndex() == -1 || e.getDestinationIndex() == -1) {
                return;
            }
            Object eventSource = e.getSource();
            if (!Layout.this.processLayoutPivotingEvent(eventSource, eventDestination = e.getDestination(), fromLayer = e.getSourceIndex(), toLayer = e.getDestinationIndex(), isPivot)) {
                return;
            }
            if (Layout.this.m_bDelayChangesToLayoutAccess) {
                PagingComponent source = (PagingComponent)eventSource;
                PagingComponent destination = (PagingComponent)eventDestination;
                LayoutPageItem sourceItem = (LayoutPageItem)source.getItem(e.getSourceIndex());
                if (isPivot) {
                    source.remove((Component)((Object)sourceItem));
                    if (destination != null) {
                        if (source == destination) {
                            destination.add((Component)((Object)sourceItem), e.getDestinationIndex());
                        } else {
                            destination.add((Component)((Object)new LayoutPageItem(sourceItem.getName(), sourceItem.getText())), e.getDestinationIndex());
                        }
                    }
                } else {
                    LayoutPageItem destinationItem = (LayoutPageItem)destination.getItem(e.getDestinationIndex());
                    source.remove((Component)((Object)sourceItem));
                    destination.remove((Component)((Object)destinationItem));
                    if (source != destination) {
                        source.add((Component)((Object)new LayoutPageItem(destinationItem.getName(), destinationItem.getText())), e.getSourceIndex());
                        destination.add((Component)((Object)new LayoutPageItem(sourceItem.getName(), sourceItem.getText())), e.getDestinationIndex());
                    } else if (e.getSourceIndex() > e.getDestinationIndex()) {
                        destination.add((Component)((Object)sourceItem), e.getDestinationIndex());
                        source.add((Component)((Object)destinationItem), e.getSourceIndex());
                    } else {
                        source.add((Component)((Object)destinationItem), e.getSourceIndex());
                        destination.add((Component)((Object)sourceItem), e.getDestinationIndex());
                    }
                }
            }
        }
    }

    public class PopupManager
    extends MouseAdapter
    implements ActionListener {
        private String moveTo = "";
        private String moveAbove = "";
        private String moveBelow = "";
        private String moveLeft = "";
        private String moveRight = "";
        private String hide = "";
        private String swap = "";
        private Object[] lcs = new Object[5];
        private String[] lcNames = new String[5];
        private PagingPivotListener m_pagingPivotListener;
        private PivotListener m_pivotListener;
        private boolean m_showHideMenuItem = true;

        public void updateTextUsingCorrectLocale() {
            this.moveTo = Layout.this.m_rBundle.getString("Move to");
            this.moveAbove = Layout.this.m_rBundle.getString("Move above");
            this.moveBelow = Layout.this.m_rBundle.getString("Move below");
            this.moveLeft = Layout.this.m_rBundle.getString("Move left");
            this.moveRight = Layout.this.m_rBundle.getString("Move right");
            this.hide = Layout.this.m_rBundle.getString("Hide");
            this.swap = Layout.this.m_rBundle.getString("Swap with");
            this.setPageName(Layout.this.m_rBundle.getString("Page"));
        }

        public void setShowHideMenuItem(boolean b) {
            this.m_showHideMenuItem = b;
        }

        public boolean isShowHideMenuItem() {
            return this.m_showHideMenuItem;
        }

        public void setPivotListener(PivotListener pl) {
            this.m_pivotListener = pl;
        }

        public void setPageLayoutComponent(LayoutComponent lc) {
            this.lcs[0] = lc;
        }

        public void setRowLayoutComponent(LayoutComponent lc) {
            this.lcs[1] = lc;
        }

        public void setColumnLayoutComponent(LayoutComponent lc) {
            this.lcs[2] = lc;
        }

        public void setMeasureLayoutComponent(LayoutComponent lc) {
            this.lcs[3] = lc;
        }

        public void setHiddenLayoutComponent(LayoutComponent lc) {
            this.lcs[4] = lc;
        }

        public void setPageName(String name) {
            this.lcNames[0] = name;
        }

        public void setRowName(String name) {
            this.lcNames[1] = name;
        }

        public void setColumnName(String name) {
            this.lcNames[2] = name;
        }

        public void setMeasureName(String name) {
            this.lcNames[3] = name;
        }

        public void setHiddenName(String name) {
            this.lcNames[4] = name;
        }

        public PopupManager() {
        }

        public PopupManager(PagingPivotListener pagingPivotListener) {
            this();
            this.m_pagingPivotListener = pagingPivotListener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("SHOW_POPUP")) {
                Component component = (Component)e.getSource();
                LayoutComponent layoutComponent = this.getLayoutComponent(component);
                if (layoutComponent != null) {
                    Point point = new Point(0, component.getHeight());
                    if (component instanceof PageItem) {
                        PageItem pageItem = (PageItem)component;
                        this.createPopup(layoutComponent, pageItem.getText(), (JComponent)pageItem, point);
                    } else if (component instanceof LayoutPageItem) {
                        LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)component);
                        this.createPopup(layoutComponent, layoutPageItem.getText(), (JComponent)((Object)layoutPageItem), point);
                    }
                }
            } else if (e.getSource() instanceof PivotMenuItem) {
                Object event = ((PivotMenuItem)e.getSource()).getPivotEvent();
                if (event instanceof PagingPivotEvent) {
                    PagingPivotEvent ppe = (PagingPivotEvent)event;
                    if (ppe.getID() == 2002) {
                        this.m_pagingPivotListener.swap(ppe);
                    } else if (ppe.getID() == 2001) {
                        this.m_pagingPivotListener.pivot(ppe);
                    }
                } else if (event instanceof PivotEvent) {
                    PivotEvent pe = (PivotEvent)event;
                    if (pe.getID() == 2002) {
                        this.m_pivotListener.swap(pe);
                    } else if (pe.getID() == 2001) {
                        this.m_pivotListener.pivot(pe);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Container componentParent;
            LayoutComponent layoutComponent;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (layoutComponent = this.getLayoutComponent(componentParent = ((Component)mouseEvent.getSource()).getParent())) != null) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (componentParent instanceof PageItem) {
                    PageItem pageItem = (PageItem)componentParent;
                    this.createPopup(layoutComponent, pageItem.getText(), (JComponent)pageItem, point);
                } else if (componentParent instanceof LayoutPageItem) {
                    LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)componentParent);
                    this.createPopup(layoutComponent, layoutPageItem.getText(), (JComponent)((Object)layoutPageItem), point);
                }
            }
        }

        public LayoutComponent getLayoutComponent(Component component) {
            LayoutComponent layoutComponent = null;
            if (component instanceof PageItem) {
                PageItem pageItem = (PageItem)component;
                layoutComponent = (LayoutComponent)((Object)pageItem.getParent());
            } else if (component instanceof LayoutPageItem) {
                LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)component);
                layoutComponent = (LayoutComponent)((Object)layoutPageItem.getParent());
            }
            return layoutComponent;
        }

        public boolean isHidePageControl() {
            return Layout.this.m_hidePagingControl;
        }

        public void createPopup(LayoutComponent lc, String currentItem, JComponent sourceComponent, Point point) {
            PivotMenuItem menuItem;
            Object event;
            int j;
            boolean isMeasureDimension;
            int i;
            int sourceIndex;
            JPopupMenu pm;
            PivotInfo[] items;
            String strDataLabels;
            block32: {
                strDataLabels = Layout.this.m_rBundle != null ? Layout.this.m_rBundle.getString("Data Labels") : null;
                items = null;
                String[] layoutItems = null;
                String dimensionName = currentItem;
                pm = new JPopupMenu();
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                layoutItems = lc.getItems();
                sourceIndex = -1;
                for (i = 0; i < layoutItems.length; ++i) {
                    if (!layoutItems[i].equals(currentItem)) continue;
                    sourceIndex = i;
                    break;
                }
                if (Layout.this.getCanPivot(lc.getEdge(), sourceIndex) == 0) {
                    return;
                }
                isMeasureDimension = false;
                if (Layout.this.m_layoutAccess != null) {
                    try {
                        if (lc != null && Layout.this.m_layoutAccess.isSpecialDimension(lc.getEdge(), sourceIndex, "measure")) {
                            isMeasureDimension = true;
                        }
                    }
                    catch (Exception e) {
                        if (Layout.this.m_eh == null) break block32;
                        Layout.this.m_eh.error((Throwable)e, this.getClass().getName(), "createPopup");
                    }
                }
            }
            String st = this.swap;
            EnterToSpaceMenu subMenu = new EnterToSpaceMenu(st);
            for (j = 0; j < this.lcs.length; ++j) {
                if (this.lcs[j] == null || (lc instanceof DataPointGrid || !(this.lcs[j] instanceof RowHeader) && !(this.lcs[j] instanceof ColumnHeader) && !(this.lcs[j] instanceof PagingComponent) && !(this.lcs[j] instanceof LayoutSpreadTable)) && (!(this.lcs[j] instanceof DataPointGrid) || this.lcs[j] != lc && !Layout.this.isAllowDataPointGrid())) continue;
                items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, false);
                for (i = 0; items != null && i < items.length; ++i) {
                    event = this.lcs[j] instanceof PagingComponent ? new PagingPivotEvent((Object)lc, 2002, this.lcs[j], sourceIndex, items[i].getIndex()) : new PivotEvent((Object)lc, 2002, this.lcs[j], sourceIndex, items[i].getIndex());
                    if (lc.getEdge() == 4 && Layout.this.isAllowDataPointGrid() && strDataLabels.equals(items[i].getText())) continue;
                    menuItem = new PivotMenuItem(items[i].getText());
                    menuItem.setPivotEvent(event);
                    menuItem.addActionListener(this);
                    subMenu.add(menuItem);
                }
            }
            if (items != null && items.length > 0) {
                pm.add(subMenu);
            }
            String leftString = this.moveLeft;
            String rightString = this.moveRight;
            String aboveString = this.moveAbove;
            String belowString = this.moveBelow;
            EnterToSpaceMenu leftMenu = new EnterToSpaceMenu(leftString);
            EnterToSpaceMenu rightMenu = new EnterToSpaceMenu(rightString);
            EnterToSpaceMenu aboveMenu = new EnterToSpaceMenu(aboveString);
            EnterToSpaceMenu belowMenu = new EnterToSpaceMenu(belowString);
            boolean leftMenuHasItems = false;
            boolean rightMenuHasItems = false;
            boolean aboveMenuHasItems = false;
            boolean belowMenuHasItems = false;
            for (j = 0; j < this.lcs.length; ++j) {
                if (this.lcs[j] == null || (lc instanceof DataPointGrid || this.lcs[j] instanceof DataPointGrid) && (!(this.lcs[j] instanceof DataPointGrid) || this.lcs[j] != lc && !Layout.this.isAllowDataPointGrid())) continue;
                if (this.lcs[j] instanceof RowHeader || this.lcs[j] instanceof LayoutSpreadTable) {
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex()) continue;
                        leftMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex());
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        leftMenu.add(menuItem);
                    }
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex() + 1) continue;
                        rightMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex() + 1);
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        rightMenu.add(menuItem);
                    }
                    continue;
                }
                if (this.lcs[j] instanceof PagingComponent) {
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex()) continue;
                        leftMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PagingPivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex());
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        leftMenu.add(menuItem);
                    }
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex() + 1) continue;
                        rightMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PagingPivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex() + 1);
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        rightMenu.add(menuItem);
                    }
                    continue;
                }
                if (this.lcs[j] instanceof ColumnHeader) {
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex()) continue;
                        aboveMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex());
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        aboveMenu.add(menuItem);
                    }
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex() + 1) continue;
                        belowMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex() + 1);
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        belowMenu.add(menuItem);
                    }
                    continue;
                }
                if (!(this.lcs[j] instanceof DataPointGrid)) continue;
                DataPointGrid measureItems = (DataPointGrid)this.lcs[j];
                if (measureItems.getOrientation() == 0) {
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex()) continue;
                        leftMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex());
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        leftMenu.add(menuItem);
                    }
                    items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                    for (i = 0; items != null && i < items.length; ++i) {
                        if (this.lcs[j] == lc && sourceIndex == items[i].getIndex() + 1) continue;
                        rightMenuHasItems = true;
                        menuItem = new PivotMenuItem(items[i].getText());
                        event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex() + 1);
                        menuItem.setPivotEvent(event);
                        menuItem.addActionListener(this);
                        rightMenu.add(menuItem);
                    }
                    continue;
                }
                if (measureItems.getOrientation() != 1) continue;
                items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                for (i = 0; items != null && i < items.length; ++i) {
                    if (this.lcs[j] == lc && sourceIndex == items[i].getIndex()) continue;
                    aboveMenuHasItems = true;
                    menuItem = new PivotMenuItem(items[i].getText());
                    event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex());
                    menuItem.setPivotEvent(event);
                    menuItem.addActionListener(this);
                    aboveMenu.add(menuItem);
                }
                items = this.getPivotInfoList(((LayoutComponent)this.lcs[j]).getEdge(), ((LayoutComponent)this.lcs[j]).getItems(), currentItem, true);
                for (i = 0; items != null && i < items.length; ++i) {
                    if (this.lcs[j] == lc && sourceIndex == items[i].getIndex() + 1) continue;
                    belowMenuHasItems = true;
                    menuItem = new PivotMenuItem(items[i].getText());
                    event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, items[i].getIndex() + 1);
                    menuItem.setPivotEvent(event);
                    menuItem.addActionListener(this);
                    belowMenu.add(menuItem);
                }
            }
            if (leftMenuHasItems) {
                pm.add(leftMenu);
            }
            if (rightMenuHasItems) {
                pm.add(rightMenu);
            }
            if (aboveMenuHasItems) {
                pm.add(aboveMenu);
            }
            if (belowMenuHasItems) {
                pm.add(belowMenu);
            }
            boolean bSkipDataPointGrid = false;
            for (j = 0; j < this.lcs.length; ++j) {
                if (this.lcs[j] == null) continue;
                if (!Layout.this.isAllowDataPointGrid()) {
                    boolean bl = bSkipDataPointGrid = this.lcs[j] instanceof DataPointGrid && lc instanceof DataPointGrid;
                }
                if (this.lcs[j] == lc || bSkipDataPointGrid) continue;
                st = this.moveTo;
                st = MessageFormat.format(st, this.lcNames[j]);
                menuItem = new PivotMenuItem(st);
                if (this.lcs[j] instanceof PagingComponent) {
                    if (this.isHidePageControl()) continue;
                    event = new PagingPivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, 0);
                    menuItem.setPivotEvent(event);
                    menuItem.addActionListener(this);
                    pm.add(menuItem);
                    continue;
                }
                event = new PivotEvent((Object)lc, 2001, this.lcs[j], sourceIndex, 0);
                menuItem.setPivotEvent(event);
                menuItem.addActionListener(this);
                pm.add(menuItem);
            }
            if (this.m_showHideMenuItem && !isMeasureDimension) {
                menuItem = new PivotMenuItem(this.hide);
                event = new PagingPivotEvent((Object)lc, 2001, null, sourceIndex, 0);
                menuItem.setPivotEvent(event);
                menuItem.addActionListener(this);
                pm.add(menuItem);
            }
            MenuUtils.showPopupMenu((JPopupMenu)pm, (Component)sourceComponent, (int)point.x, (int)point.y);
        }

        private PivotInfo[] getPivotInfoList(int edge, String[] items, String currentItem, boolean bForPivot) {
            PivotInfo[] retList;
            int i;
            int count = items.length;
            int currentIndex = -1;
            int pivotCount = 0;
            for (i = 0; i < count; ++i) {
                if (currentItem.equals(items[i])) {
                    currentIndex = i;
                }
                if (Layout.this.getCanPivot(edge, i) != 1) continue;
                ++pivotCount;
            }
            int retindex = 0;
            if (bForPivot) {
                if (currentIndex == -1) {
                    retList = new PivotInfo[pivotCount];
                    for (i = 0; i < count; ++i) {
                        if (Layout.this.getCanPivot(edge, i) == 0) continue;
                        PivotInfo pivotInfo = new PivotInfo();
                        pivotInfo.setText(items[i]);
                        pivotInfo.setIndex(i);
                        retList[retindex++] = pivotInfo;
                    }
                } else {
                    retList = new PivotInfo[pivotCount - 1];
                    for (i = 0; i < count; ++i) {
                        if (Layout.this.getCanPivot(edge, i) == 0 || i == currentIndex) continue;
                        PivotInfo pivotInfo = new PivotInfo();
                        pivotInfo.setText(items[i]);
                        if (i < currentIndex) {
                            pivotInfo.setIndex(i);
                        } else {
                            pivotInfo.setIndex(i - 1);
                        }
                        retList[retindex++] = pivotInfo;
                    }
                }
            } else if (currentIndex == -1) {
                retList = new PivotInfo[pivotCount];
                for (i = 0; i < count; ++i) {
                    if (Layout.this.getCanPivot(edge, i) == 0) continue;
                    PivotInfo pivotInfo = new PivotInfo();
                    pivotInfo.setText(items[i]);
                    pivotInfo.setIndex(i);
                    retList[retindex++] = pivotInfo;
                }
            } else {
                retList = new PivotInfo[pivotCount - 1];
                int j = 0;
                for (i = 0; i < count; ++i) {
                    if (Layout.this.getCanPivot(edge, i) == 0 || i == currentIndex) continue;
                    PivotInfo pivotInfo = new PivotInfo();
                    pivotInfo.setText(items[i]);
                    pivotInfo.setIndex(i);
                    retList[j] = pivotInfo;
                    ++j;
                }
                if (j == 0) {
                    retList = null;
                }
            }
            return retList;
        }
    }

    class PivotInfo {
        private String m_text;
        private int m_index;

        PivotInfo() {
        }

        public String getText() {
            return this.m_text;
        }

        public void setText(String text) {
            this.m_text = text;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void setIndex(int index) {
            this.m_index = index;
        }
    }

    class PivotMenuItem
    extends JMenuItem {
        private Object m_pivotEvent;

        public PivotMenuItem(String text) {
            super(text);
            this.m_pivotEvent = null;
        }

        public Object getPivotEvent() {
            return this.m_pivotEvent;
        }

        public void setPivotEvent(Object pe) {
            this.m_pivotEvent = pe;
        }
    }

    public class LayoutPivotListener
    implements PivotListener {
        public void pivot(PivotEvent e) {
            this.processPivotEvent(e, true);
        }

        public void swap(PivotEvent e) {
            this.processPivotEvent(e, false);
        }

        private void processPivotEvent(PivotEvent e, boolean isPivot) {
            Object source = e.getSource();
            Object destination = e.getDestination();
            int fromLayer = e.getSourceIndex();
            int toLayer = e.getDestinationIndex();
            Layout.this.processLayoutPivotingEvent(source, destination, fromLayer, toLayer, isPivot);
        }
    }
}

