/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Crosstab;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class CornerPainter
extends AbstractPainter {
    @CodeSharingSafe(value="StaticField")
    private static Painter _sPainter;

    private CornerPainter() {
    }

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new CornerPainter();
        }
        return _sPainter;
    }

    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(0, 0);
    }

    public int getRepaintFlags(PaintContext context) {
        return 128;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        Object h = context.getPaintData(Crosstab.KEY_HORIZONTAL);
        boolean horizontal = Boolean.TRUE.equals(h);
        Object v = context.getPaintData(Crosstab.KEY_VERTICAL);
        boolean vertical = Boolean.TRUE.equals(v);
        g.setColor(control);
        g.fillRect(x, y, width, height);
        g.setColor(shadow);
        if (vertical) {
            g.drawLine(right, y, right, bottom);
        }
        if (horizontal) {
            g.drawLine(x, bottom, right, bottom);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }
}

