/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.wizard.ListIconRenderer;
import oracle.ideimpl.palette.wizard.PalettePnl__addItemBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__addPageBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__removeItemBtn_actionAdapter;
import oracle.ideimpl.palette.wizard.PalettePnl__removePageBtn_actionAdapter;

public class PalettePnl
extends JPanel
implements ListSelectionListener,
PaletteModelListener {
    private final DefaultListModel _pageModel = new DefaultListModel();
    private final DefaultListModel _componentModel = new DefaultListModel();
    private final PaletteImpl _palette = PaletteImpl.getInstance();
    private final PaletteCommands _commands = new PaletteCommands();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private final JScrollPane _pageScrollPane = new JScrollPane();
    private final JScrollPane _componentScrollPane = new JScrollPane();
    private final JList _pageList = new JList(this._pageModel);
    private final JList _componentList = new JList(this._componentModel);
    private JButton _addPageBtn = new JButton();
    private JButton _removePageBtn = new JButton();
    private JButton _addItemBtn = new JButton();
    private ListIconRenderer renderer = new ListIconRenderer();
    private JButton _removeItemBtn = new JButton();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();

    public PalettePnl() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(380, 400));
        this._pageList.addListSelectionListener(this);
        this._palette.addPaletteModelListener(this);
        this.jLabel1.setText("Pages:");
        this.jLabel2.setText("Components:");
        this._addPageBtn.setText("Add...");
        this._addPageBtn.addActionListener(new PalettePnl__addPageBtn_actionAdapter(this));
        this._removePageBtn.setText("Remove...");
        this._removePageBtn.addActionListener(new PalettePnl__removePageBtn_actionAdapter(this));
        this._addItemBtn.setText("Add Item(s)");
        this._addItemBtn.addActionListener(new PalettePnl__addItemBtn_actionAdapter(this));
        this._removeItemBtn.setText("Remove Item(s)");
        this._removeItemBtn.addActionListener(new PalettePnl__removeItemBtn_actionAdapter(this));
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._pageScrollPane, new GridBagConstraints(0, 1, 4, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._pageScrollPane.getViewport().add((Component)this._pageList, null);
        this.add((Component)this._componentScrollPane, new GridBagConstraints(4, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._componentScrollPane.getViewport().add((Component)this._componentList, null);
        this.add((Component)this._addPageBtn, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._removePageBtn, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._addItemBtn, new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._removeItemBtn, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._componentList.setCellRenderer(this.renderer);
    }

    protected void populatePageList() {
        if (!this._palette.getHasPopulated()) {
            this._palette.populate();
        }
        Iterator iter = this._palette.getChildren();
    }

    private void _populateComponents(String page) {
        if (page != null) {
            this._componentModel.removeAllElements();
            PalettePage pg = this._palette.getPalettePage(page);
            for (PaletteItem item : pg.getPaletteItems()) {
                ImageIcon icon = (ImageIcon)item.getIcon();
                String name = item.getShortLabel();
                icon.setDescription(name);
                this._componentModel.addElement(icon);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._pageModel.getSize() > 0) {
            String pageSelected = (String)this._pageList.getSelectedValue();
            this._populateComponents(pageSelected);
        }
    }

    void addPage(ActionEvent e) {
    }

    void removePage(ActionEvent e) {
        String pageSelected = (String)this._pageList.getSelectedValue();
        if (pageSelected != null) {
            PalettePage activePage = this._palette.getPalettePage(pageSelected);
            this._palette.setActivePage(activePage);
            try {
                boolean removed = this._commands.removePalettePage();
                if (removed) {
                    this._componentModel.removeAllElements();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void addItem(ActionEvent e) {
        try {
            PalettePage activePage = this._palette.getPalettePage((String)this._pageList.getSelectedValue());
            if (activePage != null) {
                this._commands.invokeItemWizard(activePage);
                this._populateComponents((String)this._pageList.getSelectedValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void removeItem(ActionEvent e) {
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        if (icon != null) {
            String name = icon.getDescription();
            int confirm = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to remove \"" + name + "\"?", "Removing Palette Page", 0);
            if (confirm == 0) {
                this._palette.removeItem(name, (String)this._pageList.getSelectedValue());
                this._componentModel.removeElement(icon);
            }
        }
    }

    @Override
    public void palettePageAdded(PalettePage page) {
        this._pageModel.addElement(page.getName());
        this._pageList.setSelectedIndex(0);
        String pageSelected = (String)this._pageList.getSelectedValue();
        this._populateComponents(pageSelected);
    }

    @Override
    public void palettePageRemoved(PalettePage page) {
        this._pageModel.removeElement(this._pageList.getSelectedValue());
    }

    @Override
    public void paletteItemAdded(PaletteItem item) {
    }

    @Override
    public void paletteItemRemoved(PaletteItem item) {
    }

    @Override
    public void palettePageRenamed(String oldname, PalettePage page) {
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
    }
}

