/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.pageprovider;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteTransferable;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.view.View;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.pageprovider.DeclaredPalette1PageProvider;
import oracle.ideimpl.palette.pageprovider.DefaultPalette1Section;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.util.ModelUtil;

public class DeclaredPalette1Pages
extends PalettePages
implements PaletteModelListener,
PaletteListener,
oracle.ide.palette.PaletteListener,
DragSourceListener,
Palette1Provider {
    public static final String DECLAREDPROVIDER_ID = DeclaredPalette1PageProvider.class.getName();
    public static final String ITEM_PALETTE1PAGENAME = "palette1PageName";
    private static DeclaredPalette1Pages _singleton = new DeclaredPalette1Pages();
    protected CopyOnWriteArrayList<PalettePagesListener> palettePagesListeners = new CopyOnWriteArrayList();
    protected List<String> palette1PageExclusions;
    protected List<oracle.ide.palette2.PalettePage> palettePages = new ArrayList<oracle.ide.palette2.PalettePage>();
    protected Context context;
    private PaletteItemImpl palette1ItemImpl;
    private Object _droppedObject = null;
    private PaletteItem palette1PointerItem;
    private Map<String, String> defaultPageMap = new HashMap<String, String>();
    private Map<PaletteItem, PalettePage> palette1PagesByItem = new HashMap<PaletteItem, PalettePage>();

    private DeclaredPalette1Pages() {
        oracle.ideimpl.palette2.PaletteWindowImpl pWindow = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        pWindow.addPaletteListener((PaletteListener)this);
        this.palette1PageExclusions = pWindow.getPalette1PageExclusions();
        this.palette1PointerItem = new PaletteItemImpl(true);
    }

    public static DeclaredPalette1Pages getInstance() {
        return _singleton;
    }

    public void setPageAsDefault(String docExtension, String pageName) {
        this.defaultPageMap.put(docExtension, pageName);
    }

    public String getDefaultPage(String docExtension) {
        return this.defaultPageMap.get(docExtension);
    }

    public void initialize(Context ctxt) {
        Palette palette1;
        PaletteManager palette1Manager;
        this.context = new Context(ctxt);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null) {
            PaletteContext.setEditor(this.context, editor);
        }
        if ((palette1Manager = PaletteManager.getPaletteManager()) != null) {
            palette1Manager.removePaletteListener(this);
            palette1 = palette1Manager.getPalette();
            if (palette1 != null) {
                palette1.removePaletteModelListener(this);
            }
        }
        this.palettePages.clear();
        this.initPages();
        if (palette1Manager != null) {
            palette1Manager.addPaletteListener(this);
            palette1 = palette1Manager.getPalette();
            if (palette1 != null) {
                palette1.addPaletteModelListener(this);
            }
        }
    }

    private void initPages() {
        Palette palette1;
        PaletteManager palette1Manager = PaletteManager.getPaletteManager();
        if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
            Iterator iter = palette1.getPalettePages(this.context);
            while (iter.hasNext()) {
                PalettePageImpl page = (PalettePageImpl)iter.next();
                if (this.excludePage(page)) continue;
                this.addPage(page);
            }
        }
    }

    private boolean excludePage(PalettePageImpl page) {
        boolean ret = false;
        if (page.isPalette1Only()) {
            ret = true;
        } else if (!page.canShow()) {
            ret = true;
        } else {
            String name = page.getShortLabel();
            if (this.palette1PageExclusions != null) {
                for (String p1PageName : this.palette1PageExclusions) {
                    if (!p1PageName.equalsIgnoreCase(name)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    public Collection<oracle.ide.palette2.PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    public oracle.ide.palette2.PaletteItem getItem(String providerId, String itemId) {
        oracle.ide.palette2.PaletteItem paletteItem;
        block2: {
            oracle.ide.palette2.PalettePage palettePage;
            DefaultPalettePage defPage;
            if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
                return null;
            }
            paletteItem = null;
            if (!providerId.equals(DECLAREDPROVIDER_ID)) break block2;
            Iterator<oracle.ide.palette2.PalettePage> iterator = this.palettePages.iterator();
            while (iterator.hasNext() && (paletteItem = (defPage = (DefaultPalettePage)(palettePage = iterator.next())).getItem(itemId)) == null) {
            }
        }
        return paletteItem;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        if (null == listener) {
            return;
        }
        this.palettePagesListeners.addIfAbsent(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        if (null == listener) {
            return;
        }
        this.palettePagesListeners.remove(listener);
        if (this.palettePagesListeners.isEmpty()) {
            this.context = null;
        }
    }

    private List<String> tokenizeString(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            StringTokenizer tkn = new StringTokenizer(text, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                tokens.add(token);
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    private List<DefaultPalettePage.ShowForTypeRecord> tokenizeShowForTypes(String text) {
        ArrayList<DefaultPalettePage.ShowForTypeRecord> tokens = new ArrayList<DefaultPalettePage.ShowForTypeRecord>();
        if (text != null) {
            StringTokenizer tkn = new StringTokenizer(text, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                tokens.add(new DefaultPalettePage.ShowForTypeRecord(token));
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    private void addPage(PalettePage palette1Page) {
        DefaultPalettePage page = this.transformPalette1Page(palette1Page);
        if (!this.palettePages.add((oracle.ide.palette2.PalettePage)page)) {
            return;
        }
        HashSet<DefaultPalettePage> added = new HashSet<DefaultPalettePage>();
        added.add(page);
        Set removed = Collections.emptySet();
        Set updated = Collections.emptySet();
        for (PalettePagesListener l : this.palettePagesListeners) {
            l.palettePagesChanged(added, removed, updated);
        }
    }

    private void removePage(PalettePage palette1Page) {
        for (oracle.ide.palette2.PalettePage palettePage : this.palettePages) {
            if (!palettePage.getName().equals(palette1Page.getShortLabel())) continue;
            this.palettePages.remove(palettePage);
            HashSet<oracle.ide.palette2.PalettePage> removed = new HashSet<oracle.ide.palette2.PalettePage>();
            removed.add(palettePage);
            Set added = Collections.emptySet();
            Set updated = Collections.emptySet();
            for (PalettePagesListener l : this.palettePagesListeners) {
                l.palettePagesChanged(added, removed, updated);
            }
        }
    }

    private DefaultPalettePage transformPalette1Page(PalettePage palette1Page) {
        DefaultPalettePage page = this.findOrCreatePage(palette1Page);
        DefaultPaletteGroup group = this.findOrCreateGroup(palette1Page, page);
        DefaultPalette1Section section = this.findOrCreateSection(palette1Page, group);
        for (PaletteItem item : palette1Page.getPaletteItems()) {
            if (!item.canShow() || null == this.findOrCreateItem(palette1Page, item, section)) continue;
            this.palette1PagesByItem.put(item, palette1Page);
        }
        return page;
    }

    private static String pageNameToPageId(String pageName) {
        return MessageFormat.format("{0}.page.{1}", DECLAREDPROVIDER_ID, pageName);
    }

    private static String pageNameToGroupId(String pageName) {
        return MessageFormat.format("{0}.group.{1}", DeclaredPalette1Pages.pageNameToPageId(pageName), pageName);
    }

    private static String pageNameToSectionId(String pageName) {
        return MessageFormat.format("{0}.section.{1}", DeclaredPalette1Pages.pageNameToGroupId(pageName), pageName);
    }

    private static String pageNameAndItemNameToItemId(String pageName, String itemName) {
        return MessageFormat.format("{0}.item.{1}", DeclaredPalette1Pages.pageNameToSectionId(pageName), itemName);
    }

    @Override
    public void palettePageAdded(PalettePage palette1Page) {
        if (!this.excludePage((PalettePageImpl)palette1Page)) {
            this.addPage(palette1Page);
        }
    }

    @Override
    public void palettePageRemoved(PalettePage palette1Page) {
        if (!this.excludePage((PalettePageImpl)palette1Page)) {
            this.removePage(palette1Page);
        }
    }

    public void refreshPalette() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null) {
            oracle.ideimpl.palette2.PaletteWindowImpl pWindow = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
            pWindow.showType(false, (View)editor);
        }
    }

    @Override
    public void paletteItemAdded(PaletteItem item) {
        if (!item.canShow()) {
            return;
        }
        PalettePage palette1Page = this.getPalette1PageWithItem(item);
        if (null == palette1Page) {
            return;
        }
        this.palette1PagesByItem.put(item, palette1Page);
        DefaultPalettePage page = this.findOrCreatePage(palette1Page);
        DefaultPaletteGroup group = this.findOrCreateGroup(palette1Page, page);
        DefaultPalette1Section section = this.findOrCreateSection(palette1Page, group);
        this.findOrCreateItem(palette1Page, item, section);
        Set added = Collections.emptySet();
        Set removed = Collections.emptySet();
        HashSet<DefaultPalettePage> updated = new HashSet<DefaultPalettePage>();
        updated.add(page);
        for (PalettePagesListener l : this.palettePagesListeners) {
            l.palettePagesChanged(added, removed, updated);
        }
    }

    private PalettePage getPalette1PageWithItem(PaletteItem item) {
        PalettePage page = this.palette1PagesByItem.get(item);
        if (null != page) {
            return page;
        }
        Iterator pages = PaletteImpl.getInstance().getChildren();
        while (pages.hasNext()) {
            page = (PalettePage)pages.next();
            if (page.getPaletteItem(item.getShortLabel()) != item) continue;
            return page;
        }
        return null;
    }

    @Override
    public void paletteItemRemoved(PaletteItem palette1Item) {
        PalettePage palette1Page = this.palette1PagesByItem.remove(palette1Item);
        if (null == palette1Page) {
            return;
        }
        DefaultPalettePage page = this.findOrCreatePage(palette1Page);
        DefaultPaletteGroup group = this.findOrCreateGroup(palette1Page, page);
        DefaultPalette1Section section = this.findOrCreateSection(palette1Page, group);
        DefaultPaletteItem item = this.findOrCreateItem(palette1Page, palette1Item, section);
        section.removeItem((oracle.ide.palette2.PaletteItem)item);
        Set added = Collections.emptySet();
        Set removed = Collections.emptySet();
        HashSet<DefaultPalettePage> updated = new HashSet<DefaultPalettePage>();
        updated.add(page);
        for (PalettePagesListener l : this.palettePagesListeners) {
            l.palettePagesChanged(added, removed, updated);
        }
    }

    @Override
    public void palettePageRenamed(String oldName, PalettePage palette1Page) {
        DefaultPalettePage page = this.findPageByName(oldName);
        if (null == page) {
            return;
        }
        Set added = Collections.emptySet();
        HashSet<DefaultPalettePage> removed = new HashSet<DefaultPalettePage>();
        removed.add(page);
        Set updated = Collections.emptySet();
        for (PalettePagesListener l : this.palettePagesListeners) {
            l.palettePagesChanged(added, removed, updated);
        }
        this.palettePageAdded(palette1Page);
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
        if (!item.canShow()) {
            return;
        }
        PalettePage palette1Page = this.getPalette1PageWithItem(item);
        if (null == palette1Page) {
            return;
        }
        this.palette1PagesByItem.put(item, palette1Page);
        DefaultPalettePage page = this.findOrCreatePage(palette1Page);
        DefaultPaletteGroup group = this.findOrCreateGroup(palette1Page, page);
        DefaultPalette1Section section = this.findOrCreateSection(palette1Page, group);
        this.findOrCreateItem(palette1Page, item, section);
        Set added = Collections.emptySet();
        Set removed = Collections.emptySet();
        HashSet<DefaultPalettePage> updated = new HashSet<DefaultPalettePage>();
        updated.add(page);
        for (PalettePagesListener l : this.palettePagesListeners) {
            l.palettePagesChanged(added, removed, updated);
        }
    }

    public void paletteOpened(oracle.ide.palette2.PaletteEvent event) {
    }

    public void paletteClosed(oracle.ide.palette2.PaletteEvent event) {
    }

    public void selectionChanged(oracle.ide.palette2.PaletteEvent event) {
    }

    public void itemSelected(oracle.ide.palette2.PaletteEvent event) {
        Palette palette1;
        PaletteManager palette1Manager;
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        oracle.ide.palette2.PaletteItem item = window.getSelectedItem();
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID) && (palette1Manager = PaletteManager.getPaletteManager()) != null && (palette1 = PaletteManager.getPaletteManager().getPalette()) != null) {
            String pageName = (String)item.getData((Object)ITEM_PALETTE1PAGENAME);
            PalettePage palette1Page = palette1.getPalettePage(pageName);
            PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
            if (palette1Item == null) {
                if (item.getName().equals("Pointer")) {
                    palette1Item = this.palette1PointerItem;
                } else {
                    return;
                }
            }
            palette1.setActivePage(palette1Page);
            palette1.setActiveItem(palette1Item);
            this.firePalette1ItemPressed(event.getAction());
        }
    }

    public void escapeKeyPressed(oracle.ide.palette2.PaletteItem item) {
        Palette palette1;
        PaletteManager palette1Manager;
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID) && (palette1Manager = PaletteManager.getPaletteManager()) != null && (palette1 = PaletteManager.getPaletteManager().getPalette()) != null) {
            String pageName = (String)item.getData((Object)ITEM_PALETTE1PAGENAME);
            PalettePage palette1Page = palette1.getPalettePage(pageName);
            palette1.setActivePage(palette1Page);
            palette1.setActiveItem(this.palette1PointerItem);
            this.firePalette1ItemPressed("PALETTE2_ITEM_SELECTED");
        }
    }

    private void firePalette1ItemPressed(String action) {
        Palette palette1;
        PaletteManager palette1Manager = PaletteManager.getPaletteManager();
        if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
            PaletteWindowImpl palette1Window = (PaletteWindowImpl)palette1Manager.getPaletteWindow();
            if (action.equals("PALETTE2_ITEM_SELECTED")) {
                palette1Window.fireItemPressed(new PaletteEvent(palette1, "ITEM_PRESSED"));
            } else if (action.equals("PALETTE2_ITEM_DEFAULTCREATE")) {
                palette1Window.fireDefaultCreate(new PaletteEvent(palette1, "CREATE_DEFAULT"));
            }
        }
    }

    public void itemUnselected(oracle.ide.palette2.PaletteEvent event) {
    }

    public void stickyModeActivated(oracle.ide.palette2.PaletteEvent event) {
        this.firePalette1StickyMode(true);
    }

    public void stickyModeDeactivated(oracle.ide.palette2.PaletteEvent event) {
        this.firePalette1StickyMode(false);
    }

    private void firePalette1StickyMode(boolean activate) {
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        oracle.ide.palette2.PaletteItem item = window.getSelectedItem();
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID)) {
            Palette palette1;
            if (item.getName().equals("Pointer")) {
                return;
            }
            PaletteManager palette1Manager = PaletteManager.getPaletteManager();
            if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
                String pageName = (String)item.getData((Object)ITEM_PALETTE1PAGENAME);
                PalettePage palette1Page = palette1.getPalettePage(pageName);
                PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
                palette1.setActivePage(palette1Page);
                palette1.setActiveItem(palette1Item);
                PaletteWindowImpl palette1Window = (PaletteWindowImpl)palette1Manager.getPaletteWindow();
                PaletteController palette1Controller = (PaletteController)palette1Window.getController();
                palette1Controller.setStickyMode(activate);
            }
        }
    }

    public void dragGestureRecognized(DragSource dragSource, DragGestureEvent dge) {
        oracle.ideimpl.palette2.PaletteWindowImpl window;
        oracle.ide.palette2.PaletteItem item;
        boolean rightClick = false;
        InputEvent triggerEvent = dge.getTriggerEvent();
        if (4 == triggerEvent.getModifiers() || 8 == triggerEvent.getModifiers()) {
            rightClick = true;
        }
        if ((item = (window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance()).getSelectedItem()) != null && item.getProviderId().equals(DECLAREDPROVIDER_ID)) {
            if (item.getName().equals("Pointer")) {
                return;
            }
            if (item instanceof DefaultPaletteItem) {
                AugmentableTransferable transferable = TransferUtils.createTransferable();
                if (dge != null) {
                    DndUtils.addTriggerEvent((AugmentableTransferable)transferable, (InputEvent)dge.getTriggerEvent());
                }
                transferable.augment(oracle.ide.palette2.PaletteItem.PALETTE_ITEM_FLAVOR, (Object)item, 0.5f, null);
                Object data = item.getData((Object)"DnDTransferData");
                if (data instanceof TransferDataInfo[]) {
                    for (TransferDataInfo d : (TransferDataInfo[])data) {
                        transferable.augment(d);
                    }
                }
                dragSource.startDrag(dge, null, (Transferable)transferable, this);
            } else {
                Palette palette1;
                PaletteManager palette1Manager = PaletteManager.getPaletteManager();
                if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
                    String pageName = (String)item.getData((Object)ITEM_PALETTE1PAGENAME);
                    PalettePage palette1Page = palette1.getPalettePage(pageName);
                    PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
                    this.palette1ItemImpl = (PaletteItemImpl)palette1Item;
                    palette1.setActivePage(palette1Page);
                    palette1.setActiveItem(palette1Item);
                    this._droppedObject = null;
                    dragSource.startDrag(dge, null, this.palette1ItemImpl, this);
                }
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        PaletteControllerUI controller;
        PaletteItemUI itemUI;
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        if (dsde.getDropSuccess()) {
            PaletteItemImpl element = this.palette1ItemImpl;
            Element[] elems = new Element[]{this.palette1ItemImpl};
            Context context = new Context((Element)element);
            context.setSelection(elems);
            View editor = window.getEditor();
            if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
                context.setNode(editor.getContext().getNode());
                context.setProject(editor.getContext().getProject());
                context.setWorkspace(editor.getContext().getWorkspace());
            }
            if (null != this.palette1ItemImpl) {
                this.palette1ItemImpl.paletteInvokeConfigure(context);
            }
            if (this._droppedObject != null && this._droppedObject instanceof PaletteTransferable) {
                ((PaletteTransferable)this._droppedObject).postConfigure(context);
            }
        }
        if ((itemUI = (controller = PaletteControllerUI.getInstance()).getSelectedItemUI()) != null) {
            itemUI.showAsUnselected();
        }
        controller.setSelectedWindowUI((PaletteItemUI)null);
    }

    @Override
    public void paletteOpened(PaletteEvent event) {
    }

    @Override
    public void paletteClosed(PaletteEvent event) {
    }

    @Override
    public void selectionChanged(PaletteEvent event) {
    }

    @Override
    public void itemPressed(PaletteEvent event) {
        if (event.getAction().equals("ITEM_UNPRESSED")) {
            PaletteWindow window = oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
            window.unSelectSelectedItem();
        }
    }

    @Override
    public void stickyModeActivated(PaletteEvent event) {
    }

    @Override
    public void stickyModeDeactivated(PaletteEvent event) {
    }

    public oracle.ide.palette2.PalettePage getPreferredPage() {
        return super.getPreferredPage();
    }

    public float getPreferredPageRank() {
        return super.getPreferredPageRank();
    }

    private DefaultPalettePage findOrCreatePage(PalettePage palette1Page) {
        if (null == palette1Page) {
            return null;
        }
        String pageName = palette1Page.getName();
        DefaultPalettePage page = this.findPageByName(pageName);
        if (null != page) {
            return page;
        }
        String types = palette1Page.getShowForTypes();
        List<DefaultPalettePage.ShowForTypeRecord> records = this.tokenizeShowForTypes(types);
        String technologyScopes = palette1Page.getTechnologyScope();
        List<String> scopes = this.tokenizeString(technologyScopes);
        String pageId = DeclaredPalette1Pages.pageNameToPageId(pageName);
        DefaultPalettePage.Builder pageBuilder = new DefaultPalettePage.Builder(pageName, palette1Page.getLongLabel()).pageId(pageId).pageEditor(palette1Page.getPageEditor()).projectConfiguration(palette1Page.getProjectConfigurator()).showForTypes(records).technologyScopes(scopes).type(palette1Page.getType()).pageContext(palette1Page.getPaletteContext());
        return (DefaultPalettePage)pageBuilder.build();
    }

    private DefaultPaletteGroup findOrCreateGroup(PalettePage palette1Page, DefaultPalettePage page) {
        if (null == palette1Page || null == page) {
            return null;
        }
        String pageName = palette1Page.getName();
        for (PaletteGroup group : page.getGroups()) {
            if (!(group instanceof DefaultPaletteGroup) || !ModelUtil.areEqual((Object)pageName, (Object)group.getName())) continue;
            return (DefaultPaletteGroup)group;
        }
        DefaultPaletteGroup group = (DefaultPaletteGroup)new DefaultPaletteGroup.Builder(pageName, palette1Page.getLongLabel()).groupId(DeclaredPalette1Pages.pageNameToGroupId(pageName)).build();
        page.addGroup((PaletteGroup)group);
        return group;
    }

    private DefaultPalette1Section findOrCreateSection(PalettePage palette1Page, DefaultPaletteGroup group) {
        if (null == palette1Page || null == group) {
            return null;
        }
        String pageName = palette1Page.getName();
        String sectionId = DeclaredPalette1Pages.pageNameToSectionId(pageName);
        for (PaletteSection section : group.getSections()) {
            if (!(section instanceof DefaultPalette1Section) || !ModelUtil.areEqual((Object)sectionId, (Object)section.getData((Object)"sectiomId"))) continue;
            return (DefaultPalette1Section)section;
        }
        DefaultPalette1Section section = new DefaultPalette1Section(null, sectionId);
        section.setData("pageType", palette1Page.getType());
        group.addSection((PaletteSection)section);
        return section;
    }

    private DefaultPaletteItem findOrCreateItem(PalettePage palette1Page, PaletteItem palette1Item, DefaultPaletteSection section) {
        int comPos;
        if (null == palette1Page || null == palette1Item || null == section) {
            return null;
        }
        String pageName = palette1Page.getName();
        String itemName = palette1Item.getShortLabel();
        String itemDesc = palette1Item.getLongLabel();
        for (oracle.ide.palette2.PaletteItem item : section.getPaletteItems()) {
            if (!(item instanceof DefaultPaletteItem) || !ModelUtil.areEqual((Object)itemName, (Object)item.getName())) continue;
            return (DefaultPaletteItem)item;
        }
        String classPath = null;
        String className = null;
        String info = palette1Item.getItemInfo();
        if (info != null && (comPos = info.indexOf(",")) != -1) {
            classPath = info.substring(0, comPos);
            if (info.length() > comPos) {
                className = info.substring(comPos + 1);
            }
        }
        if (className == null) {
            className = itemDesc;
        }
        List<String> itemScopes = this.tokenizeString(palette1Item.getTechnologyScope());
        String weight = String.valueOf(palette1Item.getItemWeight());
        String itemId = DeclaredPalette1Pages.pageNameAndItemNameToItemId(pageName, itemName);
        DefaultPaletteItem.Builder itemBuilder = (DefaultPaletteItem.Builder)new DefaultPaletteItem.Builder(itemName, itemDesc, itemId).providerId(DECLAREDPROVIDER_ID).pageEditor(palette1Item.getEditor()).technologyScopes(itemScopes).type(palette1Item.getItemType()).info(info).classPath(classPath).className(className).library(palette1Item.getLibrary()).weight(weight).helpable(palette1Item.getItemHelpable()).data(ITEM_PALETTE1PAGENAME, (Object)pageName).icon(palette1Item.getIcon());
        DefaultPaletteItem item = (DefaultPaletteItem)itemBuilder.build();
        section.addItem((oracle.ide.palette2.PaletteItem)item);
        return item;
    }

    private DefaultPalettePage findPageByName(String pageName) {
        for (oracle.ide.palette2.PalettePage page : this.getPages()) {
            if (!(page instanceof DefaultPalettePage) || !ModelUtil.areEqual((Object)pageName, (Object)page.getName())) continue;
            return (DefaultPalettePage)page;
        }
        return null;
    }
}

