/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.DeferredItem;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteSubject;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.model.Page;

public class PalettePageImpl
extends PaletteSubject
implements PalettePage {
    private ArrayList _paletteItems = null;
    private boolean listView = false;
    private boolean _isPersistent = true;
    private Page _page;
    private boolean _isPalette1Only = false;

    public PalettePageImpl(Page page) {
        this._page = page;
        this.setName(page.getName());
        this.setLongLabel(page.getName());
    }

    public Page getPage() {
        return this._page;
    }

    protected Page getPageModel() {
        return this._page;
    }

    @Override
    public void addPaletteItem(String icon, String info, boolean isPersistent, String longLabel, String shortLabel, String type, String editor, String library) {
        Item item = PalettePageImpl.createPaletteItem(icon, info, isPersistent, longLabel, shortLabel, type, editor, library);
        PaletteItemImpl paletteItem = new PaletteItemImpl(item);
        this.add(paletteItem);
    }

    public void addPaletteItem(String icon, String info, boolean isPersistent, String longLabel, String shortLabel, String type, String editor, String library, String helpable) {
        Item item = PalettePageImpl.createPaletteItem(icon, info, isPersistent, longLabel, shortLabel, type, editor, library);
        item.setHelpable(helpable);
        PaletteItemImpl paletteItem = new PaletteItemImpl(item);
        this.add(paletteItem);
    }

    @Override
    public ArrayList getPaletteItems() {
        if (this._paletteItems == null) {
            this._paletteItems = this.getItemsFromPage(this._page);
        }
        return this._paletteItems;
    }

    public boolean add(Element element) {
        if (!this.getPaletteItems().contains(element)) {
            PaletteItemImpl piImpl = (PaletteItemImpl)element;
            int index = this._page.addItem(piImpl.getItem());
            this.getPaletteItems().add(index, element);
            try {
                PaletteUI ui = PaletteController.getInstance().getPaletteUI();
                if (ui != null) {
                    ui.getPageMap().remove(this.getShortLabel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            PaletteImpl.getInstance().firePaletteItemAdded(piImpl);
            return true;
        }
        return false;
    }

    public boolean remove(Element element) {
        PaletteItemImpl pi = (PaletteItemImpl)element;
        this._page.removeItem(pi.getItem());
        if (this.getPaletteItems().remove(element)) {
            try {
                PaletteController.getInstance().getPaletteUI().getPageMap().remove(this.getShortLabel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            PaletteImpl.getInstance().firePaletteItemRemoved(pi);
            return true;
        }
        return false;
    }

    public boolean canRemove(Element element) {
        return true;
    }

    public boolean canAdd(Element element) {
        return true;
    }

    public boolean containsChild(Element child) {
        return this.getPaletteItems().contains(child);
    }

    public int size() {
        return this.getPaletteItems().size();
    }

    public void removeAll() {
        this._page.removeAll();
        this.getPaletteItems().clear();
        try {
            PaletteUI ui = PaletteController.getInstance().getPaletteUI();
            if (ui != null) {
                ui.getPageMap().remove(this.getShortLabel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getData() {
        return this;
    }

    public void setListView(boolean listView) {
        this.listView = listView;
    }

    public boolean isListView() {
        return this.listView;
    }

    @Override
    public Iterator getChildren() {
        return this.getPaletteItems().iterator();
    }

    void addPaletteItem(String icon, String info, boolean isPersistent, boolean canRemove, String longLabel, String shortLabel, String type, String editor, String library, String helpable) {
        Item item = PalettePageImpl.createPaletteItem(icon, info, isPersistent, longLabel, shortLabel, type, editor, library);
        item.setHelpable(helpable);
        item.setCanRemove(canRemove);
        PaletteItemImpl paletteItem = new PaletteItemImpl(item);
        this.add(paletteItem);
    }

    private ArrayList getItemsFromPage(Page page) {
        ArrayList<PaletteItemImpl> paletteItems = new ArrayList<PaletteItemImpl>();
        Item[] items = page.getItem();
        int numItems = items != null ? items.length : 0;
        for (int i = 0; i < numItems; ++i) {
            if (this.getTechnologyScope() != null) {
                items[i].setTechnologyScope(this.getTechnologyScope());
            }
            paletteItems.add(new PaletteItemImpl(items[i]));
        }
        return paletteItems;
    }

    public Page getFinishPage() {
        int size = this.getPaletteItems().size();
        Iterator iter = this.getPaletteItems().iterator();
        Item[] items = new Item[size];
        int counter = 0;
        while (iter.hasNext()) {
            items[counter] = ((PaletteItemImpl)iter.next()).getItem();
            ++counter;
        }
        this._page.setItem(items);
        return this._page;
    }

    @Override
    public void setIsPersistent(boolean persist) {
        this._isPersistent = persist;
    }

    @Override
    public boolean isPersistent() {
        return this._isPersistent;
    }

    @Override
    public boolean canShow() {
        String show = this._page.getCanShow();
        return !show.equals("false");
    }

    @Override
    public void setCanShow(boolean canShow) {
        String s = "false";
        if (canShow) {
            s = "true";
        }
        this._page.setCanShow(s);
    }

    @Override
    public void setPaletteContext(String paletteContext) {
        this._page.setPaletteContext(paletteContext);
    }

    @Override
    public String getPaletteContext() {
        return this._page.getPaletteContext();
    }

    @Override
    public void setName(String name) {
        this.setShortLabel(name);
        this._page.setName(name);
    }

    @Override
    public String getName() {
        return this.getShortLabel();
    }

    @Override
    public void setShowForTypes(String types) {
        this._page.setShowForTypes(types);
    }

    @Override
    public String getShowForTypes() {
        return this._page.getShowForTypes();
    }

    @Override
    public void setType(String type) {
        this._page.setType(type);
    }

    @Override
    public String getType() {
        return this._page.getType();
    }

    @Override
    public void setView(String view) {
        this._page.setView(view);
    }

    @Override
    public String getView() {
        return this._page.getView();
    }

    @Override
    public void setCanRemove(boolean canRemove) {
        this._page.setCanRemove(canRemove);
    }

    @Override
    public boolean getCanRemove() {
        return this._page.getCanRemove();
    }

    @Override
    public void setPageEditor(String pageEditor) {
        this._page.setPageEditor(pageEditor);
    }

    @Override
    public String getPageEditor() {
        return this._page.getPageEditor();
    }

    @Override
    public void setProjectConfigurator(String pc) {
        this._page.setProjectConfiguration(pc);
    }

    @Override
    public String getProjectConfigurator() {
        return this._page.getProjectConfiguration();
    }

    @Override
    public void setTechnologyScope(String scope) {
        this._page.setTechnologyScope(scope);
    }

    @Override
    public String getTechnologyScope() {
        return this._page.getTechnologyScope();
    }

    @Override
    public void setDraggable(boolean drag) {
        this._page.setDraggable(drag);
    }

    @Override
    public boolean getDraggable() {
        return this._page.getDraggable();
    }

    static Item createPaletteItem(DeferredItem deferred) {
        Item item = new Item();
        if (deferred.getIcon() == null) {
            item.setBeanInfo("1");
        } else {
            String icon = deferred.getIcon().trim();
            if (icon.startsWith("res:")) {
                icon = icon.substring("res:".length());
            }
            item.setIcon(deferred.getIcon());
        }
        item.setInfo(deferred.getInfo());
        item.setIsPersistent(deferred.isPersistent());
        item.setCanRemove(deferred.canRemove());
        item.setLongLabel(deferred.getLongLabel());
        item.setShortLabel(deferred.getShortLabel());
        item.setType(deferred.getType());
        item.setEditor(deferred.getEditor());
        item.setLibrary(deferred.getLibrary());
        item.setHelpable(deferred.getHelpable());
        item.setTechnologyScope(deferred.getTechnologyScope());
        try {
            item.setWeight(Float.parseFloat(deferred.getWeight()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    static Item createPaletteItem(String icon, String info, boolean isPersistent, String longLabel, String shortLabel, String type, String editor, String library) {
        Item item = new Item();
        if (icon == null) {
            item.setBeanInfo("1");
        } else {
            item.setIcon(icon);
        }
        item.setInfo(info);
        item.setIsPersistent(isPersistent);
        item.setLongLabel(longLabel);
        item.setShortLabel(shortLabel);
        item.setType(type);
        item.setEditor(editor);
        item.setLibrary(library);
        return item;
    }

    @Override
    public PaletteItem getPaletteItem(String itemName) {
        for (PaletteItemImpl item : this.getPaletteItems()) {
            if (!item.getShortLabel().equalsIgnoreCase(itemName)) continue;
            return item;
        }
        return null;
    }

    public boolean isPalette1Only() {
        return this._isPalette1Only;
    }

    public void setIsPalette1Only(boolean palette1Only) {
        this._isPalette1Only = palette1Only;
    }
}

