/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.Parameter;
import oracle.jdevimpl.help.BaseInfo;
import oracle.jdevimpl.help.BaseInfoComparator;
import oracle.jdevimpl.help.CellInfo;
import oracle.jdevimpl.help.StartPageDefinition;
import oracle.jdevimpl.help.StartPageHook;

public final class ColumnInfo
extends BaseInfo {
    private String _tabId;
    private List<Cell> _cellList;
    private List<Cell> _summaryCellList;

    ColumnInfo(HashStructure hash, String tabId) {
        super(hash);
        this._tabId = tabId;
    }

    public boolean hasRSSComp() {
        List<Cell> cellList = this.getCells();
        for (Cell cell : cellList) {
            if (!cell.getCompId().equals("rss")) continue;
            return true;
        }
        return false;
    }

    public int getRightMargin() {
        return this._hash.getInt("rightMargin");
    }

    public List<Cell> getCells() {
        if (this._cellList == null) {
            this._cellList = this.getCells("cell");
        }
        return this._cellList;
    }

    public List<Cell> getSummaryCells() {
        if (this._summaryCellList == null) {
            this._summaryCellList = this.getCells("summary-cell");
        }
        return this._summaryCellList;
    }

    private List<Cell> getCells(String cellType) {
        List hashList;
        ArrayList<Cell> cellList = new ArrayList<Cell>(7);
        if (this._hash != null && (hashList = this._hash.getAsList(cellType)) != null && hashList.size() > 0) {
            for (HashStructure h : hashList) {
                cellList.add(new CellInfo(h));
            }
        }
        StartPageDefinition def = StartPageHook.getStartPageDefinition();
        List<Cell> cellInfos = def.getTopLevelCells(cellType);
        for (Cell cInfo : cellInfos) {
            String tabRef = cInfo.getTabRef();
            String columnRef = cInfo.getColumnRef();
            if (tabRef == null || !tabRef.equals(this._tabId) || columnRef == null || !columnRef.equals(this.getId())) continue;
            cellList.add(cInfo);
        }
        if (cellList.size() > 0) {
            Collections.sort(cellList, new BaseInfoComparator());
            this.consolidateMenuButtons(cellList);
            return cellList;
        }
        return Collections.EMPTY_LIST;
    }

    private void consolidateMenuButtons(List<Cell> cellList) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        ArrayList<Cell> deleteList = new ArrayList<Cell>(5);
        for (Cell cell : cellList) {
            String groupName;
            if (!cell.getCompId().equals("menuButton") || (groupName = cell.getParameterValue("groupName")) == null) continue;
            if (map.containsKey(groupName)) {
                Parameter parameter = (Parameter)map.get(groupName);
                String oldValue = parameter.getValue();
                String appendValue = cell.getParameterValue("action-refs");
                if (appendValue != null) {
                    parameter.setValue(oldValue + ";" + appendValue);
                }
                deleteList.add(cell);
                continue;
            }
            cell.setParameter("resolvedActions", cell.getParameterValue("action-refs"));
            map.put(groupName, cell.getParameter("resolvedActions"));
        }
        if (deleteList.size() > 0) {
            cellList.removeAll(deleteList);
        }
    }

    public String getTabRef() {
        return this._hash.getString("tab-ref");
    }

    public int getMaxEntries() {
        return this._hash.getInt("maxEntries", 5);
    }

    public boolean getShowBorder() {
        return this._hash.getBoolean("border", Boolean.FALSE.booleanValue());
    }
}

