/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.specification.Merge;

public class TypeExportSpecification {
    public static final TypeExportSpecification DEFAULT_EXPORTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.EXPORTED, null, CompatibilityAccess.EXPORTED);
    public static final TypeExportSpecification DEFAULT_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.RESTRICTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.RESTRICTED);
    public static final TypeExportSpecification DEFAULT_CONCEALED = new TypeExportSpecification(CompatibilityAccess.CONCEALED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.CONCEALED);
    public static final TypeExportSpecification DEFAULT_NULL = new TypeExportSpecification(null, null, null, null);
    private final CompatibilityAccess access;
    private final CompatibilityAccess extension;
    private final Map<MemberName, CompatibilityAccess> members;
    private final CompatibilityAccess defaultMemberAccess;

    public TypeExportSpecification(CompatibilityAccess access, CompatibilityAccess extension, Map<MemberName, CompatibilityAccess> members, CompatibilityAccess defaultMemberAccess) {
        if (extension == null && access != null) {
            throw new IllegalStateException("extension null when access not");
        }
        if (members == null) {
            members = Collections.emptyMap();
        }
        if (defaultMemberAccess == null) {
            defaultMemberAccess = access;
        }
        if (CompatibilityAccess.isMoreExported(extension, access)) {
            throw new IllegalStateException("extension more exported than access");
        }
        if (!members.isEmpty() && !CompatibilityAccess.isConcealed(defaultMemberAccess)) {
            throw new IllegalStateException("members itemized but default member access not concealed");
        }
        for (CompatibilityAccess memberAccess : members.values()) {
            if (!CompatibilityAccess.isMoreExported(memberAccess, access)) continue;
            throw new IllegalStateException("member access more exported than access");
        }
        if (CompatibilityAccess.isMoreExported(defaultMemberAccess, access)) {
            throw new IllegalStateException("default member access more exported than access");
        }
        this.access = access;
        this.extension = extension;
        this.members = members;
        this.defaultMemberAccess = defaultMemberAccess;
    }

    public Merge<TypeExportSpecification> merge(TypeExportSpecification that) {
        CompatibilityAccess thatAccess;
        if (!CompatibilityAccess.isExportedOrRestricted(this.access)) {
            throw new IllegalStateException("merging concealed or uncontrolled type: " + this);
        }
        if (!CompatibilityAccess.isExportedOrRestricted(that.access)) {
            throw new IllegalStateException("merging concealed or uncontrolled type: " + that);
        }
        Merge<TypeExportSpecification> merge = new Merge<TypeExportSpecification>(this, that, "type export specification", new Object[0]);
        if (merge.completeIfEqual()) {
            return merge;
        }
        CompatibilityAccess thisAccess = this.getAccess();
        Merge<CompatibilityAccess> mergedAccess = new Merge<CompatibilityAccess>(thisAccess, thatAccess = that.getAccess(), "access", new Object[0]);
        if (!mergedAccess.completeIfEqual()) {
            mergedAccess.completeWarning(CompatibilityAccess.mostExported(thisAccess, thatAccess));
        }
        merge.addMerge(mergedAccess);
        CompatibilityAccess thisExtension = this.getExtension();
        CompatibilityAccess thatExtension = that.getExtension();
        Merge<CompatibilityAccess> mergedExtension = new Merge<CompatibilityAccess>(thisExtension, thatExtension, "extension", new Object[0]);
        if (!mergedExtension.completeIfEqual()) {
            mergedExtension.completeWarning(CompatibilityAccess.mostExported(thisExtension, thatExtension));
        }
        merge.addMerge(mergedExtension);
        CompatibilityAccess thisDefaultMemberAccess = this.getDefaultMemberAccess();
        CompatibilityAccess thatDefaultMemberAccess = that.getDefaultMemberAccess();
        Merge<CompatibilityAccess> mergedDefaultMemberAccess = new Merge<CompatibilityAccess>(thisDefaultMemberAccess, thatDefaultMemberAccess, "default member access", new Object[0]);
        CompatibilityAccess adjustedAccess = null;
        if (!mergedDefaultMemberAccess.completeIfEqual()) {
            mergedDefaultMemberAccess.completeWarning(CompatibilityAccess.mostExported(thisDefaultMemberAccess, thatDefaultMemberAccess));
            adjustedAccess = mergedDefaultMemberAccess.getValue();
        }
        merge.addMerge(mergedDefaultMemberAccess);
        Map<MemberName, CompatibilityAccess> thisMembers = this.members;
        Map<MemberName, CompatibilityAccess> thatMembers = that.members;
        Merge<Map<MemberName, CompatibilityAccess>> mergedMembers = new Merge<Map<MemberName, CompatibilityAccess>>(thisMembers, thatMembers, "members", new Object[0]);
        if (!mergedMembers.completeIfEqual()) {
            if (thisMembers.isEmpty() && CompatibilityAccess.isExported(thisAccess)) {
                mergedMembers.complete(thisMembers);
            } else if (thatMembers.isEmpty() && CompatibilityAccess.isExported(thatAccess)) {
                mergedMembers.complete(thatMembers);
            } else if (thisMembers.isEmpty() && CompatibilityAccess.isConcealedOrNull(thisAccess)) {
                mergedMembers.complete(thatMembers);
            } else if (thatMembers.isEmpty() && CompatibilityAccess.isConcealedOrNull(thatAccess)) {
                mergedMembers.complete(thisMembers);
            } else {
                if (adjustedAccess != null) {
                    Map<MemberName, CompatibilityAccess> moreExportedMembers;
                    LinkedHashMap<MemberName, CompatibilityAccess> lessExportedMembers;
                    if (adjustedAccess == thisDefaultMemberAccess) {
                        lessExportedMembers = new LinkedHashMap<MemberName, CompatibilityAccess>(thatMembers);
                        thatMembers = lessExportedMembers;
                        moreExportedMembers = thisMembers;
                    } else {
                        lessExportedMembers = new LinkedHashMap<MemberName, CompatibilityAccess>(thisMembers);
                        thisMembers = lessExportedMembers;
                        moreExportedMembers = thatMembers;
                    }
                    Iterator i = lessExportedMembers.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (moreExportedMembers.containsKey(entry.getKey())) continue;
                        Merge<CompatibilityAccess> mergedMember = new Merge<CompatibilityAccess>((CompatibilityAccess)((Object)entry.getValue()), adjustedAccess, "member", new Object[0]);
                        if (!mergedMember.completeIfEqual()) {
                            mergedMember.completeWarning(CompatibilityAccess.mostExported((CompatibilityAccess)((Object)entry.getValue()), adjustedAccess));
                        }
                        if (adjustedAccess == mergedMember.getValue()) {
                            i.remove();
                            continue;
                        }
                        entry.setValue(mergedMember.getValue());
                        merge.addMerge(mergedMember);
                    }
                }
                Map<MemberName, CompatibilityAccess> union = new LinkedHashMap<MemberName, CompatibilityAccess>(thisMembers);
                for (Map.Entry<MemberName, CompatibilityAccess> entry : thatMembers.entrySet()) {
                    CompatibilityAccess thatMember;
                    MemberName memberName = entry.getKey();
                    CompatibilityAccess thisMember = union.putIfAbsent(memberName, thatMember = entry.getValue());
                    if (thisMember == null) continue;
                    Merge<CompatibilityAccess> mergedMember = new Merge<CompatibilityAccess>(thisMember, thatMember, "member", new Object[0]);
                    if (!mergedMember.completeIfEqual()) {
                        mergedMember.completeWarning(CompatibilityAccess.mostExported(thisMember, thatMember));
                    }
                    union.put(memberName, mergedMember.getValue());
                    mergedMembers.addMerge(mergedMember);
                }
                if (union.isEmpty()) {
                    union = Collections.emptyMap();
                }
                mergedMembers.complete(union);
            }
        }
        merge.addMerge(mergedMembers);
        merge.complete(new TypeExportSpecification(mergedAccess.getValue(), mergedExtension.getValue(), mergedMembers.getValue(), mergedDefaultMemberAccess.getValue()));
        return merge;
    }

    public CompatibilityAccess getAccess() {
        return this.access;
    }

    public CompatibilityAccess getExtension() {
        return this.extension;
    }

    public CompatibilityAccess getMember(MemberName name) {
        return this.members.getOrDefault(name, this.defaultMemberAccess);
    }

    public CompatibilityAccess getMemberUnqualified(MemberName name) {
        for (Map.Entry<MemberName, CompatibilityAccess> entry : this.members.entrySet()) {
            if (name.compareToUnqualified(entry.getKey()) != 0) continue;
            return entry.getValue();
        }
        return this.defaultMemberAccess;
    }

    public boolean isMemberExplicit(MemberName name) {
        return this.members.containsKey(name);
    }

    public boolean isMemberExplicitUnqualified(MemberName name) {
        boolean result = false;
        for (MemberName key : this.members.keySet()) {
            if (name.compareToUnqualified(key) != 0) continue;
            result = true;
        }
        return result;
    }

    Set<MemberName> getMemberNames() {
        return this.members.keySet();
    }

    public CompatibilityAccess getDefaultMemberAccess() {
        return this.defaultMemberAccess;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypeExportSpecification)) {
            return false;
        }
        TypeExportSpecification that = (TypeExportSpecification)object;
        if (this.access != that.access) {
            return false;
        }
        if (this.extension != that.extension) {
            return false;
        }
        if (this.defaultMemberAccess != that.defaultMemberAccess) {
            return false;
        }
        return Objects.equals(this.members, that.members);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.access);
        builder.append(this.members == null ? "[*]" : this.members);
        builder.append((Object)this.defaultMemberAccess);
        return builder.toString();
    }
}

