/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.exports.message.ChildLog;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;

class RootLog
extends Log {
    private final boolean traces;
    private final Tag[] baseTags;
    private final List<Message> messages = new ArrayList<Message>();

    RootLog(Tag ... tags) {
        this.traces = false;
        this.baseTags = tags;
    }

    RootLog(boolean traces, Tag ... tags) {
        this.traces = traces;
        this.baseTags = tags;
    }

    @Override
    public boolean isEnabled(Severity severity) {
        return severity != TRACE || this.traces;
    }

    @Override
    public Log child(Tag ... childTags) {
        Tag[] tags = new Tag[this.baseTags.length + childTags.length];
        System.arraycopy(this.baseTags, 0, tags, 0, this.baseTags.length);
        System.arraycopy(childTags, 0, tags, this.baseTags.length, childTags.length);
        return new ChildLog(this, tags);
    }

    @Override
    public Message message(Message message) {
        if (!this.traces && message.getSeverity() == TRACE) {
            return Message.nullMessage();
        }
        this.messages.add(message);
        return message;
    }

    @Override
    public Collection<Message> getMessages() {
        return this.messages;
    }
}

