/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.message;

import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLKey;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;

public class LogWriter {
    public static AttributeType SCOPE = AttributeType.SCOPE;
    public static AttributeType TIME = AttributeType.TIME;
    public static AttributeType SEVERITY = AttributeType.SEVERITY;
    public static AttributeType ID = AttributeType.ID;
    public static AttributeType MESSAGE = AttributeType.MESSAGE;
    public static AttributeType EXCEPTION = AttributeType.EXCEPTION;
    private Path baseDirectory;
    private List<Matcher> ids = Collections.emptyList();
    private EnumSet<Severity> severities = EnumSet.allOf(Severity.class);
    private EnumSet<AttributeType> attributes = EnumSet.allOf(AttributeType.class);

    public LogWriter(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setSeverities(EnumSet<Severity> severities) {
        this.severities = severities;
    }

    public void setIds(Collection<String> idPatterns) {
        this.ids = new ArrayList<Matcher>(idPatterns.size());
        for (String pattern : idPatterns) {
            this.ids.add(new Matcher(pattern));
        }
    }

    public void setIds(String ... idPatterns) {
        this.setIds(Arrays.asList(idPatterns));
    }

    public void setAttributes(EnumSet<AttributeType> attributes) {
        this.attributes = attributes;
    }

    public void setAttributes(AttributeType ... attributes) {
        this.attributes = EnumSet.copyOf(Arrays.asList(attributes));
    }

    public void write(Log log, Path path, Message ... initialMessages) {
        Message[] messages = new Message[initialMessages.length + log.getMessages().size()];
        int count = 0;
        int idLength = 0;
        for (Message message : initialMessages) {
            if (!this.severities.contains((Object)message.getSeverity()) || !Matcher.matches(message.getId(), this.ids)) continue;
            messages[count++] = message;
            if (message.getId().length() <= idLength) continue;
            idLength = message.getId().length();
        }
        for (Message message : log.getMessages()) {
            if (!this.severities.contains((Object)message.getSeverity()) || !Matcher.matches(message.getId(), this.ids)) continue;
            messages[count++] = message;
            if (message.getId().length() <= idLength) continue;
            idLength = message.getId().length();
        }
        if (this.attributes.contains((Object)SCOPE)) {
            Arrays.sort(messages, 0, count, new Comparator<Message>(){

                @Override
                public int compare(Message m1, Message m2) {
                    Tag s2;
                    Tag s1 = m1.getTag("scope");
                    if (s1 == null) {
                        s1 = m1.getTag("element");
                    }
                    if ((s2 = m2.getTag("scope")) == null) {
                        s2 = m2.getTag("element");
                    }
                    String t1 = s1 != null && s1.getValue() != null ? LogWriter.this.trim(s1.getValue()).toString() : "";
                    String t2 = s2 != null && s2.getValue() != null ? LogWriter.this.trim(s2.getValue()).toString() : "";
                    return t1.compareTo(t2);
                }
            });
        }
        char[] idFill = new char[idLength];
        Arrays.fill(idFill, ' ');
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            String lastScope = "";
            Object[] buffer = new Object[32];
            int highwater = buffer.length;
            for (int m = 0; m < count; ++m) {
                Throwable exception;
                Message message = messages[m];
                if (this.attributes.contains((Object)SCOPE)) {
                    String scope;
                    Tag scopeTag = message.getTag("scope");
                    if (scopeTag == null) {
                        scopeTag = message.getTag("element");
                    }
                    String string = scope = scopeTag != null && scopeTag.getValue() != null ? this.trim(scopeTag.getValue()).toString() : "";
                    if (!lastScope.equals(scope)) {
                        lastScope = scope;
                        writer.println();
                        writer.print("-- ");
                        writer.println(scope);
                    }
                }
                if (this.attributes.contains((Object)TIME)) {
                    LogWriter.writeTime(message.getTime(), writer);
                    writer.write(": ");
                }
                if (this.attributes.contains((Object)ID)) {
                    String id = message.getId();
                    writer.write(id);
                    writer.write(58);
                    writer.write(idFill, 0, idLength - id.length() + 1);
                }
                if (this.attributes.contains((Object)SEVERITY)) {
                    switch (message.getSeverity()) {
                        case ERROR: {
                            writer.write("error:   ");
                            break;
                        }
                        case WARNING: {
                            writer.write("warning: ");
                            break;
                        }
                        case NOTE: {
                            writer.write("note:    ");
                            break;
                        }
                        case TRACE: {
                            writer.write("trace:    ");
                        }
                    }
                }
                if (this.attributes.contains((Object)MESSAGE)) {
                    int i;
                    String text;
                    int i2;
                    Object[] arguments = message.getArguments();
                    int length = arguments.length;
                    for (i2 = 0; i2 < length; ++i2) {
                        buffer[i2] = this.trim(arguments[i2]);
                    }
                    for (i2 = length; i2 < highwater; ++i2) {
                        buffer[i2] = "?";
                    }
                    highwater = length;
                    try {
                        text = String.format(message.getFormat(), buffer);
                    }
                    catch (Exception e) {
                        StringBuilder builder = new StringBuilder(message.getFormat());
                        builder.append(" (");
                        for (int i3 = 0; i3 < arguments.length; ++i3) {
                            if (i3 > 0) {
                                builder.append(", ");
                            }
                            builder.append(arguments[i3]);
                        }
                        builder.append(") ");
                        builder.append(e.getMessage());
                        text = builder.toString();
                    }
                    String[] lines = text.split("\n");
                    for (i = 0; i < lines.length && lines[i].trim().isEmpty(); ++i) {
                    }
                    writer.println(lines[i++].trim());
                    while (i < lines.length) {
                        writer.print("\t");
                        writer.println(lines[i]);
                        ++i;
                    }
                } else {
                    writer.println();
                }
                if (!this.attributes.contains((Object)EXCEPTION) || (exception = message.getValue("exception", Throwable.class)) == null) continue;
                exception.printStackTrace(writer);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static void writeTime(long time, PrintWriter writer) {
        char[] timeBuffer = new char[]{' ', ' ', '0', '.', '0', '0', '0', ',', '0', '0', '0'};
        time = (time - Message.TIME_ZERO_NANO) / 1000L;
        timeBuffer[10] = (char)(48L + time % 10L);
        if ((time /= 10L) > 0L) {
            timeBuffer[9] = (char)(48L + time % 10L);
            if ((time /= 10L) > 0L) {
                timeBuffer[8] = (char)(48L + time % 10L);
                if ((time /= 10L) > 0L) {
                    timeBuffer[7] = 44;
                    timeBuffer[6] = (char)(48L + time % 10L);
                    if ((time /= 10L) > 0L) {
                        timeBuffer[5] = (char)(48L + time % 10L);
                        if ((time /= 10L) > 0L) {
                            timeBuffer[4] = (char)(48L + time % 10L);
                            if ((time /= 10L) > 0L) {
                                timeBuffer[3] = 46;
                                timeBuffer[2] = (char)(48L + time % 10L);
                                if ((time /= 10L) > 0L) {
                                    timeBuffer[1] = (char)(48L + time % 10L);
                                    if ((time /= 10L) > 0L) {
                                        timeBuffer[0] = (char)(48L + time % 10L);
                                        if ((time /= 10L) <= 0L) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        writer.write(timeBuffer);
    }

    public String trim(Path path) {
        String trim;
        if (this.baseDirectory == null || this.baseDirectory.getNameCount() == 0) {
            return Paths.toString(path);
        }
        if (Paths.isJarScheme(path)) {
            String baseString = path.getFileSystem().toString();
            Path basePath = Paths.get(baseString, new String[0]);
            if (basePath.startsWith(this.baseDirectory)) {
                baseString = this.baseDirectory.relativize(basePath).toString();
            }
            if (path.getNameCount() > 0) {
                baseString = baseString + "!" + path.toString();
            }
            return baseString;
        }
        if (path.startsWith(this.baseDirectory) && !(trim = this.baseDirectory.relativize(path).toString()).isEmpty()) {
            return trim;
        }
        return path.toString();
    }

    public String trim(URL url) {
        if (JarUtil.isJarURL(url)) {
            String base = this.trim(Paths.getAsDefaultPath(JarUtil.getJarFileURL(url)));
            String entry = JarUtil.getJarEntry(url);
            return entry.isEmpty() ? base : base + "!/" + entry;
        }
        return this.trim(Paths.getAsDefaultPath(url));
    }

    public Object trim(Object object) {
        if (object instanceof Path) {
            return this.trim((Path)object);
        }
        if (object instanceof PathKey) {
            return ((PathKey)object).relativize(this.baseDirectory);
        }
        if (object instanceof URL) {
            return this.trim((URL)object);
        }
        if (object instanceof URLKey) {
            return this.trim(((URLKey)object).toURL());
        }
        if (object instanceof ExportLibrary) {
            return this.trim(((ExportLibrary)object).getOrigin());
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            StringBuilder builder = new StringBuilder();
            if (array.length == 2 && array[1] instanceof String && (array[0] instanceof Path || array[0] instanceof URL)) {
                builder.append(this.trim(array[0])).append("[").append(array[1]).append("]");
            } else {
                for (Object element : array) {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(this.trim(element));
                }
            }
            return builder.toString();
        }
        return object;
    }

    private static class Matcher {
        private final Polarity polarity;
        private final String id;
        private final String prefix;
        private final String suffix;
        private final int minimum;

        public Matcher(String pattern) {
            switch (pattern.charAt(0)) {
                case '+': {
                    this.polarity = Polarity.POSITIVE;
                    break;
                }
                case '-': {
                    this.polarity = Polarity.NEGATIVE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("pattern must begin with \"+\" or \"-\"");
                }
            }
            int star = pattern.indexOf(42);
            if (star < 0) {
                this.id = pattern.substring(1);
                this.prefix = null;
                this.suffix = null;
                this.minimum = this.id.length();
            } else {
                this.id = null;
                this.prefix = pattern.substring(1, star);
                this.suffix = pattern.substring(star + 1);
                this.minimum = this.prefix.length() + this.suffix.length();
            }
        }

        public Polarity polarity(String id) {
            if (id.length() < this.minimum) {
                return null;
            }
            if (this.id != null ? this.id.equals(id) : id.startsWith(this.prefix) && id.endsWith(this.suffix)) {
                return this.polarity;
            }
            return null;
        }

        public static boolean matches(String string, List<Matcher> matchers) {
            Polarity result = null;
            for (Matcher matcher : matchers) {
                Polarity polarity = matcher.polarity(string);
                if (polarity == null) continue;
                result = polarity;
            }
            return result != Polarity.NEGATIVE;
        }

        private static enum Polarity {
            POSITIVE,
            NEGATIVE;

        }
    }

    public static enum AttributeType {
        SCOPE,
        TIME,
        SEVERITY,
        ID,
        MESSAGE,
        EXCEPTION;

    }
}

