/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.message;

import java.util.Collection;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.NullLog;
import oracle.javatools.exports.message.RootLog;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;

public abstract class Log {
    public static final Severity ERROR = Severity.ERROR;
    public static final Severity WARNING = Severity.WARNING;
    public static final Severity NOTE = Severity.NOTE;
    public static final Severity TRACE = Severity.TRACE;

    public static Log newLog(Tag ... tags) {
        return new RootLog(tags);
    }

    public static Log newLog(boolean traces, Tag ... tags) {
        return new RootLog(traces, tags);
    }

    public static Log newNullLog() {
        return new NullLog();
    }

    public abstract boolean isEnabled(Severity var1);

    public abstract Log child(Tag ... var1);

    public abstract Message message(Message var1);

    public abstract Collection<Message> getMessages();

    public Message message(Severity severity, String id, String format, Object ... arguments) {
        return this.message(new Message(severity, id, format, arguments));
    }

    public Message error(String id, String format, Object ... arguments) {
        return this.message(ERROR, id, format, arguments);
    }

    public Message warning(String id, String format, Object ... arguments) {
        return this.message(WARNING, id, format, arguments);
    }

    public Message note(String id, String format, Object ... arguments) {
        return this.message(NOTE, id, format, arguments);
    }

    public Message trace(String id, String format, Object ... arguments) {
        return this.message(TRACE, id, format, arguments);
    }
}

