/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.common.UnmodifiableArrayWrapper;
import oracle.javatools.exports.common.UnmodifiableMappingArrayWrapper;
import oracle.javatools.exports.common.UnmodifiableMappingListWrapper;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.library.LibraryScope;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;
import oracle.javatools.util.UnexpectedExceptionError;
import org.xml.sax.SAXException;

public class FileExportLibrary
implements ExportLibrary {
    private final URL origin;
    private final String extensionId;
    private final String name;
    private final String syntheticId;
    private final String id;
    private final String description;
    private final EnumSet<LibraryFlag> flags;
    private final Map<String, List<URL>> exportSpecificationPaths;
    private final List<URL> remediationCommentsPaths;
    private final List<URL> sourcePath;
    private final List<URL> docPath;
    private final List<URL> endorsedDirectoriesPath;
    private final List<URL> endorsedSourcePath;
    private final List<URL> endorsedDocPath;
    private final List<LibraryDependency> dependencies;
    private final List<ClassPathEntry> suppliedClassPathEntries;
    private ClassPathEntry[] resolvedClassPathEntries;
    private ClassPathEntry[] expandedClassPathEntries;
    private Map<String, String> resolvedRemediationComments;
    private boolean resolvedDependencies;
    private boolean manifestClassPath;
    private static final AtomicInteger namelessCount = new AtomicInteger();
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public FileExportLibrary(URL origin, String extensionId, String name, String id, String description, EnumSet<LibraryFlag> flags, List<ClassPathEntry> suppliedClassPathEntries, Map<String, List<URL>> exportSpecificationPaths, List<URL> remediationCommentsPaths, List<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        this(origin, extensionId, name, null, id, description, flags, suppliedClassPathEntries, exportSpecificationPaths, remediationCommentsPaths, dependencies, sourcePath, docPath, endorsedDirectoriesPath, endorsedSourcePath, endorsedDocPath);
    }

    public FileExportLibrary(URL origin, String extensionId, String name, String syntheticId, String id, String description, EnumSet<LibraryFlag> flags, List<ClassPathEntry> suppliedClassPathEntries, Map<String, List<URL>> exportSpecificationPaths, List<URL> remediationCommentsPaths, List<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        assert (!exportSpecificationPaths.containsKey(null));
        if (name == null) {
            String string = name = origin != null ? URLFileSystem.getName(origin) : "unnamed-" + namelessCount.incrementAndGet();
        }
        if (syntheticId == null) {
            syntheticId = extensionId != null ? ExportLibrary.syntheticId(extensionId, name) : ExportLibrary.syntheticId(origin, name);
        }
        this.origin = origin;
        this.extensionId = extensionId;
        this.syntheticId = syntheticId;
        this.id = id;
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.suppliedClassPathEntries = suppliedClassPathEntries;
        this.exportSpecificationPaths = exportSpecificationPaths;
        this.remediationCommentsPaths = remediationCommentsPaths;
        this.dependencies = dependencies;
        this.sourcePath = sourcePath;
        this.docPath = docPath;
        this.endorsedDirectoriesPath = endorsedDirectoriesPath;
        this.endorsedSourcePath = endorsedSourcePath;
        this.endorsedDocPath = endorsedDocPath;
    }

    public void resolve(ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Function<String, ?> nameOrIdResolver, Log log) {
        this.resolve(new IdentityHashMap<ExportLibrary, Boolean>(), specificationReader, commentsReader, nameOrIdResolver, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resolve(Map<ExportLibrary, Boolean> resolvingLibraries, ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Function<String, ?> nameOrIdResolver, Log log) {
        if (this.resolvedDependencies) {
            return;
        }
        this.resolvedDependencies = true;
        HashMap<String, ExportSpecification> resolvedExportSpecifications = new HashMap<String, ExportSpecification>();
        LibraryScope libraryScope = new LibraryScope(null, this);
        for (Map.Entry<String, List<URL>> entry : this.exportSpecificationPaths.entrySet()) {
            Object mergedSpecification;
            ArrayList<ExportSpecification> specifications = new ArrayList<ExportSpecification>();
            for (URL uRL : entry.getValue()) {
                String key;
                try {
                    specifications.add(specificationReader.read(new SpecificationScope(libraryScope, ExportLinkage.LIBRARY, entry.getKey(), uRL, null), uRL, URLFileSystem.openInputStream(uRL), log));
                }
                catch (FileNotFoundException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    log.error("library-exports-absent", "library export specification %s for %s not found", URLFileSystem.getPlatformPathName(uRL), key).scope(this.origin);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    log.error("library-exports-unread", "library export specification %s for %s not read", URLFileSystem.getPlatformPathName(uRL), key).scope(this.origin);
                }
            }
            switch (specifications.size()) {
                case 0: {
                    mergedSpecification = null;
                    break;
                }
                case 1: {
                    mergedSpecification = (ExportSpecification)specifications.get(0);
                    break;
                }
                default: {
                    void var12_17;
                    mergedSpecification = (ExportSpecification)specifications.get(0);
                    boolean bl = true;
                    while (var12_17 < specifications.size()) {
                        ExportSpecification specification = (ExportSpecification)specifications.get((int)var12_17);
                        Merge<ExportSpecification> merge = ExportSpecification.merge(new SpecificationScope(libraryScope, ExportLinkage.LIBRARY, entry.getKey()), mergedSpecification, specification);
                        mergedSpecification = merge.getValue();
                        if (merge.getSeverity() == Severity.ERROR) {
                            log.message(merge.getSeverity(), "library-merge-key", "%s", merge.getDescription(Severity.WARNING));
                        }
                        ++var12_17;
                    }
                    break block4;
                }
            }
            resolvedExportSpecifications.put(entry.getKey(), (ExportSpecification)mergedSpecification);
        }
        this.resolvedRemediationComments = Collections.emptyMap();
        for (URL url : this.remediationCommentsPaths) {
            try {
                Map<String, String> comments = commentsReader.read(url, URLFileSystem.openInputStream(url), log);
                if (comments.isEmpty()) continue;
                if (this.resolvedRemediationComments.isEmpty()) {
                    this.resolvedRemediationComments = new HashMap<String, String>(comments);
                    continue;
                }
                for (Map.Entry entry : comments.entrySet()) {
                    String value = (String)entry.getValue();
                    String predecessor = this.resolvedRemediationComments.putIfAbsent((String)entry.getKey(), value);
                    if (predecessor == null || predecessor.equals(value)) continue;
                    log.warning("library-duplicate-comment", "duplicate remediation comment for %s in %s: \"%s\" preceded by \"%s\"", entry.getKey(), URLFileSystem.getPlatformPathName(url), value, predecessor).scope(this);
                }
            }
            catch (FileNotFoundException e) {
                log.error("library-comments-absent", "remediation comments file %s not found", URLFileSystem.getPlatformPathName(url)).scope(this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error("library-comments-unread", "remediation comments file %s not read", URLFileSystem.getPlatformPathName(url)).scope(this);
            }
        }
        Merge<Object> merge = new Merge<Object>(null, null, "class path of library %s", this);
        LinkedHashSet<ClassPathEntry> resolvedEntryCollector = new LinkedHashSet<ClassPathEntry>();
        LinkedHashMap<ClassPathEntry, ClassPathEntry> expandedClassPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
        for (ClassPathEntry classPathEntry : this.suppliedClassPathEntries) {
            resolvedEntryCollector.add(classPathEntry);
            classPathEntry.resolve(this, resolvedExportSpecifications, specificationReader, commentsReader, log);
            ClassPathEntry result = expandedClassPath.merge(classPathEntry, classPathEntry, (l, r) -> ClassPathEntry.merge(l, r, merge));
            if (result == classPathEntry) {
                FileExportLibrary.accumulateManifestClasspath(classPathEntry, classPathEntry, expandedClassPath, merge, log, this);
                this.manifestClassPath |= classPathEntry.hasManifestClassPath();
            }
            this.mergeComments(classPathEntry.getResolvedRemediationComments(), result.getUrl(), log);
        }
        resolvingLibraries.put(this, true);
        try {
            for (LibraryDependency libraryDependency : this.getDependencies()) {
                ClassPathEntry newEntry;
                Object resolvedLibrary = libraryDependency.resolve(nameOrIdResolver);
                if (resolvedLibrary instanceof ExportLibrary) {
                    ExportLibrary dependencyLibrary = (ExportLibrary)resolvedLibrary;
                    if (resolvedLibrary instanceof FileExportLibrary) {
                        Boolean resolving = resolvingLibraries.putIfAbsent(dependencyLibrary, true);
                        if (resolving == null) {
                            ((FileExportLibrary)dependencyLibrary).resolve(resolvingLibraries, specificationReader, commentsReader, nameOrIdResolver, log);
                        } else if (resolving.booleanValue()) {
                            log.error("library-dependency-cycle", "dependency cycle at library %s (%s)", dependencyLibrary.getName(), dependencyLibrary.getId()).scope(this);
                            continue;
                        }
                    }
                    resolvedEntryCollector.addAll(dependencyLibrary.getResolvedClassPathEntries());
                    this.manifestClassPath |= dependencyLibrary.hasManifestClassPath();
                    for (ClassPathEntry dependencyEntry : dependencyLibrary.getExpandedClassPathEntries()) {
                        newEntry = new ClassPathEntry(libraryDependency, dependencyEntry.getUrl(), dependencyEntry);
                        expandedClassPath.merge(newEntry, newEntry, (l, r) -> ClassPathEntry.merge(l, r, merge));
                        if (!libraryDependency.isReexported()) continue;
                        this.mergeComments(newEntry.getResolvedRemediationComments(), newEntry.getUrl(), log);
                    }
                    continue;
                }
                if (resolvedLibrary != null) {
                    try {
                        URLPath classPath = (URLPath)resolvedLibrary.getClass().getMethod("getClassPath", new Class[0]).invoke(resolvedLibrary, new Object[0]);
                        for (URL url : classPath) {
                            newEntry = new ClassPathEntry(libraryDependency, url, null);
                            resolvedEntryCollector.add(newEntry);
                            ClassPathEntry result = expandedClassPath.merge(newEntry, newEntry, (l, r) -> ClassPathEntry.merge(l, r, merge));
                            if (result != newEntry) continue;
                            FileExportLibrary.accumulateManifestClasspath(newEntry, newEntry, expandedClassPath, merge, log, this);
                            this.manifestClassPath |= newEntry.hasManifestClassPath();
                        }
                        continue;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new UnexpectedExceptionError(e, "invocation of %s.getClassPath() failed: %s", resolvedLibrary.getClass().getName(), e);
                    }
                }
                log.error("library-dependency-absent", "library dependency %s not found in library %s (\"%s\"): %s", libraryDependency.getId(), this.getId(), this.getName(), this.getOrigin()).scope(this);
            }
        }
        finally {
            resolvingLibraries.put(this, false);
        }
        this.resolvedClassPathEntries = new ClassPathEntry[resolvedEntryCollector.size()];
        int count = 0;
        for (ClassPathEntry entry : resolvedEntryCollector) {
            ClassPathEntry resolvedEntry = (ClassPathEntry)expandedClassPath.get(entry);
            assert (resolvedEntry != null) : "null resolved entry for " + entry;
            this.resolvedClassPathEntries[count++] = resolvedEntry;
        }
        this.expandedClassPathEntries = expandedClassPath.values().toArray(new ClassPathEntry[expandedClassPath.size()]);
        merge.complete(null);
        if (merge.getSeverity() == Severity.ERROR) {
            log.message(merge.getSeverity(), "library-merge-classpath", "%s", merge.getDescription(Severity.WARNING));
        }
    }

    static void accumulateManifestClasspath(ClassPathEntry suppliedEntry, ClassPathEntry manifestEntry, Map<ClassPathEntry, ClassPathEntry> resolvedClassPath, Merge<Void> merge, Log log, FileExportLibrary library) {
        URL containerUrl = manifestEntry.getUrl();
        URL manifestUrl = URLFactory.newJarURL(containerUrl, "META-INF/MANIFEST.MF");
        try {
            String paths;
            String[] stringArray = null;
            try (InputStream stream = URLFileSystem.openInputStream(manifestUrl);){
                paths = new Manifest(stream).getMainAttributes().getValue("Class-Path");
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            if (paths == null) {
                return;
            }
            manifestEntry.markManifestClassPath();
            URL context = FileExportLibrary.getContextUrl(containerUrl);
            for (String entryPath : paths.split(" +")) {
                ClassPathEntry newEntry;
                ClassPathEntry result;
                boolean archive;
                URL entryUrl;
                if (entryPath.isEmpty() || !URLFileSystem.exists(entryUrl = FileExportLibrary.resolve(entryPath, context))) continue;
                int dot = entryPath.lastIndexOf(46);
                boolean bl = archive = dot >= 0 && ARCHIVE_SUFFIXES.contains(entryPath.substring(dot));
                if (archive) {
                    entryUrl = URLFactory.newJarURL(entryUrl, "");
                }
                if ((result = resolvedClassPath.merge(newEntry = new ClassPathEntry(entryUrl, manifestEntry, suppliedEntry), newEntry, (l, r) -> ClassPathEntry.merge(l, r, merge))) != newEntry) continue;
                FileExportLibrary.accumulateManifestClasspath(suppliedEntry, newEntry, resolvedClassPath, merge, log, library);
            }
        }
        catch (FileNotFoundException paths) {
        }
        catch (IOException e) {
            log.error("library-manifest-unread", "manifest of %s not read: %s", manifestEntry, e).scope(library);
        }
    }

    private void mergeComments(Map<String, String> comments, URL url, Log log) {
        if (!comments.isEmpty()) {
            if (this.resolvedRemediationComments.isEmpty()) {
                this.resolvedRemediationComments = new HashMap<String, String>(comments);
            } else {
                for (Map.Entry<String, String> e : comments.entrySet()) {
                    String value = e.getValue();
                    String predecessor = this.resolvedRemediationComments.putIfAbsent(e.getKey(), value);
                    if (predecessor == null || predecessor.equals(value)) continue;
                    log.warning("library-duplicate-comment", "duplicate remediation comment for %s in %s: \"%s\" preceded by \"%s\"", e.getKey(), URLFileSystem.getPlatformPathName(url), value, predecessor).scope(this);
                }
            }
        }
    }

    public boolean isResolved() {
        return this.resolvedDependencies;
    }

    @Override
    public URL getOrigin() {
        return this.origin;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String getId() {
        return this.id != null && !this.id.isEmpty() ? this.id : this.syntheticId;
    }

    public String getSyntheticId() {
        return this.syntheticId;
    }

    public boolean isIdSynthetic() {
        return this.id == null || this.id.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public EnumSet<LibraryFlag> getFlags() {
        return this.flags;
    }

    public boolean isSet(LibraryFlag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.exportSpecificationPaths;
    }

    @Override
    public List<URL> getRemediationCommentsPaths() {
        return this.remediationCommentsPaths;
    }

    @Override
    public List<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    public List<URL> getSourcePath() {
        return this.sourcePath;
    }

    public List<URL> getDocPath() {
        return this.docPath;
    }

    public List<URL> getEndorsedDirectoriesPath() {
        return this.endorsedDirectoriesPath;
    }

    public List<URL> getEndorsedSourcePath() {
        return this.endorsedSourcePath;
    }

    public List<URL> getEndorsedDocPath() {
        return this.endorsedDocPath;
    }

    @Override
    public List<ClassPathEntry> getSuppliedClassPathEntries() {
        return this.suppliedClassPathEntries;
    }

    @Override
    public List<URL> getSuppliedClassPath() {
        return new UnmodifiableMappingListWrapper<ClassPathEntry, URL>(this.suppliedClassPathEntries, ClassPathEntry::getUrl);
    }

    @Override
    public boolean hasManifestClassPath() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return this.manifestClassPath;
    }

    @Override
    public List<ClassPathEntry> getResolvedClassPathEntries() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return new UnmodifiableArrayWrapper<ClassPathEntry>(this.resolvedClassPathEntries);
    }

    @Override
    public List<URL> getResolvedClassPath() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return new UnmodifiableMappingArrayWrapper<ClassPathEntry, URL>(this.resolvedClassPathEntries, ClassPathEntry::getUrl);
    }

    @Override
    public List<ClassPathEntry> getExpandedClassPathEntries() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return new UnmodifiableArrayWrapper<ClassPathEntry>(this.expandedClassPathEntries);
    }

    @Override
    public List<URL> getExpandedClassPath() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return new UnmodifiableMappingArrayWrapper<ClassPathEntry, URL>(this.expandedClassPathEntries, ClassPathEntry::getUrl);
    }

    @Override
    public Map<String, String> getResolvedRemediationComments() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return this.resolvedRemediationComments;
    }

    public String toString() {
        return '\"' + this.name + "\" (" + this.getId() + " at " + URLFileSystem.getPlatformPathName(this.origin) + ")";
    }

    private static URL resolve(String path, URL contextUrl) {
        URL fileUrl = FileExportLibrary.isAbsolute(path) ? URLFactory.newFileURL(path) : URLFactory.newURL(contextUrl, path);
        return fileUrl;
    }

    protected static boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() >= 2 && path.charAt(1) == ':';
    }

    private static URL getContextUrl(URL url) {
        if (JarUtil.isJarURL(url) && JarUtil.getJarEntry(url).isEmpty()) {
            url = JarUtil.getJarFileURL(url);
        }
        return URLFileSystem.getParent(url);
    }

    public static enum LibraryFlag {
        DEPLOYED,
        LOCKED,
        HIDDEN,
        LAZY;


        public String getAttributeName() {
            return this.toString().toLowerCase();
        }
    }
}

