/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportLibraryReader
extends DefaultHandler {
    private ExportSpecificationReader exportSpecificationReader;
    private RemediationCommentsReader remediationCommentsReader;
    private boolean schemaValidating;
    private boolean quiet;
    private SAXParser parser;
    private URL libraryUrl;
    private URL originUrl;
    private URL contextUrl;
    private Map<String, String> macros;
    private Locator locator;
    private int line;
    private int column;
    private String extensionId;
    private String id;
    private String name;
    private EnumSet<FileExportLibrary.LibraryFlag> flags;
    private String description;
    private Map<ClassPathEntry, ClassPathEntry> classPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
    private ExportLinkage classPathType;
    private String classPathKey;
    private boolean classPathManifestExport;
    private Map<String, List<URL>> exportSpecificationPaths = new HashMap<String, List<URL>>();
    private List<URL> remediationCommentPaths = new ArrayList<URL>();
    private String exportPathKey;
    private StringBuilder characters;
    private List<URL> sourcePath = new ArrayList<URL>();
    private List<URL> docPath = new ArrayList<URL>();
    private List<LibraryDependency> dependencies = new ArrayList<LibraryDependency>();
    private boolean reexport;
    private FileExportLibrary library;
    private Log log;
    private Consumer<FileExportLibrary> libraryCompletionHandler;
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public ExportLibraryReader() {
        this(new ExportSpecificationReader(), new RemediationCommentsReader(), false, false);
    }

    public ExportLibraryReader(ExportSpecificationReader exportSpecificationReader, RemediationCommentsReader remediationCommentsReader, boolean schemaValidating, boolean quiet) {
        this.exportSpecificationReader = exportSpecificationReader;
        this.remediationCommentsReader = remediationCommentsReader;
        this.schemaValidating = schemaValidating;
        this.quiet = quiet;
    }

    public ExportSpecificationReader getExportSpecificationReader() {
        return this.exportSpecificationReader;
    }

    public void setExportSpecificationReader(ExportSpecificationReader exportSpecificationReader) {
        this.exportSpecificationReader = exportSpecificationReader;
    }

    public RemediationCommentsReader getRemediationCommentsReader() {
        return this.remediationCommentsReader;
    }

    public void setRemediationCommentsReader(RemediationCommentsReader remediationCommentsReader) {
        this.remediationCommentsReader = remediationCommentsReader;
    }

    public boolean isSchemaValidating() {
        return this.schemaValidating;
    }

    public void setSchemaValidating(boolean schemaValidating) {
        if (schemaValidating != this.schemaValidating) {
            this.schemaValidating = schemaValidating;
            this.parser = null;
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public FileExportLibrary read(URL url, Map<String, String> macros, Log log) throws ParserConfigurationException, SAXException, IOException {
        URL contextUrl;
        URL originUrl;
        if (JarUtil.isJarURL(url)) {
            originUrl = JarUtil.getJarFileURL(url);
            contextUrl = URLFileSystem.getParent(originUrl);
        } else {
            originUrl = url;
            contextUrl = URLFileSystem.getParent(url);
        }
        this.beginExtension(url, originUrl, contextUrl, null, macros, null, log);
        try (InputStream stream = URLFileSystem.openInputStream(url);){
            FileExportLibrary fileExportLibrary = this.read(stream);
            return fileExportLibrary;
        }
    }

    public FileExportLibrary read(Path path, Map<String, String> macros, Log log) throws ParserConfigurationException, SAXException, IOException {
        this.beginExtension(path, path.getParent(), null, macros, null, log);
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            FileExportLibrary fileExportLibrary = this.read(stream);
            return fileExportLibrary;
        }
    }

    public void beginExtension(Path path, Path contextPath, String extensionId, Map<String, String> macros, Consumer<FileExportLibrary> libraryCompletionHandler, Log log) {
        URL libraryUrl = Paths.toUrl(path);
        URL originUrl = Paths.toUrl(Paths.getDefaultPath(path));
        URL contextUrl = Paths.toUrl(contextPath);
        this.beginExtension(libraryUrl, originUrl, contextUrl, extensionId, macros, libraryCompletionHandler, log);
    }

    private void beginExtension(URL libraryUrl, URL originUrl, URL contextUrl, String extensionId, Map<String, String> macros, Consumer<FileExportLibrary> libraryCompletionHandler, Log log) {
        this.libraryUrl = libraryUrl;
        this.originUrl = originUrl;
        this.contextUrl = contextUrl;
        this.macros = macros;
        this.log = log.child(new Tag("scope", libraryUrl));
        this.extensionId = extensionId;
        this.libraryCompletionHandler = libraryCompletionHandler;
    }

    private FileExportLibrary read(InputStream stream) throws SAXException, ParserConfigurationException, IOException {
        if (this.parser == null) {
            if (this.schemaValidating) {
                InputStream schemaInputStream = ExportLibraryReader.class.getResourceAsStream("manifest-library.xsd");
                StreamSource schemaSource = new StreamSource(schemaInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaSource);
                SAXParserFactory factory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", ClassLoader.getSystemClassLoader());
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setSchema(schema);
                this.parser = factory.newSAXParser();
            } else {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
        }
        try {
            this.parser.parse((InputStream)new BufferedInputStream(stream), (DefaultHandler)this);
        }
        catch (NoSuchFileException | LegacyFormatException | LocatorSAXException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new LocatorSAXException(e.getMessage() + this.at(), e);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + this.at(), e);
        }
        return this.library;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "JLibraryNode": {
                throw new LegacyFormatException();
            }
            case "library": {
                this.id = this.optional(attributes, "id");
                this.name = this.required(attributes, "name", "library");
                if ("${COHERENCE_RUNTIME_LIB_NAME}".equals(this.name)) {
                    this.name = "Coherence Runtime";
                }
                this.description = null;
                this.flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
                if (Boolean.parseBoolean(this.optional(attributes, "deployed"))) {
                    this.flags.add(FileExportLibrary.LibraryFlag.DEPLOYED);
                }
                if (Boolean.parseBoolean(this.optional(attributes, "locked"))) {
                    this.flags.add(FileExportLibrary.LibraryFlag.LOCKED);
                }
                if (!this.classPath.isEmpty()) {
                    this.classPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
                }
                if (!this.exportSpecificationPaths.isEmpty()) {
                    this.exportSpecificationPaths = new HashMap<String, List<URL>>();
                }
                if (!this.remediationCommentPaths.isEmpty()) {
                    this.remediationCommentPaths = new ArrayList<URL>();
                }
                if (!this.dependencies.isEmpty()) {
                    this.dependencies = new ArrayList<LibraryDependency>();
                }
                if (!this.sourcePath.isEmpty()) {
                    this.sourcePath = new ArrayList<URL>();
                }
                if (this.docPath.isEmpty()) break;
                this.docPath = new ArrayList<URL>();
                break;
            }
            case "description": {
                this.characters = new StringBuilder();
                break;
            }
            case "dependency": {
                this.reexport = Boolean.parseBoolean(this.optional(attributes, "reexport"));
                this.characters = new StringBuilder();
                break;
            }
            case "classpath": {
                String manifestExport;
                String exportText = this.optional(attributes, "export");
                if (exportText != null) {
                    switch (exportText.toLowerCase()) {
                        case "none": {
                            this.classPathType = ExportLinkage.NONE;
                            break;
                        }
                        case "embedded": {
                            this.classPathType = ExportLinkage.EMBEDDED;
                            break;
                        }
                        case "library": {
                            this.classPathType = ExportLinkage.LIBRARY;
                            break;
                        }
                        case "all": {
                            this.classPathType = ExportLinkage.ALL;
                            break;
                        }
                        default: {
                            this.log.error("library-export-attribute", "<classpath> export attribute value \"%s\" must be \"none\", \"embedded\", \"library\", or \"all\" (%s:%d)", exportText, this.libraryUrl, this.line);
                            break;
                        }
                    }
                } else {
                    this.classPathType = ExportLinkage.NULL;
                }
                if ((manifestExport = this.optional(attributes, "manifest-export")) == null) {
                    manifestExport = this.optional(attributes, "manifest");
                }
                this.classPathManifestExport = Boolean.parseBoolean(manifestExport);
                this.classPathKey = this.optional(attributes, "key");
                if (this.classPathKey == null) {
                    this.classPathKey = "";
                }
                this.characters = new StringBuilder();
                break;
            }
            case "export-specification": {
                this.exportPathKey = this.optional(attributes, "key");
                if (this.exportPathKey == null) {
                    this.exportPathKey = "";
                }
                this.characters = new StringBuilder();
                break;
            }
            case "remediation-comments": {
                this.characters = new StringBuilder();
                break;
            }
            case "sourcepath": 
            case "srcpath": 
            case "docpath": {
                this.characters = new StringBuilder();
                break;
            }
            default: {
                this.log.error("library-unexpected-element", "unexpected element name %s (%s:%d)", qualifiedName, this.libraryUrl, this.line);
            }
        }
    }

    @Override
    public void characters(char[] text, int offset, int length) throws SAXException {
        if (text != null && this.characters != null) {
            this.characters.append(text, offset, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "library": {
                this.library = new FileExportLibrary(this.originUrl, this.extensionId, this.name, this.id, this.description, this.flags, this.classPath.isEmpty() ? Collections.emptyList() : new ArrayList<ClassPathEntry>(this.classPath.keySet()), this.exportSpecificationPaths.isEmpty() ? Collections.emptyMap() : this.exportSpecificationPaths, this.remediationCommentPaths.isEmpty() ? Collections.emptyList() : this.remediationCommentPaths, this.dependencies.isEmpty() ? Collections.emptyList() : this.dependencies, this.sourcePath.isEmpty() ? Collections.emptyList() : this.sourcePath, this.docPath.isEmpty() ? Collections.emptyList() : this.docPath, null, null, null);
                if (this.libraryCompletionHandler != null) {
                    this.libraryCompletionHandler.accept(this.library);
                }
                if (!this.classPath.isEmpty()) {
                    this.classPath = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
                }
                if (!this.exportSpecificationPaths.isEmpty()) {
                    this.exportSpecificationPaths = new HashMap<String, List<URL>>();
                }
                if (!this.remediationCommentPaths.isEmpty()) {
                    this.remediationCommentPaths = new ArrayList<URL>();
                }
                if (!this.dependencies.isEmpty()) {
                    this.dependencies = new ArrayList<LibraryDependency>();
                }
                if (!this.sourcePath.isEmpty()) {
                    this.sourcePath = new ArrayList<URL>();
                }
                if (this.docPath.isEmpty()) break;
                this.docPath = new ArrayList<URL>();
                break;
            }
            case "dependency": {
                this.dependencies.add(new LibraryDependency(this.characters.toString(), this.reexport));
                this.characters = null;
                break;
            }
            case "description": {
                this.description = this.characters.toString();
                this.characters = null;
                break;
            }
            case "classpath": {
                for (URL uRL : this.toUrls(this.characters, this.contextUrl)) {
                    ClassPathEntry entry = new ClassPathEntry(uRL, this.classPathType, this.classPathKey, this.classPathManifestExport, this.line);
                    ClassPathEntry predecessor = this.classPath.putIfAbsent(entry, entry);
                    if (predecessor == null) continue;
                    if (this.classPathType != null && this.classPathType != predecessor.getExportLinkage() || !Objects.equals(this.classPathKey, predecessor.getLibraryLinkageKey())) {
                        this.log.error("library-duplicate-classpath", "duplicate classpath entry with conflicting export values %s ignored (%s:%d)", URLFileSystem.getPlatformPathName(uRL), this.libraryUrl, this.line);
                        continue;
                    }
                    if (this.classPathManifestExport != predecessor.isManifestExport()) {
                        this.log.error("library-duplicate-classpath", "duplicate classpath entry with conflicting manifest-export value %s ignored (%s:%d)", URLFileSystem.getPlatformPathName(uRL), this.libraryUrl, this.line);
                        continue;
                    }
                    this.log.warning("library-duplicate-classpath", "duplicate classpath entry %s ignored (%s:%d)", URLFileSystem.getPlatformPathName(uRL), this.libraryUrl, this.line);
                }
                this.classPathType = null;
                this.classPathKey = null;
                this.classPathManifestExport = false;
                this.characters = null;
                break;
            }
            case "sourcepath": 
            case "srcpath": {
                this.sourcePath.addAll(this.toUrls(this.characters, this.contextUrl));
                this.characters = null;
                break;
            }
            case "docpath": {
                this.docPath.addAll(this.toUrls(this.characters, this.contextUrl));
                this.characters = null;
                break;
            }
            case "export-specification": {
                URL specificationUrl = this.toUrl(this.characters.toString().trim(), this.contextUrl);
                this.exportSpecificationPaths.computeIfAbsent(this.exportPathKey, v -> new ArrayList()).add(specificationUrl);
                this.characters = null;
                break;
            }
            case "remediation-comments": {
                URL uRL = this.toUrl(this.characters.toString().trim(), this.contextUrl);
                this.remediationCommentPaths.add(uRL);
                this.characters = null;
                break;
            }
        }
    }

    private String optional(Attributes attributes, String name) {
        String text = attributes.getValue(name);
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    private String required(Attributes attributes, String name, String element) {
        String text = attributes.getValue(name);
        if (text != null) {
            if ((text = text.trim()).isEmpty()) {
                this.log.error("library-required-value", "<%s> requires non-empty %s attribute value (%s:%d)", element, name, this.libraryUrl, this.line);
                text = null;
            }
        } else {
            this.log.error("library-required-value", "<%s> requires %s attribute (%s:%d)", element, name, this.libraryUrl, this.line);
        }
        return text;
    }

    private <E> List<E> empty(List<E> list) {
        return list.isEmpty() ? list : Collections.emptyList();
    }

    private <E> Set<E> empty(Set<E> set) {
        return set.isEmpty() ? set : Collections.emptySet();
    }

    private <K, V> Map<K, V> empty(Map<K, V> map) {
        return map.isEmpty() ? map : Collections.emptyMap();
    }

    @Override
    public void warning(SAXParseException e) {
        this.log.warning("library-schema-validation-warning", "%s (%s:%d)", e.getMessage(), this.libraryUrl, e.getLineNumber());
    }

    @Override
    public void error(SAXParseException e) {
        this.log.error("library-schema-validation-error", "%s (%s:%d)", e.getMessage(), this.libraryUrl, e.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected String at() {
        return " (" + URLFileSystem.getPlatformPathName(this.libraryUrl) + ", line " + this.line + ", column " + this.column + ')';
    }

    protected List<? extends URL> toUrls(StringBuilder text, URL contextUrl) {
        int end;
        ArrayList<URL> list = new ArrayList<URL>();
        int start = 0;
        while ((end = text.indexOf(",", start)) >= 0) {
            URL url = this.toUrl(text.substring(start, end), contextUrl);
            if (url != null) {
                list.add(url);
            }
            start = end + 1;
        }
        URL url = this.toUrl(text.substring(start), contextUrl);
        if (url != null) {
            list.add(url);
        }
        return list;
    }

    protected URL toUrl(String text, URL contextUrl) {
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        int dollar = text.indexOf("${");
        if (dollar >= 0) {
            int to;
            StringBuilder builder = new StringBuilder();
            int mark = 0;
            do {
                builder.append(text, mark, dollar);
                mark = dollar;
                to = text.indexOf(125, dollar + 2);
                if (to < 0) break;
                String name = text.substring(dollar + 2, to);
                String value = this.macros.get(name);
                if (value != null) {
                    builder.append(value);
                    continue;
                }
                this.log.warning("library-macro-absent", "undefined macro reference ${%s} (%s:%d)", name, this.libraryUrl, this.line);
                builder.append("${").append(name).append("}");
            } while ((dollar = text.indexOf("${", mark = to + 1)) >= 0);
            builder.append(text, mark, text.length());
            text = builder.toString();
        }
        String path = text;
        String scheme = "";
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ':') {
                scheme = path.substring(0, i);
                path = path.substring(i + 1);
                break;
            }
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') break;
        }
        String authority = "";
        if (path.startsWith("//")) {
            for (int i = 2; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c != '/' && c != '?' && c != '#') continue;
                authority = path.substring(2, i);
                path = path.substring(i);
                break;
            }
        }
        if (!authority.isEmpty()) {
            return URLFactory.newURL(text);
        }
        switch (scheme) {
            case "jar": 
            case "zip": 
            case "ear": 
            case "war": {
                String entryPath;
                String filePath;
                int entryIndex = path.indexOf("!/");
                if (entryIndex >= 0) {
                    filePath = path.substring(0, entryIndex);
                    entryPath = path.substring(entryIndex + 2);
                } else {
                    filePath = path;
                    entryPath = "";
                }
                return URLFactory.newJarURL(this.resolve(filePath, contextUrl), entryPath);
            }
            case "": 
            case "file": {
                String entryPath;
                String filePath;
                int entryIndex = path.indexOf("!/");
                if (entryIndex >= 0) {
                    filePath = path.substring(0, entryIndex);
                    entryPath = path.substring(entryIndex + 2);
                } else {
                    filePath = path;
                    int dot = filePath.lastIndexOf(46);
                    entryPath = dot >= 0 && ARCHIVE_SUFFIXES.contains(filePath.substring(dot)) ? "" : null;
                }
                URL fileUrl = this.resolve(filePath, contextUrl);
                return entryPath == null ? fileUrl : URLFactory.newJarURL(fileUrl, entryPath);
            }
        }
        return URLFactory.newURL(text);
    }

    private URL resolve(String path, URL contextUrl) {
        URL fileUrl = this.isAbsolute(path) ? URLFactory.newFileURL(path) : URLFactory.newURL(contextUrl, path);
        return fileUrl;
    }

    protected boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() >= 2 && path.charAt(1) == ':';
    }

    private static class LocatorSAXException
    extends SAXException {
        public LocatorSAXException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class LegacyFormatException
    extends SAXException {
        public LegacyFormatException() {
            super("Legacy file format: use JLibraryNode to read");
        }
    }
}

