/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class Paths {
    private static final String SEPARATOR = FileSystems.getDefault().getSeparator();
    private static final String SEPARATOR_GROUP = SEPARATOR.equals("/") ? SEPARATOR : (SEPARATOR.equals("\\") ? "/|\\\\" : "/|" + SEPARATOR);
    private static final Matcher MATCHER = Pattern.compile("[.](jar|zip)(" + SEPARATOR_GROUP + ")").matcher("");
    private static Path currentWorkingDirectory;

    private Paths() {
    }

    public static Path get(String first, String ... more) {
        return java.nio.file.Paths.get(first, more);
    }

    public static Path get(URI uri) {
        return java.nio.file.Paths.get(uri);
    }

    public static Path getExtended(String string) {
        if (MATCHER.reset(string).find()) {
            String fileName = string.substring(0, MATCHER.end(1));
            String entryName = string.substring(MATCHER.start(2)).replace(SEPARATOR, "/");
            try {
                Path file = new File(fileName).toPath();
                return FileSystems.newFileSystem(file, null).getPath(entryName, new String[0]);
            }
            catch (IOException | FileSystemNotFoundException e) {
                Path file = new File(fileName).toPath();
                return file.resolve(java.nio.file.Paths.get("", entryName.split("/")));
            }
        }
        return java.nio.file.Paths.get(string, new String[0]);
    }

    public static Path getExtended(URI uri) {
        try {
            return java.nio.file.Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            if ("jar".equals(uri.getScheme())) {
                int delimiter;
                String text = uri.getSchemeSpecificPart();
                String fileName = text.substring(0, delimiter = text.lastIndexOf("!/"));
                if (fileName.startsWith("file:")) {
                    fileName = fileName.substring("file:".length());
                }
                String entryName = text.substring(delimiter + 2);
                try {
                    Path file = java.nio.file.Paths.get(new URI(fileName));
                    return file.resolve(java.nio.file.Paths.get("", entryName.split("/")));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static Path getExtended(URL url) {
        URI uri;
        String entry;
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            entry = JarUtil.getJarEntry(url);
            url = JarUtil.getJarFileURL(url);
        } else {
            entry = null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException f) {
                f.initCause(e);
                throw new IllegalArgumentException(f);
            }
        }
        Path path = java.nio.file.Paths.get(uri);
        if (entry == null) {
            return path;
        }
        try {
            return FileSystems.newFileSystem(path, null).getPath("/", new String[0]).resolve(entry);
        }
        catch (IOException | FileSystemNotFoundException e) {
            return path.resolve(java.nio.file.Paths.get("", entry.split("/")));
        }
    }

    public static Path getAsDefaultPath(URL url) {
        URI uri;
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            if (!JarUtil.getJarEntry(url).isEmpty()) {
                return null;
            }
            url = JarUtil.getJarFileURL(url);
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException f) {
                f.initCause(e);
                throw new IllegalArgumentException(f);
            }
        }
        return java.nio.file.Paths.get(uri);
    }

    public static boolean isDefaultScheme(Path path) {
        return FileSystems.getDefault().equals(path.getFileSystem());
    }

    public static boolean isJarScheme(Path path) {
        return "jar".equals(path.getFileSystem().provider().getScheme());
    }

    public static Path getParent(Path path) {
        Path parent = path.getParent();
        if (parent == null && Paths.isJarScheme(path)) {
            parent = java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]);
        }
        return parent;
    }

    public static Path getFileName(Path path) {
        Path name = path.getFileName();
        if (name == null && Paths.isJarScheme(path)) {
            name = java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]).getFileName();
        }
        return name;
    }

    public static Path getDefaultPath(Path path) {
        return Paths.isJarScheme(path) ? java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]) : path;
    }

    public static String getSuffix(Path path) {
        String name = Paths.getFileName(path).toString();
        int dot = name.lastIndexOf(46);
        return dot >= 0 ? name.substring(dot) : "";
    }

    public static boolean hasSuffix(Path path, String ... suffixes) {
        String name = Paths.getFileName(path).toString();
        for (String suffix : suffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static URL toUrl(Path path) {
        if (Paths.isJarScheme(path)) {
            String entry = path.toString();
            if (entry.charAt(0) == '/') {
                entry = entry.substring(1);
            }
            return URLFactory.newJarURL(new File(path.getFileSystem().toString()), entry);
        }
        return URLFactory.newFileURL(path.toFile());
    }

    public static String toString(Path path) {
        if (path == null) {
            return "null";
        }
        if (Paths.isJarScheme(path)) {
            return path.getFileSystem().toString() + path.toString();
        }
        return path.toString();
    }

    public static String relativize(Path path, Path basePath) {
        if (path == null) {
            return null;
        }
        if (basePath == null) {
            return Paths.toString(path);
        }
        Path filePath = path;
        String entry = "";
        if (Paths.isJarScheme(path)) {
            filePath = Paths.get(path.getFileSystem().toString(), new String[0]);
            if (path.getNameCount() > 0) {
                entry = "!" + path;
            }
        }
        try {
            return basePath.relativize(filePath) + entry;
        }
        catch (IllegalArgumentException e) {
            return Paths.toString(path);
        }
    }

    public static String relativize(URL url, Path basePath) {
        if (url == null) {
            return null;
        }
        if (basePath == null) {
            return URLFileSystem.getPlatformPathName(url);
        }
        if (Paths.isJarScheme(basePath)) {
            basePath = Paths.getDefaultPath(basePath).getParent();
        }
        URL baseUrl = URLFactory.newDirURL(basePath.toFile());
        String entry = "";
        if (JarUtil.isJarURL(url)) {
            entry = JarUtil.getJarEntry(url);
            if (!entry.isEmpty()) {
                entry = '!' + entry;
            }
            url = JarUtil.getJarFileURL(url);
        }
        return URLFileSystem.toRelativeSpec(url, baseUrl) + entry;
    }

    public static Path getCurrentWorkingDirectory() {
        if (currentWorkingDirectory != null) {
            return currentWorkingDirectory;
        }
        String directory = System.getProperty("ide.startingcwd");
        if (directory == null) {
            directory = System.getProperty("user.dir");
        }
        if (directory.startsWith("\"") && directory.endsWith("\"")) {
            directory = directory.substring(1, directory.length() - 1);
        }
        currentWorkingDirectory = new File(directory).toPath();
        return currentWorkingDirectory;
    }
}

