/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class NullBufferedWriter
extends BufferedWriter {
    private static final BufferedWriter NULL_WRITER = new NullBufferedWriter();

    public static BufferedWriter nullWriter() {
        return NULL_WRITER;
    }

    public static BufferedWriter writerOrNullWriter(Path path, OpenOption ... options) throws IOException {
        return path != null ? Files.newBufferedWriter(path, options) : NULL_WRITER;
    }

    public static BufferedWriter writerOrNullWriter(Path path, Charset cs, OpenOption ... options) throws IOException {
        return path != null ? Files.newBufferedWriter(path, cs, options) : NULL_WRITER;
    }

    public static BufferedWriter writerOrNullWriter(File file) throws IOException {
        return file != null ? new BufferedWriter(new FileWriter(file)) : NULL_WRITER;
    }

    public NullBufferedWriter() {
        super(new CharArrayWriter(1), 1);
    }

    @Override
    public void write(int c) throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
    }

    @Override
    public void newLine() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(char[] cbuf) throws IOException {
    }

    @Override
    public void write(String str) throws IOException {
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        return this;
    }
}

